/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigurationResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeOrganizationConfigurationResponse.Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(DescribeOrganizationConfigurationResponse::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnable").build()).build();

    private static final SdkField<Boolean> MEMBER_ACCOUNT_LIMIT_REACHED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("MemberAccountLimitReached")
            .getter(getter(DescribeOrganizationConfigurationResponse::memberAccountLimitReached))
            .setter(setter(Builder::memberAccountLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountLimitReached").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD,
            MEMBER_ACCOUNT_LIMIT_REACHED_FIELD));

    private final Boolean autoEnable;

    private final Boolean memberAccountLimitReached;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.memberAccountLimitReached = builder.memberAccountLimitReached;
    }

    /**
     * <p>
     * Whether to automatically enable Security Hub for new accounts in the organization.
     * </p>
     * <p>
     * If set to <code>true</code>, then Security Hub is enabled for new accounts. If set to false, then new accounts
     * are not added automatically.
     * </p>
     * 
     * @return Whether to automatically enable Security Hub for new accounts in the organization.</p>
     *         <p>
     *         If set to <code>true</code>, then Security Hub is enabled for new accounts. If set to false, then new
     *         accounts are not added automatically.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Whether the maximum number of allowed member accounts are already associated with the Security Hub administrator
     * account.
     * </p>
     * 
     * @return Whether the maximum number of allowed member accounts are already associated with the Security Hub
     *         administrator account.
     */
    public final Boolean memberAccountLimitReached() {
        return memberAccountLimitReached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountLimitReached());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse) obj;
        return Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(memberAccountLimitReached(), other.memberAccountLimitReached());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationConfigurationResponse").add("AutoEnable", autoEnable())
                .add("MemberAccountLimitReached", memberAccountLimitReached()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "MemberAccountLimitReached":
            return Optional.ofNullable(clazz.cast(memberAccountLimitReached()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        /**
         * <p>
         * Whether to automatically enable Security Hub for new accounts in the organization.
         * </p>
         * <p>
         * If set to <code>true</code>, then Security Hub is enabled for new accounts. If set to false, then new
         * accounts are not added automatically.
         * </p>
         * 
         * @param autoEnable
         *        Whether to automatically enable Security Hub for new accounts in the organization.</p>
         *        <p>
         *        If set to <code>true</code>, then Security Hub is enabled for new accounts. If set to false, then new
         *        accounts are not added automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Whether the maximum number of allowed member accounts are already associated with the Security Hub
         * administrator account.
         * </p>
         * 
         * @param memberAccountLimitReached
         *        Whether the maximum number of allowed member accounts are already associated with the Security Hub
         *        administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountLimitReached(Boolean memberAccountLimitReached);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private Boolean autoEnable;

        private Boolean memberAccountLimitReached;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            autoEnable(model.autoEnable);
            memberAccountLimitReached(model.memberAccountLimitReached);
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        public final Boolean getMemberAccountLimitReached() {
            return memberAccountLimitReached;
        }

        @Override
        public final Builder memberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
            return this;
        }

        public final void setMemberAccountLimitReached(Boolean memberAccountLimitReached) {
            this.memberAccountLimitReached = memberAccountLimitReached;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
