/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembersRequest extends SecurityHubRequest implements
        ToCopyableBuilder<CreateMembersRequest.Builder, CreateMembersRequest> {
    private static final SdkField<List<AccountDetails>> ACCOUNT_DETAILS_FIELD = SdkField
            .<List<AccountDetails>> builder(MarshallingType.LIST)
            .memberName("AccountDetails")
            .getter(getter(CreateMembersRequest::accountDetails))
            .setter(setter(Builder::accountDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_DETAILS_FIELD));

    private final List<AccountDetails> accountDetails;

    private CreateMembersRequest(BuilderImpl builder) {
        super(builder);
        this.accountDetails = builder.accountDetails;
    }

    /**
     * Returns true if the AccountDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccountDetails() {
        return accountDetails != null && !(accountDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accounts to associate with the Security Hub master account. For each account, the list includes the
     * account ID and optionally the email address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of accounts to associate with the Security Hub master account. For each account, the list
     *         includes the account ID and optionally the email address.
     */
    public final List<AccountDetails> accountDetails() {
        return accountDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountDetails() ? accountDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersRequest)) {
            return false;
        }
        CreateMembersRequest other = (CreateMembersRequest) obj;
        return hasAccountDetails() == other.hasAccountDetails() && Objects.equals(accountDetails(), other.accountDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembersRequest").add("AccountDetails", hasAccountDetails() ? accountDetails() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountDetails":
            return Optional.ofNullable(clazz.cast(accountDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersRequest, T> g) {
        return obj -> g.apply((CreateMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembersRequest> {
        /**
         * <p>
         * The list of accounts to associate with the Security Hub master account. For each account, the list includes
         * the account ID and optionally the email address.
         * </p>
         * 
         * @param accountDetails
         *        The list of accounts to associate with the Security Hub master account. For each account, the list
         *        includes the account ID and optionally the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDetails(Collection<AccountDetails> accountDetails);

        /**
         * <p>
         * The list of accounts to associate with the Security Hub master account. For each account, the list includes
         * the account ID and optionally the email address.
         * </p>
         * 
         * @param accountDetails
         *        The list of accounts to associate with the Security Hub master account. For each account, the list
         *        includes the account ID and optionally the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDetails(AccountDetails... accountDetails);

        /**
         * <p>
         * The list of accounts to associate with the Security Hub master account. For each account, the list includes
         * the account ID and optionally the email address.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountDetails>.Builder} avoiding the need
         * to create one manually via {@link List<AccountDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link #accountDetails(List<AccountDetails>)}.
         * 
         * @param accountDetails
         *        a consumer that will call methods on {@link List<AccountDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountDetails(List<AccountDetails>)
         */
        Builder accountDetails(Consumer<AccountDetails.Builder>... accountDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<AccountDetails> accountDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersRequest model) {
            super(model);
            accountDetails(model.accountDetails);
        }

        public final Collection<AccountDetails.Builder> getAccountDetails() {
            if (accountDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return accountDetails != null ? accountDetails.stream().map(AccountDetails::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder accountDetails(Collection<AccountDetails> accountDetails) {
            this.accountDetails = AccountDetailsListCopier.copy(accountDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(AccountDetails... accountDetails) {
            accountDetails(Arrays.asList(accountDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(Consumer<AccountDetails.Builder>... accountDetails) {
            accountDetails(Stream.of(accountDetails).map(c -> AccountDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountDetails(Collection<AccountDetails.BuilderImpl> accountDetails) {
            this.accountDetails = AccountDetailsListCopier.copyFromBuilder(accountDetails);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembersRequest build() {
            return new CreateMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
