/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains finding details that are specific to control-based findings. Only returned for findings generated from
 * controls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Compliance implements SdkPojo, Serializable, ToCopyableBuilder<Compliance.Builder, Compliance> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Compliance::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> RELATED_REQUIREMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RelatedRequirements")
            .getter(getter(Compliance::relatedRequirements))
            .setter(setter(Builder::relatedRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StatusReason>> STATUS_REASONS_FIELD = SdkField
            .<List<StatusReason>> builder(MarshallingType.LIST)
            .memberName("StatusReasons")
            .getter(getter(Compliance::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatusReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatusReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            RELATED_REQUIREMENTS_FIELD, STATUS_REASONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final List<String> relatedRequirements;

    private final List<StatusReason> statusReasons;

    private Compliance(BuilderImpl builder) {
        this.status = builder.status;
        this.relatedRequirements = builder.relatedRequirements;
        this.statusReasons = builder.statusReasons;
    }

    /**
     * <p>
     * The result of a standards check.
     * </p>
     * <p>
     * The valid values for <code>Status</code> are as follows.
     * </p>
     * <ul>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <code>PASSED</code> - Standards check passed for all evaluated resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Standards check failed for at least one evaluated resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the
     * result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation result was
     * <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the finding.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The result of a standards check.</p>
     *         <p>
     *         The valid values for <code>Status</code> are as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSED</code> - Standards check passed for all evaluated resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Standards check failed for at least one evaluated resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because
     *         the result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation
     *         result was <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the
     *         finding.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ComplianceStatus
     */
    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(status);
    }

    /**
     * <p>
     * The result of a standards check.
     * </p>
     * <p>
     * The valid values for <code>Status</code> are as follows.
     * </p>
     * <ul>
     * <li>
     * <ul>
     * <li>
     * <p>
     * <code>PASSED</code> - Standards check passed for all evaluated resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Standards check failed for at least one evaluated resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the
     * result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation result was
     * <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the finding.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The result of a standards check.</p>
     *         <p>
     *         The valid values for <code>Status</code> are as follows.
     *         </p>
     *         <ul>
     *         <li>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSED</code> - Standards check passed for all evaluated resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Standards check failed for at least one evaluated resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because
     *         the result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation
     *         result was <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the
     *         finding.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ComplianceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns true if the RelatedRequirements property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRelatedRequirements() {
        return relatedRequirements != null && !(relatedRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a control, the industry or regulatory framework requirements that are related to the control. The check for
     * that control is aligned with these requirements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedRequirements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For a control, the industry or regulatory framework requirements that are related to the control. The
     *         check for that control is aligned with these requirements.
     */
    public final List<String> relatedRequirements() {
        return relatedRequirements;
    }

    /**
     * Returns true if the StatusReasons property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list of
     * status reason codes and their meanings, see <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
     * >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatusReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the
     *         list of status reason codes and their meanings, see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
     *         >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
     */
    public final List<StatusReason> statusReasons() {
        return statusReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedRequirements() ? relatedRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && hasRelatedRequirements() == other.hasRelatedRequirements()
                && Objects.equals(relatedRequirements(), other.relatedRequirements())
                && hasStatusReasons() == other.hasStatusReasons() && Objects.equals(statusReasons(), other.statusReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Compliance").add("Status", statusAsString())
                .add("RelatedRequirements", hasRelatedRequirements() ? relatedRequirements() : null)
                .add("StatusReasons", hasStatusReasons() ? statusReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RelatedRequirements":
            return Optional.ofNullable(clazz.cast(relatedRequirements()));
        case "StatusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Compliance, T> g) {
        return obj -> g.apply((Compliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Compliance> {
        /**
         * <p>
         * The result of a standards check.
         * </p>
         * <p>
         * The valid values for <code>Status</code> are as follows.
         * </p>
         * <ul>
         * <li>
         * <ul>
         * <li>
         * <p>
         * <code>PASSED</code> - Standards check passed for all evaluated resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Standards check failed for at least one evaluated resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the
         * result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation result was
         * <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the finding.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result of a standards check.</p>
         *        <p>
         *        The valid values for <code>Status</code> are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSED</code> - Standards check passed for all evaluated resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> - Some information is missing or this check is not supported for your
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Standards check failed for at least one evaluated resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or
         *        because the result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config
         *        evaluation result was <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically
         *        archives the finding.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The result of a standards check.
         * </p>
         * <p>
         * The valid values for <code>Status</code> are as follows.
         * </p>
         * <ul>
         * <li>
         * <ul>
         * <li>
         * <p>
         * <code>PASSED</code> - Standards check passed for all evaluated resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Standards check failed for at least one evaluated resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the
         * result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation result was
         * <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the finding.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result of a standards check.</p>
         *        <p>
         *        The valid values for <code>Status</code> are as follows.
         *        </p>
         *        <ul>
         *        <li>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSED</code> - Standards check passed for all evaluated resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code> - Some information is missing or this check is not supported for your
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Standards check failed for at least one evaluated resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or
         *        because the result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config
         *        evaluation result was <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically
         *        archives the finding.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(ComplianceStatus status);

        /**
         * <p>
         * For a control, the industry or regulatory framework requirements that are related to the control. The check
         * for that control is aligned with these requirements.
         * </p>
         * 
         * @param relatedRequirements
         *        For a control, the industry or regulatory framework requirements that are related to the control. The
         *        check for that control is aligned with these requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedRequirements(Collection<String> relatedRequirements);

        /**
         * <p>
         * For a control, the industry or regulatory framework requirements that are related to the control. The check
         * for that control is aligned with these requirements.
         * </p>
         * 
         * @param relatedRequirements
         *        For a control, the industry or regulatory framework requirements that are related to the control. The
         *        check for that control is aligned with these requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedRequirements(String... relatedRequirements);

        /**
         * <p>
         * For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list
         * of status reason codes and their meanings, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
         * >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
         * </p>
         * 
         * @param statusReasons
         *        For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For
         *        the list of status reason codes and their meanings, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
         *        >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<StatusReason> statusReasons);

        /**
         * <p>
         * For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list
         * of status reason codes and their meanings, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
         * >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
         * </p>
         * 
         * @param statusReasons
         *        For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For
         *        the list of status reason codes and their meanings, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
         *        >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(StatusReason... statusReasons);

        /**
         * <p>
         * For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list
         * of status reason codes and their meanings, see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff"
         * >Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatusReason>.Builder} avoiding the need to
         * create one manually via {@link List<StatusReason>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatusReason>.Builder#build()} is called immediately and its
         * result is passed to {@link #statusReasons(List<StatusReason>)}.
         * 
         * @param statusReasons
         *        a consumer that will call methods on {@link List<StatusReason>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReasons(List<StatusReason>)
         */
        Builder statusReasons(Consumer<StatusReason.Builder>... statusReasons);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private List<String> relatedRequirements = DefaultSdkAutoConstructList.getInstance();

        private List<StatusReason> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            status(model.status);
            relatedRequirements(model.relatedRequirements);
            statusReasons(model.statusReasons);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getRelatedRequirements() {
            if (relatedRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedRequirements;
        }

        @Override
        public final Builder relatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedRequirements(String... relatedRequirements) {
            relatedRequirements(Arrays.asList(relatedRequirements));
            return this;
        }

        public final void setRelatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
        }

        public final Collection<StatusReason.Builder> getStatusReasons() {
            if (statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasons != null ? statusReasons.stream().map(StatusReason::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder statusReasons(Collection<StatusReason> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(StatusReason... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(Consumer<StatusReason.Builder>... statusReasons) {
            statusReasons(Stream.of(statusReasons).map(c -> StatusReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatusReasons(Collection<StatusReason.BuilderImpl> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copyFromBuilder(statusReasons);
        }

        @Override
        public Compliance build() {
            return new Compliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
