/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an EC2 volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VolumeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VolumeDetails.Builder, AwsEc2VolumeDetails> {
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateTime").getter(getter(AwsEc2VolumeDetails::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsEc2VolumeDetails::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(AwsEc2VolumeDetails::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(AwsEc2VolumeDetails::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsEc2VolumeDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsEc2VolumeDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<AwsEc2VolumeAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<AwsEc2VolumeAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(AwsEc2VolumeDetails::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VolumeAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VolumeAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            ENCRYPTED_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createTime;

    private final Boolean encrypted;

    private final Integer size;

    private final String snapshotId;

    private final String status;

    private final String kmsKeyId;

    private final List<AwsEc2VolumeAttachment> attachments;

    private AwsEc2VolumeDetails(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.encrypted = builder.encrypted;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * Indicates when the volume was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the volume was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createTime() {
        return createTime;
    }

    /**
     * <p>
     * Whether the volume is encrypted.
     * </p>
     * 
     * @return Whether the volume is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The size of the volume, in GiBs.
     * </p>
     * 
     * @return The size of the volume, in GiBs.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which the volume was created.
     * </p>
     * 
     * @return The snapshot from which the volume was created.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume state.
     * </p>
     * 
     * @return The volume state.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the volume
     * encryption key for the volume.
     * </p>
     * 
     * @return The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect
     *         the volume encryption key for the volume.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Attachments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The volume attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The volume attachments.
     */
    public final List<AwsEc2VolumeAttachment> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VolumeDetails)) {
            return false;
        }
        AwsEc2VolumeDetails other = (AwsEc2VolumeDetails) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(size(), other.size()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(status(), other.status()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VolumeDetails").add("CreateTime", createTime()).add("Encrypted", encrypted())
                .add("Size", size()).add("SnapshotId", snapshotId()).add("Status", status()).add("KmsKeyId", kmsKeyId())
                .add("Attachments", hasAttachments() ? attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VolumeDetails, T> g) {
        return obj -> g.apply((AwsEc2VolumeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VolumeDetails> {
        /**
         * <p>
         * Indicates when the volume was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createTime
         *        Indicates when the volume was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(String createTime);

        /**
         * <p>
         * Whether the volume is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Whether the volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The size of the volume, in GiBs.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which the volume was created.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which the volume was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume state.
         * </p>
         * 
         * @param status
         *        The volume state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
         * volume encryption key for the volume.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect
         *        the volume encryption key for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * 
         * @param attachments
         *        The volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AwsEc2VolumeAttachment> attachments);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * 
         * @param attachments
         *        The volume attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AwsEc2VolumeAttachment... attachments);

        /**
         * <p>
         * The volume attachments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2VolumeAttachment>.Builder} avoiding
         * the need to create one manually via {@link List<AwsEc2VolumeAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2VolumeAttachment>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<AwsEc2VolumeAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AwsEc2VolumeAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AwsEc2VolumeAttachment>)
         */
        Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder>... attachments);
    }

    static final class BuilderImpl implements Builder {
        private String createTime;

        private Boolean encrypted;

        private Integer size;

        private String snapshotId;

        private String status;

        private String kmsKeyId;

        private List<AwsEc2VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VolumeDetails model) {
            createTime(model.createTime);
            encrypted(model.encrypted);
            size(model.size);
            snapshotId(model.snapshotId);
            status(model.status);
            kmsKeyId(model.kmsKeyId);
            attachments(model.attachments);
        }

        public final String getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<AwsEc2VolumeAttachment.Builder> getAttachments() {
            if (attachments instanceof SdkAutoConstructList) {
                return null;
            }
            return attachments != null ? attachments.stream().map(AwsEc2VolumeAttachment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attachments(Collection<AwsEc2VolumeAttachment> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AwsEc2VolumeAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AwsEc2VolumeAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<AwsEc2VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public AwsEc2VolumeDetails build() {
            return new AwsEc2VolumeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
