/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsEc2SecurityGroupIpRangeListCopier {
    static List<AwsEc2SecurityGroupIpRange> copy(Collection<AwsEc2SecurityGroupIpRange> awsEc2SecurityGroupIpRangeListParam) {
        if (awsEc2SecurityGroupIpRangeListParam == null || awsEc2SecurityGroupIpRangeListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<AwsEc2SecurityGroupIpRange> awsEc2SecurityGroupIpRangeListParamCopy = new ArrayList<>(
                awsEc2SecurityGroupIpRangeListParam);
        return Collections.unmodifiableList(awsEc2SecurityGroupIpRangeListParamCopy);
    }

    static List<AwsEc2SecurityGroupIpRange> copyFromBuilder(
            Collection<? extends AwsEc2SecurityGroupIpRange.Builder> awsEc2SecurityGroupIpRangeListParam) {
        if (awsEc2SecurityGroupIpRangeListParam == null
                || awsEc2SecurityGroupIpRangeListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(awsEc2SecurityGroupIpRangeListParam.stream().map(AwsEc2SecurityGroupIpRange.Builder::build).collect(toList()));
    }
}
