/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about caching for the distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionCacheBehaviors implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionCacheBehaviors.Builder, AwsCloudFrontDistributionCacheBehaviors> {
    private static final SdkField<List<AwsCloudFrontDistributionCacheBehavior>> ITEMS_FIELD = SdkField
            .<List<AwsCloudFrontDistributionCacheBehavior>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(AwsCloudFrontDistributionCacheBehaviors::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCloudFrontDistributionCacheBehavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCloudFrontDistributionCacheBehavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsCloudFrontDistributionCacheBehavior> items;

    private AwsCloudFrontDistributionCacheBehaviors(BuilderImpl builder) {
        this.items = builder.items;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cache behaviors for the distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The cache behaviors for the distribution.
     */
    public final List<AwsCloudFrontDistributionCacheBehavior> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionCacheBehaviors)) {
            return false;
        }
        AwsCloudFrontDistributionCacheBehaviors other = (AwsCloudFrontDistributionCacheBehaviors) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionCacheBehaviors").add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionCacheBehaviors, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionCacheBehaviors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionCacheBehaviors> {
        /**
         * <p>
         * The cache behaviors for the distribution.
         * </p>
         * 
         * @param items
         *        The cache behaviors for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AwsCloudFrontDistributionCacheBehavior> items);

        /**
         * <p>
         * The cache behaviors for the distribution.
         * </p>
         * 
         * @param items
         *        The cache behaviors for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AwsCloudFrontDistributionCacheBehavior... items);

        /**
         * <p>
         * The cache behaviors for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsCloudFrontDistributionCacheBehavior>.Builder} avoiding the need to create one manually via {@link List
         * <AwsCloudFrontDistributionCacheBehavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsCloudFrontDistributionCacheBehavior>.Builder#build()} is
         * called immediately and its result is passed to {@link #items(List<AwsCloudFrontDistributionCacheBehavior>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<AwsCloudFrontDistributionCacheBehavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<AwsCloudFrontDistributionCacheBehavior>)
         */
        Builder items(Consumer<AwsCloudFrontDistributionCacheBehavior.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsCloudFrontDistributionCacheBehavior> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionCacheBehaviors model) {
            items(model.items);
        }

        public final Collection<AwsCloudFrontDistributionCacheBehavior.Builder> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items != null ? items.stream().map(AwsCloudFrontDistributionCacheBehavior::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<AwsCloudFrontDistributionCacheBehavior> items) {
            this.items = AwsCloudFrontDistributionCacheBehaviorsItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AwsCloudFrontDistributionCacheBehavior... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AwsCloudFrontDistributionCacheBehavior.Builder>... items) {
            items(Stream.of(items).map(c -> AwsCloudFrontDistributionCacheBehavior.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<AwsCloudFrontDistributionCacheBehavior.BuilderImpl> items) {
            this.items = AwsCloudFrontDistributionCacheBehaviorsItemListCopier.copyFromBuilder(items);
        }

        @Override
        public AwsCloudFrontDistributionCacheBehaviors build() {
            return new AwsCloudFrontDistributionCacheBehaviors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
