/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an auto scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingAutoScalingGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAutoScalingAutoScalingGroupDetails.Builder, AwsAutoScalingAutoScalingGroupDetails> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(AwsAutoScalingAutoScalingGroupDetails::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(AwsAutoScalingAutoScalingGroupDetails::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(AwsAutoScalingAutoScalingGroupDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_CONFIGURATION_NAME_FIELD, LOAD_BALANCER_NAMES_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD,
            CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchConfigurationName;

    private final List<String> loadBalancerNames;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String createdTime;

    private AwsAutoScalingAutoScalingGroupDetails(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * Returns true if the LoadBalancerNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of load balancers associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of load balancers associated with the group.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * <p>
     * The service to use for the health checks.
     * </p>
     * 
     * @return The service to use for the health checks.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2
     * instance that has come into service.
     * </p>
     * 
     * @return The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of
     *         an EC2 instance that has come into service.
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * Indicates when the auto scaling group was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the auto scaling group was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupDetails other = (AwsAutoScalingAutoScalingGroupDetails) obj;
        return Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingAutoScalingGroupDetails")
                .add("LaunchConfigurationName", launchConfigurationName())
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null)
                .add("HealthCheckType", healthCheckType()).add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingAutoScalingGroupDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The list of load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        The list of load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * The list of load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        The list of load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The service to use for the health checks.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an
         * EC2 instance that has come into service.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status
         *        of an EC2 instance that has come into service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * Indicates when the auto scaling group was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdTime
         *        Indicates when the auto scaling group was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String launchConfigurationName;

        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupDetails model) {
            launchConfigurationName(model.launchConfigurationName);
            loadBalancerNames(model.loadBalancerNames);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            createdTime(model.createdTime);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public AwsAutoScalingAutoScalingGroupDetails build() {
            return new AwsAutoScalingAutoScalingGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
