/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about one of the following actions that affects or that was taken on a resource:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A remote IP address issued an AWS API call
 * </p>
 * </li>
 * <li>
 * <p>
 * A DNS request was received
 * </p>
 * </li>
 * <li>
 * <p>
 * A remote IP address attempted to connect to an EC2 instance
 * </p>
 * </li>
 * <li>
 * <p>
 * A remote IP address attempted a port probe on an EC2 instance
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(Action::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<NetworkConnectionAction> NETWORK_CONNECTION_ACTION_FIELD = SdkField
            .<NetworkConnectionAction> builder(MarshallingType.SDK_POJO).memberName("NetworkConnectionAction")
            .getter(getter(Action::networkConnectionAction)).setter(setter(Builder::networkConnectionAction))
            .constructor(NetworkConnectionAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConnectionAction").build())
            .build();

    private static final SdkField<AwsApiCallAction> AWS_API_CALL_ACTION_FIELD = SdkField
            .<AwsApiCallAction> builder(MarshallingType.SDK_POJO).memberName("AwsApiCallAction")
            .getter(getter(Action::awsApiCallAction)).setter(setter(Builder::awsApiCallAction))
            .constructor(AwsApiCallAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiCallAction").build()).build();

    private static final SdkField<DnsRequestAction> DNS_REQUEST_ACTION_FIELD = SdkField
            .<DnsRequestAction> builder(MarshallingType.SDK_POJO).memberName("DnsRequestAction")
            .getter(getter(Action::dnsRequestAction)).setter(setter(Builder::dnsRequestAction))
            .constructor(DnsRequestAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRequestAction").build()).build();

    private static final SdkField<PortProbeAction> PORT_PROBE_ACTION_FIELD = SdkField
            .<PortProbeAction> builder(MarshallingType.SDK_POJO).memberName("PortProbeAction")
            .getter(getter(Action::portProbeAction)).setter(setter(Builder::portProbeAction))
            .constructor(PortProbeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortProbeAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            NETWORK_CONNECTION_ACTION_FIELD, AWS_API_CALL_ACTION_FIELD, DNS_REQUEST_ACTION_FIELD, PORT_PROBE_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final NetworkConnectionAction networkConnectionAction;

    private final AwsApiCallAction awsApiCallAction;

    private final DnsRequestAction dnsRequestAction;

    private final PortProbeAction portProbeAction;

    private Action(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.networkConnectionAction = builder.networkConnectionAction;
        this.awsApiCallAction = builder.awsApiCallAction;
        this.dnsRequestAction = builder.dnsRequestAction;
        this.portProbeAction = builder.portProbeAction;
    }

    /**
     * <p>
     * The type of action that was detected. The possible action types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NETWORK_CONNECTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_API_CALL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DNS_REQUEST</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PORT_PROBE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of action that was detected. The possible action types are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NETWORK_CONNECTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_API_CALL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DNS_REQUEST</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PORT_PROBE</code>
     *         </p>
     *         </li>
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * <p>
     * Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the network
     * connection that was detected.
     * </p>
     * 
     * @return Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the
     *         network connection that was detected.
     */
    public final NetworkConnectionAction networkConnectionAction() {
        return networkConnectionAction;
    }

    /**
     * <p>
     * Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call that was
     * detected.
     * </p>
     * 
     * @return Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call
     *         that was detected.
     */
    public final AwsApiCallAction awsApiCallAction() {
        return awsApiCallAction;
    }

    /**
     * <p>
     * Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS request that was
     * detected.
     * </p>
     * 
     * @return Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS request
     *         that was detected.
     */
    public final DnsRequestAction dnsRequestAction() {
        return dnsRequestAction;
    }

    /**
     * <p>
     * Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe that was
     * detected.
     * </p>
     * 
     * @return Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe
     *         that was detected.
     */
    public final PortProbeAction portProbeAction() {
        return portProbeAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(networkConnectionAction());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRequestAction());
        hashCode = 31 * hashCode + Objects.hashCode(portProbeAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(actionType(), other.actionType())
                && Objects.equals(networkConnectionAction(), other.networkConnectionAction())
                && Objects.equals(awsApiCallAction(), other.awsApiCallAction())
                && Objects.equals(dnsRequestAction(), other.dnsRequestAction())
                && Objects.equals(portProbeAction(), other.portProbeAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("ActionType", actionType())
                .add("NetworkConnectionAction", networkConnectionAction()).add("AwsApiCallAction", awsApiCallAction())
                .add("DnsRequestAction", dnsRequestAction()).add("PortProbeAction", portProbeAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "NetworkConnectionAction":
            return Optional.ofNullable(clazz.cast(networkConnectionAction()));
        case "AwsApiCallAction":
            return Optional.ofNullable(clazz.cast(awsApiCallAction()));
        case "DnsRequestAction":
            return Optional.ofNullable(clazz.cast(dnsRequestAction()));
        case "PortProbeAction":
            return Optional.ofNullable(clazz.cast(portProbeAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The type of action that was detected. The possible action types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NETWORK_CONNECTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_API_CALL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DNS_REQUEST</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PORT_PROBE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param actionType
         *        The type of action that was detected. The possible action types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NETWORK_CONNECTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_API_CALL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DNS_REQUEST</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PORT_PROBE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the network
         * connection that was detected.
         * </p>
         * 
         * @param networkConnectionAction
         *        Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the
         *        network connection that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction);

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>NETWORK_CONNECTION</code>. Provides details about the network
         * connection that was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConnectionAction.Builder} avoiding the
         * need to create one manually via {@link NetworkConnectionAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConnectionAction.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConnectionAction(NetworkConnectionAction)}.
         * 
         * @param networkConnectionAction
         *        a consumer that will call methods on {@link NetworkConnectionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConnectionAction(NetworkConnectionAction)
         */
        default Builder networkConnectionAction(Consumer<NetworkConnectionAction.Builder> networkConnectionAction) {
            return networkConnectionAction(NetworkConnectionAction.builder().applyMutation(networkConnectionAction).build());
        }

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call that
         * was detected.
         * </p>
         * 
         * @param awsApiCallAction
         *        Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call
         *        that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiCallAction(AwsApiCallAction awsApiCallAction);

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>AWS_API_CALL</code>. Provides details about the API call that
         * was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsApiCallAction.Builder} avoiding the need to
         * create one manually via {@link AwsApiCallAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsApiCallAction.Builder#build()} is called immediately and its
         * result is passed to {@link #awsApiCallAction(AwsApiCallAction)}.
         * 
         * @param awsApiCallAction
         *        a consumer that will call methods on {@link AwsApiCallAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiCallAction(AwsApiCallAction)
         */
        default Builder awsApiCallAction(Consumer<AwsApiCallAction.Builder> awsApiCallAction) {
            return awsApiCallAction(AwsApiCallAction.builder().applyMutation(awsApiCallAction).build());
        }

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS request that
         * was detected.
         * </p>
         * 
         * @param dnsRequestAction
         *        Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS
         *        request that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRequestAction(DnsRequestAction dnsRequestAction);

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>DNS_REQUEST</code>. Provides details about the DNS request that
         * was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRequestAction.Builder} avoiding the need to
         * create one manually via {@link DnsRequestAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRequestAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsRequestAction(DnsRequestAction)}.
         * 
         * @param dnsRequestAction
         *        a consumer that will call methods on {@link DnsRequestAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRequestAction(DnsRequestAction)
         */
        default Builder dnsRequestAction(Consumer<DnsRequestAction.Builder> dnsRequestAction) {
            return dnsRequestAction(DnsRequestAction.builder().applyMutation(dnsRequestAction).build());
        }

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe that
         * was detected.
         * </p>
         * 
         * @param portProbeAction
         *        Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe
         *        that was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portProbeAction(PortProbeAction portProbeAction);

        /**
         * <p>
         * Included if <code>ActionType</code> is <code>PORT_PROBE</code>. Provides details about the port probe that
         * was detected.
         * </p>
         * This is a convenience that creates an instance of the {@link PortProbeAction.Builder} avoiding the need to
         * create one manually via {@link PortProbeAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortProbeAction.Builder#build()} is called immediately and its
         * result is passed to {@link #portProbeAction(PortProbeAction)}.
         * 
         * @param portProbeAction
         *        a consumer that will call methods on {@link PortProbeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portProbeAction(PortProbeAction)
         */
        default Builder portProbeAction(Consumer<PortProbeAction.Builder> portProbeAction) {
            return portProbeAction(PortProbeAction.builder().applyMutation(portProbeAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private NetworkConnectionAction networkConnectionAction;

        private AwsApiCallAction awsApiCallAction;

        private DnsRequestAction dnsRequestAction;

        private PortProbeAction portProbeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            actionType(model.actionType);
            networkConnectionAction(model.networkConnectionAction);
            awsApiCallAction(model.awsApiCallAction);
            dnsRequestAction(model.dnsRequestAction);
            portProbeAction(model.portProbeAction);
        }

        public final String getActionType() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final NetworkConnectionAction.Builder getNetworkConnectionAction() {
            return networkConnectionAction != null ? networkConnectionAction.toBuilder() : null;
        }

        @Override
        public final Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction;
            return this;
        }

        public final void setNetworkConnectionAction(NetworkConnectionAction.BuilderImpl networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction != null ? networkConnectionAction.build() : null;
        }

        public final AwsApiCallAction.Builder getAwsApiCallAction() {
            return awsApiCallAction != null ? awsApiCallAction.toBuilder() : null;
        }

        @Override
        public final Builder awsApiCallAction(AwsApiCallAction awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction;
            return this;
        }

        public final void setAwsApiCallAction(AwsApiCallAction.BuilderImpl awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction != null ? awsApiCallAction.build() : null;
        }

        public final DnsRequestAction.Builder getDnsRequestAction() {
            return dnsRequestAction != null ? dnsRequestAction.toBuilder() : null;
        }

        @Override
        public final Builder dnsRequestAction(DnsRequestAction dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction;
            return this;
        }

        public final void setDnsRequestAction(DnsRequestAction.BuilderImpl dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction != null ? dnsRequestAction.build() : null;
        }

        public final PortProbeAction.Builder getPortProbeAction() {
            return portProbeAction != null ? portProbeAction.toBuilder() : null;
        }

        @Override
        public final Builder portProbeAction(PortProbeAction portProbeAction) {
            this.portProbeAction = portProbeAction;
            return this;
        }

        public final void setPortProbeAction(PortProbeAction.BuilderImpl portProbeAction) {
            this.portProbeAction = portProbeAction != null ? portProbeAction.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
