/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbDomainMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbDomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(AwsRdsDbDomainMembership.getter(AwsRdsDbDomainMembership::domain)).setter(AwsRdsDbDomainMembership.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRdsDbDomainMembership.getter(AwsRdsDbDomainMembership::status)).setter(AwsRdsDbDomainMembership.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FQDN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fqdn").getter(AwsRdsDbDomainMembership.getter(AwsRdsDbDomainMembership::fqdn)).setter(AwsRdsDbDomainMembership.setter(Builder::fqdn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fqdn").build()}).build();
    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleName").getter(AwsRdsDbDomainMembership.getter(AwsRdsDbDomainMembership::iamRoleName)).setter(AwsRdsDbDomainMembership.setter(Builder::iamRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD, FQDN_FIELD, IAM_ROLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String status;
    private final String fqdn;
    private final String iamRoleName;

    private AwsRdsDbDomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
    }

    public String domain() {
        return this.domain;
    }

    public String status() {
        return this.status;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String iamRoleName() {
        return this.iamRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbDomainMembership)) {
            return false;
        }
        AwsRdsDbDomainMembership other = (AwsRdsDbDomainMembership)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.fqdn(), other.fqdn()) && Objects.equals(this.iamRoleName(), other.iamRoleName());
    }

    public String toString() {
        return ToString.builder((String)"AwsRdsDbDomainMembership").add("Domain", (Object)this.domain()).add("Status", (Object)this.status()).add("Fqdn", (Object)this.fqdn()).add("IamRoleName", (Object)this.iamRoleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Fqdn": {
                return Optional.ofNullable(clazz.cast(this.fqdn()));
            }
            case "IamRoleName": {
                return Optional.ofNullable(clazz.cast(this.iamRoleName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbDomainMembership, T> g) {
        return obj -> g.apply((AwsRdsDbDomainMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String status;
        private String fqdn;
        private String iamRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbDomainMembership model) {
            this.domain(model.domain);
            this.status(model.status);
            this.fqdn(model.fqdn);
            this.iamRoleName(model.iamRoleName);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFqdn() {
            return this.fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        public final String getIamRoleName() {
            return this.iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        public AwsRdsDbDomainMembership build() {
            return new AwsRdsDbDomainMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbDomainMembership> {
        public Builder domain(String var1);

        public Builder status(String var1);

        public Builder fqdn(String var1);

        public Builder iamRoleName(String var1);
    }
}

