/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole;
import software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRolesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamInstanceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamInstanceProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::arn)).setter(AwsIamInstanceProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateDate").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::createDate)).setter(AwsIamInstanceProfile.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileId").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::instanceProfileId)).setter(AwsIamInstanceProfile.setter(Builder::instanceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileId").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::instanceProfileName)).setter(AwsIamInstanceProfile.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::path)).setter(AwsIamInstanceProfile.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<List<AwsIamInstanceProfileRole>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roles").getter(AwsIamInstanceProfile.getter(AwsIamInstanceProfile::roles)).setter(AwsIamInstanceProfile.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsIamInstanceProfileRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATE_DATE_FIELD, INSTANCE_PROFILE_ID_FIELD, INSTANCE_PROFILE_NAME_FIELD, PATH_FIELD, ROLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String createDate;
    private final String instanceProfileId;
    private final String instanceProfileName;
    private final String path;
    private final List<AwsIamInstanceProfileRole> roles;

    private AwsIamInstanceProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.instanceProfileId = builder.instanceProfileId;
        this.instanceProfileName = builder.instanceProfileName;
        this.path = builder.path;
        this.roles = builder.roles;
    }

    public String arn() {
        return this.arn;
    }

    public String createDate() {
        return this.createDate;
    }

    public String instanceProfileId() {
        return this.instanceProfileId;
    }

    public String instanceProfileName() {
        return this.instanceProfileName;
    }

    public String path() {
        return this.path;
    }

    public boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public List<AwsIamInstanceProfileRole> roles() {
        return this.roles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamInstanceProfile)) {
            return false;
        }
        AwsIamInstanceProfile other = (AwsIamInstanceProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.instanceProfileId(), other.instanceProfileId()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.path(), other.path()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles());
    }

    public String toString() {
        return ToString.builder((String)"AwsIamInstanceProfile").add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("InstanceProfileId", (Object)this.instanceProfileId()).add("InstanceProfileName", (Object)this.instanceProfileName()).add("Path", (Object)this.path()).add("Roles", this.hasRoles() ? this.roles() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "InstanceProfileId": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileId()));
            }
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamInstanceProfile, T> g) {
        return obj -> g.apply((AwsIamInstanceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String createDate;
        private String instanceProfileId;
        private String instanceProfileName;
        private String path;
        private List<AwsIamInstanceProfileRole> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamInstanceProfile model) {
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.instanceProfileId(model.instanceProfileId);
            this.instanceProfileName(model.instanceProfileName);
            this.path(model.path);
            this.roles(model.roles);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public final String getInstanceProfileId() {
            return this.instanceProfileId;
        }

        @Override
        public final Builder instanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
            return this;
        }

        public final void setInstanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<AwsIamInstanceProfileRole.Builder> getRoles() {
            if (this.roles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roles != null ? (Collection)this.roles.stream().map(AwsIamInstanceProfileRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<AwsIamInstanceProfileRole> roles) {
            this.roles = AwsIamInstanceProfileRolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(AwsIamInstanceProfileRole ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<AwsIamInstanceProfileRole.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (AwsIamInstanceProfileRole)((AwsIamInstanceProfileRole.Builder)AwsIamInstanceProfileRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<AwsIamInstanceProfileRole.BuilderImpl> roles) {
            this.roles = AwsIamInstanceProfileRolesCopier.copyFromBuilder(roles);
        }

        public AwsIamInstanceProfile build() {
            return new AwsIamInstanceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamInstanceProfile> {
        public Builder arn(String var1);

        public Builder createDate(String var1);

        public Builder instanceProfileId(String var1);

        public Builder instanceProfileName(String var1);

        public Builder path(String var1);

        public Builder roles(Collection<AwsIamInstanceProfileRole> var1);

        public Builder roles(AwsIamInstanceProfileRole ... var1);

        public Builder roles(Consumer<AwsIamInstanceProfileRole.Builder> ... var1);
    }
}

