/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbInstanceAssociatedRole
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbInstanceAssociatedRole> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AwsRdsDbInstanceAssociatedRole.getter(AwsRdsDbInstanceAssociatedRole::roleArn)).setter(AwsRdsDbInstanceAssociatedRole.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(AwsRdsDbInstanceAssociatedRole.getter(AwsRdsDbInstanceAssociatedRole::featureName)).setter(AwsRdsDbInstanceAssociatedRole.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRdsDbInstanceAssociatedRole.getter(AwsRdsDbInstanceAssociatedRole::status)).setter(AwsRdsDbInstanceAssociatedRole.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, FEATURE_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String featureName;
    private final String status;

    private AwsRdsDbInstanceAssociatedRole(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.featureName = builder.featureName;
        this.status = builder.status;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String featureName() {
        return this.featureName;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbInstanceAssociatedRole)) {
            return false;
        }
        AwsRdsDbInstanceAssociatedRole other = (AwsRdsDbInstanceAssociatedRole)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"AwsRdsDbInstanceAssociatedRole").add("RoleArn", (Object)this.roleArn()).add("FeatureName", (Object)this.featureName()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbInstanceAssociatedRole, T> g) {
        return obj -> g.apply((AwsRdsDbInstanceAssociatedRole)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String featureName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbInstanceAssociatedRole model) {
            this.roleArn(model.roleArn);
            this.featureName(model.featureName);
            this.status(model.status);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public AwsRdsDbInstanceAssociatedRole build() {
            return new AwsRdsDbInstanceAssociatedRole(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbInstanceAssociatedRole> {
        public Builder roleArn(String var1);

        public Builder featureName(String var1);

        public Builder status(String var1);
    }
}

