/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceSecurityGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2NetworkInterfaceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2NetworkInterfaceDetails> {
    private static final SdkField<AwsEc2NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::attachment)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::attachment)).constructor(AwsEc2NetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::networkInterfaceId)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<List<AwsEc2NetworkInterfaceSecurityGroup>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::securityGroups)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkInterfaceSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AwsEc2NetworkInterfaceDetails.getter(AwsEc2NetworkInterfaceDetails::sourceDestCheck)).setter(AwsEc2NetworkInterfaceDetails.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, NETWORK_INTERFACE_ID_FIELD, SECURITY_GROUPS_FIELD, SOURCE_DEST_CHECK_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsEc2NetworkInterfaceAttachment attachment;
    private final String networkInterfaceId;
    private final List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups;
    private final Boolean sourceDestCheck;

    private AwsEc2NetworkInterfaceDetails(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public AwsEc2NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceDetails)) {
            return false;
        }
        AwsEc2NetworkInterfaceDetails other = (AwsEc2NetworkInterfaceDetails)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2NetworkInterfaceDetails").add("Attachment", (Object)this.attachment()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SecurityGroups", this.securityGroups()).add("SourceDestCheck", (Object)this.sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceDetails, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsEc2NetworkInterfaceAttachment attachment;
        private String networkInterfaceId;
        private List<AwsEc2NetworkInterfaceSecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceDetails model) {
            this.attachment(model.attachment);
            this.networkInterfaceId(model.networkInterfaceId);
            this.securityGroups(model.securityGroups);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final AwsEc2NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(AwsEc2NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(AwsEc2NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<AwsEc2NetworkInterfaceSecurityGroup.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(AwsEc2NetworkInterfaceSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (AwsEc2NetworkInterfaceSecurityGroup)((AwsEc2NetworkInterfaceSecurityGroup.Builder)AwsEc2NetworkInterfaceSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = AwsEc2NetworkInterfaceSecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public AwsEc2NetworkInterfaceDetails build() {
            return new AwsEc2NetworkInterfaceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2NetworkInterfaceDetails> {
        public Builder attachment(AwsEc2NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<AwsEc2NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((AwsEc2NetworkInterfaceAttachment)((AwsEc2NetworkInterfaceAttachment.Builder)AwsEc2NetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder networkInterfaceId(String var1);

        public Builder securityGroups(Collection<AwsEc2NetworkInterfaceSecurityGroup> var1);

        public Builder securityGroups(AwsEc2NetworkInterfaceSecurityGroup ... var1);

        public Builder securityGroups(Consumer<AwsEc2NetworkInterfaceSecurityGroup.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);
    }
}

