/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a rule to exclude from a rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WafExcludedRule implements SdkPojo, Serializable, ToCopyableBuilder<WafExcludedRule.Builder, WafExcludedRule> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WafExcludedRule::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleId;

    private WafExcludedRule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
    }

    /**
     * <p>
     * The unique identifier for the rule to exclude from the rule group.
     * </p>
     * 
     * @return The unique identifier for the rule to exclude from the rule group.
     */
    public String ruleId() {
        return ruleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WafExcludedRule)) {
            return false;
        }
        WafExcludedRule other = (WafExcludedRule) obj;
        return Objects.equals(ruleId(), other.ruleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WafExcludedRule").add("RuleId", ruleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WafExcludedRule, T> g) {
        return obj -> g.apply((WafExcludedRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WafExcludedRule> {
        /**
         * <p>
         * The unique identifier for the rule to exclude from the rule group.
         * </p>
         * 
         * @param ruleId
         *        The unique identifier for the rule to exclude from the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);
    }

    static final class BuilderImpl implements Builder {
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(WafExcludedRule model) {
            ruleId(model.ruleId);
        }

        public final String getRuleId() {
            return ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public WafExcludedRule build() {
            return new WafExcludedRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
