/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details about a resource related to a finding.
 * </p>
 * <p>
 * To provide the details, use the object that corresponds to the resource type. For example, if the resource type is
 * <code>AwsEc2Instance</code>, then you use the <code>AwsEc2Instance</code> object to provide the details.
 * </p>
 * <p>
 * If the type-specific object does not contain all of the fields you want to populate, then you use the
 * <code>Other</code> object to populate those additional fields.
 * </p>
 * <p>
 * You also use the <code>Other</code> object to populate the details when the selected type does not have a
 * corresponding object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<AwsCodeBuildProjectDetails> AWS_CODE_BUILD_PROJECT_FIELD = SdkField
            .<AwsCodeBuildProjectDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsCodeBuildProject))
            .setter(setter(Builder::awsCodeBuildProject)).constructor(AwsCodeBuildProjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCodeBuildProject").build())
            .build();

    private static final SdkField<AwsCloudFrontDistributionDetails> AWS_CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField
            .<AwsCloudFrontDistributionDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsCloudFrontDistribution)).setter(setter(Builder::awsCloudFrontDistribution))
            .constructor(AwsCloudFrontDistributionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCloudFrontDistribution").build())
            .build();

    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField
            .<AwsEc2InstanceDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsEc2Instance))
            .setter(setter(Builder::awsEc2Instance)).constructor(AwsEc2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Instance").build()).build();

    private static final SdkField<AwsEc2NetworkInterfaceDetails> AWS_EC2_NETWORK_INTERFACE_FIELD = SdkField
            .<AwsEc2NetworkInterfaceDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsEc2NetworkInterface)).setter(setter(Builder::awsEc2NetworkInterface))
            .constructor(AwsEc2NetworkInterfaceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterface").build())
            .build();

    private static final SdkField<AwsEc2SecurityGroupDetails> AWS_EC2_SECURITY_GROUP_FIELD = SdkField
            .<AwsEc2SecurityGroupDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsEc2SecurityGroup))
            .setter(setter(Builder::awsEc2SecurityGroup)).constructor(AwsEc2SecurityGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2SecurityGroup").build())
            .build();

    private static final SdkField<AwsElbv2LoadBalancerDetails> AWS_ELBV2_LOAD_BALANCER_FIELD = SdkField
            .<AwsElbv2LoadBalancerDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsElbv2LoadBalancer)).setter(setter(Builder::awsElbv2LoadBalancer))
            .constructor(AwsElbv2LoadBalancerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElbv2LoadBalancer").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainDetails> AWS_ELASTICSEARCH_DOMAIN_FIELD = SdkField
            .<AwsElasticsearchDomainDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsElasticsearchDomain)).setter(setter(Builder::awsElasticsearchDomain))
            .constructor(AwsElasticsearchDomainDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsElasticsearchDomain").build())
            .build();

    private static final SdkField<AwsS3BucketDetails> AWS_S3_BUCKET_FIELD = SdkField
            .<AwsS3BucketDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsS3Bucket))
            .setter(setter(Builder::awsS3Bucket)).constructor(AwsS3BucketDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Bucket").build()).build();

    private static final SdkField<AwsS3ObjectDetails> AWS_S3_OBJECT_FIELD = SdkField
            .<AwsS3ObjectDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsS3Object))
            .setter(setter(Builder::awsS3Object)).constructor(AwsS3ObjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Object").build()).build();

    private static final SdkField<AwsIamAccessKeyDetails> AWS_IAM_ACCESS_KEY_FIELD = SdkField
            .<AwsIamAccessKeyDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsIamAccessKey))
            .setter(setter(Builder::awsIamAccessKey)).constructor(AwsIamAccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamAccessKey").build()).build();

    private static final SdkField<AwsIamRoleDetails> AWS_IAM_ROLE_FIELD = SdkField
            .<AwsIamRoleDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsIamRole))
            .setter(setter(Builder::awsIamRole)).constructor(AwsIamRoleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamRole").build()).build();

    private static final SdkField<AwsKmsKeyDetails> AWS_KMS_KEY_FIELD = SdkField
            .<AwsKmsKeyDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsKmsKey))
            .setter(setter(Builder::awsKmsKey)).constructor(AwsKmsKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKey").build()).build();

    private static final SdkField<AwsLambdaFunctionDetails> AWS_LAMBDA_FUNCTION_FIELD = SdkField
            .<AwsLambdaFunctionDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsLambdaFunction))
            .setter(setter(Builder::awsLambdaFunction)).constructor(AwsLambdaFunctionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaFunction").build()).build();

    private static final SdkField<AwsLambdaLayerVersionDetails> AWS_LAMBDA_LAYER_VERSION_FIELD = SdkField
            .<AwsLambdaLayerVersionDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceDetails::awsLambdaLayerVersion)).setter(setter(Builder::awsLambdaLayerVersion))
            .constructor(AwsLambdaLayerVersionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambdaLayerVersion").build())
            .build();

    private static final SdkField<AwsRdsDbInstanceDetails> AWS_RDS_DB_INSTANCE_FIELD = SdkField
            .<AwsRdsDbInstanceDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsRdsDbInstance))
            .setter(setter(Builder::awsRdsDbInstance)).constructor(AwsRdsDbInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRdsDbInstance").build()).build();

    private static final SdkField<AwsSnsTopicDetails> AWS_SNS_TOPIC_FIELD = SdkField
            .<AwsSnsTopicDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsSnsTopic))
            .setter(setter(Builder::awsSnsTopic)).constructor(AwsSnsTopicDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSnsTopic").build()).build();

    private static final SdkField<AwsSqsQueueDetails> AWS_SQS_QUEUE_FIELD = SdkField
            .<AwsSqsQueueDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsSqsQueue))
            .setter(setter(Builder::awsSqsQueue)).constructor(AwsSqsQueueDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSqsQueue").build()).build();

    private static final SdkField<AwsWafWebAclDetails> AWS_WAF_WEB_ACL_FIELD = SdkField
            .<AwsWafWebAclDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::awsWafWebAcl))
            .setter(setter(Builder::awsWafWebAcl)).constructor(AwsWafWebAclDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsWafWebAcl").build()).build();

    private static final SdkField<ContainerDetails> CONTAINER_FIELD = SdkField
            .<ContainerDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::container))
            .setter(setter(Builder::container)).constructor(ContainerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<Map<String, String>> OTHER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ResourceDetails::other))
            .setter(setter(Builder::other))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_CODE_BUILD_PROJECT_FIELD,
            AWS_CLOUD_FRONT_DISTRIBUTION_FIELD, AWS_EC2_INSTANCE_FIELD, AWS_EC2_NETWORK_INTERFACE_FIELD,
            AWS_EC2_SECURITY_GROUP_FIELD, AWS_ELBV2_LOAD_BALANCER_FIELD, AWS_ELASTICSEARCH_DOMAIN_FIELD, AWS_S3_BUCKET_FIELD,
            AWS_S3_OBJECT_FIELD, AWS_IAM_ACCESS_KEY_FIELD, AWS_IAM_ROLE_FIELD, AWS_KMS_KEY_FIELD, AWS_LAMBDA_FUNCTION_FIELD,
            AWS_LAMBDA_LAYER_VERSION_FIELD, AWS_RDS_DB_INSTANCE_FIELD, AWS_SNS_TOPIC_FIELD, AWS_SQS_QUEUE_FIELD,
            AWS_WAF_WEB_ACL_FIELD, CONTAINER_FIELD, OTHER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCodeBuildProjectDetails awsCodeBuildProject;

    private final AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

    private final AwsEc2InstanceDetails awsEc2Instance;

    private final AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;

    private final AwsEc2SecurityGroupDetails awsEc2SecurityGroup;

    private final AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

    private final AwsElasticsearchDomainDetails awsElasticsearchDomain;

    private final AwsS3BucketDetails awsS3Bucket;

    private final AwsS3ObjectDetails awsS3Object;

    private final AwsIamAccessKeyDetails awsIamAccessKey;

    private final AwsIamRoleDetails awsIamRole;

    private final AwsKmsKeyDetails awsKmsKey;

    private final AwsLambdaFunctionDetails awsLambdaFunction;

    private final AwsLambdaLayerVersionDetails awsLambdaLayerVersion;

    private final AwsRdsDbInstanceDetails awsRdsDbInstance;

    private final AwsSnsTopicDetails awsSnsTopic;

    private final AwsSqsQueueDetails awsSqsQueue;

    private final AwsWafWebAclDetails awsWafWebAcl;

    private final ContainerDetails container;

    private final Map<String, String> other;

    private ResourceDetails(BuilderImpl builder) {
        this.awsCodeBuildProject = builder.awsCodeBuildProject;
        this.awsCloudFrontDistribution = builder.awsCloudFrontDistribution;
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsEc2NetworkInterface = builder.awsEc2NetworkInterface;
        this.awsEc2SecurityGroup = builder.awsEc2SecurityGroup;
        this.awsElbv2LoadBalancer = builder.awsElbv2LoadBalancer;
        this.awsElasticsearchDomain = builder.awsElasticsearchDomain;
        this.awsS3Bucket = builder.awsS3Bucket;
        this.awsS3Object = builder.awsS3Object;
        this.awsIamAccessKey = builder.awsIamAccessKey;
        this.awsIamRole = builder.awsIamRole;
        this.awsKmsKey = builder.awsKmsKey;
        this.awsLambdaFunction = builder.awsLambdaFunction;
        this.awsLambdaLayerVersion = builder.awsLambdaLayerVersion;
        this.awsRdsDbInstance = builder.awsRdsDbInstance;
        this.awsSnsTopic = builder.awsSnsTopic;
        this.awsSqsQueue = builder.awsSqsQueue;
        this.awsWafWebAcl = builder.awsWafWebAcl;
        this.container = builder.container;
        this.other = builder.other;
    }

    /**
     * <p>
     * Details for an AWS CodeBuild project.
     * </p>
     * 
     * @return Details for an AWS CodeBuild project.
     */
    public AwsCodeBuildProjectDetails awsCodeBuildProject() {
        return awsCodeBuildProject;
    }

    /**
     * <p>
     * Details about a CloudFront distribution.
     * </p>
     * 
     * @return Details about a CloudFront distribution.
     */
    public AwsCloudFrontDistributionDetails awsCloudFrontDistribution() {
        return awsCloudFrontDistribution;
    }

    /**
     * <p>
     * Details about an Amazon EC2 instance related to a finding.
     * </p>
     * 
     * @return Details about an Amazon EC2 instance related to a finding.
     */
    public AwsEc2InstanceDetails awsEc2Instance() {
        return awsEc2Instance;
    }

    /**
     * <p>
     * Details for an Amazon EC2 network interface.
     * </p>
     * 
     * @return Details for an Amazon EC2 network interface.
     */
    public AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface() {
        return awsEc2NetworkInterface;
    }

    /**
     * <p>
     * Details for an EC2 security group.
     * </p>
     * 
     * @return Details for an EC2 security group.
     */
    public AwsEc2SecurityGroupDetails awsEc2SecurityGroup() {
        return awsEc2SecurityGroup;
    }

    /**
     * <p>
     * Details about a load balancer.
     * </p>
     * 
     * @return Details about a load balancer.
     */
    public AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer() {
        return awsElbv2LoadBalancer;
    }

    /**
     * <p>
     * Details for an Elasticsearch domain.
     * </p>
     * 
     * @return Details for an Elasticsearch domain.
     */
    public AwsElasticsearchDomainDetails awsElasticsearchDomain() {
        return awsElasticsearchDomain;
    }

    /**
     * <p>
     * Details about an Amazon S3 bucket related to a finding.
     * </p>
     * 
     * @return Details about an Amazon S3 bucket related to a finding.
     */
    public AwsS3BucketDetails awsS3Bucket() {
        return awsS3Bucket;
    }

    /**
     * <p>
     * Details about an Amazon S3 object related to a finding.
     * </p>
     * 
     * @return Details about an Amazon S3 object related to a finding.
     */
    public AwsS3ObjectDetails awsS3Object() {
        return awsS3Object;
    }

    /**
     * <p>
     * Details about an IAM access key related to a finding.
     * </p>
     * 
     * @return Details about an IAM access key related to a finding.
     */
    public AwsIamAccessKeyDetails awsIamAccessKey() {
        return awsIamAccessKey;
    }

    /**
     * <p>
     * Details about an IAM role.
     * </p>
     * 
     * @return Details about an IAM role.
     */
    public AwsIamRoleDetails awsIamRole() {
        return awsIamRole;
    }

    /**
     * <p>
     * Details about a KMS key.
     * </p>
     * 
     * @return Details about a KMS key.
     */
    public AwsKmsKeyDetails awsKmsKey() {
        return awsKmsKey;
    }

    /**
     * <p>
     * Details about a Lambda function.
     * </p>
     * 
     * @return Details about a Lambda function.
     */
    public AwsLambdaFunctionDetails awsLambdaFunction() {
        return awsLambdaFunction;
    }

    /**
     * <p>
     * Details for a Lambda layer version.
     * </p>
     * 
     * @return Details for a Lambda layer version.
     */
    public AwsLambdaLayerVersionDetails awsLambdaLayerVersion() {
        return awsLambdaLayerVersion;
    }

    /**
     * <p>
     * Details for an Amazon RDS database instance.
     * </p>
     * 
     * @return Details for an Amazon RDS database instance.
     */
    public AwsRdsDbInstanceDetails awsRdsDbInstance() {
        return awsRdsDbInstance;
    }

    /**
     * <p>
     * Details about an SNS topic.
     * </p>
     * 
     * @return Details about an SNS topic.
     */
    public AwsSnsTopicDetails awsSnsTopic() {
        return awsSnsTopic;
    }

    /**
     * <p>
     * Details about an SQS queue.
     * </p>
     * 
     * @return Details about an SQS queue.
     */
    public AwsSqsQueueDetails awsSqsQueue() {
        return awsSqsQueue;
    }

    /**
     * <p>
     * Details for a WAF WebACL.
     * </p>
     * 
     * @return Details for a WAF WebACL.
     */
    public AwsWafWebAclDetails awsWafWebAcl() {
        return awsWafWebAcl;
    }

    /**
     * <p>
     * Details about a container resource related to a finding.
     * </p>
     * 
     * @return Details about a container resource related to a finding.
     */
    public ContainerDetails container() {
        return container;
    }

    /**
     * Returns true if the Other property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOther() {
        return other != null && !(other instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about a resource that are not available in a type-specific details object. Use the <code>Other</code>
     * object in the following cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The type-specific object does not contain all of the fields that you want to populate. In this case, first use
     * the type-specific object to populate those fields. Use the <code>Other</code> object to populate the fields that
     * are missing from the type-specific object.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type does not have a corresponding object. This includes resources for which the type is
     * <code>Other</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOther()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about a resource that are not available in a type-specific details object. Use the
     *         <code>Other</code> object in the following cases.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The type-specific object does not contain all of the fields that you want to populate. In this case,
     *         first use the type-specific object to populate those fields. Use the <code>Other</code> object to
     *         populate the fields that are missing from the type-specific object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type does not have a corresponding object. This includes resources for which the type is
     *         <code>Other</code>.
     *         </p>
     *         </li>
     */
    public Map<String, String> other() {
        return other;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsCodeBuildProject());
        hashCode = 31 * hashCode + Objects.hashCode(awsCloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(awsEc2SecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(awsElbv2LoadBalancer());
        hashCode = 31 * hashCode + Objects.hashCode(awsElasticsearchDomain());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(awsS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamRole());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(awsLambdaLayerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(awsRdsDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(awsSnsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(awsSqsQueue());
        hashCode = 31 * hashCode + Objects.hashCode(awsWafWebAcl());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(other());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(awsCodeBuildProject(), other.awsCodeBuildProject())
                && Objects.equals(awsCloudFrontDistribution(), other.awsCloudFrontDistribution())
                && Objects.equals(awsEc2Instance(), other.awsEc2Instance())
                && Objects.equals(awsEc2NetworkInterface(), other.awsEc2NetworkInterface())
                && Objects.equals(awsEc2SecurityGroup(), other.awsEc2SecurityGroup())
                && Objects.equals(awsElbv2LoadBalancer(), other.awsElbv2LoadBalancer())
                && Objects.equals(awsElasticsearchDomain(), other.awsElasticsearchDomain())
                && Objects.equals(awsS3Bucket(), other.awsS3Bucket()) && Objects.equals(awsS3Object(), other.awsS3Object())
                && Objects.equals(awsIamAccessKey(), other.awsIamAccessKey()) && Objects.equals(awsIamRole(), other.awsIamRole())
                && Objects.equals(awsKmsKey(), other.awsKmsKey())
                && Objects.equals(awsLambdaFunction(), other.awsLambdaFunction())
                && Objects.equals(awsLambdaLayerVersion(), other.awsLambdaLayerVersion())
                && Objects.equals(awsRdsDbInstance(), other.awsRdsDbInstance())
                && Objects.equals(awsSnsTopic(), other.awsSnsTopic()) && Objects.equals(awsSqsQueue(), other.awsSqsQueue())
                && Objects.equals(awsWafWebAcl(), other.awsWafWebAcl()) && Objects.equals(container(), other.container())
                && Objects.equals(other(), other.other());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceDetails").add("AwsCodeBuildProject", awsCodeBuildProject())
                .add("AwsCloudFrontDistribution", awsCloudFrontDistribution()).add("AwsEc2Instance", awsEc2Instance())
                .add("AwsEc2NetworkInterface", awsEc2NetworkInterface()).add("AwsEc2SecurityGroup", awsEc2SecurityGroup())
                .add("AwsElbv2LoadBalancer", awsElbv2LoadBalancer()).add("AwsElasticsearchDomain", awsElasticsearchDomain())
                .add("AwsS3Bucket", awsS3Bucket()).add("AwsS3Object", awsS3Object()).add("AwsIamAccessKey", awsIamAccessKey())
                .add("AwsIamRole", awsIamRole()).add("AwsKmsKey", awsKmsKey()).add("AwsLambdaFunction", awsLambdaFunction())
                .add("AwsLambdaLayerVersion", awsLambdaLayerVersion()).add("AwsRdsDbInstance", awsRdsDbInstance())
                .add("AwsSnsTopic", awsSnsTopic()).add("AwsSqsQueue", awsSqsQueue()).add("AwsWafWebAcl", awsWafWebAcl())
                .add("Container", container()).add("Other", other()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsCodeBuildProject":
            return Optional.ofNullable(clazz.cast(awsCodeBuildProject()));
        case "AwsCloudFrontDistribution":
            return Optional.ofNullable(clazz.cast(awsCloudFrontDistribution()));
        case "AwsEc2Instance":
            return Optional.ofNullable(clazz.cast(awsEc2Instance()));
        case "AwsEc2NetworkInterface":
            return Optional.ofNullable(clazz.cast(awsEc2NetworkInterface()));
        case "AwsEc2SecurityGroup":
            return Optional.ofNullable(clazz.cast(awsEc2SecurityGroup()));
        case "AwsElbv2LoadBalancer":
            return Optional.ofNullable(clazz.cast(awsElbv2LoadBalancer()));
        case "AwsElasticsearchDomain":
            return Optional.ofNullable(clazz.cast(awsElasticsearchDomain()));
        case "AwsS3Bucket":
            return Optional.ofNullable(clazz.cast(awsS3Bucket()));
        case "AwsS3Object":
            return Optional.ofNullable(clazz.cast(awsS3Object()));
        case "AwsIamAccessKey":
            return Optional.ofNullable(clazz.cast(awsIamAccessKey()));
        case "AwsIamRole":
            return Optional.ofNullable(clazz.cast(awsIamRole()));
        case "AwsKmsKey":
            return Optional.ofNullable(clazz.cast(awsKmsKey()));
        case "AwsLambdaFunction":
            return Optional.ofNullable(clazz.cast(awsLambdaFunction()));
        case "AwsLambdaLayerVersion":
            return Optional.ofNullable(clazz.cast(awsLambdaLayerVersion()));
        case "AwsRdsDbInstance":
            return Optional.ofNullable(clazz.cast(awsRdsDbInstance()));
        case "AwsSnsTopic":
            return Optional.ofNullable(clazz.cast(awsSnsTopic()));
        case "AwsSqsQueue":
            return Optional.ofNullable(clazz.cast(awsSqsQueue()));
        case "AwsWafWebAcl":
            return Optional.ofNullable(clazz.cast(awsWafWebAcl()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Other":
            return Optional.ofNullable(clazz.cast(other()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * Details for an AWS CodeBuild project.
         * </p>
         * 
         * @param awsCodeBuildProject
         *        Details for an AWS CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCodeBuildProject(AwsCodeBuildProjectDetails awsCodeBuildProject);

        /**
         * <p>
         * Details for an AWS CodeBuild project.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCodeBuildProjectDetails.Builder} avoiding the
         * need to create one manually via {@link AwsCodeBuildProjectDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsCodeBuildProject(AwsCodeBuildProjectDetails)}.
         * 
         * @param awsCodeBuildProject
         *        a consumer that will call methods on {@link AwsCodeBuildProjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCodeBuildProject(AwsCodeBuildProjectDetails)
         */
        default Builder awsCodeBuildProject(Consumer<AwsCodeBuildProjectDetails.Builder> awsCodeBuildProject) {
            return awsCodeBuildProject(AwsCodeBuildProjectDetails.builder().applyMutation(awsCodeBuildProject).build());
        }

        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * 
         * @param awsCloudFrontDistribution
         *        Details about a CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution);

        /**
         * <p>
         * Details about a CloudFront distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCloudFrontDistributionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)}.
         * 
         * @param awsCloudFrontDistribution
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsCloudFrontDistribution(AwsCloudFrontDistributionDetails)
         */
        default Builder awsCloudFrontDistribution(Consumer<AwsCloudFrontDistributionDetails.Builder> awsCloudFrontDistribution) {
            return awsCloudFrontDistribution(AwsCloudFrontDistributionDetails.builder().applyMutation(awsCloudFrontDistribution)
                    .build());
        }

        /**
         * <p>
         * Details about an Amazon EC2 instance related to a finding.
         * </p>
         * 
         * @param awsEc2Instance
         *        Details about an Amazon EC2 instance related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance);

        /**
         * <p>
         * Details about an Amazon EC2 instance related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2InstanceDetails.Builder} avoiding the need
         * to create one manually via {@link AwsEc2InstanceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2InstanceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEc2Instance(AwsEc2InstanceDetails)}.
         * 
         * @param awsEc2Instance
         *        a consumer that will call methods on {@link AwsEc2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2Instance(AwsEc2InstanceDetails)
         */
        default Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return awsEc2Instance(AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance).build());
        }

        /**
         * <p>
         * Details for an Amazon EC2 network interface.
         * </p>
         * 
         * @param awsEc2NetworkInterface
         *        Details for an Amazon EC2 network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface);

        /**
         * <p>
         * Details for an Amazon EC2 network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2NetworkInterfaceDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEc2NetworkInterfaceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2NetworkInterfaceDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails)}.
         * 
         * @param awsEc2NetworkInterface
         *        a consumer that will call methods on {@link AwsEc2NetworkInterfaceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails)
         */
        default Builder awsEc2NetworkInterface(Consumer<AwsEc2NetworkInterfaceDetails.Builder> awsEc2NetworkInterface) {
            return awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails.builder().applyMutation(awsEc2NetworkInterface).build());
        }

        /**
         * <p>
         * Details for an EC2 security group.
         * </p>
         * 
         * @param awsEc2SecurityGroup
         *        Details for an EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails awsEc2SecurityGroup);

        /**
         * <p>
         * Details for an EC2 security group.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEc2SecurityGroupDetails.Builder} avoiding the
         * need to create one manually via {@link AwsEc2SecurityGroupDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEc2SecurityGroupDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsEc2SecurityGroup(AwsEc2SecurityGroupDetails)}.
         * 
         * @param awsEc2SecurityGroup
         *        a consumer that will call methods on {@link AwsEc2SecurityGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEc2SecurityGroup(AwsEc2SecurityGroupDetails)
         */
        default Builder awsEc2SecurityGroup(Consumer<AwsEc2SecurityGroupDetails.Builder> awsEc2SecurityGroup) {
            return awsEc2SecurityGroup(AwsEc2SecurityGroupDetails.builder().applyMutation(awsEc2SecurityGroup).build());
        }

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * 
         * @param awsElbv2LoadBalancer
         *        Details about a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer);

        /**
         * <p>
         * Details about a load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsElbv2LoadBalancerDetails.Builder} avoiding
         * the need to create one manually via {@link AwsElbv2LoadBalancerDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElbv2LoadBalancerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)}.
         * 
         * @param awsElbv2LoadBalancer
         *        a consumer that will call methods on {@link AwsElbv2LoadBalancerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails)
         */
        default Builder awsElbv2LoadBalancer(Consumer<AwsElbv2LoadBalancerDetails.Builder> awsElbv2LoadBalancer) {
            return awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.builder().applyMutation(awsElbv2LoadBalancer).build());
        }

        /**
         * <p>
         * Details for an Elasticsearch domain.
         * </p>
         * 
         * @param awsElasticsearchDomain
         *        Details for an Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails awsElasticsearchDomain);

        /**
         * <p>
         * Details for an Elasticsearch domain.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsElasticsearchDomainDetails.Builder} avoiding
         * the need to create one manually via {@link AwsElasticsearchDomainDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsElasticsearchDomain(AwsElasticsearchDomainDetails)}.
         * 
         * @param awsElasticsearchDomain
         *        a consumer that will call methods on {@link AwsElasticsearchDomainDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsElasticsearchDomain(AwsElasticsearchDomainDetails)
         */
        default Builder awsElasticsearchDomain(Consumer<AwsElasticsearchDomainDetails.Builder> awsElasticsearchDomain) {
            return awsElasticsearchDomain(AwsElasticsearchDomainDetails.builder().applyMutation(awsElasticsearchDomain).build());
        }

        /**
         * <p>
         * Details about an Amazon S3 bucket related to a finding.
         * </p>
         * 
         * @param awsS3Bucket
         *        Details about an Amazon S3 bucket related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket);

        /**
         * <p>
         * Details about an Amazon S3 bucket related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsS3BucketDetails.Builder} avoiding the need to
         * create one manually via {@link AwsS3BucketDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3BucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsS3Bucket(AwsS3BucketDetails)}.
         * 
         * @param awsS3Bucket
         *        a consumer that will call methods on {@link AwsS3BucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3Bucket(AwsS3BucketDetails)
         */
        default Builder awsS3Bucket(Consumer<AwsS3BucketDetails.Builder> awsS3Bucket) {
            return awsS3Bucket(AwsS3BucketDetails.builder().applyMutation(awsS3Bucket).build());
        }

        /**
         * <p>
         * Details about an Amazon S3 object related to a finding.
         * </p>
         * 
         * @param awsS3Object
         *        Details about an Amazon S3 object related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsS3Object(AwsS3ObjectDetails awsS3Object);

        /**
         * <p>
         * Details about an Amazon S3 object related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsS3ObjectDetails.Builder} avoiding the need to
         * create one manually via {@link AwsS3ObjectDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsS3ObjectDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsS3Object(AwsS3ObjectDetails)}.
         * 
         * @param awsS3Object
         *        a consumer that will call methods on {@link AwsS3ObjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsS3Object(AwsS3ObjectDetails)
         */
        default Builder awsS3Object(Consumer<AwsS3ObjectDetails.Builder> awsS3Object) {
            return awsS3Object(AwsS3ObjectDetails.builder().applyMutation(awsS3Object).build());
        }

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * 
         * @param awsIamAccessKey
         *        Details about an IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey);

        /**
         * <p>
         * Details about an IAM access key related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIamAccessKeyDetails.Builder} avoiding the
         * need to create one manually via {@link AwsIamAccessKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamAccessKeyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsIamAccessKey(AwsIamAccessKeyDetails)}.
         * 
         * @param awsIamAccessKey
         *        a consumer that will call methods on {@link AwsIamAccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamAccessKey(AwsIamAccessKeyDetails)
         */
        default Builder awsIamAccessKey(Consumer<AwsIamAccessKeyDetails.Builder> awsIamAccessKey) {
            return awsIamAccessKey(AwsIamAccessKeyDetails.builder().applyMutation(awsIamAccessKey).build());
        }

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * 
         * @param awsIamRole
         *        Details about an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamRole(AwsIamRoleDetails awsIamRole);

        /**
         * <p>
         * Details about an IAM role.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIamRoleDetails.Builder} avoiding the need to
         * create one manually via {@link AwsIamRoleDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamRoleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamRole(AwsIamRoleDetails)}.
         * 
         * @param awsIamRole
         *        a consumer that will call methods on {@link AwsIamRoleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamRole(AwsIamRoleDetails)
         */
        default Builder awsIamRole(Consumer<AwsIamRoleDetails.Builder> awsIamRole) {
            return awsIamRole(AwsIamRoleDetails.builder().applyMutation(awsIamRole).build());
        }

        /**
         * <p>
         * Details about a KMS key.
         * </p>
         * 
         * @param awsKmsKey
         *        Details about a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey);

        /**
         * <p>
         * Details about a KMS key.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsKmsKeyDetails.Builder} avoiding the need to
         * create one manually via {@link AwsKmsKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsKmsKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsKmsKey(AwsKmsKeyDetails)}.
         * 
         * @param awsKmsKey
         *        a consumer that will call methods on {@link AwsKmsKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsKmsKey(AwsKmsKeyDetails)
         */
        default Builder awsKmsKey(Consumer<AwsKmsKeyDetails.Builder> awsKmsKey) {
            return awsKmsKey(AwsKmsKeyDetails.builder().applyMutation(awsKmsKey).build());
        }

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * 
         * @param awsLambdaFunction
         *        Details about a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction);

        /**
         * <p>
         * Details about a Lambda function.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionDetails.Builder} avoiding the
         * need to create one manually via {@link AwsLambdaFunctionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambdaFunction(AwsLambdaFunctionDetails)}.
         * 
         * @param awsLambdaFunction
         *        a consumer that will call methods on {@link AwsLambdaFunctionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaFunction(AwsLambdaFunctionDetails)
         */
        default Builder awsLambdaFunction(Consumer<AwsLambdaFunctionDetails.Builder> awsLambdaFunction) {
            return awsLambdaFunction(AwsLambdaFunctionDetails.builder().applyMutation(awsLambdaFunction).build());
        }

        /**
         * <p>
         * Details for a Lambda layer version.
         * </p>
         * 
         * @param awsLambdaLayerVersion
         *        Details for a Lambda layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails awsLambdaLayerVersion);

        /**
         * <p>
         * Details for a Lambda layer version.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaLayerVersionDetails.Builder} avoiding
         * the need to create one manually via {@link AwsLambdaLayerVersionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaLayerVersionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #awsLambdaLayerVersion(AwsLambdaLayerVersionDetails)}.
         * 
         * @param awsLambdaLayerVersion
         *        a consumer that will call methods on {@link AwsLambdaLayerVersionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambdaLayerVersion(AwsLambdaLayerVersionDetails)
         */
        default Builder awsLambdaLayerVersion(Consumer<AwsLambdaLayerVersionDetails.Builder> awsLambdaLayerVersion) {
            return awsLambdaLayerVersion(AwsLambdaLayerVersionDetails.builder().applyMutation(awsLambdaLayerVersion).build());
        }

        /**
         * <p>
         * Details for an Amazon RDS database instance.
         * </p>
         * 
         * @param awsRdsDbInstance
         *        Details for an Amazon RDS database instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRdsDbInstance(AwsRdsDbInstanceDetails awsRdsDbInstance);

        /**
         * <p>
         * Details for an Amazon RDS database instance.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsRdsDbInstanceDetails.Builder} avoiding the
         * need to create one manually via {@link AwsRdsDbInstanceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsRdsDbInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #awsRdsDbInstance(AwsRdsDbInstanceDetails)}.
         * 
         * @param awsRdsDbInstance
         *        a consumer that will call methods on {@link AwsRdsDbInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsRdsDbInstance(AwsRdsDbInstanceDetails)
         */
        default Builder awsRdsDbInstance(Consumer<AwsRdsDbInstanceDetails.Builder> awsRdsDbInstance) {
            return awsRdsDbInstance(AwsRdsDbInstanceDetails.builder().applyMutation(awsRdsDbInstance).build());
        }

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * 
         * @param awsSnsTopic
         *        Details about an SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic);

        /**
         * <p>
         * Details about an SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSnsTopicDetails.Builder} avoiding the need to
         * create one manually via {@link AwsSnsTopicDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSnsTopicDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSnsTopic(AwsSnsTopicDetails)}.
         * 
         * @param awsSnsTopic
         *        a consumer that will call methods on {@link AwsSnsTopicDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSnsTopic(AwsSnsTopicDetails)
         */
        default Builder awsSnsTopic(Consumer<AwsSnsTopicDetails.Builder> awsSnsTopic) {
            return awsSnsTopic(AwsSnsTopicDetails.builder().applyMutation(awsSnsTopic).build());
        }

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * 
         * @param awsSqsQueue
         *        Details about an SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue);

        /**
         * <p>
         * Details about an SQS queue.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSqsQueueDetails.Builder} avoiding the need to
         * create one manually via {@link AwsSqsQueueDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSqsQueueDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSqsQueue(AwsSqsQueueDetails)}.
         * 
         * @param awsSqsQueue
         *        a consumer that will call methods on {@link AwsSqsQueueDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSqsQueue(AwsSqsQueueDetails)
         */
        default Builder awsSqsQueue(Consumer<AwsSqsQueueDetails.Builder> awsSqsQueue) {
            return awsSqsQueue(AwsSqsQueueDetails.builder().applyMutation(awsSqsQueue).build());
        }

        /**
         * <p>
         * Details for a WAF WebACL.
         * </p>
         * 
         * @param awsWafWebAcl
         *        Details for a WAF WebACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsWafWebAcl(AwsWafWebAclDetails awsWafWebAcl);

        /**
         * <p>
         * Details for a WAF WebACL.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsWafWebAclDetails.Builder} avoiding the need
         * to create one manually via {@link AwsWafWebAclDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsWafWebAclDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsWafWebAcl(AwsWafWebAclDetails)}.
         * 
         * @param awsWafWebAcl
         *        a consumer that will call methods on {@link AwsWafWebAclDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsWafWebAcl(AwsWafWebAclDetails)
         */
        default Builder awsWafWebAcl(Consumer<AwsWafWebAclDetails.Builder> awsWafWebAcl) {
            return awsWafWebAcl(AwsWafWebAclDetails.builder().applyMutation(awsWafWebAcl).build());
        }

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * 
         * @param container
         *        Details about a container resource related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerDetails container);

        /**
         * <p>
         * Details about a container resource related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDetails.Builder} avoiding the need to
         * create one manually via {@link ContainerDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerDetails)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerDetails)
         */
        default Builder container(Consumer<ContainerDetails.Builder> container) {
            return container(ContainerDetails.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * Details about a resource that are not available in a type-specific details object. Use the <code>Other</code>
         * object in the following cases.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The type-specific object does not contain all of the fields that you want to populate. In this case, first
         * use the type-specific object to populate those fields. Use the <code>Other</code> object to populate the
         * fields that are missing from the type-specific object.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type does not have a corresponding object. This includes resources for which the type is
         * <code>Other</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param other
         *        Details about a resource that are not available in a type-specific details object. Use the
         *        <code>Other</code> object in the following cases.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The type-specific object does not contain all of the fields that you want to populate. In this case,
         *        first use the type-specific object to populate those fields. Use the <code>Other</code> object to
         *        populate the fields that are missing from the type-specific object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type does not have a corresponding object. This includes resources for which the type is
         *        <code>Other</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder other(Map<String, String> other);
    }

    static final class BuilderImpl implements Builder {
        private AwsCodeBuildProjectDetails awsCodeBuildProject;

        private AwsCloudFrontDistributionDetails awsCloudFrontDistribution;

        private AwsEc2InstanceDetails awsEc2Instance;

        private AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface;

        private AwsEc2SecurityGroupDetails awsEc2SecurityGroup;

        private AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer;

        private AwsElasticsearchDomainDetails awsElasticsearchDomain;

        private AwsS3BucketDetails awsS3Bucket;

        private AwsS3ObjectDetails awsS3Object;

        private AwsIamAccessKeyDetails awsIamAccessKey;

        private AwsIamRoleDetails awsIamRole;

        private AwsKmsKeyDetails awsKmsKey;

        private AwsLambdaFunctionDetails awsLambdaFunction;

        private AwsLambdaLayerVersionDetails awsLambdaLayerVersion;

        private AwsRdsDbInstanceDetails awsRdsDbInstance;

        private AwsSnsTopicDetails awsSnsTopic;

        private AwsSqsQueueDetails awsSqsQueue;

        private AwsWafWebAclDetails awsWafWebAcl;

        private ContainerDetails container;

        private Map<String, String> other = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            awsCodeBuildProject(model.awsCodeBuildProject);
            awsCloudFrontDistribution(model.awsCloudFrontDistribution);
            awsEc2Instance(model.awsEc2Instance);
            awsEc2NetworkInterface(model.awsEc2NetworkInterface);
            awsEc2SecurityGroup(model.awsEc2SecurityGroup);
            awsElbv2LoadBalancer(model.awsElbv2LoadBalancer);
            awsElasticsearchDomain(model.awsElasticsearchDomain);
            awsS3Bucket(model.awsS3Bucket);
            awsS3Object(model.awsS3Object);
            awsIamAccessKey(model.awsIamAccessKey);
            awsIamRole(model.awsIamRole);
            awsKmsKey(model.awsKmsKey);
            awsLambdaFunction(model.awsLambdaFunction);
            awsLambdaLayerVersion(model.awsLambdaLayerVersion);
            awsRdsDbInstance(model.awsRdsDbInstance);
            awsSnsTopic(model.awsSnsTopic);
            awsSqsQueue(model.awsSqsQueue);
            awsWafWebAcl(model.awsWafWebAcl);
            container(model.container);
            other(model.other);
        }

        public final AwsCodeBuildProjectDetails.Builder getAwsCodeBuildProject() {
            return awsCodeBuildProject != null ? awsCodeBuildProject.toBuilder() : null;
        }

        @Override
        public final Builder awsCodeBuildProject(AwsCodeBuildProjectDetails awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject;
            return this;
        }

        public final void setAwsCodeBuildProject(AwsCodeBuildProjectDetails.BuilderImpl awsCodeBuildProject) {
            this.awsCodeBuildProject = awsCodeBuildProject != null ? awsCodeBuildProject.build() : null;
        }

        public final AwsCloudFrontDistributionDetails.Builder getAwsCloudFrontDistribution() {
            return awsCloudFrontDistribution != null ? awsCloudFrontDistribution.toBuilder() : null;
        }

        @Override
        public final Builder awsCloudFrontDistribution(AwsCloudFrontDistributionDetails awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution;
            return this;
        }

        public final void setAwsCloudFrontDistribution(AwsCloudFrontDistributionDetails.BuilderImpl awsCloudFrontDistribution) {
            this.awsCloudFrontDistribution = awsCloudFrontDistribution != null ? awsCloudFrontDistribution.build() : null;
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return awsEc2Instance != null ? awsEc2Instance.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        public final AwsEc2NetworkInterfaceDetails.Builder getAwsEc2NetworkInterface() {
            return awsEc2NetworkInterface != null ? awsEc2NetworkInterface.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface;
            return this;
        }

        public final void setAwsEc2NetworkInterface(AwsEc2NetworkInterfaceDetails.BuilderImpl awsEc2NetworkInterface) {
            this.awsEc2NetworkInterface = awsEc2NetworkInterface != null ? awsEc2NetworkInterface.build() : null;
        }

        public final AwsEc2SecurityGroupDetails.Builder getAwsEc2SecurityGroup() {
            return awsEc2SecurityGroup != null ? awsEc2SecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2SecurityGroup(AwsEc2SecurityGroupDetails awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup;
            return this;
        }

        public final void setAwsEc2SecurityGroup(AwsEc2SecurityGroupDetails.BuilderImpl awsEc2SecurityGroup) {
            this.awsEc2SecurityGroup = awsEc2SecurityGroup != null ? awsEc2SecurityGroup.build() : null;
        }

        public final AwsElbv2LoadBalancerDetails.Builder getAwsElbv2LoadBalancer() {
            return awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.toBuilder() : null;
        }

        @Override
        public final Builder awsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer;
            return this;
        }

        public final void setAwsElbv2LoadBalancer(AwsElbv2LoadBalancerDetails.BuilderImpl awsElbv2LoadBalancer) {
            this.awsElbv2LoadBalancer = awsElbv2LoadBalancer != null ? awsElbv2LoadBalancer.build() : null;
        }

        public final AwsElasticsearchDomainDetails.Builder getAwsElasticsearchDomain() {
            return awsElasticsearchDomain != null ? awsElasticsearchDomain.toBuilder() : null;
        }

        @Override
        public final Builder awsElasticsearchDomain(AwsElasticsearchDomainDetails awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain;
            return this;
        }

        public final void setAwsElasticsearchDomain(AwsElasticsearchDomainDetails.BuilderImpl awsElasticsearchDomain) {
            this.awsElasticsearchDomain = awsElasticsearchDomain != null ? awsElasticsearchDomain.build() : null;
        }

        public final AwsS3BucketDetails.Builder getAwsS3Bucket() {
            return awsS3Bucket != null ? awsS3Bucket.toBuilder() : null;
        }

        @Override
        public final Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket;
            return this;
        }

        public final void setAwsS3Bucket(AwsS3BucketDetails.BuilderImpl awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket != null ? awsS3Bucket.build() : null;
        }

        public final AwsS3ObjectDetails.Builder getAwsS3Object() {
            return awsS3Object != null ? awsS3Object.toBuilder() : null;
        }

        @Override
        public final Builder awsS3Object(AwsS3ObjectDetails awsS3Object) {
            this.awsS3Object = awsS3Object;
            return this;
        }

        public final void setAwsS3Object(AwsS3ObjectDetails.BuilderImpl awsS3Object) {
            this.awsS3Object = awsS3Object != null ? awsS3Object.build() : null;
        }

        public final AwsIamAccessKeyDetails.Builder getAwsIamAccessKey() {
            return awsIamAccessKey != null ? awsIamAccessKey.toBuilder() : null;
        }

        @Override
        public final Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey;
            return this;
        }

        public final void setAwsIamAccessKey(AwsIamAccessKeyDetails.BuilderImpl awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey != null ? awsIamAccessKey.build() : null;
        }

        public final AwsIamRoleDetails.Builder getAwsIamRole() {
            return awsIamRole != null ? awsIamRole.toBuilder() : null;
        }

        @Override
        public final Builder awsIamRole(AwsIamRoleDetails awsIamRole) {
            this.awsIamRole = awsIamRole;
            return this;
        }

        public final void setAwsIamRole(AwsIamRoleDetails.BuilderImpl awsIamRole) {
            this.awsIamRole = awsIamRole != null ? awsIamRole.build() : null;
        }

        public final AwsKmsKeyDetails.Builder getAwsKmsKey() {
            return awsKmsKey != null ? awsKmsKey.toBuilder() : null;
        }

        @Override
        public final Builder awsKmsKey(AwsKmsKeyDetails awsKmsKey) {
            this.awsKmsKey = awsKmsKey;
            return this;
        }

        public final void setAwsKmsKey(AwsKmsKeyDetails.BuilderImpl awsKmsKey) {
            this.awsKmsKey = awsKmsKey != null ? awsKmsKey.build() : null;
        }

        public final AwsLambdaFunctionDetails.Builder getAwsLambdaFunction() {
            return awsLambdaFunction != null ? awsLambdaFunction.toBuilder() : null;
        }

        @Override
        public final Builder awsLambdaFunction(AwsLambdaFunctionDetails awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction;
            return this;
        }

        public final void setAwsLambdaFunction(AwsLambdaFunctionDetails.BuilderImpl awsLambdaFunction) {
            this.awsLambdaFunction = awsLambdaFunction != null ? awsLambdaFunction.build() : null;
        }

        public final AwsLambdaLayerVersionDetails.Builder getAwsLambdaLayerVersion() {
            return awsLambdaLayerVersion != null ? awsLambdaLayerVersion.toBuilder() : null;
        }

        @Override
        public final Builder awsLambdaLayerVersion(AwsLambdaLayerVersionDetails awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion;
            return this;
        }

        public final void setAwsLambdaLayerVersion(AwsLambdaLayerVersionDetails.BuilderImpl awsLambdaLayerVersion) {
            this.awsLambdaLayerVersion = awsLambdaLayerVersion != null ? awsLambdaLayerVersion.build() : null;
        }

        public final AwsRdsDbInstanceDetails.Builder getAwsRdsDbInstance() {
            return awsRdsDbInstance != null ? awsRdsDbInstance.toBuilder() : null;
        }

        @Override
        public final Builder awsRdsDbInstance(AwsRdsDbInstanceDetails awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance;
            return this;
        }

        public final void setAwsRdsDbInstance(AwsRdsDbInstanceDetails.BuilderImpl awsRdsDbInstance) {
            this.awsRdsDbInstance = awsRdsDbInstance != null ? awsRdsDbInstance.build() : null;
        }

        public final AwsSnsTopicDetails.Builder getAwsSnsTopic() {
            return awsSnsTopic != null ? awsSnsTopic.toBuilder() : null;
        }

        @Override
        public final Builder awsSnsTopic(AwsSnsTopicDetails awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic;
            return this;
        }

        public final void setAwsSnsTopic(AwsSnsTopicDetails.BuilderImpl awsSnsTopic) {
            this.awsSnsTopic = awsSnsTopic != null ? awsSnsTopic.build() : null;
        }

        public final AwsSqsQueueDetails.Builder getAwsSqsQueue() {
            return awsSqsQueue != null ? awsSqsQueue.toBuilder() : null;
        }

        @Override
        public final Builder awsSqsQueue(AwsSqsQueueDetails awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue;
            return this;
        }

        public final void setAwsSqsQueue(AwsSqsQueueDetails.BuilderImpl awsSqsQueue) {
            this.awsSqsQueue = awsSqsQueue != null ? awsSqsQueue.build() : null;
        }

        public final AwsWafWebAclDetails.Builder getAwsWafWebAcl() {
            return awsWafWebAcl != null ? awsWafWebAcl.toBuilder() : null;
        }

        @Override
        public final Builder awsWafWebAcl(AwsWafWebAclDetails awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl;
            return this;
        }

        public final void setAwsWafWebAcl(AwsWafWebAclDetails.BuilderImpl awsWafWebAcl) {
            this.awsWafWebAcl = awsWafWebAcl != null ? awsWafWebAcl.build() : null;
        }

        public final ContainerDetails.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetails container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetails.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Map<String, String> getOther() {
            return other;
        }

        @Override
        public final Builder other(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
            return this;
        }

        public final void setOther(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
