/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMembersResponse extends SecurityHubResponse implements
        ToCopyableBuilder<GetMembersResponse.Builder, GetMembersResponse> {
    private static final SdkField<List<Member>> MEMBERS_FIELD = SdkField
            .<List<Member>> builder(MarshallingType.LIST)
            .getter(getter(GetMembersResponse::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Member> builder(MarshallingType.SDK_POJO)
                                            .constructor(Member::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Result>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<Result>> builder(MarshallingType.LIST)
            .getter(getter(GetMembersResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Result> builder(MarshallingType.SDK_POJO)
                                            .constructor(Result::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<Member> members;

    private final List<Result> unprocessedAccounts;

    private GetMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the Members property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of details about the Security Hub member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of details about the Security Hub member accounts.
     */
    public List<Member> members() {
        return members;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of AWS accounts that could not be processed. For each account, the list includes the account ID and the
     * email address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of AWS accounts that could not be processed. For each account, the list includes the account ID
     *         and the email address.
     */
    public List<Result> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(members());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedAccounts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembersResponse)) {
            return false;
        }
        GetMembersResponse other = (GetMembersResponse) obj;
        return Objects.equals(members(), other.members()) && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMembersResponse").add("Members", members()).add("UnprocessedAccounts", unprocessedAccounts())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMembersResponse, T> g) {
        return obj -> g.apply((GetMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMembersResponse> {
        /**
         * <p>
         * The list of details about the Security Hub member accounts.
         * </p>
         * 
         * @param members
         *        The list of details about the Security Hub member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<Member> members);

        /**
         * <p>
         * The list of details about the Security Hub member accounts.
         * </p>
         * 
         * @param members
         *        The list of details about the Security Hub member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Member... members);

        /**
         * <p>
         * The list of details about the Security Hub member accounts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Member>.Builder} avoiding the need to
         * create one manually via {@link List<Member>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Member>.Builder#build()} is called immediately and its
         * result is passed to {@link #members(List<Member>)}.
         * 
         * @param members
         *        a consumer that will call methods on {@link List<Member>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(List<Member>)
         */
        Builder members(Consumer<Member.Builder>... members);

        /**
         * <p>
         * The list of AWS accounts that could not be processed. For each account, the list includes the account ID and
         * the email address.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of AWS accounts that could not be processed. For each account, the list includes the account
         *        ID and the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<Result> unprocessedAccounts);

        /**
         * <p>
         * The list of AWS accounts that could not be processed. For each account, the list includes the account ID and
         * the email address.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of AWS accounts that could not be processed. For each account, the list includes the account
         *        ID and the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Result... unprocessedAccounts);

        /**
         * <p>
         * The list of AWS accounts that could not be processed. For each account, the list includes the account ID and
         * the email address.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Result>.Builder} avoiding the need to
         * create one manually via {@link List<Result>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Result>.Builder#build()} is called immediately and its
         * result is passed to {@link #unprocessedAccounts(List<Result>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<Result>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<Result>)
         */
        Builder unprocessedAccounts(Consumer<Result.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<Member> members = DefaultSdkAutoConstructList.getInstance();

        private List<Result> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembersResponse model) {
            super(model);
            members(model.members);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<Member.Builder> getMembers() {
            return members != null ? members.stream().map(Member::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder>... members) {
            members(Stream.of(members).map(c -> Member.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        public final Collection<Result.Builder> getUnprocessedAccounts() {
            return unprocessedAccounts != null ? unprocessedAccounts.stream().map(Result::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<Result> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Result... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<Result.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> Result.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<Result.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public GetMembersResponse build() {
            return new GetMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
