/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightResultsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<GetInsightResultsResponse.Builder, GetInsightResultsResponse> {
    private static final SdkField<InsightResults> INSIGHT_RESULTS_FIELD = SdkField
            .<InsightResults> builder(MarshallingType.SDK_POJO).getter(getter(GetInsightResultsResponse::insightResults))
            .setter(setter(Builder::insightResults)).constructor(InsightResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_RESULTS_FIELD));

    private final InsightResults insightResults;

    private GetInsightResultsResponse(BuilderImpl builder) {
        super(builder);
        this.insightResults = builder.insightResults;
    }

    /**
     * <p>
     * The insight results returned by the operation.
     * </p>
     * 
     * @return The insight results returned by the operation.
     */
    public InsightResults insightResults() {
        return insightResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightResultsResponse)) {
            return false;
        }
        GetInsightResultsResponse other = (GetInsightResultsResponse) obj;
        return Objects.equals(insightResults(), other.insightResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInsightResultsResponse").add("InsightResults", insightResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightResults":
            return Optional.ofNullable(clazz.cast(insightResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightResultsResponse, T> g) {
        return obj -> g.apply((GetInsightResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightResultsResponse> {
        /**
         * <p>
         * The insight results returned by the operation.
         * </p>
         * 
         * @param insightResults
         *        The insight results returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightResults(InsightResults insightResults);

        /**
         * <p>
         * The insight results returned by the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link InsightResults.Builder} avoiding the need to
         * create one manually via {@link InsightResults#builder()}.
         *
         * When the {@link Consumer} completes, {@link InsightResults.Builder#build()} is called immediately and its
         * result is passed to {@link #insightResults(InsightResults)}.
         * 
         * @param insightResults
         *        a consumer that will call methods on {@link InsightResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightResults(InsightResults)
         */
        default Builder insightResults(Consumer<InsightResults.Builder> insightResults) {
            return insightResults(InsightResults.builder().applyMutation(insightResults).build());
        }
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private InsightResults insightResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightResultsResponse model) {
            super(model);
            insightResults(model.insightResults);
        }

        public final InsightResults.Builder getInsightResults() {
            return insightResults != null ? insightResults.toBuilder() : null;
        }

        @Override
        public final Builder insightResults(InsightResults insightResults) {
            this.insightResults = insightResults;
            return this;
        }

        public final void setInsightResults(InsightResults.BuilderImpl insightResults) {
            this.insightResults = insightResults != null ? insightResults.build() : null;
        }

        @Override
        public GetInsightResultsResponse build() {
            return new GetInsightResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
