/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableImportFindingsForProductRequest extends SecurityHubRequest implements
        ToCopyableBuilder<DisableImportFindingsForProductRequest.Builder, DisableImportFindingsForProductRequest> {
    private static final SdkField<String> PRODUCT_SUBSCRIPTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DisableImportFindingsForProductRequest::productSubscriptionArn))
            .setter(setter(Builder::productSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("ProductSubscriptionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRODUCT_SUBSCRIPTION_ARN_FIELD));

    private final String productSubscriptionArn;

    private DisableImportFindingsForProductRequest(BuilderImpl builder) {
        super(builder);
        this.productSubscriptionArn = builder.productSubscriptionArn;
    }

    /**
     * <p>
     * The ARN of the integrated product to disable the integration for.
     * </p>
     * 
     * @return The ARN of the integrated product to disable the integration for.
     */
    public String productSubscriptionArn() {
        return productSubscriptionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productSubscriptionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableImportFindingsForProductRequest)) {
            return false;
        }
        DisableImportFindingsForProductRequest other = (DisableImportFindingsForProductRequest) obj;
        return Objects.equals(productSubscriptionArn(), other.productSubscriptionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableImportFindingsForProductRequest").add("ProductSubscriptionArn", productSubscriptionArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductSubscriptionArn":
            return Optional.ofNullable(clazz.cast(productSubscriptionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableImportFindingsForProductRequest, T> g) {
        return obj -> g.apply((DisableImportFindingsForProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableImportFindingsForProductRequest> {
        /**
         * <p>
         * The ARN of the integrated product to disable the integration for.
         * </p>
         * 
         * @param productSubscriptionArn
         *        The ARN of the integrated product to disable the integration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productSubscriptionArn(String productSubscriptionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String productSubscriptionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableImportFindingsForProductRequest model) {
            super(model);
            productSubscriptionArn(model.productSubscriptionArn);
        }

        public final String getProductSubscriptionArn() {
            return productSubscriptionArn;
        }

        @Override
        public final Builder productSubscriptionArn(String productSubscriptionArn) {
            this.productSubscriptionArn = productSubscriptionArn;
            return this;
        }

        public final void setProductSubscriptionArn(String productSubscriptionArn) {
            this.productSubscriptionArn = productSubscriptionArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableImportFindingsForProductRequest build() {
            return new DisableImportFindingsForProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
