/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHubResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeHubResponse.Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHubResponse::hubArn)).setter(setter(Builder::hubArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()).build();

    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHubResponse::subscribedAt)).setter(setter(Builder::subscribedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD,
            SUBSCRIBED_AT_FIELD));

    private final String hubArn;

    private final String subscribedAt;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.subscribedAt = builder.subscribedAt;
    }

    /**
     * <p>
     * The ARN of the Hub resource that was retrieved.
     * </p>
     * 
     * @return The ARN of the Hub resource that was retrieved.
     */
    public String hubArn() {
        return hubArn;
    }

    /**
     * <p>
     * The date and time when Security Hub was enabled in the account.
     * </p>
     * 
     * @return The date and time when Security Hub was enabled in the account.
     */
    public String subscribedAt() {
        return subscribedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse) obj;
        return Objects.equals(hubArn(), other.hubArn()) && Objects.equals(subscribedAt(), other.subscribedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHubResponse").add("HubArn", hubArn()).add("SubscribedAt", subscribedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubArn":
            return Optional.ofNullable(clazz.cast(hubArn()));
        case "SubscribedAt":
            return Optional.ofNullable(clazz.cast(subscribedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHubResponse> {
        /**
         * <p>
         * The ARN of the Hub resource that was retrieved.
         * </p>
         * 
         * @param hubArn
         *        The ARN of the Hub resource that was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubArn(String hubArn);

        /**
         * <p>
         * The date and time when Security Hub was enabled in the account.
         * </p>
         * 
         * @param subscribedAt
         *        The date and time when Security Hub was enabled in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedAt(String subscribedAt);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private String hubArn;

        private String subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            hubArn(model.hubArn);
            subscribedAt(model.subscribedAt);
        }

        public final String getHubArn() {
            return hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        public final String getSubscribedAt() {
            return subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
