/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A date range for the date filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateRange implements SdkPojo, Serializable, ToCopyableBuilder<DateRange.Builder, DateRange> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DateRange::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DateRange::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String unit;

    private DateRange(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * A date range value for the date filter.
     * </p>
     * 
     * @return A date range value for the date filter.
     */
    public Integer value() {
        return value;
    }

    /**
     * <p>
     * A date range unit for the date filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DateRangeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return A date range unit for the date filter.
     * @see DateRangeUnit
     */
    public DateRangeUnit unit() {
        return DateRangeUnit.fromValue(unit);
    }

    /**
     * <p>
     * A date range unit for the date filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DateRangeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return A date range unit for the date filter.
     * @see DateRangeUnit
     */
    public String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DateRange").add("Value", value()).add("Unit", unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateRange, T> g) {
        return obj -> g.apply((DateRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateRange> {
        /**
         * <p>
         * A date range value for the date filter.
         * </p>
         * 
         * @param value
         *        A date range value for the date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * A date range unit for the date filter.
         * </p>
         * 
         * @param unit
         *        A date range unit for the date filter.
         * @see DateRangeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateRangeUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * A date range unit for the date filter.
         * </p>
         * 
         * @param unit
         *        A date range unit for the date filter.
         * @see DateRangeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateRangeUnit
         */
        Builder unit(DateRangeUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRange model) {
            value(model.value);
            unit(model.unit);
        }

        public final Integer getValue() {
            return value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DateRangeUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public DateRange build() {
            return new DateRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
