/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container details related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDetails.Builder, ContainerDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDetails::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_ID_FIELD,
            IMAGE_NAME_FIELD, LAUNCHED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String imageId;

    private final String imageName;

    private final String launchedAt;

    private ContainerDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.imageId = builder.imageId;
        this.imageName = builder.imageName;
        this.launchedAt = builder.launchedAt;
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * 
     * @return The name of the container related to a finding.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * 
     * @return The identifier of the image related to a finding.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * 
     * @return The name of the image related to a finding.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The date and time when the container started.
     * </p>
     * 
     * @return The date and time when the container started.
     */
    public String launchedAt() {
        return launchedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetails)) {
            return false;
        }
        ContainerDetails other = (ContainerDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(imageName(), other.imageName()) && Objects.equals(launchedAt(), other.launchedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerDetails").add("Name", name()).add("ImageId", imageId()).add("ImageName", imageName())
                .add("LaunchedAt", launchedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDetails, T> g) {
        return obj -> g.apply((ContainerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDetails> {
        /**
         * <p>
         * The name of the container related to a finding.
         * </p>
         * 
         * @param name
         *        The name of the container related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the image related to a finding.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the image related to a finding.
         * </p>
         * 
         * @param imageName
         *        The name of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The date and time when the container started.
         * </p>
         * 
         * @param launchedAt
         *        The date and time when the container started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(String launchedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String imageId;

        private String imageName;

        private String launchedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetails model) {
            name(model.name);
            imageId(model.imageId);
            imageName(model.imageName);
            launchedAt(model.launchedAt);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getLaunchedAt() {
            return launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public ContainerDetails build() {
            return new ContainerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
