/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketServerSideEncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketServerSideEncryptionConfiguration.Builder, AwsS3BucketServerSideEncryptionConfiguration> {
    private static final SdkField<List<AwsS3BucketServerSideEncryptionRule>> RULES_FIELD = SdkField
            .<List<AwsS3BucketServerSideEncryptionRule>> builder(MarshallingType.LIST)
            .getter(getter(AwsS3BucketServerSideEncryptionConfiguration::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketServerSideEncryptionRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsS3BucketServerSideEncryptionRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsS3BucketServerSideEncryptionRule> rules;

    private AwsS3BucketServerSideEncryptionConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The encryption rules that are applied to the S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The encryption rules that are applied to the S3 bucket.
     */
    public List<AwsS3BucketServerSideEncryptionRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketServerSideEncryptionConfiguration)) {
            return false;
        }
        AwsS3BucketServerSideEncryptionConfiguration other = (AwsS3BucketServerSideEncryptionConfiguration) obj;
        return Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsS3BucketServerSideEncryptionConfiguration").add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketServerSideEncryptionConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketServerSideEncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketServerSideEncryptionConfiguration> {
        /**
         * <p>
         * The encryption rules that are applied to the S3 bucket.
         * </p>
         * 
         * @param rules
         *        The encryption rules that are applied to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AwsS3BucketServerSideEncryptionRule> rules);

        /**
         * <p>
         * The encryption rules that are applied to the S3 bucket.
         * </p>
         * 
         * @param rules
         *        The encryption rules that are applied to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AwsS3BucketServerSideEncryptionRule... rules);

        /**
         * <p>
         * The encryption rules that are applied to the S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsS3BucketServerSideEncryptionRule>.Builder} avoiding the need to create one manually via {@link List
         * <AwsS3BucketServerSideEncryptionRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsS3BucketServerSideEncryptionRule>.Builder#build()} is
         * called immediately and its result is passed to {@link #rules(List<AwsS3BucketServerSideEncryptionRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<AwsS3BucketServerSideEncryptionRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<AwsS3BucketServerSideEncryptionRule>)
         */
        Builder rules(Consumer<AwsS3BucketServerSideEncryptionRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsS3BucketServerSideEncryptionRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketServerSideEncryptionConfiguration model) {
            rules(model.rules);
        }

        public final Collection<AwsS3BucketServerSideEncryptionRule.Builder> getRules() {
            return rules != null ? rules.stream().map(AwsS3BucketServerSideEncryptionRule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<AwsS3BucketServerSideEncryptionRule> rules) {
            this.rules = AwsS3BucketServerSideEncryptionRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsS3BucketServerSideEncryptionRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsS3BucketServerSideEncryptionRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AwsS3BucketServerSideEncryptionRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<AwsS3BucketServerSideEncryptionRule.BuilderImpl> rules) {
            this.rules = AwsS3BucketServerSideEncryptionRulesCopier.copyFromBuilder(rules);
        }

        @Override
        public AwsS3BucketServerSideEncryptionConfiguration build() {
            return new AwsS3BucketServerSideEncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
