/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon RDS DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbInstanceDetails.Builder, AwsRdsDbInstanceDetails> {
    private static final SdkField<List<AwsRdsDbInstanceAssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<AwsRdsDbInstanceAssociatedRole>> builder(MarshallingType.LIST)
            .getter(getter(AwsRdsDbInstanceDetails::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbInstanceAssociatedRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbInstanceAssociatedRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::caCertificateIdentifier)).setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::dbClusterIdentifier)).setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::dbInstanceIdentifier)).setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::dbInstanceClass)).setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Integer> DB_INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsRdsDbInstanceDetails::dbInstancePort)).setter(setter(Builder::dbInstancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstancePort").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::dbiResourceId)).setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsRdsDbInstanceDetails::deletionProtection)).setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<AwsRdsDbInstanceEndpoint> ENDPOINT_FIELD = SdkField
            .<AwsRdsDbInstanceEndpoint> builder(MarshallingType.SDK_POJO).getter(getter(AwsRdsDbInstanceDetails::endpoint))
            .setter(setter(Builder::endpoint)).constructor(AwsRdsDbInstanceEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsRdsDbInstanceDetails::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<String> INSTANCE_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::instanceCreateTime)).setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsRdsDbInstanceDetails::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsRdsDbInstanceDetails::storageEncrypted)).setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsRdsDbInstanceDetails::tdeCredentialArn)).setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<List<AwsRdsDbInstanceVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsRdsDbInstanceVpcSecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(AwsRdsDbInstanceDetails::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbInstanceVpcSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbInstanceVpcSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLES_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD,
            DB_INSTANCE_PORT_FIELD, DBI_RESOURCE_ID_FIELD, DB_NAME_FIELD, DELETION_PROTECTION_FIELD, ENDPOINT_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, INSTANCE_CREATE_TIME_FIELD,
            KMS_KEY_ID_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STORAGE_ENCRYPTED_FIELD, TDE_CREDENTIAL_ARN_FIELD,
            VPC_SECURITY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsRdsDbInstanceAssociatedRole> associatedRoles;

    private final String caCertificateIdentifier;

    private final String dbClusterIdentifier;

    private final String dbInstanceIdentifier;

    private final String dbInstanceClass;

    private final Integer dbInstancePort;

    private final String dbiResourceId;

    private final String dbName;

    private final Boolean deletionProtection;

    private final AwsRdsDbInstanceEndpoint endpoint;

    private final String engine;

    private final String engineVersion;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final String instanceCreateTime;

    private final String kmsKeyId;

    private final Boolean publiclyAccessible;

    private final Boolean storageEncrypted;

    private final String tdeCredentialArn;

    private final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups;

    private AwsRdsDbInstanceDetails(BuilderImpl builder) {
        this.associatedRoles = builder.associatedRoles;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbiResourceId = builder.dbiResourceId;
        this.dbName = builder.dbName;
        this.deletionProtection = builder.deletionProtection;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.storageEncrypted = builder.storageEncrypted;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    /**
     * Returns true if the AssociatedRoles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssociatedRoles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     */
    public List<AwsRdsDbInstanceAssociatedRole> associatedRoles() {
        return associatedRoles;
    }

    /**
     * <p>
     * The identifier of the CA certificate for this DB instance.
     * </p>
     * 
     * @return The identifier of the CA certificate for this DB instance.
     */
    public String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
     * member of.
     * </p>
     * 
     * @return If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance
     *         is a member of.
     */
    public String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     * </p>
     * 
     * @return Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
     *         instance.
     */
    public String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the name of the compute and memory capacity class of the DB instance.
     * </p>
     * 
     * @return Contains the name of the compute and memory capacity class of the DB instance.
     */
    public String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
     * different port than the DB cluster port.
     * </p>
     * 
     * @return Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can
     *         be a different port than the DB cluster port.
     */
    public Integer dbInstancePort() {
        return dbInstancePort;
    }

    /**
     * <p>
     * The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log
     * entries whenever the AWS KMS key for the DB instance is accessed.
     * </p>
     * 
     * @return The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS
     *         CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
     */
    public String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The meaning of this parameter differs according to the database engine you use.
     * </p>
     * <p>
     * <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
     * </p>
     * <p>
     * Contains the name of the initial database of this instance that was provided at create time, if one was specified
     * when the DB instance was created. This same name is returned for the life of the DB instance.
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not
     * apply to an Oracle DB instance.
     * </p>
     * 
     * @return The meaning of this parameter differs according to the database engine you use.</p>
     *         <p>
     *         <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
     *         </p>
     *         <p>
     *         Contains the name of the initial database of this instance that was provided at create time, if one was
     *         specified when the DB instance was created. This same name is returned for the life of the DB instance.
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do
     *         not apply to an Oracle DB instance.
     */
    public String dbName() {
        return dbName;
    }

    /**
     * <p>
     * Indicates whether the DB instance has deletion protection enabled.
     * </p>
     * <p>
     * When deletion protection is enabled, the database cannot be deleted.
     * </p>
     * 
     * @return Indicates whether the DB instance has deletion protection enabled.</p>
     *         <p>
     *         When deletion protection is enabled, the database cannot be deleted.
     */
    public Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Specifies the connection endpoint.
     * </p>
     * 
     * @return Specifies the connection endpoint.
     */
    public AwsRdsDbInstanceEndpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Provides the name of the database engine to use for this DB instance.
     * </p>
     * 
     * @return Provides the name of the database engine to use for this DB instance.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
     * otherwise false.
     * </p>
     * <p>
     * IAM database authentication can be enabled for the following database engines.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For MySQL 5.6, minor version 5.6.34 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * For MySQL 5.7, minor version 5.7.16 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora 5.6 or higher
     * </p>
     * </li>
     * </ul>
     * 
     * @return True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
     *         otherwise false.</p>
     *         <p>
     *         IAM database authentication can be enabled for the following database engines.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For MySQL 5.6, minor version 5.6.34 or higher
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For MySQL 5.7, minor version 5.7.16 or higher
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora 5.6 or higher
     *         </p>
     *         </li>
     */
    public Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * Provides the date and time the DB instance was created.
     * </p>
     * 
     * @return Provides the date and time the DB instance was created.
     */
    public String instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * If <code>StorageEncrypted</code> is true, the AWS KMS key identifier for the encrypted DB instance.
     * </p>
     * 
     * @return If <code>StorageEncrypted</code> is true, the AWS KMS key identifier for the encrypted DB instance.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies the accessibility options for the DB instance.
     * </p>
     * <p>
     * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a
     * public IP address.
     * </p>
     * <p>
     * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
     * </p>
     * 
     * @return Specifies the accessibility options for the DB instance.</p>
     *         <p>
     *         A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves
     *         to a public IP address.
     *         </p>
     *         <p>
     *         A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Specifies whether the DB instance is encrypted.
     * </p>
     * 
     * @return Specifies whether the DB instance is encrypted.
     */
    public Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The ARN from the key store with which the instance is associated for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * Returns true if the VpcSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the DB instance belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VPC security groups that the DB instance belongs to.
     */
    public List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedRoles());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstancePort());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbInstanceDetails)) {
            return false;
        }
        AwsRdsDbInstanceDetails other = (AwsRdsDbInstanceDetails) obj;
        return Objects.equals(associatedRoles(), other.associatedRoles())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(dbInstancePort(), other.dbInstancePort())
                && Objects.equals(dbiResourceId(), other.dbiResourceId()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(storageEncrypted(), other.storageEncrypted())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsRdsDbInstanceDetails").add("AssociatedRoles", associatedRoles())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBInstanceIdentifier", dbInstanceIdentifier()).add("DBInstanceClass", dbInstanceClass())
                .add("DbInstancePort", dbInstancePort()).add("DbiResourceId", dbiResourceId()).add("DBName", dbName())
                .add("DeletionProtection", deletionProtection()).add("Endpoint", endpoint()).add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("InstanceCreateTime", instanceCreateTime()).add("KmsKeyId", kmsKeyId())
                .add("PubliclyAccessible", publiclyAccessible()).add("StorageEncrypted", storageEncrypted())
                .add("TdeCredentialArn", tdeCredentialArn()).add("VpcSecurityGroups", vpcSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "DbInstancePort":
            return Optional.ofNullable(clazz.cast(dbInstancePort()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbInstanceDetails, T> g) {
        return obj -> g.apply((AwsRdsDbInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbInstanceDetails> {
        /**
         * <p>
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * </p>
         * 
         * @param associatedRoles
         *        The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> associatedRoles);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * </p>
         * 
         * @param associatedRoles
         *        The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(AwsRdsDbInstanceAssociatedRole... associatedRoles);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsRdsDbInstanceAssociatedRole>.Builder}
         * avoiding the need to create one manually via {@link List<AwsRdsDbInstanceAssociatedRole>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsRdsDbInstanceAssociatedRole>.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedRoles(List<AwsRdsDbInstanceAssociatedRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on {@link List<AwsRdsDbInstanceAssociatedRole>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(List<AwsRdsDbInstanceAssociatedRole>)
         */
        Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder>... associatedRoles);

        /**
         * <p>
         * The identifier of the CA certificate for this DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The identifier of the CA certificate for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
         * member of.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB
         *        instance is a member of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         * instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Contains the name of the compute and memory capacity class of the DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        Contains the name of the compute and memory capacity class of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
         * different port than the DB cluster port.
         * </p>
         * 
         * @param dbInstancePort
         *        Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this
         *        can be a different port than the DB cluster port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstancePort(Integer dbInstancePort);

        /**
         * <p>
         * The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail
         * log entries whenever the AWS KMS key for the DB instance is accessed.
         * </p>
         * 
         * @param dbiResourceId
         *        The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS
         *        CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The meaning of this parameter differs according to the database engine you use.
         * </p>
         * <p>
         * <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
         * </p>
         * <p>
         * Contains the name of the initial database of this instance that was provided at create time, if one was
         * specified when the DB instance was created. This same name is returned for the life of the DB instance.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not
         * apply to an Oracle DB instance.
         * </p>
         * 
         * @param dbName
         *        The meaning of this parameter differs according to the database engine you use.</p>
         *        <p>
         *        <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
         *        </p>
         *        <p>
         *        Contains the name of the initial database of this instance that was provided at create time, if one
         *        was specified when the DB instance was created. This same name is returned for the life of the DB
         *        instance.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters
         *        do not apply to an Oracle DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * Indicates whether the DB instance has deletion protection enabled.
         * </p>
         * <p>
         * When deletion protection is enabled, the database cannot be deleted.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether the DB instance has deletion protection enabled.</p>
         *        <p>
         *        When deletion protection is enabled, the database cannot be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(AwsRdsDbInstanceEndpoint endpoint);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsRdsDbInstanceEndpoint.Builder} avoiding the
         * need to create one manually via {@link AwsRdsDbInstanceEndpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsRdsDbInstanceEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoint(AwsRdsDbInstanceEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link AwsRdsDbInstanceEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(AwsRdsDbInstanceEndpoint)
         */
        default Builder endpoint(Consumer<AwsRdsDbInstanceEndpoint.Builder> endpoint) {
            return endpoint(AwsRdsDbInstanceEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Provides the name of the database engine to use for this DB instance.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to use for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and
         * otherwise false.
         * </p>
         * <p>
         * IAM database authentication can be enabled for the following database engines.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For MySQL 5.6, minor version 5.6.34 or higher
         * </p>
         * </li>
         * <li>
         * <p>
         * For MySQL 5.7, minor version 5.7.16 or higher
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora 5.6 or higher
         * </p>
         * </li>
         * </ul>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled,
         *        and otherwise false.</p>
         *        <p>
         *        IAM database authentication can be enabled for the following database engines.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For MySQL 5.6, minor version 5.6.34 or higher
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For MySQL 5.7, minor version 5.7.16 or higher
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora 5.6 or higher
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * Provides the date and time the DB instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        Provides the date and time the DB instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(String instanceCreateTime);

        /**
         * <p>
         * If <code>StorageEncrypted</code> is true, the AWS KMS key identifier for the encrypted DB instance.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>StorageEncrypted</code> is true, the AWS KMS key identifier for the encrypted DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies the accessibility options for the DB instance.
         * </p>
         * <p>
         * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to
         * a public IP address.
         * </p>
         * <p>
         * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for the DB instance.</p>
         *        <p>
         *        A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which
         *        resolves to a public IP address.
         *        </p>
         *        <p>
         *        A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Specifies whether the DB instance is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the DB instance is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The ARN from the key store with which the instance is associated for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which the instance is associated for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsRdsDbInstanceVpcSecurityGroup>.Builder}
         * avoiding the need to create one manually via {@link List<AwsRdsDbInstanceVpcSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsRdsDbInstanceVpcSecurityGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<AwsRdsDbInstanceVpcSecurityGroup>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<AwsRdsDbInstanceVpcSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<AwsRdsDbInstanceVpcSecurityGroup>)
         */
        Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsRdsDbInstanceAssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private String caCertificateIdentifier;

        private String dbClusterIdentifier;

        private String dbInstanceIdentifier;

        private String dbInstanceClass;

        private Integer dbInstancePort;

        private String dbiResourceId;

        private String dbName;

        private Boolean deletionProtection;

        private AwsRdsDbInstanceEndpoint endpoint;

        private String engine;

        private String engineVersion;

        private Boolean iamDatabaseAuthenticationEnabled;

        private String instanceCreateTime;

        private String kmsKeyId;

        private Boolean publiclyAccessible;

        private Boolean storageEncrypted;

        private String tdeCredentialArn;

        private List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbInstanceDetails model) {
            associatedRoles(model.associatedRoles);
            caCertificateIdentifier(model.caCertificateIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            dbInstancePort(model.dbInstancePort);
            dbiResourceId(model.dbiResourceId);
            dbName(model.dbName);
            deletionProtection(model.deletionProtection);
            endpoint(model.endpoint);
            engine(model.engine);
            engineVersion(model.engineVersion);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            instanceCreateTime(model.instanceCreateTime);
            kmsKeyId(model.kmsKeyId);
            publiclyAccessible(model.publiclyAccessible);
            storageEncrypted(model.storageEncrypted);
            tdeCredentialArn(model.tdeCredentialArn);
            vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final Collection<AwsRdsDbInstanceAssociatedRole.Builder> getAssociatedRoles() {
            return associatedRoles != null ? associatedRoles.stream().map(AwsRdsDbInstanceAssociatedRole::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AwsRdsDbInstanceAssociatedRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles)
                    .map(c -> AwsRdsDbInstanceAssociatedRole.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedRoles(Collection<AwsRdsDbInstanceAssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copyFromBuilder(associatedRoles);
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getDbInstancePort() {
            return dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getDbName() {
            return dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final AwsRdsDbInstanceEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(AwsRdsDbInstanceEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(AwsRdsDbInstanceEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final String getInstanceCreateTime() {
            return instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Collection<AwsRdsDbInstanceVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            return vpcSecurityGroups != null ? vpcSecurityGroups.stream().map(AwsRdsDbInstanceVpcSecurityGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> AwsRdsDbInstanceVpcSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public AwsRdsDbInstanceDetails build() {
            return new AwsRdsDbInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
