/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Lambda layer version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaLayerVersionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaLayerVersionDetails.Builder, AwsLambdaLayerVersionDetails> {
    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AwsLambdaLayerVersionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsLambdaLayerVersionDetails::compatibleRuntimes))
            .setter(setter(Builder::compatibleRuntimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsLambdaLayerVersionDetails::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            COMPATIBLE_RUNTIMES_FIELD, CREATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long version;

    private final List<String> compatibleRuntimes;

    private final String createdDate;

    private AwsLambdaLayerVersionDetails(BuilderImpl builder) {
        this.version = builder.version;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public Long version() {
        return version;
    }

    /**
     * Returns true if the CompatibleRuntimes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCompatibleRuntimes() {
        return compatibleRuntimes != null && !(compatibleRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The layer's compatible runtimes. Maximum number of five items.
     * </p>
     * <p>
     * Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> | <code>java11</code> |
     * <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> | <code>python3.8</code> |
     * <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code> | <code>ruby2.5</code> |
     * <code>provided</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompatibleRuntimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The layer's compatible runtimes. Maximum number of five items.</p>
     *         <p>
     *         Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> |
     *         <code>java11</code> | <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> |
     *         <code>python3.8</code> | <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code> |
     *         <code>ruby2.5</code> | <code>provided</code>
     */
    public List<String> compatibleRuntimes() {
        return compatibleRuntimes;
    }

    /**
     * <p>
     * The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
     * </p>
     * 
     * @return The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
     */
    public String createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(compatibleRuntimes());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaLayerVersionDetails)) {
            return false;
        }
        AwsLambdaLayerVersionDetails other = (AwsLambdaLayerVersionDetails) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(compatibleRuntimes(), other.compatibleRuntimes())
                && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsLambdaLayerVersionDetails").add("Version", version())
                .add("CompatibleRuntimes", compatibleRuntimes()).add("CreatedDate", createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CompatibleRuntimes":
            return Optional.ofNullable(clazz.cast(compatibleRuntimes()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaLayerVersionDetails, T> g) {
        return obj -> g.apply((AwsLambdaLayerVersionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaLayerVersionDetails> {
        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The layer's compatible runtimes. Maximum number of five items.
         * </p>
         * <p>
         * Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> | <code>java11</code> |
         * <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> | <code>python3.8</code> |
         * <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code> | <code>ruby2.5</code> |
         * <code>provided</code>
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes. Maximum number of five items.</p>
         *        <p>
         *        Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> |
         *        <code>java11</code> | <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> |
         *        <code>python3.8</code> | <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code>
         *        | <code>ruby2.5</code> | <code>provided</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Collection<String> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes. Maximum number of five items.
         * </p>
         * <p>
         * Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> | <code>java11</code> |
         * <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> | <code>python3.8</code> |
         * <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code> | <code>ruby2.5</code> |
         * <code>provided</code>
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes. Maximum number of five items.</p>
         *        <p>
         *        Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> |
         *        <code>java11</code> | <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> |
         *        <code>python3.8</code> | <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code>
         *        | <code>ruby2.5</code> | <code>provided</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(String... compatibleRuntimes);

        /**
         * <p>
         * The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
         * </p>
         * 
         * @param createdDate
         *        The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);
    }

    static final class BuilderImpl implements Builder {
        private Long version;

        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaLayerVersionDetails model) {
            version(model.version);
            compatibleRuntimes(model.compatibleRuntimes);
            createdDate(model.createdDate);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Collection<String> getCompatibleRuntimes() {
            return compatibleRuntimes;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(String... compatibleRuntimes) {
            compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public AwsLambdaLayerVersionDetails build() {
            return new AwsLambdaLayerVersionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
