/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Elasticsearch domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticsearchDomainDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticsearchDomainDetails.Builder, AwsElasticsearchDomainDetails> {
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDetails::accessPolicies)).setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<AwsElasticsearchDomainDomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainDomainEndpointOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsElasticsearchDomainDetails::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(AwsElasticsearchDomainDomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDetails::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDetails::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDetails::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AwsElasticsearchDomainDetails::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsElasticsearchDomainDetails::elasticsearchVersion)).setter(setter(Builder::elasticsearchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainEncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainEncryptionAtRestOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsElasticsearchDomainDetails::encryptionAtRestOptions))
            .setter(setter(Builder::encryptionAtRestOptions)).constructor(AwsElasticsearchDomainEncryptionAtRestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainNodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainNodeToNodeEncryptionOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsElasticsearchDomainDetails::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(AwsElasticsearchDomainNodeToNodeEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<AwsElasticsearchDomainVPCOptions> VPC_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainVPCOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsElasticsearchDomainDetails::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(AwsElasticsearchDomainVPCOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD,
            DOMAIN_ENDPOINT_OPTIONS_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD,
            ELASTICSEARCH_VERSION_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD,
            VPC_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessPolicies;

    private final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;

    private final String domainId;

    private final String domainName;

    private final String endpoint;

    private final Map<String, String> endpoints;

    private final String elasticsearchVersion;

    private final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;

    private final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

    private final AwsElasticsearchDomainVPCOptions vpcOptions;

    private AwsElasticsearchDomainDetails(BuilderImpl builder) {
        this.accessPolicies = builder.accessPolicies;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.vpcOptions = builder.vpcOptions;
    }

    /**
     * <p>
     * IAM policy document specifying the access policies for the new Amazon ES domain.
     * </p>
     * 
     * @return IAM policy document specifying the access policies for the new Amazon ES domain.
     */
    public String accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * Additional options for the domain endpoint.
     * </p>
     * 
     * @return Additional options for the domain endpoint.
     */
    public AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Unique identifier for an Amazon ES domain.
     * </p>
     * 
     * @return Unique identifier for an Amazon ES domain.
     */
    public String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Name of an Amazon ES domain.
     * </p>
     * <p>
     * Domain names are unique across all domains owned by the same account within an AWS Region.
     * </p>
     * <p>
     * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
     * </p>
     * <p>
     * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
     * </p>
     * 
     * @return Name of an Amazon ES domain.</p>
     *         <p>
     *         Domain names are unique across all domains owned by the same account within an AWS Region.
     *         </p>
     *         <p>
     *         Domain names must start with a lowercase letter and must be between 3 and 28 characters.
     *         </p>
     *         <p>
     *         Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Domain-specific endpoint used to submit index, search, and data upload requests to an Amazon ES domain.
     * </p>
     * <p>
     * The endpoint is a service URL.
     * </p>
     * 
     * @return Domain-specific endpoint used to submit index, search, and data upload requests to an Amazon ES
     *         domain.</p>
     *         <p>
     *         The endpoint is a service URL.
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
     */
    public Map<String, String> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * Elasticsearch version.
     * </p>
     * 
     * @return Elasticsearch version.
     */
    public String elasticsearchVersion() {
        return elasticsearchVersion;
    }

    /**
     * <p>
     * Details about the configuration for encryption at rest.
     * </p>
     * 
     * @return Details about the configuration for encryption at rest.
     */
    public AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Details about the configuration for node-to-node encryption.
     * </p>
     * 
     * @return Details about the configuration for node-to-node encryption.
     */
    public AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.
     * </p>
     * 
     * @return Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.
     */
    public AwsElasticsearchDomainVPCOptions vpcOptions() {
        return vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainDetails)) {
            return false;
        }
        AwsElasticsearchDomainDetails other = (AwsElasticsearchDomainDetails) obj;
        return Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(elasticsearchVersion(), other.elasticsearchVersion())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && Objects.equals(vpcOptions(), other.vpcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsElasticsearchDomainDetails").add("AccessPolicies", accessPolicies())
                .add("DomainEndpointOptions", domainEndpointOptions()).add("DomainId", domainId())
                .add("DomainName", domainName()).add("Endpoint", endpoint()).add("Endpoints", endpoints())
                .add("ElasticsearchVersion", elasticsearchVersion()).add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions()).add("VPCOptions", vpcOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "ElasticsearchVersion":
            return Optional.ofNullable(clazz.cast(elasticsearchVersion()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainDetails, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
        /**
         * <p>
         * IAM policy document specifying the access policies for the new Amazon ES domain.
         * </p>
         * 
         * @param accessPolicies
         *        IAM policy document specifying the access policies for the new Amazon ES domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(String accessPolicies);

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Additional options for the domain endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions);

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainDomainEndpointOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainDomainEndpointOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainDomainEndpointOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainDomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions)
         */
        default Builder domainEndpointOptions(Consumer<AwsElasticsearchDomainDomainEndpointOptions.Builder> domainEndpointOptions) {
            return domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.builder()
                    .applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Unique identifier for an Amazon ES domain.
         * </p>
         * 
         * @param domainId
         *        Unique identifier for an Amazon ES domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Name of an Amazon ES domain.
         * </p>
         * <p>
         * Domain names are unique across all domains owned by the same account within an AWS Region.
         * </p>
         * <p>
         * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
         * </p>
         * <p>
         * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
         * </p>
         * 
         * @param domainName
         *        Name of an Amazon ES domain.</p>
         *        <p>
         *        Domain names are unique across all domains owned by the same account within an AWS Region.
         *        </p>
         *        <p>
         *        Domain names must start with a lowercase letter and must be between 3 and 28 characters.
         *        </p>
         *        <p>
         *        Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Domain-specific endpoint used to submit index, search, and data upload requests to an Amazon ES domain.
         * </p>
         * <p>
         * The endpoint is a service URL.
         * </p>
         * 
         * @param endpoint
         *        Domain-specific endpoint used to submit index, search, and data upload requests to an Amazon ES
         *        domain.</p>
         *        <p>
         *        The endpoint is a service URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
         * </p>
         * 
         * @param endpoints
         *        The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Map<String, String> endpoints);

        /**
         * <p>
         * Elasticsearch version.
         * </p>
         * 
         * @param elasticsearchVersion
         *        Elasticsearch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersion(String elasticsearchVersion);

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Details about the configuration for encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions);

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainEncryptionAtRestOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions)
         */
        default Builder encryptionAtRestOptions(
                Consumer<AwsElasticsearchDomainEncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions.builder()
                    .applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Details about the configuration for node-to-node encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder} avoiding the need to create one manually
         * via {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions)
         */
        default Builder nodeToNodeEncryptionOptions(
                Consumer<AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions.builder()
                    .applyMutation(nodeToNodeEncryptionOptions).build());
        }

        /**
         * <p>
         * Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * 
         * @param vpcOptions
         *        Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions);

        /**
         * <p>
         * Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsElasticsearchDomainVPCOptions.Builder}
         * avoiding the need to create one manually via {@link AwsElasticsearchDomainVPCOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainVPCOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcOptions(AwsElasticsearchDomainVPCOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainVPCOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(AwsElasticsearchDomainVPCOptions)
         */
        default Builder vpcOptions(Consumer<AwsElasticsearchDomainVPCOptions.Builder> vpcOptions) {
            return vpcOptions(AwsElasticsearchDomainVPCOptions.builder().applyMutation(vpcOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessPolicies;

        private AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;

        private String domainId;

        private String domainName;

        private String endpoint;

        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();

        private String elasticsearchVersion;

        private AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;

        private AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

        private AwsElasticsearchDomainVPCOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainDetails model) {
            accessPolicies(model.accessPolicies);
            domainEndpointOptions(model.domainEndpointOptions);
            domainId(model.domainId);
            domainName(model.domainName);
            endpoint(model.endpoint);
            endpoints(model.endpoints);
            elasticsearchVersion(model.elasticsearchVersion);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            vpcOptions(model.vpcOptions);
        }

        public final String getAccessPolicies() {
            return accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final AwsElasticsearchDomainDomainEndpointOptions.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Map<String, String> getEndpoints() {
            return endpoints;
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
        }

        public final String getElasticsearchVersion() {
            return elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final AwsElasticsearchDomainEncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final void setEncryptionAtRestOptions(
                AwsElasticsearchDomainEncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        public final AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(
                AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final void setNodeToNodeEncryptionOptions(
                AwsElasticsearchDomainNodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        public final AwsElasticsearchDomainVPCOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVpcOptions(AwsElasticsearchDomainVPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public AwsElasticsearchDomainDetails build() {
            return new AwsElasticsearchDomainDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
