/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the network interface attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2NetworkInterfaceAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2NetworkInterfaceAttachment.Builder, AwsEc2NetworkInterfaceAttachment> {
    private static final SdkField<String> ATTACH_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::attachTime)).setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::deleteOnTermination)).setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::deviceIndex)).setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::instanceOwnerId)).setter(setter(Builder::instanceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2NetworkInterfaceAttachment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD,
            ATTACHMENT_ID_FIELD, DELETE_ON_TERMINATION_FIELD, DEVICE_INDEX_FIELD, INSTANCE_ID_FIELD, INSTANCE_OWNER_ID_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachTime;

    private final String attachmentId;

    private final Boolean deleteOnTermination;

    private final Integer deviceIndex;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String status;

    private AwsEc2NetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp indicating when the attachment initiated.
     * </p>
     * 
     * @return The timestamp indicating when the attachment initiated.
     */
    public String attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The identifier of the network interface attachment
     * </p>
     * 
     * @return The identifier of the network interface attachment
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The device index of the network interface attachment on the instance.
     * </p>
     * 
     * @return The device index of the network interface attachment on the instance.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the instance.
     * </p>
     * 
     * @return The AWS account ID of the owner of the instance.
     */
    public String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>
     * </p>
     * 
     * @return The attachment state.</p>
     *         <p>
     *         Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> |
     *         <code>detached</code>
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceAttachment)) {
            return false;
        }
        AwsEc2NetworkInterfaceAttachment other = (AwsEc2NetworkInterfaceAttachment) obj;
        return Objects.equals(attachTime(), other.attachTime()) && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(deviceIndex(), other.deviceIndex()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2NetworkInterfaceAttachment").add("AttachTime", attachTime())
                .add("AttachmentId", attachmentId()).add("DeleteOnTermination", deleteOnTermination())
                .add("DeviceIndex", deviceIndex()).add("InstanceId", instanceId()).add("InstanceOwnerId", instanceOwnerId())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.ofNullable(clazz.cast(instanceOwnerId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceAttachment, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2NetworkInterfaceAttachment> {
        /**
         * <p>
         * The timestamp indicating when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The timestamp indicating when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(String attachTime);

        /**
         * <p>
         * The identifier of the network interface attachment
         * </p>
         * 
         * @param attachmentId
         *        The identifier of the network interface attachment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The device index of the network interface attachment on the instance.
         * </p>
         * 
         * @param deviceIndex
         *        The device index of the network interface attachment on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The AWS account ID of the owner of the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The AWS account ID of the owner of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The attachment state.
         * </p>
         * <p>
         * Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>
         * </p>
         * 
         * @param status
         *        The attachment state.</p>
         *        <p>
         *        Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> |
         *        <code>detached</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String attachTime;

        private String attachmentId;

        private Boolean deleteOnTermination;

        private Integer deviceIndex;

        private String instanceId;

        private String instanceOwnerId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceAttachment model) {
            attachTime(model.attachTime);
            attachmentId(model.attachmentId);
            deleteOnTermination(model.deleteOnTermination);
            deviceIndex(model.deviceIndex);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            status(model.status);
        }

        public final String getAttachTime() {
            return attachTime;
        }

        @Override
        public final Builder attachTime(String attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(String attachTime) {
            this.attachTime = attachTime;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public AwsEc2NetworkInterfaceAttachment build() {
            return new AwsEc2NetworkInterfaceAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
