/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2InstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2InstanceDetails.Builder, AwsEc2InstanceDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsEc2InstanceDetails::ipV4Addresses))
            .setter(setter(Builder::ipV4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsEc2InstanceDetails::ipV6Addresses))
            .setter(setter(Builder::ipV6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::iamInstanceProfileArn)).setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileArn").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsEc2InstanceDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IMAGE_ID_FIELD,
            IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD, KEY_NAME_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, VPC_ID_FIELD,
            SUBNET_ID_FIELD, LAUNCHED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String imageId;

    private final List<String> ipV4Addresses;

    private final List<String> ipV6Addresses;

    private final String keyName;

    private final String iamInstanceProfileArn;

    private final String vpcId;

    private final String subnetId;

    private final String launchedAt;

    private AwsEc2InstanceDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.imageId = builder.imageId;
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.keyName = builder.keyName;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.launchedAt = builder.launchedAt;
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * 
     * @return The instance type of the instance.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) ID of the instance.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * Returns true if the IpV4Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpV4Addresses() {
        return ipV4Addresses != null && !(ipV4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpV4Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 addresses associated with the instance.
     */
    public List<String> ipV4Addresses() {
        return ipV4Addresses;
    }

    /**
     * Returns true if the IpV6Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpV6Addresses() {
        return ipV6Addresses != null && !(ipV6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpV6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 addresses associated with the instance.
     */
    public List<String> ipV6Addresses() {
        return ipV6Addresses;
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * 
     * @return The key name associated with the instance.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * 
     * @return The IAM profile ARN of the instance.
     */
    public String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the VPC that the instance was launched in.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the subnet that the instance was launched in.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * 
     * @return The date/time the instance was launched.
     */
    public String launchedAt() {
        return launchedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(ipV4Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(ipV6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceDetails)) {
            return false;
        }
        AwsEc2InstanceDetails other = (AwsEc2InstanceDetails) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(ipV4Addresses(), other.ipV4Addresses())
                && Objects.equals(ipV6Addresses(), other.ipV6Addresses()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(launchedAt(), other.launchedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsEc2InstanceDetails").add("Type", type()).add("ImageId", imageId())
                .add("IpV4Addresses", ipV4Addresses()).add("IpV6Addresses", ipV6Addresses()).add("KeyName", keyName())
                .add("IamInstanceProfileArn", iamInstanceProfileArn()).add("VpcId", vpcId()).add("SubnetId", subnetId())
                .add("LaunchedAt", launchedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "IpV4Addresses":
            return Optional.ofNullable(clazz.cast(ipV4Addresses()));
        case "IpV6Addresses":
            return Optional.ofNullable(clazz.cast(ipV6Addresses()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "IamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "LaunchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceDetails, T> g) {
        return obj -> g.apply((AwsEc2InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2InstanceDetails> {
        /**
         * <p>
         * The instance type of the instance.
         * </p>
         * 
         * @param type
         *        The instance type of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID of the instance.
         * </p>
         * 
         * @param imageId
         *        The Amazon Machine Image (AMI) ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(Collection<String> ipV4Addresses);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(String... ipV4Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(Collection<String> ipV6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(String... ipV6Addresses);

        /**
         * <p>
         * The key name associated with the instance.
         * </p>
         * 
         * @param keyName
         *        The key name associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The IAM profile ARN of the instance.
         * </p>
         * 
         * @param iamInstanceProfileArn
         *        The IAM profile ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * <p>
         * The identifier of the VPC that the instance was launched in.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The identifier of the subnet that the instance was launched in.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The date/time the instance was launched.
         * </p>
         * 
         * @param launchedAt
         *        The date/time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(String launchedAt);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String imageId;

        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String keyName;

        private String iamInstanceProfileArn;

        private String vpcId;

        private String subnetId;

        private String launchedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceDetails model) {
            type(model.type);
            imageId(model.imageId);
            ipV4Addresses(model.ipV4Addresses);
            ipV6Addresses(model.ipV6Addresses);
            keyName(model.keyName);
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            vpcId(model.vpcId);
            subnetId(model.subnetId);
            launchedAt(model.launchedAt);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<String> getIpV4Addresses() {
            return ipV4Addresses;
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String... ipV4Addresses) {
            ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
        }

        public final Collection<String> getIpV6Addresses() {
            return ipV6Addresses;
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String... ipV6Addresses) {
            ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLaunchedAt() {
            return launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public AwsEc2InstanceDetails build() {
            return new AwsEc2InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
