/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the build environment for this build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectEnvironment.Builder, AwsCodeBuildProjectEnvironment> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCodeBuildProjectEnvironment::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCodeBuildProjectEnvironment::imagePullCredentialsType))
            .setter(setter(Builder::imagePullCredentialsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePullCredentialsType").build())
            .build();

    private static final SdkField<AwsCodeBuildProjectEnvironmentRegistryCredential> REGISTRY_CREDENTIAL_FIELD = SdkField
            .<AwsCodeBuildProjectEnvironmentRegistryCredential> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsCodeBuildProjectEnvironment::registryCredential)).setter(setter(Builder::registryCredential))
            .constructor(AwsCodeBuildProjectEnvironmentRegistryCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryCredential").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCodeBuildProjectEnvironment::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            IMAGE_PULL_CREDENTIALS_TYPE_FIELD, REGISTRY_CREDENTIAL_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificate;

    private final String imagePullCredentialsType;

    private final AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;

    private final String type;

    private AwsCodeBuildProjectEnvironment(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.imagePullCredentialsType = builder.imagePullCredentialsType;
        this.registryCredential = builder.registryCredential;
        this.type = builder.type;
    }

    /**
     * <p>
     * The certificate to use with this build project.
     * </p>
     * 
     * @return The certificate to use with this build project.
     */
    public String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The type of credentials AWS CodeBuild uses to pull images in your build.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your
     * ECR repository policy to trust the AWS CodeBuild service principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When
     * you use an AWS CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * </p>
     * 
     * @return The type of credentials AWS CodeBuild uses to pull images in your build.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
     *         modify your ECR repository policy to trust the AWS CodeBuild service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
     *         credentials. When you use an AWS CodeBuild curated image, you must use <code>CODEBUILD</code>
     *         credentials.
     */
    public String imagePullCredentialsType() {
        return imagePullCredentialsType;
    }

    /**
     * <p>
     * The credentials for access to a private registry.
     * </p>
     * 
     * @return The credentials for access to a private registry.
     */
    public AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential() {
        return registryCredential;
    }

    /**
     * <p>
     * The type of build environment to use for related builds.
     * </p>
     * <p>
     * The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney),
     * and Europe (Frankfurt).
     * </p>
     * <p>
     * The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only in
     * Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland),
     * Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia
     * Pacific (Sydney), China (Beijing), and China (Ningxia).
     * </p>
     * <p>
     * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
     * (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia
     * Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
     * China (Ningxia).
     * </p>
     * <p>
     * Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> | <code>LINUX_GPU_CONTAINER</code> |
     * <code>ARM_CONTAINER</code>
     * </p>
     * 
     * @return The type of build environment to use for related builds.</p>
     *         <p>
     *         The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia
     *         Pacific (Sydney), and Europe (Frankfurt).
     *         </p>
     *         <p>
     *         The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available
     *         only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe
     *         (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
     *         </p>
     *         <p>
     *         The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia),
     *         US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
     *         (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney),
     *         China (Beijing), and China (Ningxia).
     *         </p>
     *         <p>
     *         Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
     *         <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(imagePullCredentialsType());
        hashCode = 31 * hashCode + Objects.hashCode(registryCredential());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectEnvironment)) {
            return false;
        }
        AwsCodeBuildProjectEnvironment other = (AwsCodeBuildProjectEnvironment) obj;
        return Objects.equals(certificate(), other.certificate())
                && Objects.equals(imagePullCredentialsType(), other.imagePullCredentialsType())
                && Objects.equals(registryCredential(), other.registryCredential()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsCodeBuildProjectEnvironment").add("Certificate", certificate())
                .add("ImagePullCredentialsType", imagePullCredentialsType()).add("RegistryCredential", registryCredential())
                .add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "ImagePullCredentialsType":
            return Optional.ofNullable(clazz.cast(imagePullCredentialsType()));
        case "RegistryCredential":
            return Optional.ofNullable(clazz.cast(registryCredential()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectEnvironment, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectEnvironment> {
        /**
         * <p>
         * The certificate to use with this build project.
         * </p>
         * 
         * @param certificate
         *        The certificate to use with this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The type of credentials AWS CodeBuild uses to pull images in your build.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify
         * your ECR repository policy to trust the AWS CodeBuild service principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
         * When you use an AWS CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * </p>
         * 
         * @param imagePullCredentialsType
         *        The type of credentials AWS CodeBuild uses to pull images in your build.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you
         *        modify your ECR repository policy to trust the AWS CodeBuild service principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project's service role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
         *        credentials. When you use an AWS CodeBuild curated image, you must use <code>CODEBUILD</code>
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePullCredentialsType(String imagePullCredentialsType);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * 
         * @param registryCredential
         *        The credentials for access to a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder} avoiding the need to create one manually via
         * {@link AwsCodeBuildProjectEnvironmentRegistryCredential#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential)}.
         * 
         * @param registryCredential
         *        a consumer that will call methods on {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential)
         */
        default Builder registryCredential(Consumer<AwsCodeBuildProjectEnvironmentRegistryCredential.Builder> registryCredential) {
            return registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential.builder()
                    .applyMutation(registryCredential).build());
        }

        /**
         * <p>
         * The type of build environment to use for related builds.
         * </p>
         * <p>
         * The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         * (Sydney), and Europe (Frankfurt).
         * </p>
         * <p>
         * The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only
         * in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe
         * (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
         * (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         * </p>
         * <p>
         * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US
         * East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
         * (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney),
         * China (Beijing), and China (Ningxia).
         * </p>
         * <p>
         * Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
         * <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
         * </p>
         * 
         * @param type
         *        The type of build environment to use for related builds.</p>
         *        <p>
         *        The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US
         *        East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia
         *        Pacific (Sydney), and Europe (Frankfurt).
         *        </p>
         *        <p>
         *        The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is
         *        available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada
         *        (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
         *        (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *        </p>
         *        <p>
         *        The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N.
         *        Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe
         *        (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
         *        Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *        </p>
         *        <p>
         *        Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
         *        <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String certificate;

        private String imagePullCredentialsType;

        private AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectEnvironment model) {
            certificate(model.certificate);
            imagePullCredentialsType(model.imagePullCredentialsType);
            registryCredential(model.registryCredential);
            type(model.type);
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getImagePullCredentialsType() {
            return imagePullCredentialsType;
        }

        @Override
        public final Builder imagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
            return this;
        }

        public final void setImagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
        }

        public final AwsCodeBuildProjectEnvironmentRegistryCredential.Builder getRegistryCredential() {
            return registryCredential != null ? registryCredential.toBuilder() : null;
        }

        @Override
        public final Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential) {
            this.registryCredential = registryCredential;
            return this;
        }

        public final void setRegistryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential.BuilderImpl registryCredential) {
            this.registryCredential = registryCredential != null ? registryCredential.build() : null;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public AwsCodeBuildProjectEnvironment build() {
            return new AwsCodeBuildProjectEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
