/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionDetails.Builder, AwsCloudFrontDistributionDetails> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionDetails::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionDetails::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<String> LAST_MODIFIED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionDetails::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<AwsCloudFrontDistributionLogging> LOGGING_FIELD = SdkField
            .<AwsCloudFrontDistributionLogging> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsCloudFrontDistributionDetails::logging)).setter(setter(Builder::logging))
            .constructor(AwsCloudFrontDistributionLogging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOrigins> ORIGINS_FIELD = SdkField
            .<AwsCloudFrontDistributionOrigins> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsCloudFrontDistributionDetails::origins)).setter(setter(Builder::origins))
            .constructor(AwsCloudFrontDistributionOrigins::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionDetails::webAclId)).setter(setter(Builder::webAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            E_TAG_FIELD, LAST_MODIFIED_TIME_FIELD, LOGGING_FIELD, ORIGINS_FIELD, STATUS_FIELD, WEB_ACL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String eTag;

    private final String lastModifiedTime;

    private final AwsCloudFrontDistributionLogging logging;

    private final AwsCloudFrontDistributionOrigins origins;

    private final String status;

    private final String webAclId;

    private AwsCloudFrontDistributionDetails(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.eTag = builder.eTag;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logging = builder.logging;
        this.origins = builder.origins;
        this.status = builder.status;
        this.webAclId = builder.webAclId;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution.
     * </p>
     * 
     * @return The domain name corresponding to the distribution.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The entity tag is a hash of the object.
     * </p>
     * 
     * @return The entity tag is a hash of the object.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The date and time that the distribution was last modified.
     * </p>
     * 
     * @return The date and time that the distribution was last modified.
     */
    public String lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the distribution.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the distribution.
     */
    public AwsCloudFrontDistributionLogging logging() {
        return logging;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public AwsCloudFrontDistributionOrigins origins() {
        return origins;
    }

    /**
     * <p>
     * Indicates the current status of the distribution.
     * </p>
     * 
     * @return Indicates the current status of the distribution.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
     * </p>
     * 
     * @return A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
     */
    public String webAclId() {
        return webAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(webAclId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionDetails)) {
            return false;
        }
        AwsCloudFrontDistributionDetails other = (AwsCloudFrontDistributionDetails) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(logging(), other.logging())
                && Objects.equals(origins(), other.origins()) && Objects.equals(status(), other.status())
                && Objects.equals(webAclId(), other.webAclId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsCloudFrontDistributionDetails").add("DomainName", domainName()).add("ETag", eTag())
                .add("LastModifiedTime", lastModifiedTime()).add("Logging", logging()).add("Origins", origins())
                .add("Status", status()).add("WebAclId", webAclId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "Origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "WebAclId":
            return Optional.ofNullable(clazz.cast(webAclId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionDetails, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionDetails> {
        /**
         * <p>
         * The domain name corresponding to the distribution.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The entity tag is a hash of the object.
         * </p>
         * 
         * @param eTag
         *        The entity tag is a hash of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The date and time that the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(String lastModifiedTime);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(AwsCloudFrontDistributionLogging logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCloudFrontDistributionLogging.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionLogging#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionLogging.Builder#build()} is called
         * immediately and its result is passed to {@link #logging(AwsCloudFrontDistributionLogging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionLogging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(AwsCloudFrontDistributionLogging)
         */
        default Builder logging(Consumer<AwsCloudFrontDistributionLogging.Builder> logging) {
            return logging(AwsCloudFrontDistributionLogging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(AwsCloudFrontDistributionOrigins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCloudFrontDistributionOrigins.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionOrigins#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOrigins.Builder#build()} is called
         * immediately and its result is passed to {@link #origins(AwsCloudFrontDistributionOrigins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOrigins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(AwsCloudFrontDistributionOrigins)
         */
        default Builder origins(Consumer<AwsCloudFrontDistributionOrigins.Builder> origins) {
            return origins(AwsCloudFrontDistributionOrigins.builder().applyMutation(origins).build());
        }

        /**
         * <p>
         * Indicates the current status of the distribution.
         * </p>
         * 
         * @param status
         *        Indicates the current status of the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
         * </p>
         * 
         * @param webAclId
         *        A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclId(String webAclId);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String eTag;

        private String lastModifiedTime;

        private AwsCloudFrontDistributionLogging logging;

        private AwsCloudFrontDistributionOrigins origins;

        private String status;

        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionDetails model) {
            domainName(model.domainName);
            eTag(model.eTag);
            lastModifiedTime(model.lastModifiedTime);
            logging(model.logging);
            origins(model.origins);
            status(model.status);
            webAclId(model.webAclId);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final AwsCloudFrontDistributionLogging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(AwsCloudFrontDistributionLogging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(AwsCloudFrontDistributionLogging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final AwsCloudFrontDistributionOrigins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(AwsCloudFrontDistributionOrigins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(AwsCloudFrontDistributionOrigins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getWebAclId() {
            return webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        public AwsCloudFrontDistributionDetails build() {
            return new AwsCloudFrontDistributionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
