/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that represents your subscription to a supported standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsSubscription.Builder, StandardsSubscription> {
    private static final SdkField<String> STANDARDS_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StandardsSubscription::standardsSubscriptionArn)).setter(setter(Builder::standardsSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArn").build())
            .build();

    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StandardsSubscription::standardsArn)).setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final SdkField<Map<String, String>> STANDARDS_INPUT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(StandardsSubscription::standardsInput))
            .setter(setter(Builder::standardsInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsInput").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STANDARDS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StandardsSubscription::standardsStatusAsString)).setter(setter(Builder::standardsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDARDS_SUBSCRIPTION_ARN_FIELD, STANDARDS_ARN_FIELD, STANDARDS_INPUT_FIELD, STANDARDS_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String standardsSubscriptionArn;

    private final String standardsArn;

    private final Map<String, String> standardsInput;

    private final String standardsStatus;

    private StandardsSubscription(BuilderImpl builder) {
        this.standardsSubscriptionArn = builder.standardsSubscriptionArn;
        this.standardsArn = builder.standardsArn;
        this.standardsInput = builder.standardsInput;
        this.standardsStatus = builder.standardsStatus;
    }

    /**
     * <p>
     * The ARN of a resource that represents your subscription to a supported standard.
     * </p>
     * 
     * @return The ARN of a resource that represents your subscription to a supported standard.
     */
    public String standardsSubscriptionArn() {
        return standardsSubscriptionArn;
    }

    /**
     * <p>
     * The ARN of a standard.
     * </p>
     * <p>
     * In this release, Security Hub supports only the CIS AWS Foundations standard, which uses the following ARN:
     * <code>arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.</code>
     * </p>
     * 
     * @return The ARN of a standard.</p>
     *         <p>
     *         In this release, Security Hub supports only the CIS AWS Foundations standard, which uses the following
     *         ARN: <code>arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.</code>
     */
    public String standardsArn() {
        return standardsArn;
    }

    /**
     * Returns true if the StandardsInput property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStandardsInput() {
        return standardsInput != null && !(standardsInput instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value pair of input for the standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStandardsInput()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value pair of input for the standard.
     */
    public Map<String, String> standardsInput() {
        return standardsInput;
    }

    /**
     * <p>
     * The status of the standards subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardsStatus}
     * will return {@link StandardsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardsStatusAsString}.
     * </p>
     * 
     * @return The status of the standards subscription.
     * @see StandardsStatus
     */
    public StandardsStatus standardsStatus() {
        return StandardsStatus.fromValue(standardsStatus);
    }

    /**
     * <p>
     * The status of the standards subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standardsStatus}
     * will return {@link StandardsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standardsStatusAsString}.
     * </p>
     * 
     * @return The status of the standards subscription.
     * @see StandardsStatus
     */
    public String standardsStatusAsString() {
        return standardsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(standardsInput());
        hashCode = 31 * hashCode + Objects.hashCode(standardsStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsSubscription)) {
            return false;
        }
        StandardsSubscription other = (StandardsSubscription) obj;
        return Objects.equals(standardsSubscriptionArn(), other.standardsSubscriptionArn())
                && Objects.equals(standardsArn(), other.standardsArn())
                && Objects.equals(standardsInput(), other.standardsInput())
                && Objects.equals(standardsStatusAsString(), other.standardsStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StandardsSubscription").add("StandardsSubscriptionArn", standardsSubscriptionArn())
                .add("StandardsArn", standardsArn()).add("StandardsInput", standardsInput())
                .add("StandardsStatus", standardsStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsSubscriptionArn":
            return Optional.ofNullable(clazz.cast(standardsSubscriptionArn()));
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        case "StandardsInput":
            return Optional.ofNullable(clazz.cast(standardsInput()));
        case "StandardsStatus":
            return Optional.ofNullable(clazz.cast(standardsStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandardsSubscription, T> g) {
        return obj -> g.apply((StandardsSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsSubscription> {
        /**
         * <p>
         * The ARN of a resource that represents your subscription to a supported standard.
         * </p>
         * 
         * @param standardsSubscriptionArn
         *        The ARN of a resource that represents your subscription to a supported standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsSubscriptionArn(String standardsSubscriptionArn);

        /**
         * <p>
         * The ARN of a standard.
         * </p>
         * <p>
         * In this release, Security Hub supports only the CIS AWS Foundations standard, which uses the following ARN:
         * <code>arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.</code>
         * </p>
         * 
         * @param standardsArn
         *        The ARN of a standard.</p>
         *        <p>
         *        In this release, Security Hub supports only the CIS AWS Foundations standard, which uses the following
         *        ARN: <code>arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);

        /**
         * <p>
         * A key-value pair of input for the standard.
         * </p>
         * 
         * @param standardsInput
         *        A key-value pair of input for the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsInput(Map<String, String> standardsInput);

        /**
         * <p>
         * The status of the standards subscription.
         * </p>
         * 
         * @param standardsStatus
         *        The status of the standards subscription.
         * @see StandardsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsStatus
         */
        Builder standardsStatus(String standardsStatus);

        /**
         * <p>
         * The status of the standards subscription.
         * </p>
         * 
         * @param standardsStatus
         *        The status of the standards subscription.
         * @see StandardsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandardsStatus
         */
        Builder standardsStatus(StandardsStatus standardsStatus);
    }

    static final class BuilderImpl implements Builder {
        private String standardsSubscriptionArn;

        private String standardsArn;

        private Map<String, String> standardsInput = DefaultSdkAutoConstructMap.getInstance();

        private String standardsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsSubscription model) {
            standardsSubscriptionArn(model.standardsSubscriptionArn);
            standardsArn(model.standardsArn);
            standardsInput(model.standardsInput);
            standardsStatus(model.standardsStatus);
        }

        public final String getStandardsSubscriptionArn() {
            return standardsSubscriptionArn;
        }

        @Override
        public final Builder standardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
            return this;
        }

        public final void setStandardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        public final Map<String, String> getStandardsInput() {
            return standardsInput;
        }

        @Override
        public final Builder standardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
            return this;
        }

        public final void setStandardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
        }

        public final String getStandardsStatusAsString() {
            return standardsStatus;
        }

        @Override
        public final Builder standardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
            return this;
        }

        @Override
        public final Builder standardsStatus(StandardsStatus standardsStatus) {
            this.standardsStatus(standardsStatus == null ? null : standardsStatus.toString());
            return this;
        }

        public final void setStandardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
        }

        @Override
        public StandardsSubscription build() {
            return new StandardsSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
