/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::partitionAsString)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Resource::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ResourceDetails> DETAILS_FIELD = SdkField.<ResourceDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(Resource::details)).setter(setter(Builder::details)).constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD,
            PARTITION_FIELD, REGION_FIELD, TAGS_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String id;

    private final String partition;

    private final String region;

    private final Map<String, String> tags;

    private final ResourceDetails details;

    private Resource(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.tags = builder.tags;
        this.details = builder.details;
    }

    /**
     * <p>
     * The type of the resource that details are provided for.
     * </p>
     * 
     * @return The type of the resource that details are provided for.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * 
     * @return The canonical identifier for the given resource type.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partition} will
     * return {@link Partition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partitionAsString}.
     * </p>
     * 
     * @return The canonical AWS partition name that the Region is assigned to.
     * @see Partition
     */
    public Partition partition() {
        return Partition.fromValue(partition);
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partition} will
     * return {@link Partition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partitionAsString}.
     * </p>
     * 
     * @return The canonical AWS partition name that the Region is assigned to.
     * @see Partition
     */
    public String partitionAsString() {
        return partition;
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * 
     * @return The canonical AWS external Region name where this resource is located.
     */
    public String region() {
        return region;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS tags associated with a resource at the time the finding was processed.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Additional details about the resource related to a finding.
     * </p>
     * 
     * @return Additional details about the resource related to a finding.
     */
    public ResourceDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(partitionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(id(), other.id())
                && Objects.equals(partitionAsString(), other.partitionAsString()) && Objects.equals(region(), other.region())
                && Objects.equals(tags(), other.tags()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Resource").add("Type", type()).add("Id", id()).add("Partition", partitionAsString())
                .add("Region", region()).add("Tags", tags()).add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Partition":
            return Optional.ofNullable(clazz.cast(partitionAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The type of the resource that details are provided for.
         * </p>
         * 
         * @param type
         *        The type of the resource that details are provided for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The canonical identifier for the given resource type.
         * </p>
         * 
         * @param id
         *        The canonical identifier for the given resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The canonical AWS partition name that the Region is assigned to.
         * </p>
         * 
         * @param partition
         *        The canonical AWS partition name that the Region is assigned to.
         * @see Partition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Partition
         */
        Builder partition(String partition);

        /**
         * <p>
         * The canonical AWS partition name that the Region is assigned to.
         * </p>
         * 
         * @param partition
         *        The canonical AWS partition name that the Region is assigned to.
         * @see Partition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Partition
         */
        Builder partition(Partition partition);

        /**
         * <p>
         * The canonical AWS external Region name where this resource is located.
         * </p>
         * 
         * @param region
         *        The canonical AWS external Region name where this resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * </p>
         * 
         * @param tags
         *        A list of AWS tags associated with a resource at the time the finding was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Additional details about the resource related to a finding.
         * </p>
         * 
         * @param details
         *        Additional details about the resource related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceDetails details);

        /**
         * <p>
         * Additional details about the resource related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDetails.Builder} avoiding the need to
         * create one manually via {@link ResourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(ResourceDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(ResourceDetails)
         */
        default Builder details(Consumer<ResourceDetails.Builder> details) {
            return details(ResourceDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String id;

        private String partition;

        private String region;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ResourceDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            type(model.type);
            id(model.id);
            partition(model.partition);
            region(model.region);
            tags(model.tags);
            details(model.details);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPartitionAsString() {
            return partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public final Builder partition(Partition partition) {
            this.partition(partition == null ? null : partition.toString());
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
        }

        public final ResourceDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Override
        public final Builder details(ResourceDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(ResourceDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
