/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A number filter for querying findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberFilter implements SdkPojo, Serializable, ToCopyableBuilder<NumberFilter.Builder, NumberFilter> {
    private static final SdkField<Double> GTE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(NumberFilter::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gte").build()).build();

    private static final SdkField<Double> LTE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(NumberFilter::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lte").build()).build();

    private static final SdkField<Double> EQ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(NumberFilter::eq)).setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Eq").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GTE_FIELD, LTE_FIELD, EQ_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double gte;

    private final Double lte;

    private final Double eq;

    private NumberFilter(BuilderImpl builder) {
        this.gte = builder.gte;
        this.lte = builder.lte;
        this.eq = builder.eq;
    }

    /**
     * <p>
     * The greater-than-equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return The greater-than-equal condition to be applied to a single field when querying for findings.
     */
    public Double gte() {
        return gte;
    }

    /**
     * <p>
     * The less-than-equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return The less-than-equal condition to be applied to a single field when querying for findings.
     */
    public Double lte() {
        return lte;
    }

    /**
     * <p>
     * The equal-to condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return The equal-to condition to be applied to a single field when querying for findings.
     */
    public Double eq() {
        return eq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(eq());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberFilter)) {
            return false;
        }
        NumberFilter other = (NumberFilter) obj;
        return Objects.equals(gte(), other.gte()) && Objects.equals(lte(), other.lte()) && Objects.equals(eq(), other.eq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NumberFilter").add("Gte", gte()).add("Lte", lte()).add("Eq", eq()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "Lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "Eq":
            return Optional.ofNullable(clazz.cast(eq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumberFilter, T> g) {
        return obj -> g.apply((NumberFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberFilter> {
        /**
         * <p>
         * The greater-than-equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param gte
         *        The greater-than-equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gte(Double gte);

        /**
         * <p>
         * The less-than-equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lte
         *        The less-than-equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Double lte);

        /**
         * <p>
         * The equal-to condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param eq
         *        The equal-to condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Double eq);
    }

    static final class BuilderImpl implements Builder {
        private Double gte;

        private Double lte;

        private Double eq;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberFilter model) {
            gte(model.gte);
            lte(model.lte);
            eq(model.eq);
        }

        public final Double getGte() {
            return gte;
        }

        @Override
        public final Builder gte(Double gte) {
            this.gte = gte;
            return this;
        }

        public final void setGte(Double gte) {
            this.gte = gte;
        }

        public final Double getLte() {
            return lte;
        }

        @Override
        public final Builder lte(Double lte) {
            this.lte = lte;
            return this;
        }

        public final void setLte(Double lte) {
            this.lte = lte;
        }

        public final Double getEq() {
            return eq;
        }

        @Override
        public final Builder eq(Double eq) {
            this.eq = eq;
            return this;
        }

        public final void setEq(Double eq) {
            this.eq = eq;
        }

        @Override
        public NumberFilter build() {
            return new NumberFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
