/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActionTargetsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeActionTargetsResponse.Builder, DescribeActionTargetsResponse> {
    private static final SdkField<List<ActionTarget>> ACTION_TARGETS_FIELD = SdkField
            .<List<ActionTarget>> builder(MarshallingType.LIST)
            .getter(getter(DescribeActionTargetsResponse::actionTargets))
            .setter(setter(Builder::actionTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeActionTargetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TARGETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ActionTarget> actionTargets;

    private final String nextToken;

    private DescribeActionTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.actionTargets = builder.actionTargets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ActionTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActionTargets() {
        return actionTargets != null && !(actionTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
     * <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
     *         <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
     */
    public List<ActionTarget> actionTargets() {
        return actionTargets;
    }

    /**
     * <p>
     * The token that is required for pagination.
     * </p>
     * 
     * @return The token that is required for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTargets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionTargetsResponse)) {
            return false;
        }
        DescribeActionTargetsResponse other = (DescribeActionTargetsResponse) obj;
        return Objects.equals(actionTargets(), other.actionTargets()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeActionTargetsResponse").add("ActionTargets", actionTargets())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionTargets":
            return Optional.ofNullable(clazz.cast(actionTargets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionTargetsResponse, T> g) {
        return obj -> g.apply((DescribeActionTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeActionTargetsResponse> {
        /**
         * <p>
         * A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
         * <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
         * </p>
         * 
         * @param actionTargets
         *        A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
         *        <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTargets(Collection<ActionTarget> actionTargets);

        /**
         * <p>
         * A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
         * <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
         * </p>
         * 
         * @param actionTargets
         *        A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
         *        <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTargets(ActionTarget... actionTargets);

        /**
         * <p>
         * A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>,
         * <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActionTarget>.Builder} avoiding the need to
         * create one manually via {@link List<ActionTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActionTarget>.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTargets(List<ActionTarget>)}.
         * 
         * @param actionTargets
         *        a consumer that will call methods on {@link List<ActionTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTargets(List<ActionTarget>)
         */
        Builder actionTargets(Consumer<ActionTarget.Builder>... actionTargets);

        /**
         * <p>
         * The token that is required for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token that is required for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<ActionTarget> actionTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionTargetsResponse model) {
            super(model);
            actionTargets(model.actionTargets);
            nextToken(model.nextToken);
        }

        public final Collection<ActionTarget.Builder> getActionTargets() {
            return actionTargets != null ? actionTargets.stream().map(ActionTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder actionTargets(Collection<ActionTarget> actionTargets) {
            this.actionTargets = ActionTargetListCopier.copy(actionTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTargets(ActionTarget... actionTargets) {
            actionTargets(Arrays.asList(actionTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTargets(Consumer<ActionTarget.Builder>... actionTargets) {
            actionTargets(Stream.of(actionTargets).map(c -> ActionTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActionTargets(Collection<ActionTarget.BuilderImpl> actionTargets) {
            this.actionTargets = ActionTargetListCopier.copyFromBuilder(actionTargets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeActionTargetsResponse build() {
            return new DescribeActionTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
