/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of attributes that are applied to all active Security Hub-aggregated findings and that result in a
 * subset of findings that are included in this insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSecurityFindingFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSecurityFindingFilters.Builder, AwsSecurityFindingFilters> {
    private static final SdkField<List<StringFilter>> PRODUCT_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::productArn))
            .setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> AWS_ACCOUNT_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> GENERATOR_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::generatorId))
            .setter(setter(Builder::generatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratorId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> FIRST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> LAST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> CREATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> UPDATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> SEVERITY_PRODUCT_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::severityProduct))
            .setter(setter(Builder::severityProduct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityProduct").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> SEVERITY_NORMALIZED_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::severityNormalized))
            .setter(setter(Builder::severityNormalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityNormalized").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> SEVERITY_LABEL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::severityLabel))
            .setter(setter(Builder::severityLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLabel").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> CONFIDENCE_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::confidence))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> CRITICALITY_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::criticality))
            .setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> TITLE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> DESCRIPTION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RECOMMENDATION_TEXT_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::recommendationText))
            .setter(setter(Builder::recommendationText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationText").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> SOURCE_URL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::sourceUrl))
            .setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> PRODUCT_FIELDS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::productFields))
            .setter(setter(Builder::productFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> PRODUCT_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPANY_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::companyName))
            .setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> MALWARE_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::malwareName))
            .setter(setter(Builder::malwareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> MALWARE_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::malwareType))
            .setter(setter(Builder::malwareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> MALWARE_PATH_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::malwarePath))
            .setter(setter(Builder::malwarePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwarePath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> MALWARE_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::malwareState))
            .setter(setter(Builder::malwareState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_DIRECTION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkDirection))
            .setter(setter(Builder::networkDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkDirection").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_PROTOCOL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkProtocol))
            .setter(setter(Builder::networkProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProtocol").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> NETWORK_SOURCE_IP_V4_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkSourceIpV4))
            .setter(setter(Builder::networkSourceIpV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSourceIpV4").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> NETWORK_SOURCE_IP_V6_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkSourceIpV6))
            .setter(setter(Builder::networkSourceIpV6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSourceIpV6").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> NETWORK_SOURCE_PORT_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkSourcePort))
            .setter(setter(Builder::networkSourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSourcePort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_SOURCE_DOMAIN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkSourceDomain))
            .setter(setter(Builder::networkSourceDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSourceDomain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_SOURCE_MAC_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkSourceMac))
            .setter(setter(Builder::networkSourceMac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSourceMac").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> NETWORK_DESTINATION_IP_V4_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkDestinationIpV4))
            .setter(setter(Builder::networkDestinationIpV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkDestinationIpV4").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> NETWORK_DESTINATION_IP_V6_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkDestinationIpV6))
            .setter(setter(Builder::networkDestinationIpV6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkDestinationIpV6").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> NETWORK_DESTINATION_PORT_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkDestinationPort))
            .setter(setter(Builder::networkDestinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkDestinationPort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_DESTINATION_DOMAIN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::networkDestinationDomain))
            .setter(setter(Builder::networkDestinationDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkDestinationDomain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> PROCESS_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processName))
            .setter(setter(Builder::processName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> PROCESS_PATH_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processPath))
            .setter(setter(Builder::processPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> PROCESS_PID_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processPid))
            .setter(setter(Builder::processPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessPid").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> PROCESS_PARENT_PID_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processParentPid))
            .setter(setter(Builder::processParentPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessParentPid").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> PROCESS_LAUNCHED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processLaunchedAt))
            .setter(setter(Builder::processLaunchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessLaunchedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> PROCESS_TERMINATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::processTerminatedAt))
            .setter(setter(Builder::processTerminatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessTerminatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> THREAT_INTEL_INDICATOR_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorType))
            .setter(setter(Builder::threatIntelIndicatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> THREAT_INTEL_INDICATOR_VALUE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorValue))
            .setter(setter(Builder::threatIntelIndicatorValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> THREAT_INTEL_INDICATOR_CATEGORY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorCategory))
            .setter(setter(Builder::threatIntelIndicatorCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorCategory")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> THREAT_INTEL_INDICATOR_LAST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorLastObservedAt))
            .setter(setter(Builder::threatIntelIndicatorLastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorLastObservedAt")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> THREAT_INTEL_INDICATOR_SOURCE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorSource))
            .setter(setter(Builder::threatIntelIndicatorSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorSource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> THREAT_INTEL_INDICATOR_SOURCE_URL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::threatIntelIndicatorSourceUrl))
            .setter(setter(Builder::threatIntelIndicatorSourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicatorSourceUrl")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_PARTITION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourcePartition))
            .setter(setter(Builder::resourcePartition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePartition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_REGION_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> RESOURCE_TAGS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceType))
            .setter(setter(Builder::resourceAwsEc2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_IMAGE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceImageId))
            .setter(setter(Builder::resourceAwsEc2InstanceImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceImageId")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> RESOURCE_AWS_EC2_INSTANCE_IP_V4_ADDRESSES_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceIpV4Addresses))
            .setter(setter(Builder::resourceAwsEc2InstanceIpV4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ResourceAwsEc2InstanceIpV4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpFilter>> RESOURCE_AWS_EC2_INSTANCE_IP_V6_ADDRESSES_FIELD = SdkField
            .<List<IpFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceIpV6Addresses))
            .setter(setter(Builder::resourceAwsEc2InstanceIpV6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ResourceAwsEc2InstanceIpV6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_KEY_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceKeyName))
            .setter(setter(Builder::resourceAwsEc2InstanceKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceKeyName")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceIamInstanceProfileArn))
            .setter(setter(Builder::resourceAwsEc2InstanceIamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ResourceAwsEc2InstanceIamInstanceProfileArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_VPC_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceVpcId))
            .setter(setter(Builder::resourceAwsEc2InstanceVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceVpcId")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_EC2_INSTANCE_SUBNET_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceSubnetId))
            .setter(setter(Builder::resourceAwsEc2InstanceSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceSubnetId")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> RESOURCE_AWS_EC2_INSTANCE_LAUNCHED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsEc2InstanceLaunchedAt))
            .setter(setter(Builder::resourceAwsEc2InstanceLaunchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsEc2InstanceLaunchedAt")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_S3_BUCKET_OWNER_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsS3BucketOwnerId))
            .setter(setter(Builder::resourceAwsS3BucketOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsS3BucketOwnerId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_S3_BUCKET_OWNER_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsS3BucketOwnerName))
            .setter(setter(Builder::resourceAwsS3BucketOwnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsS3BucketOwnerName")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_IAM_ACCESS_KEY_USER_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsIamAccessKeyUserName))
            .setter(setter(Builder::resourceAwsIamAccessKeyUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsIamAccessKeyUserName")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_AWS_IAM_ACCESS_KEY_STATUS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsIamAccessKeyStatus))
            .setter(setter(Builder::resourceAwsIamAccessKeyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsIamAccessKeyStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> RESOURCE_AWS_IAM_ACCESS_KEY_CREATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceAwsIamAccessKeyCreatedAt))
            .setter(setter(Builder::resourceAwsIamAccessKeyCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAwsIamAccessKeyCreatedAt")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_CONTAINER_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceContainerName))
            .setter(setter(Builder::resourceContainerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceContainerName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_CONTAINER_IMAGE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceContainerImageId))
            .setter(setter(Builder::resourceContainerImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceContainerImageId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_CONTAINER_IMAGE_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceContainerImageName))
            .setter(setter(Builder::resourceContainerImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceContainerImageName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> RESOURCE_CONTAINER_LAUNCHED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceContainerLaunchedAt))
            .setter(setter(Builder::resourceContainerLaunchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceContainerLaunchedAt")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> RESOURCE_DETAILS_OTHER_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::resourceDetailsOther))
            .setter(setter(Builder::resourceDetailsOther))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetailsOther").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPLIANCE_STATUS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::complianceStatus))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VERIFICATION_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::verificationState))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> WORKFLOW_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::workflowState))
            .setter(setter(Builder::workflowState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RECORD_STATE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::recordState))
            .setter(setter(Builder::recordState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RELATED_FINDINGS_PRODUCT_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::relatedFindingsProductArn))
            .setter(setter(Builder::relatedFindingsProductArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingsProductArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RELATED_FINDINGS_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::relatedFindingsId))
            .setter(setter(Builder::relatedFindingsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingsId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NOTE_TEXT_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::noteText))
            .setter(setter(Builder::noteText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteText").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> NOTE_UPDATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::noteUpdatedAt))
            .setter(setter(Builder::noteUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteUpdatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NOTE_UPDATED_BY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::noteUpdatedBy))
            .setter(setter(Builder::noteUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteUpdatedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeywordFilter>> KEYWORD_FIELD = SdkField
            .<List<KeywordFilter>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFindingFilters::keyword))
            .setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeywordFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeywordFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD,
            AWS_ACCOUNT_ID_FIELD, ID_FIELD, GENERATOR_ID_FIELD, TYPE_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, SEVERITY_PRODUCT_FIELD, SEVERITY_NORMALIZED_FIELD, SEVERITY_LABEL_FIELD,
            CONFIDENCE_FIELD, CRITICALITY_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, RECOMMENDATION_TEXT_FIELD, SOURCE_URL_FIELD,
            PRODUCT_FIELDS_FIELD, PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, USER_DEFINED_FIELDS_FIELD, MALWARE_NAME_FIELD,
            MALWARE_TYPE_FIELD, MALWARE_PATH_FIELD, MALWARE_STATE_FIELD, NETWORK_DIRECTION_FIELD, NETWORK_PROTOCOL_FIELD,
            NETWORK_SOURCE_IP_V4_FIELD, NETWORK_SOURCE_IP_V6_FIELD, NETWORK_SOURCE_PORT_FIELD, NETWORK_SOURCE_DOMAIN_FIELD,
            NETWORK_SOURCE_MAC_FIELD, NETWORK_DESTINATION_IP_V4_FIELD, NETWORK_DESTINATION_IP_V6_FIELD,
            NETWORK_DESTINATION_PORT_FIELD, NETWORK_DESTINATION_DOMAIN_FIELD, PROCESS_NAME_FIELD, PROCESS_PATH_FIELD,
            PROCESS_PID_FIELD, PROCESS_PARENT_PID_FIELD, PROCESS_LAUNCHED_AT_FIELD, PROCESS_TERMINATED_AT_FIELD,
            THREAT_INTEL_INDICATOR_TYPE_FIELD, THREAT_INTEL_INDICATOR_VALUE_FIELD, THREAT_INTEL_INDICATOR_CATEGORY_FIELD,
            THREAT_INTEL_INDICATOR_LAST_OBSERVED_AT_FIELD, THREAT_INTEL_INDICATOR_SOURCE_FIELD,
            THREAT_INTEL_INDICATOR_SOURCE_URL_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_PARTITION_FIELD,
            RESOURCE_REGION_FIELD, RESOURCE_TAGS_FIELD, RESOURCE_AWS_EC2_INSTANCE_TYPE_FIELD,
            RESOURCE_AWS_EC2_INSTANCE_IMAGE_ID_FIELD, RESOURCE_AWS_EC2_INSTANCE_IP_V4_ADDRESSES_FIELD,
            RESOURCE_AWS_EC2_INSTANCE_IP_V6_ADDRESSES_FIELD, RESOURCE_AWS_EC2_INSTANCE_KEY_NAME_FIELD,
            RESOURCE_AWS_EC2_INSTANCE_IAM_INSTANCE_PROFILE_ARN_FIELD, RESOURCE_AWS_EC2_INSTANCE_VPC_ID_FIELD,
            RESOURCE_AWS_EC2_INSTANCE_SUBNET_ID_FIELD, RESOURCE_AWS_EC2_INSTANCE_LAUNCHED_AT_FIELD,
            RESOURCE_AWS_S3_BUCKET_OWNER_ID_FIELD, RESOURCE_AWS_S3_BUCKET_OWNER_NAME_FIELD,
            RESOURCE_AWS_IAM_ACCESS_KEY_USER_NAME_FIELD, RESOURCE_AWS_IAM_ACCESS_KEY_STATUS_FIELD,
            RESOURCE_AWS_IAM_ACCESS_KEY_CREATED_AT_FIELD, RESOURCE_CONTAINER_NAME_FIELD, RESOURCE_CONTAINER_IMAGE_ID_FIELD,
            RESOURCE_CONTAINER_IMAGE_NAME_FIELD, RESOURCE_CONTAINER_LAUNCHED_AT_FIELD, RESOURCE_DETAILS_OTHER_FIELD,
            COMPLIANCE_STATUS_FIELD, VERIFICATION_STATE_FIELD, WORKFLOW_STATE_FIELD, RECORD_STATE_FIELD,
            RELATED_FINDINGS_PRODUCT_ARN_FIELD, RELATED_FINDINGS_ID_FIELD, NOTE_TEXT_FIELD, NOTE_UPDATED_AT_FIELD,
            NOTE_UPDATED_BY_FIELD, KEYWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> productArn;

    private final List<StringFilter> awsAccountId;

    private final List<StringFilter> id;

    private final List<StringFilter> generatorId;

    private final List<StringFilter> type;

    private final List<DateFilter> firstObservedAt;

    private final List<DateFilter> lastObservedAt;

    private final List<DateFilter> createdAt;

    private final List<DateFilter> updatedAt;

    private final List<NumberFilter> severityProduct;

    private final List<NumberFilter> severityNormalized;

    private final List<StringFilter> severityLabel;

    private final List<NumberFilter> confidence;

    private final List<NumberFilter> criticality;

    private final List<StringFilter> title;

    private final List<StringFilter> description;

    private final List<StringFilter> recommendationText;

    private final List<StringFilter> sourceUrl;

    private final List<MapFilter> productFields;

    private final List<StringFilter> productName;

    private final List<StringFilter> companyName;

    private final List<MapFilter> userDefinedFields;

    private final List<StringFilter> malwareName;

    private final List<StringFilter> malwareType;

    private final List<StringFilter> malwarePath;

    private final List<StringFilter> malwareState;

    private final List<StringFilter> networkDirection;

    private final List<StringFilter> networkProtocol;

    private final List<IpFilter> networkSourceIpV4;

    private final List<IpFilter> networkSourceIpV6;

    private final List<NumberFilter> networkSourcePort;

    private final List<StringFilter> networkSourceDomain;

    private final List<StringFilter> networkSourceMac;

    private final List<IpFilter> networkDestinationIpV4;

    private final List<IpFilter> networkDestinationIpV6;

    private final List<NumberFilter> networkDestinationPort;

    private final List<StringFilter> networkDestinationDomain;

    private final List<StringFilter> processName;

    private final List<StringFilter> processPath;

    private final List<NumberFilter> processPid;

    private final List<NumberFilter> processParentPid;

    private final List<DateFilter> processLaunchedAt;

    private final List<DateFilter> processTerminatedAt;

    private final List<StringFilter> threatIntelIndicatorType;

    private final List<StringFilter> threatIntelIndicatorValue;

    private final List<StringFilter> threatIntelIndicatorCategory;

    private final List<DateFilter> threatIntelIndicatorLastObservedAt;

    private final List<StringFilter> threatIntelIndicatorSource;

    private final List<StringFilter> threatIntelIndicatorSourceUrl;

    private final List<StringFilter> resourceType;

    private final List<StringFilter> resourceId;

    private final List<StringFilter> resourcePartition;

    private final List<StringFilter> resourceRegion;

    private final List<MapFilter> resourceTags;

    private final List<StringFilter> resourceAwsEc2InstanceType;

    private final List<StringFilter> resourceAwsEc2InstanceImageId;

    private final List<IpFilter> resourceAwsEc2InstanceIpV4Addresses;

    private final List<IpFilter> resourceAwsEc2InstanceIpV6Addresses;

    private final List<StringFilter> resourceAwsEc2InstanceKeyName;

    private final List<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn;

    private final List<StringFilter> resourceAwsEc2InstanceVpcId;

    private final List<StringFilter> resourceAwsEc2InstanceSubnetId;

    private final List<DateFilter> resourceAwsEc2InstanceLaunchedAt;

    private final List<StringFilter> resourceAwsS3BucketOwnerId;

    private final List<StringFilter> resourceAwsS3BucketOwnerName;

    private final List<StringFilter> resourceAwsIamAccessKeyUserName;

    private final List<StringFilter> resourceAwsIamAccessKeyStatus;

    private final List<DateFilter> resourceAwsIamAccessKeyCreatedAt;

    private final List<StringFilter> resourceContainerName;

    private final List<StringFilter> resourceContainerImageId;

    private final List<StringFilter> resourceContainerImageName;

    private final List<DateFilter> resourceContainerLaunchedAt;

    private final List<MapFilter> resourceDetailsOther;

    private final List<StringFilter> complianceStatus;

    private final List<StringFilter> verificationState;

    private final List<StringFilter> workflowState;

    private final List<StringFilter> recordState;

    private final List<StringFilter> relatedFindingsProductArn;

    private final List<StringFilter> relatedFindingsId;

    private final List<StringFilter> noteText;

    private final List<DateFilter> noteUpdatedAt;

    private final List<StringFilter> noteUpdatedBy;

    private final List<KeywordFilter> keyword;

    private AwsSecurityFindingFilters(BuilderImpl builder) {
        this.productArn = builder.productArn;
        this.awsAccountId = builder.awsAccountId;
        this.id = builder.id;
        this.generatorId = builder.generatorId;
        this.type = builder.type;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.severityProduct = builder.severityProduct;
        this.severityNormalized = builder.severityNormalized;
        this.severityLabel = builder.severityLabel;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.title = builder.title;
        this.description = builder.description;
        this.recommendationText = builder.recommendationText;
        this.sourceUrl = builder.sourceUrl;
        this.productFields = builder.productFields;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.userDefinedFields = builder.userDefinedFields;
        this.malwareName = builder.malwareName;
        this.malwareType = builder.malwareType;
        this.malwarePath = builder.malwarePath;
        this.malwareState = builder.malwareState;
        this.networkDirection = builder.networkDirection;
        this.networkProtocol = builder.networkProtocol;
        this.networkSourceIpV4 = builder.networkSourceIpV4;
        this.networkSourceIpV6 = builder.networkSourceIpV6;
        this.networkSourcePort = builder.networkSourcePort;
        this.networkSourceDomain = builder.networkSourceDomain;
        this.networkSourceMac = builder.networkSourceMac;
        this.networkDestinationIpV4 = builder.networkDestinationIpV4;
        this.networkDestinationIpV6 = builder.networkDestinationIpV6;
        this.networkDestinationPort = builder.networkDestinationPort;
        this.networkDestinationDomain = builder.networkDestinationDomain;
        this.processName = builder.processName;
        this.processPath = builder.processPath;
        this.processPid = builder.processPid;
        this.processParentPid = builder.processParentPid;
        this.processLaunchedAt = builder.processLaunchedAt;
        this.processTerminatedAt = builder.processTerminatedAt;
        this.threatIntelIndicatorType = builder.threatIntelIndicatorType;
        this.threatIntelIndicatorValue = builder.threatIntelIndicatorValue;
        this.threatIntelIndicatorCategory = builder.threatIntelIndicatorCategory;
        this.threatIntelIndicatorLastObservedAt = builder.threatIntelIndicatorLastObservedAt;
        this.threatIntelIndicatorSource = builder.threatIntelIndicatorSource;
        this.threatIntelIndicatorSourceUrl = builder.threatIntelIndicatorSourceUrl;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourcePartition = builder.resourcePartition;
        this.resourceRegion = builder.resourceRegion;
        this.resourceTags = builder.resourceTags;
        this.resourceAwsEc2InstanceType = builder.resourceAwsEc2InstanceType;
        this.resourceAwsEc2InstanceImageId = builder.resourceAwsEc2InstanceImageId;
        this.resourceAwsEc2InstanceIpV4Addresses = builder.resourceAwsEc2InstanceIpV4Addresses;
        this.resourceAwsEc2InstanceIpV6Addresses = builder.resourceAwsEc2InstanceIpV6Addresses;
        this.resourceAwsEc2InstanceKeyName = builder.resourceAwsEc2InstanceKeyName;
        this.resourceAwsEc2InstanceIamInstanceProfileArn = builder.resourceAwsEc2InstanceIamInstanceProfileArn;
        this.resourceAwsEc2InstanceVpcId = builder.resourceAwsEc2InstanceVpcId;
        this.resourceAwsEc2InstanceSubnetId = builder.resourceAwsEc2InstanceSubnetId;
        this.resourceAwsEc2InstanceLaunchedAt = builder.resourceAwsEc2InstanceLaunchedAt;
        this.resourceAwsS3BucketOwnerId = builder.resourceAwsS3BucketOwnerId;
        this.resourceAwsS3BucketOwnerName = builder.resourceAwsS3BucketOwnerName;
        this.resourceAwsIamAccessKeyUserName = builder.resourceAwsIamAccessKeyUserName;
        this.resourceAwsIamAccessKeyStatus = builder.resourceAwsIamAccessKeyStatus;
        this.resourceAwsIamAccessKeyCreatedAt = builder.resourceAwsIamAccessKeyCreatedAt;
        this.resourceContainerName = builder.resourceContainerName;
        this.resourceContainerImageId = builder.resourceContainerImageId;
        this.resourceContainerImageName = builder.resourceContainerImageName;
        this.resourceContainerLaunchedAt = builder.resourceContainerLaunchedAt;
        this.resourceDetailsOther = builder.resourceDetailsOther;
        this.complianceStatus = builder.complianceStatus;
        this.verificationState = builder.verificationState;
        this.workflowState = builder.workflowState;
        this.recordState = builder.recordState;
        this.relatedFindingsProductArn = builder.relatedFindingsProductArn;
        this.relatedFindingsId = builder.relatedFindingsId;
        this.noteText = builder.noteText;
        this.noteUpdatedAt = builder.noteUpdatedAt;
        this.noteUpdatedBy = builder.noteUpdatedBy;
        this.keyword = builder.keyword;
    }

    /**
     * Returns true if the ProductArn property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductArn() {
        return productArn != null && !(productArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductArn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
     *         provider) after this provider's product (solution that generates findings) is registered with Security
     *         Hub.
     */
    public List<StringFilter> productArn() {
        return productArn;
    }

    /**
     * Returns true if the AwsAccountId property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAwsAccountId() {
        return awsAccountId != null && !(awsAccountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsAccountId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS account ID that a finding is generated in.
     */
    public List<StringFilter> awsAccountId() {
        return awsAccountId;
    }

    /**
     * Returns true if the Id property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasId() {
        return id != null && !(id instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security findings provider-specific identifier for a finding.
     */
    public List<StringFilter> id() {
        return id;
    }

    /**
     * Returns true if the GeneratorId property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGeneratorId() {
        return generatorId != null && !(generatorId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGeneratorId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
     *         In various security-findings providers' solutions, this generator can be called a rule, a check, a
     *         detector, a plug-in, etc.
     */
    public List<StringFilter> generatorId() {
        return generatorId;
    }

    /**
     * Returns true if the Type property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     */
    public List<StringFilter> type() {
        return type;
    }

    /**
     * Returns true if the FirstObservedAt property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFirstObservedAt() {
        return firstObservedAt != null && !(firstObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFirstObservedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *         potential security issue that a finding captured.
     */
    public List<DateFilter> firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * Returns true if the LastObservedAt property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLastObservedAt() {
        return lastObservedAt != null && !(lastObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLastObservedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *         the potential security issue that a finding captured.
     */
    public List<DateFilter> lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * Returns true if the CreatedAt property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCreatedAt() {
        return createdAt != null && !(createdAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreatedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
     *         security issue that a finding captured.
     */
    public List<DateFilter> createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the UpdatedAt property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdatedAt() {
        return updatedAt != null && !(updatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdatedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
     *         finding record.
     */
    public List<DateFilter> updatedAt() {
        return updatedAt;
    }

    /**
     * Returns true if the SeverityProduct property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSeverityProduct() {
        return severityProduct != null && !(severityProduct instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverityProduct()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The native severity as defined by the security-findings provider's solution that generated the finding.
     */
    public List<NumberFilter> severityProduct() {
        return severityProduct;
    }

    /**
     * Returns true if the SeverityNormalized property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSeverityNormalized() {
        return severityNormalized != null && !(severityNormalized instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverityNormalized()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The normalized severity of a finding.
     */
    public List<NumberFilter> severityNormalized() {
        return severityNormalized;
    }

    /**
     * Returns true if the SeverityLabel property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSeverityLabel() {
        return severityLabel != null && !(severityLabel instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSeverityLabel()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The label of a finding's severity.
     */
    public List<StringFilter> severityLabel() {
        return severityLabel;
    }

    /**
     * Returns true if the Confidence property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConfidence() {
        return confidence != null && !(confidence instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfidence()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *         behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *         scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    public List<NumberFilter> confidence() {
        return confidence;
    }

    /**
     * Returns true if the Criticality property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCriticality() {
        return criticality != null && !(criticality instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCriticality()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The level of importance assigned to the resources associated with the finding. A score of 0 means that
     *         the underlying resources have no criticality, and a score of 100 is reserved for the most critical
     *         resources.
     */
    public List<NumberFilter> criticality() {
        return criticality;
    }

    /**
     * Returns true if the Title property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTitle()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A finding's title.
     */
    public List<StringFilter> title() {
        return title;
    }

    /**
     * Returns true if the Description property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDescription() {
        return description != null && !(description instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDescription()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A finding's description.
     */
    public List<StringFilter> description() {
        return description;
    }

    /**
     * Returns true if the RecommendationText property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecommendationText() {
        return recommendationText != null && !(recommendationText instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendationText()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The recommendation of what to do about the issue described in a finding.
     */
    public List<StringFilter> recommendationText() {
        return recommendationText;
    }

    /**
     * Returns true if the SourceUrl property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSourceUrl() {
        return sourceUrl != null && !(sourceUrl instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceUrl()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A URL that links to a page about the current finding in the security-findings provider's solution.
     */
    public List<StringFilter> sourceUrl() {
        return sourceUrl;
    }

    /**
     * Returns true if the ProductFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductFields() {
        return productFields != null && !(productFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A data type where security-findings providers can include additional solution-specific details that
     *         aren't part of the defined <code>AwsSecurityFinding</code> format.
     */
    public List<MapFilter> productFields() {
        return productFields;
    }

    /**
     * Returns true if the ProductName property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductName() {
        return productName != null && !(productName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the solution (product) that generates findings.
     */
    public List<StringFilter> productName() {
        return productName;
    }

    /**
     * Returns true if the CompanyName property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCompanyName() {
        return companyName != null && !(companyName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompanyName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the findings provider (company) that owns the solution (product) that generates findings.
     */
    public List<StringFilter> companyName() {
        return companyName;
    }

    /**
     * Returns true if the UserDefinedFields property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserDefinedFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */
    public List<MapFilter> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * Returns true if the MalwareName property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMalwareName() {
        return malwareName != null && !(malwareName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMalwareName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the malware that was observed.
     */
    public List<StringFilter> malwareName() {
        return malwareName;
    }

    /**
     * Returns true if the MalwareType property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMalwareType() {
        return malwareType != null && !(malwareType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMalwareType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of the malware that was observed.
     */
    public List<StringFilter> malwareType() {
        return malwareType;
    }

    /**
     * Returns true if the MalwarePath property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMalwarePath() {
        return malwarePath != null && !(malwarePath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMalwarePath()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filesystem path of the malware that was observed.
     */
    public List<StringFilter> malwarePath() {
        return malwarePath;
    }

    /**
     * Returns true if the MalwareState property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMalwareState() {
        return malwareState != null && !(malwareState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMalwareState()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The state of the malware that was observed.
     */
    public List<StringFilter> malwareState() {
        return malwareState;
    }

    /**
     * Returns true if the NetworkDirection property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkDirection() {
        return networkDirection != null && !(networkDirection instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkDirection()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates the direction of network traffic associated with a finding.
     */
    public List<StringFilter> networkDirection() {
        return networkDirection;
    }

    /**
     * Returns true if the NetworkProtocol property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkProtocol() {
        return networkProtocol != null && !(networkProtocol instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkProtocol()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The protocol of network-related information about a finding.
     */
    public List<StringFilter> networkProtocol() {
        return networkProtocol;
    }

    /**
     * Returns true if the NetworkSourceIpV4 property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkSourceIpV4() {
        return networkSourceIpV4 != null && !(networkSourceIpV4 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkSourceIpV4()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source IPv4 address of network-related information about a finding.
     */
    public List<IpFilter> networkSourceIpV4() {
        return networkSourceIpV4;
    }

    /**
     * Returns true if the NetworkSourceIpV6 property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkSourceIpV6() {
        return networkSourceIpV6 != null && !(networkSourceIpV6 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkSourceIpV6()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source IPv6 address of network-related information about a finding.
     */
    public List<IpFilter> networkSourceIpV6() {
        return networkSourceIpV6;
    }

    /**
     * Returns true if the NetworkSourcePort property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkSourcePort() {
        return networkSourcePort != null && !(networkSourcePort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkSourcePort()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source port of network-related information about a finding.
     */
    public List<NumberFilter> networkSourcePort() {
        return networkSourcePort;
    }

    /**
     * Returns true if the NetworkSourceDomain property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkSourceDomain() {
        return networkSourceDomain != null && !(networkSourceDomain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkSourceDomain()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source domain of network-related information about a finding.
     */
    public List<StringFilter> networkSourceDomain() {
        return networkSourceDomain;
    }

    /**
     * Returns true if the NetworkSourceMac property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkSourceMac() {
        return networkSourceMac != null && !(networkSourceMac instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkSourceMac()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source media access control (MAC) address of network-related information about a finding.
     */
    public List<StringFilter> networkSourceMac() {
        return networkSourceMac;
    }

    /**
     * Returns true if the NetworkDestinationIpV4 property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkDestinationIpV4() {
        return networkDestinationIpV4 != null && !(networkDestinationIpV4 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkDestinationIpV4()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination IPv4 address of network-related information about a finding.
     */
    public List<IpFilter> networkDestinationIpV4() {
        return networkDestinationIpV4;
    }

    /**
     * Returns true if the NetworkDestinationIpV6 property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkDestinationIpV6() {
        return networkDestinationIpV6 != null && !(networkDestinationIpV6 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkDestinationIpV6()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination IPv6 address of network-related information about a finding.
     */
    public List<IpFilter> networkDestinationIpV6() {
        return networkDestinationIpV6;
    }

    /**
     * Returns true if the NetworkDestinationPort property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkDestinationPort() {
        return networkDestinationPort != null && !(networkDestinationPort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkDestinationPort()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination port of network-related information about a finding.
     */
    public List<NumberFilter> networkDestinationPort() {
        return networkDestinationPort;
    }

    /**
     * Returns true if the NetworkDestinationDomain property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkDestinationDomain() {
        return networkDestinationDomain != null && !(networkDestinationDomain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkDestinationDomain()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination domain of network-related information about a finding.
     */
    public List<StringFilter> networkDestinationDomain() {
        return networkDestinationDomain;
    }

    /**
     * Returns true if the ProcessName property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProcessName() {
        return processName != null && !(processName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the process.
     */
    public List<StringFilter> processName() {
        return processName;
    }

    /**
     * Returns true if the ProcessPath property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProcessPath() {
        return processPath != null && !(processPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessPath()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The path to the process executable.
     */
    public List<StringFilter> processPath() {
        return processPath;
    }

    /**
     * Returns true if the ProcessPid property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProcessPid() {
        return processPid != null && !(processPid instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessPid()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The process ID.
     */
    public List<NumberFilter> processPid() {
        return processPid;
    }

    /**
     * Returns true if the ProcessParentPid property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessParentPid() {
        return processParentPid != null && !(processParentPid instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parent process ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessParentPid()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parent process ID.
     */
    public List<NumberFilter> processParentPid() {
        return processParentPid;
    }

    /**
     * Returns true if the ProcessLaunchedAt property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessLaunchedAt() {
        return processLaunchedAt != null && !(processLaunchedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessLaunchedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The date/time that the process was launched.
     */
    public List<DateFilter> processLaunchedAt() {
        return processLaunchedAt;
    }

    /**
     * Returns true if the ProcessTerminatedAt property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessTerminatedAt() {
        return processTerminatedAt != null && !(processTerminatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessTerminatedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The date/time that the process was terminated.
     */
    public List<DateFilter> processTerminatedAt() {
        return processTerminatedAt;
    }

    /**
     * Returns true if the ThreatIntelIndicatorType property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasThreatIntelIndicatorType() {
        return threatIntelIndicatorType != null && !(threatIntelIndicatorType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of a threat intel indicator.
     */
    public List<StringFilter> threatIntelIndicatorType() {
        return threatIntelIndicatorType;
    }

    /**
     * Returns true if the ThreatIntelIndicatorValue property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasThreatIntelIndicatorValue() {
        return threatIntelIndicatorValue != null && !(threatIntelIndicatorValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorValue()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of a threat intel indicator.
     */
    public List<StringFilter> threatIntelIndicatorValue() {
        return threatIntelIndicatorValue;
    }

    /**
     * Returns true if the ThreatIntelIndicatorCategory property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasThreatIntelIndicatorCategory() {
        return threatIntelIndicatorCategory != null && !(threatIntelIndicatorCategory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorCategory()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The category of a threat intel indicator.
     */
    public List<StringFilter> threatIntelIndicatorCategory() {
        return threatIntelIndicatorCategory;
    }

    /**
     * Returns true if the ThreatIntelIndicatorLastObservedAt property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasThreatIntelIndicatorLastObservedAt() {
        return threatIntelIndicatorLastObservedAt != null
                && !(threatIntelIndicatorLastObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorLastObservedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The date/time of the last observation of a threat intel indicator.
     */
    public List<DateFilter> threatIntelIndicatorLastObservedAt() {
        return threatIntelIndicatorLastObservedAt;
    }

    /**
     * Returns true if the ThreatIntelIndicatorSource property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasThreatIntelIndicatorSource() {
        return threatIntelIndicatorSource != null && !(threatIntelIndicatorSource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source of the threat intel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorSource()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source of the threat intel.
     */
    public List<StringFilter> threatIntelIndicatorSource() {
        return threatIntelIndicatorSource;
    }

    /**
     * Returns true if the ThreatIntelIndicatorSourceUrl property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasThreatIntelIndicatorSourceUrl() {
        return threatIntelIndicatorSourceUrl != null && !(threatIntelIndicatorSourceUrl instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicatorSourceUrl()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The URL for more details from the source of the threat intel.
     */
    public List<StringFilter> threatIntelIndicatorSourceUrl() {
        return threatIntelIndicatorSourceUrl;
    }

    /**
     * Returns true if the ResourceType property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceType() {
        return resourceType != null && !(resourceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the type of the resource that details are provided for.
     */
    public List<StringFilter> resourceType() {
        return resourceType;
    }

    /**
     * Returns true if the ResourceId property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceId() {
        return resourceId != null && !(resourceId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The canonical identifier for the given resource type.
     */
    public List<StringFilter> resourceId() {
        return resourceId;
    }

    /**
     * Returns true if the ResourcePartition property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourcePartition() {
        return resourcePartition != null && !(resourcePartition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourcePartition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The canonical AWS partition name that the Region is assigned to.
     */
    public List<StringFilter> resourcePartition() {
        return resourcePartition;
    }

    /**
     * Returns true if the ResourceRegion property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceRegion() {
        return resourceRegion != null && !(resourceRegion instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceRegion()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The canonical AWS external Region name where this resource is located.
     */
    public List<StringFilter> resourceRegion() {
        return resourceRegion;
    }

    /**
     * Returns true if the ResourceTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS tags associated with a resource at the time the finding was processed.
     */
    public List<MapFilter> resourceTags() {
        return resourceTags;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceType property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceAwsEc2InstanceType() {
        return resourceAwsEc2InstanceType != null && !(resourceAwsEc2InstanceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceType()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance type of the instance.
     */
    public List<StringFilter> resourceAwsEc2InstanceType() {
        return resourceAwsEc2InstanceType;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceImageId property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceImageId() {
        return resourceAwsEc2InstanceImageId != null && !(resourceAwsEc2InstanceImageId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceImageId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) ID of the instance.
     */
    public List<StringFilter> resourceAwsEc2InstanceImageId() {
        return resourceAwsEc2InstanceImageId;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceIpV4Addresses property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceIpV4Addresses() {
        return resourceAwsEc2InstanceIpV4Addresses != null
                && !(resourceAwsEc2InstanceIpV4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceIpV4Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 addresses associated with the instance.
     */
    public List<IpFilter> resourceAwsEc2InstanceIpV4Addresses() {
        return resourceAwsEc2InstanceIpV4Addresses;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceIpV6Addresses property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceIpV6Addresses() {
        return resourceAwsEc2InstanceIpV6Addresses != null
                && !(resourceAwsEc2InstanceIpV6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceIpV6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 addresses associated with the instance.
     */
    public List<IpFilter> resourceAwsEc2InstanceIpV6Addresses() {
        return resourceAwsEc2InstanceIpV6Addresses;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceKeyName property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceKeyName() {
        return resourceAwsEc2InstanceKeyName != null && !(resourceAwsEc2InstanceKeyName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceKeyName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key name associated with the instance.
     */
    public List<StringFilter> resourceAwsEc2InstanceKeyName() {
        return resourceAwsEc2InstanceKeyName;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceIamInstanceProfileArn property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceIamInstanceProfileArn() {
        return resourceAwsEc2InstanceIamInstanceProfileArn != null
                && !(resourceAwsEc2InstanceIamInstanceProfileArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceIamInstanceProfileArn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IAM profile ARN of the instance.
     */
    public List<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn() {
        return resourceAwsEc2InstanceIamInstanceProfileArn;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceVpcId property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceAwsEc2InstanceVpcId() {
        return resourceAwsEc2InstanceVpcId != null && !(resourceAwsEc2InstanceVpcId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceVpcId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier of the VPC that the instance was launched in.
     */
    public List<StringFilter> resourceAwsEc2InstanceVpcId() {
        return resourceAwsEc2InstanceVpcId;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceSubnetId property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceSubnetId() {
        return resourceAwsEc2InstanceSubnetId != null && !(resourceAwsEc2InstanceSubnetId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceSubnetId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier of the subnet that the instance was launched in.
     */
    public List<StringFilter> resourceAwsEc2InstanceSubnetId() {
        return resourceAwsEc2InstanceSubnetId;
    }

    /**
     * Returns true if the ResourceAwsEc2InstanceLaunchedAt property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsEc2InstanceLaunchedAt() {
        return resourceAwsEc2InstanceLaunchedAt != null && !(resourceAwsEc2InstanceLaunchedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsEc2InstanceLaunchedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The date/time the instance was launched.
     */
    public List<DateFilter> resourceAwsEc2InstanceLaunchedAt() {
        return resourceAwsEc2InstanceLaunchedAt;
    }

    /**
     * Returns true if the ResourceAwsS3BucketOwnerId property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceAwsS3BucketOwnerId() {
        return resourceAwsS3BucketOwnerId != null && !(resourceAwsS3BucketOwnerId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsS3BucketOwnerId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The canonical user ID of the owner of the S3 bucket.
     */
    public List<StringFilter> resourceAwsS3BucketOwnerId() {
        return resourceAwsS3BucketOwnerId;
    }

    /**
     * Returns true if the ResourceAwsS3BucketOwnerName property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceAwsS3BucketOwnerName() {
        return resourceAwsS3BucketOwnerName != null && !(resourceAwsS3BucketOwnerName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsS3BucketOwnerName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The display name of the owner of the S3 bucket.
     */
    public List<StringFilter> resourceAwsS3BucketOwnerName() {
        return resourceAwsS3BucketOwnerName;
    }

    /**
     * Returns true if the ResourceAwsIamAccessKeyUserName property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsIamAccessKeyUserName() {
        return resourceAwsIamAccessKeyUserName != null && !(resourceAwsIamAccessKeyUserName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsIamAccessKeyUserName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user associated with the IAM access key related to a finding.
     */
    public List<StringFilter> resourceAwsIamAccessKeyUserName() {
        return resourceAwsIamAccessKeyUserName;
    }

    /**
     * Returns true if the ResourceAwsIamAccessKeyStatus property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsIamAccessKeyStatus() {
        return resourceAwsIamAccessKeyStatus != null && !(resourceAwsIamAccessKeyStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsIamAccessKeyStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     */
    public List<StringFilter> resourceAwsIamAccessKeyStatus() {
        return resourceAwsIamAccessKeyStatus;
    }

    /**
     * Returns true if the ResourceAwsIamAccessKeyCreatedAt property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasResourceAwsIamAccessKeyCreatedAt() {
        return resourceAwsIamAccessKeyCreatedAt != null && !(resourceAwsIamAccessKeyCreatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAwsIamAccessKeyCreatedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The creation date/time of the IAM access key related to a finding.
     */
    public List<DateFilter> resourceAwsIamAccessKeyCreatedAt() {
        return resourceAwsIamAccessKeyCreatedAt;
    }

    /**
     * Returns true if the ResourceContainerName property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceContainerName() {
        return resourceContainerName != null && !(resourceContainerName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceContainerName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the container related to a finding.
     */
    public List<StringFilter> resourceContainerName() {
        return resourceContainerName;
    }

    /**
     * Returns true if the ResourceContainerImageId property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceContainerImageId() {
        return resourceContainerImageId != null && !(resourceContainerImageId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceContainerImageId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier of the image related to a finding.
     */
    public List<StringFilter> resourceContainerImageId() {
        return resourceContainerImageId;
    }

    /**
     * Returns true if the ResourceContainerImageName property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceContainerImageName() {
        return resourceContainerImageName != null && !(resourceContainerImageName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceContainerImageName()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the image related to a finding.
     */
    public List<StringFilter> resourceContainerImageName() {
        return resourceContainerImageName;
    }

    /**
     * Returns true if the ResourceContainerLaunchedAt property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasResourceContainerLaunchedAt() {
        return resourceContainerLaunchedAt != null && !(resourceContainerLaunchedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceContainerLaunchedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The date/time that the container was started.
     */
    public List<DateFilter> resourceContainerLaunchedAt() {
        return resourceContainerLaunchedAt;
    }

    /**
     * Returns true if the ResourceDetailsOther property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceDetailsOther() {
        return resourceDetailsOther != null && !(resourceDetailsOther instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceDetailsOther()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of a resource that doesn't have a specific subfield for the resource type defined.
     */
    public List<MapFilter> resourceDetailsOther() {
        return resourceDetailsOther;
    }

    /**
     * Returns true if the ComplianceStatus property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasComplianceStatus() {
        return complianceStatus != null && !(complianceStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComplianceStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Exclusive to findings that are generated as the result of a check run against a specific rule in a
     *         supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     */
    public List<StringFilter> complianceStatus() {
        return complianceStatus;
    }

    /**
     * Returns true if the VerificationState property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVerificationState() {
        return verificationState != null && !(verificationState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The veracity of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVerificationState()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The veracity of a finding.
     */
    public List<StringFilter> verificationState() {
        return verificationState;
    }

    /**
     * Returns true if the WorkflowState property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWorkflowState() {
        return workflowState != null && !(workflowState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkflowState()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The workflow state of a finding.
     */
    public List<StringFilter> workflowState() {
        return workflowState;
    }

    /**
     * Returns true if the RecordState property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecordState() {
        return recordState != null && !(recordState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecordState()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The updated record state for the finding.
     */
    public List<StringFilter> recordState() {
        return recordState;
    }

    /**
     * Returns true if the RelatedFindingsProductArn property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelatedFindingsProductArn() {
        return relatedFindingsProductArn != null && !(relatedFindingsProductArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedFindingsProductArn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARN of the solution that generated a related finding.
     */
    public List<StringFilter> relatedFindingsProductArn() {
        return relatedFindingsProductArn;
    }

    /**
     * Returns true if the RelatedFindingsId property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelatedFindingsId() {
        return relatedFindingsId != null && !(relatedFindingsId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedFindingsId()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The solution-generated identifier for a related finding.
     */
    public List<StringFilter> relatedFindingsId() {
        return relatedFindingsId;
    }

    /**
     * Returns true if the NoteText property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNoteText() {
        return noteText != null && !(noteText instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The text of a note.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNoteText()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The text of a note.
     */
    public List<StringFilter> noteText() {
        return noteText;
    }

    /**
     * Returns true if the NoteUpdatedAt property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNoteUpdatedAt() {
        return noteUpdatedAt != null && !(noteUpdatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNoteUpdatedAt()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The timestamp of when the note was updated.
     */
    public List<DateFilter> noteUpdatedAt() {
        return noteUpdatedAt;
    }

    /**
     * Returns true if the NoteUpdatedBy property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNoteUpdatedBy() {
        return noteUpdatedBy != null && !(noteUpdatedBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNoteUpdatedBy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The principal that created a note.
     */
    public List<StringFilter> noteUpdatedBy() {
        return noteUpdatedBy;
    }

    /**
     * Returns true if the Keyword property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyword() {
        return keyword != null && !(keyword instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A keyword for a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyword()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A keyword for a finding.
     */
    public List<KeywordFilter> keyword() {
        return keyword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(generatorId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(severityProduct());
        hashCode = 31 * hashCode + Objects.hashCode(severityNormalized());
        hashCode = 31 * hashCode + Objects.hashCode(severityLabel());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationText());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(productFields());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(userDefinedFields());
        hashCode = 31 * hashCode + Objects.hashCode(malwareName());
        hashCode = 31 * hashCode + Objects.hashCode(malwareType());
        hashCode = 31 * hashCode + Objects.hashCode(malwarePath());
        hashCode = 31 * hashCode + Objects.hashCode(malwareState());
        hashCode = 31 * hashCode + Objects.hashCode(networkDirection());
        hashCode = 31 * hashCode + Objects.hashCode(networkProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(networkSourceIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(networkSourceIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(networkSourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(networkSourceDomain());
        hashCode = 31 * hashCode + Objects.hashCode(networkSourceMac());
        hashCode = 31 * hashCode + Objects.hashCode(networkDestinationIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(networkDestinationIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(networkDestinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(networkDestinationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(processName());
        hashCode = 31 * hashCode + Objects.hashCode(processPath());
        hashCode = 31 * hashCode + Objects.hashCode(processPid());
        hashCode = 31 * hashCode + Objects.hashCode(processParentPid());
        hashCode = 31 * hashCode + Objects.hashCode(processLaunchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(processTerminatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorType());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorValue());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorCategory());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorLastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorSource());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicatorSourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePartition());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceIpV4Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceIpV6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceIamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsEc2InstanceLaunchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsS3BucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsS3BucketOwnerName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsIamAccessKeyUserName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsIamAccessKeyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAwsIamAccessKeyCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceContainerName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceContainerImageId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceContainerImageName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceContainerLaunchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetailsOther());
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(verificationState());
        hashCode = 31 * hashCode + Objects.hashCode(workflowState());
        hashCode = 31 * hashCode + Objects.hashCode(recordState());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindingsProductArn());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindingsId());
        hashCode = 31 * hashCode + Objects.hashCode(noteText());
        hashCode = 31 * hashCode + Objects.hashCode(noteUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(noteUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecurityFindingFilters)) {
            return false;
        }
        AwsSecurityFindingFilters other = (AwsSecurityFindingFilters) obj;
        return Objects.equals(productArn(), other.productArn())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(id(), other.id())
                && Objects.equals(generatorId(), other.generatorId())
                && Objects.equals(type(), other.type())
                && Objects.equals(firstObservedAt(), other.firstObservedAt())
                && Objects.equals(lastObservedAt(), other.lastObservedAt())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(severityProduct(), other.severityProduct())
                && Objects.equals(severityNormalized(), other.severityNormalized())
                && Objects.equals(severityLabel(), other.severityLabel())
                && Objects.equals(confidence(), other.confidence())
                && Objects.equals(criticality(), other.criticality())
                && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description())
                && Objects.equals(recommendationText(), other.recommendationText())
                && Objects.equals(sourceUrl(), other.sourceUrl())
                && Objects.equals(productFields(), other.productFields())
                && Objects.equals(productName(), other.productName())
                && Objects.equals(companyName(), other.companyName())
                && Objects.equals(userDefinedFields(), other.userDefinedFields())
                && Objects.equals(malwareName(), other.malwareName())
                && Objects.equals(malwareType(), other.malwareType())
                && Objects.equals(malwarePath(), other.malwarePath())
                && Objects.equals(malwareState(), other.malwareState())
                && Objects.equals(networkDirection(), other.networkDirection())
                && Objects.equals(networkProtocol(), other.networkProtocol())
                && Objects.equals(networkSourceIpV4(), other.networkSourceIpV4())
                && Objects.equals(networkSourceIpV6(), other.networkSourceIpV6())
                && Objects.equals(networkSourcePort(), other.networkSourcePort())
                && Objects.equals(networkSourceDomain(), other.networkSourceDomain())
                && Objects.equals(networkSourceMac(), other.networkSourceMac())
                && Objects.equals(networkDestinationIpV4(), other.networkDestinationIpV4())
                && Objects.equals(networkDestinationIpV6(), other.networkDestinationIpV6())
                && Objects.equals(networkDestinationPort(), other.networkDestinationPort())
                && Objects.equals(networkDestinationDomain(), other.networkDestinationDomain())
                && Objects.equals(processName(), other.processName())
                && Objects.equals(processPath(), other.processPath())
                && Objects.equals(processPid(), other.processPid())
                && Objects.equals(processParentPid(), other.processParentPid())
                && Objects.equals(processLaunchedAt(), other.processLaunchedAt())
                && Objects.equals(processTerminatedAt(), other.processTerminatedAt())
                && Objects.equals(threatIntelIndicatorType(), other.threatIntelIndicatorType())
                && Objects.equals(threatIntelIndicatorValue(), other.threatIntelIndicatorValue())
                && Objects.equals(threatIntelIndicatorCategory(), other.threatIntelIndicatorCategory())
                && Objects.equals(threatIntelIndicatorLastObservedAt(), other.threatIntelIndicatorLastObservedAt())
                && Objects.equals(threatIntelIndicatorSource(), other.threatIntelIndicatorSource())
                && Objects.equals(threatIntelIndicatorSourceUrl(), other.threatIntelIndicatorSourceUrl())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourcePartition(), other.resourcePartition())
                && Objects.equals(resourceRegion(), other.resourceRegion())
                && Objects.equals(resourceTags(), other.resourceTags())
                && Objects.equals(resourceAwsEc2InstanceType(), other.resourceAwsEc2InstanceType())
                && Objects.equals(resourceAwsEc2InstanceImageId(), other.resourceAwsEc2InstanceImageId())
                && Objects.equals(resourceAwsEc2InstanceIpV4Addresses(), other.resourceAwsEc2InstanceIpV4Addresses())
                && Objects.equals(resourceAwsEc2InstanceIpV6Addresses(), other.resourceAwsEc2InstanceIpV6Addresses())
                && Objects.equals(resourceAwsEc2InstanceKeyName(), other.resourceAwsEc2InstanceKeyName())
                && Objects.equals(resourceAwsEc2InstanceIamInstanceProfileArn(),
                        other.resourceAwsEc2InstanceIamInstanceProfileArn())
                && Objects.equals(resourceAwsEc2InstanceVpcId(), other.resourceAwsEc2InstanceVpcId())
                && Objects.equals(resourceAwsEc2InstanceSubnetId(), other.resourceAwsEc2InstanceSubnetId())
                && Objects.equals(resourceAwsEc2InstanceLaunchedAt(), other.resourceAwsEc2InstanceLaunchedAt())
                && Objects.equals(resourceAwsS3BucketOwnerId(), other.resourceAwsS3BucketOwnerId())
                && Objects.equals(resourceAwsS3BucketOwnerName(), other.resourceAwsS3BucketOwnerName())
                && Objects.equals(resourceAwsIamAccessKeyUserName(), other.resourceAwsIamAccessKeyUserName())
                && Objects.equals(resourceAwsIamAccessKeyStatus(), other.resourceAwsIamAccessKeyStatus())
                && Objects.equals(resourceAwsIamAccessKeyCreatedAt(), other.resourceAwsIamAccessKeyCreatedAt())
                && Objects.equals(resourceContainerName(), other.resourceContainerName())
                && Objects.equals(resourceContainerImageId(), other.resourceContainerImageId())
                && Objects.equals(resourceContainerImageName(), other.resourceContainerImageName())
                && Objects.equals(resourceContainerLaunchedAt(), other.resourceContainerLaunchedAt())
                && Objects.equals(resourceDetailsOther(), other.resourceDetailsOther())
                && Objects.equals(complianceStatus(), other.complianceStatus())
                && Objects.equals(verificationState(), other.verificationState())
                && Objects.equals(workflowState(), other.workflowState()) && Objects.equals(recordState(), other.recordState())
                && Objects.equals(relatedFindingsProductArn(), other.relatedFindingsProductArn())
                && Objects.equals(relatedFindingsId(), other.relatedFindingsId()) && Objects.equals(noteText(), other.noteText())
                && Objects.equals(noteUpdatedAt(), other.noteUpdatedAt())
                && Objects.equals(noteUpdatedBy(), other.noteUpdatedBy()) && Objects.equals(keyword(), other.keyword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsSecurityFindingFilters").add("ProductArn", productArn()).add("AwsAccountId", awsAccountId())
                .add("Id", id()).add("GeneratorId", generatorId()).add("Type", type()).add("FirstObservedAt", firstObservedAt())
                .add("LastObservedAt", lastObservedAt()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("SeverityProduct", severityProduct()).add("SeverityNormalized", severityNormalized())
                .add("SeverityLabel", severityLabel()).add("Confidence", confidence()).add("Criticality", criticality())
                .add("Title", title()).add("Description", description()).add("RecommendationText", recommendationText())
                .add("SourceUrl", sourceUrl()).add("ProductFields", productFields()).add("ProductName", productName())
                .add("CompanyName", companyName()).add("UserDefinedFields", userDefinedFields())
                .add("MalwareName", malwareName()).add("MalwareType", malwareType()).add("MalwarePath", malwarePath())
                .add("MalwareState", malwareState()).add("NetworkDirection", networkDirection())
                .add("NetworkProtocol", networkProtocol()).add("NetworkSourceIpV4", networkSourceIpV4())
                .add("NetworkSourceIpV6", networkSourceIpV6()).add("NetworkSourcePort", networkSourcePort())
                .add("NetworkSourceDomain", networkSourceDomain()).add("NetworkSourceMac", networkSourceMac())
                .add("NetworkDestinationIpV4", networkDestinationIpV4()).add("NetworkDestinationIpV6", networkDestinationIpV6())
                .add("NetworkDestinationPort", networkDestinationPort())
                .add("NetworkDestinationDomain", networkDestinationDomain()).add("ProcessName", processName())
                .add("ProcessPath", processPath()).add("ProcessPid", processPid()).add("ProcessParentPid", processParentPid())
                .add("ProcessLaunchedAt", processLaunchedAt()).add("ProcessTerminatedAt", processTerminatedAt())
                .add("ThreatIntelIndicatorType", threatIntelIndicatorType())
                .add("ThreatIntelIndicatorValue", threatIntelIndicatorValue())
                .add("ThreatIntelIndicatorCategory", threatIntelIndicatorCategory())
                .add("ThreatIntelIndicatorLastObservedAt", threatIntelIndicatorLastObservedAt())
                .add("ThreatIntelIndicatorSource", threatIntelIndicatorSource())
                .add("ThreatIntelIndicatorSourceUrl", threatIntelIndicatorSourceUrl()).add("ResourceType", resourceType())
                .add("ResourceId", resourceId()).add("ResourcePartition", resourcePartition())
                .add("ResourceRegion", resourceRegion()).add("ResourceTags", resourceTags())
                .add("ResourceAwsEc2InstanceType", resourceAwsEc2InstanceType())
                .add("ResourceAwsEc2InstanceImageId", resourceAwsEc2InstanceImageId())
                .add("ResourceAwsEc2InstanceIpV4Addresses", resourceAwsEc2InstanceIpV4Addresses())
                .add("ResourceAwsEc2InstanceIpV6Addresses", resourceAwsEc2InstanceIpV6Addresses())
                .add("ResourceAwsEc2InstanceKeyName", resourceAwsEc2InstanceKeyName())
                .add("ResourceAwsEc2InstanceIamInstanceProfileArn", resourceAwsEc2InstanceIamInstanceProfileArn())
                .add("ResourceAwsEc2InstanceVpcId", resourceAwsEc2InstanceVpcId())
                .add("ResourceAwsEc2InstanceSubnetId", resourceAwsEc2InstanceSubnetId())
                .add("ResourceAwsEc2InstanceLaunchedAt", resourceAwsEc2InstanceLaunchedAt())
                .add("ResourceAwsS3BucketOwnerId", resourceAwsS3BucketOwnerId())
                .add("ResourceAwsS3BucketOwnerName", resourceAwsS3BucketOwnerName())
                .add("ResourceAwsIamAccessKeyUserName", resourceAwsIamAccessKeyUserName())
                .add("ResourceAwsIamAccessKeyStatus", resourceAwsIamAccessKeyStatus())
                .add("ResourceAwsIamAccessKeyCreatedAt", resourceAwsIamAccessKeyCreatedAt())
                .add("ResourceContainerName", resourceContainerName())
                .add("ResourceContainerImageId", resourceContainerImageId())
                .add("ResourceContainerImageName", resourceContainerImageName())
                .add("ResourceContainerLaunchedAt", resourceContainerLaunchedAt())
                .add("ResourceDetailsOther", resourceDetailsOther()).add("ComplianceStatus", complianceStatus())
                .add("VerificationState", verificationState()).add("WorkflowState", workflowState())
                .add("RecordState", recordState()).add("RelatedFindingsProductArn", relatedFindingsProductArn())
                .add("RelatedFindingsId", relatedFindingsId()).add("NoteText", noteText()).add("NoteUpdatedAt", noteUpdatedAt())
                .add("NoteUpdatedBy", noteUpdatedBy()).add("Keyword", keyword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "GeneratorId":
            return Optional.ofNullable(clazz.cast(generatorId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "FirstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "LastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "SeverityProduct":
            return Optional.ofNullable(clazz.cast(severityProduct()));
        case "SeverityNormalized":
            return Optional.ofNullable(clazz.cast(severityNormalized()));
        case "SeverityLabel":
            return Optional.ofNullable(clazz.cast(severityLabel()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RecommendationText":
            return Optional.ofNullable(clazz.cast(recommendationText()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "ProductFields":
            return Optional.ofNullable(clazz.cast(productFields()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "MalwareName":
            return Optional.ofNullable(clazz.cast(malwareName()));
        case "MalwareType":
            return Optional.ofNullable(clazz.cast(malwareType()));
        case "MalwarePath":
            return Optional.ofNullable(clazz.cast(malwarePath()));
        case "MalwareState":
            return Optional.ofNullable(clazz.cast(malwareState()));
        case "NetworkDirection":
            return Optional.ofNullable(clazz.cast(networkDirection()));
        case "NetworkProtocol":
            return Optional.ofNullable(clazz.cast(networkProtocol()));
        case "NetworkSourceIpV4":
            return Optional.ofNullable(clazz.cast(networkSourceIpV4()));
        case "NetworkSourceIpV6":
            return Optional.ofNullable(clazz.cast(networkSourceIpV6()));
        case "NetworkSourcePort":
            return Optional.ofNullable(clazz.cast(networkSourcePort()));
        case "NetworkSourceDomain":
            return Optional.ofNullable(clazz.cast(networkSourceDomain()));
        case "NetworkSourceMac":
            return Optional.ofNullable(clazz.cast(networkSourceMac()));
        case "NetworkDestinationIpV4":
            return Optional.ofNullable(clazz.cast(networkDestinationIpV4()));
        case "NetworkDestinationIpV6":
            return Optional.ofNullable(clazz.cast(networkDestinationIpV6()));
        case "NetworkDestinationPort":
            return Optional.ofNullable(clazz.cast(networkDestinationPort()));
        case "NetworkDestinationDomain":
            return Optional.ofNullable(clazz.cast(networkDestinationDomain()));
        case "ProcessName":
            return Optional.ofNullable(clazz.cast(processName()));
        case "ProcessPath":
            return Optional.ofNullable(clazz.cast(processPath()));
        case "ProcessPid":
            return Optional.ofNullable(clazz.cast(processPid()));
        case "ProcessParentPid":
            return Optional.ofNullable(clazz.cast(processParentPid()));
        case "ProcessLaunchedAt":
            return Optional.ofNullable(clazz.cast(processLaunchedAt()));
        case "ProcessTerminatedAt":
            return Optional.ofNullable(clazz.cast(processTerminatedAt()));
        case "ThreatIntelIndicatorType":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorType()));
        case "ThreatIntelIndicatorValue":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorValue()));
        case "ThreatIntelIndicatorCategory":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorCategory()));
        case "ThreatIntelIndicatorLastObservedAt":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorLastObservedAt()));
        case "ThreatIntelIndicatorSource":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorSource()));
        case "ThreatIntelIndicatorSourceUrl":
            return Optional.ofNullable(clazz.cast(threatIntelIndicatorSourceUrl()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourcePartition":
            return Optional.ofNullable(clazz.cast(resourcePartition()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "ResourceAwsEc2InstanceType":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceType()));
        case "ResourceAwsEc2InstanceImageId":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceImageId()));
        case "ResourceAwsEc2InstanceIpV4Addresses":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceIpV4Addresses()));
        case "ResourceAwsEc2InstanceIpV6Addresses":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceIpV6Addresses()));
        case "ResourceAwsEc2InstanceKeyName":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceKeyName()));
        case "ResourceAwsEc2InstanceIamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceIamInstanceProfileArn()));
        case "ResourceAwsEc2InstanceVpcId":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceVpcId()));
        case "ResourceAwsEc2InstanceSubnetId":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceSubnetId()));
        case "ResourceAwsEc2InstanceLaunchedAt":
            return Optional.ofNullable(clazz.cast(resourceAwsEc2InstanceLaunchedAt()));
        case "ResourceAwsS3BucketOwnerId":
            return Optional.ofNullable(clazz.cast(resourceAwsS3BucketOwnerId()));
        case "ResourceAwsS3BucketOwnerName":
            return Optional.ofNullable(clazz.cast(resourceAwsS3BucketOwnerName()));
        case "ResourceAwsIamAccessKeyUserName":
            return Optional.ofNullable(clazz.cast(resourceAwsIamAccessKeyUserName()));
        case "ResourceAwsIamAccessKeyStatus":
            return Optional.ofNullable(clazz.cast(resourceAwsIamAccessKeyStatus()));
        case "ResourceAwsIamAccessKeyCreatedAt":
            return Optional.ofNullable(clazz.cast(resourceAwsIamAccessKeyCreatedAt()));
        case "ResourceContainerName":
            return Optional.ofNullable(clazz.cast(resourceContainerName()));
        case "ResourceContainerImageId":
            return Optional.ofNullable(clazz.cast(resourceContainerImageId()));
        case "ResourceContainerImageName":
            return Optional.ofNullable(clazz.cast(resourceContainerImageName()));
        case "ResourceContainerLaunchedAt":
            return Optional.ofNullable(clazz.cast(resourceContainerLaunchedAt()));
        case "ResourceDetailsOther":
            return Optional.ofNullable(clazz.cast(resourceDetailsOther()));
        case "ComplianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatus()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationState()));
        case "WorkflowState":
            return Optional.ofNullable(clazz.cast(workflowState()));
        case "RecordState":
            return Optional.ofNullable(clazz.cast(recordState()));
        case "RelatedFindingsProductArn":
            return Optional.ofNullable(clazz.cast(relatedFindingsProductArn()));
        case "RelatedFindingsId":
            return Optional.ofNullable(clazz.cast(relatedFindingsId()));
        case "NoteText":
            return Optional.ofNullable(clazz.cast(noteText()));
        case "NoteUpdatedAt":
            return Optional.ofNullable(clazz.cast(noteUpdatedAt()));
        case "NoteUpdatedBy":
            return Optional.ofNullable(clazz.cast(noteUpdatedBy()));
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSecurityFindingFilters, T> g) {
        return obj -> g.apply((AwsSecurityFindingFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSecurityFindingFilters> {
        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
         * after this provider's product (solution that generates findings) is registered with Security Hub.
         * </p>
         * 
         * @param productArn
         *        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
         *        provider) after this provider's product (solution that generates findings) is registered with Security
         *        Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(Collection<StringFilter> productArn);

        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
         * after this provider's product (solution that generates findings) is registered with Security Hub.
         * </p>
         * 
         * @param productArn
         *        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
         *        provider) after this provider's product (solution that generates findings) is registered with Security
         *        Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(StringFilter... productArn);

        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
         * after this provider's product (solution that generates findings) is registered with Security Hub.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #productArn(List<StringFilter>)}.
         * 
         * @param productArn
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productArn(List<StringFilter>)
         */
        Builder productArn(Consumer<StringFilter.Builder>... productArn);

        /**
         * <p>
         * The AWS account ID that a finding is generated in.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID that a finding is generated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(Collection<StringFilter> awsAccountId);

        /**
         * <p>
         * The AWS account ID that a finding is generated in.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID that a finding is generated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(StringFilter... awsAccountId);

        /**
         * <p>
         * The AWS account ID that a finding is generated in.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #awsAccountId(List<StringFilter>)}.
         * 
         * @param awsAccountId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccountId(List<StringFilter>)
         */
        Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId);

        /**
         * <p>
         * The security findings provider-specific identifier for a finding.
         * </p>
         * 
         * @param id
         *        The security findings provider-specific identifier for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Collection<StringFilter> id);

        /**
         * <p>
         * The security findings provider-specific identifier for a finding.
         * </p>
         * 
         * @param id
         *        The security findings provider-specific identifier for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(StringFilter... id);

        /**
         * <p>
         * The security findings provider-specific identifier for a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #id(List<StringFilter>)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(List<StringFilter>)
         */
        Builder id(Consumer<StringFilter.Builder>... id);

        /**
         * <p>
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
         * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
         * plug-in, etc.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component (a discrete unit of logic) that generated a
         *        finding. In various security-findings providers' solutions, this generator can be called a rule, a
         *        check, a detector, a plug-in, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(Collection<StringFilter> generatorId);

        /**
         * <p>
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
         * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
         * plug-in, etc.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component (a discrete unit of logic) that generated a
         *        finding. In various security-findings providers' solutions, this generator can be called a rule, a
         *        check, a detector, a plug-in, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(StringFilter... generatorId);

        /**
         * <p>
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
         * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
         * plug-in, etc.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #generatorId(List<StringFilter>)}.
         * 
         * @param generatorId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatorId(List<StringFilter>)
         */
        Builder generatorId(Consumer<StringFilter.Builder>... generatorId);

        /**
         * <p>
         * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * </p>
         * 
         * @param type
         *        A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<StringFilter> type);

        /**
         * <p>
         * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * </p>
         * 
         * @param type
         *        A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(StringFilter... type);

        /**
         * <p>
         * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #type(List<StringFilter>)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(List<StringFilter>)
         */
        Builder type(Consumer<StringFilter.Builder>... type);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param firstObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Collection<DateFilter> firstObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param firstObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(DateFilter... firstObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         * potential security issue that a finding captured.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #firstObservedAt(List<DateFilter>)}.
         * 
         * @param firstObservedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstObservedAt(List<DateFilter>)
         */
        Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param lastObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently
         *        observed the potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(Collection<DateFilter> lastObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param lastObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently
         *        observed the potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(DateFilter... lastObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
         * potential security issue that a finding captured.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #lastObservedAt(List<DateFilter>)}.
         * 
         * @param lastObservedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastObservedAt(List<DateFilter>)
         */
        Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
         * security issue that a finding captured.
         * </p>
         * 
         * @param createdAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider captured the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Collection<DateFilter> createdAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
         * security issue that a finding captured.
         * </p>
         * 
         * @param createdAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider captured the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(DateFilter... createdAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
         * security issue that a finding captured.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #createdAt(List<DateFilter>)}.
         * 
         * @param createdAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdAt(List<DateFilter>)
         */
        Builder createdAt(Consumer<DateFilter.Builder>... createdAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
         * record.
         * </p>
         * 
         * @param updatedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
         *        finding record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Collection<DateFilter> updatedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
         * record.
         * </p>
         * 
         * @param updatedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
         *        finding record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(DateFilter... updatedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
         * record.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #updatedAt(List<DateFilter>)}.
         * 
         * @param updatedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatedAt(List<DateFilter>)
         */
        Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt);

        /**
         * <p>
         * The native severity as defined by the security-findings provider's solution that generated the finding.
         * </p>
         * 
         * @param severityProduct
         *        The native severity as defined by the security-findings provider's solution that generated the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityProduct(Collection<NumberFilter> severityProduct);

        /**
         * <p>
         * The native severity as defined by the security-findings provider's solution that generated the finding.
         * </p>
         * 
         * @param severityProduct
         *        The native severity as defined by the security-findings provider's solution that generated the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityProduct(NumberFilter... severityProduct);

        /**
         * <p>
         * The native severity as defined by the security-findings provider's solution that generated the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #severityProduct(List<NumberFilter>)}.
         * 
         * @param severityProduct
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityProduct(List<NumberFilter>)
         */
        Builder severityProduct(Consumer<NumberFilter.Builder>... severityProduct);

        /**
         * <p>
         * The normalized severity of a finding.
         * </p>
         * 
         * @param severityNormalized
         *        The normalized severity of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityNormalized(Collection<NumberFilter> severityNormalized);

        /**
         * <p>
         * The normalized severity of a finding.
         * </p>
         * 
         * @param severityNormalized
         *        The normalized severity of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityNormalized(NumberFilter... severityNormalized);

        /**
         * <p>
         * The normalized severity of a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #severityNormalized(List<NumberFilter>)}.
         * 
         * @param severityNormalized
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityNormalized(List<NumberFilter>)
         */
        Builder severityNormalized(Consumer<NumberFilter.Builder>... severityNormalized);

        /**
         * <p>
         * The label of a finding's severity.
         * </p>
         * 
         * @param severityLabel
         *        The label of a finding's severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLabel(Collection<StringFilter> severityLabel);

        /**
         * <p>
         * The label of a finding's severity.
         * </p>
         * 
         * @param severityLabel
         *        The label of a finding's severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLabel(StringFilter... severityLabel);

        /**
         * <p>
         * The label of a finding's severity.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #severityLabel(List<StringFilter>)}.
         * 
         * @param severityLabel
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityLabel(List<StringFilter>)
         */
        Builder severityLabel(Consumer<StringFilter.Builder>... severityLabel);

        /**
         * <p>
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
         * behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
         * scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * </p>
         * 
         * @param confidence
         *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies
         *        the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a
         *        ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Collection<NumberFilter> confidence);

        /**
         * <p>
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
         * behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
         * scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * </p>
         * 
         * @param confidence
         *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies
         *        the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a
         *        ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(NumberFilter... confidence);

        /**
         * <p>
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
         * behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
         * scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #confidence(List<NumberFilter>)}.
         * 
         * @param confidence
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confidence(List<NumberFilter>)
         */
        Builder confidence(Consumer<NumberFilter.Builder>... confidence);

        /**
         * <p>
         * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
         * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * </p>
         * 
         * @param criticality
         *        The level of importance assigned to the resources associated with the finding. A score of 0 means that
         *        the underlying resources have no criticality, and a score of 100 is reserved for the most critical
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Collection<NumberFilter> criticality);

        /**
         * <p>
         * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
         * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * </p>
         * 
         * @param criticality
         *        The level of importance assigned to the resources associated with the finding. A score of 0 means that
         *        the underlying resources have no criticality, and a score of 100 is reserved for the most critical
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(NumberFilter... criticality);

        /**
         * <p>
         * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
         * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #criticality(List<NumberFilter>)}.
         * 
         * @param criticality
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criticality(List<NumberFilter>)
         */
        Builder criticality(Consumer<NumberFilter.Builder>... criticality);

        /**
         * <p>
         * A finding's title.
         * </p>
         * 
         * @param title
         *        A finding's title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<StringFilter> title);

        /**
         * <p>
         * A finding's title.
         * </p>
         * 
         * @param title
         *        A finding's title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(StringFilter... title);

        /**
         * <p>
         * A finding's title.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #title(List<StringFilter>)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(List<StringFilter>)
         */
        Builder title(Consumer<StringFilter.Builder>... title);

        /**
         * <p>
         * A finding's description.
         * </p>
         * 
         * @param description
         *        A finding's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(Collection<StringFilter> description);

        /**
         * <p>
         * A finding's description.
         * </p>
         * 
         * @param description
         *        A finding's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(StringFilter... description);

        /**
         * <p>
         * A finding's description.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #description(List<StringFilter>)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(List<StringFilter>)
         */
        Builder description(Consumer<StringFilter.Builder>... description);

        /**
         * <p>
         * The recommendation of what to do about the issue described in a finding.
         * </p>
         * 
         * @param recommendationText
         *        The recommendation of what to do about the issue described in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationText(Collection<StringFilter> recommendationText);

        /**
         * <p>
         * The recommendation of what to do about the issue described in a finding.
         * </p>
         * 
         * @param recommendationText
         *        The recommendation of what to do about the issue described in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationText(StringFilter... recommendationText);

        /**
         * <p>
         * The recommendation of what to do about the issue described in a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendationText(List<StringFilter>)}.
         * 
         * @param recommendationText
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationText(List<StringFilter>)
         */
        Builder recommendationText(Consumer<StringFilter.Builder>... recommendationText);

        /**
         * <p>
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         * </p>
         * 
         * @param sourceUrl
         *        A URL that links to a page about the current finding in the security-findings provider's solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(Collection<StringFilter> sourceUrl);

        /**
         * <p>
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         * </p>
         * 
         * @param sourceUrl
         *        A URL that links to a page about the current finding in the security-findings provider's solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(StringFilter... sourceUrl);

        /**
         * <p>
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceUrl(List<StringFilter>)}.
         * 
         * @param sourceUrl
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceUrl(List<StringFilter>)
         */
        Builder sourceUrl(Consumer<StringFilter.Builder>... sourceUrl);

        /**
         * <p>
         * A data type where security-findings providers can include additional solution-specific details that aren't
         * part of the defined <code>AwsSecurityFinding</code> format.
         * </p>
         * 
         * @param productFields
         *        A data type where security-findings providers can include additional solution-specific details that
         *        aren't part of the defined <code>AwsSecurityFinding</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFields(Collection<MapFilter> productFields);

        /**
         * <p>
         * A data type where security-findings providers can include additional solution-specific details that aren't
         * part of the defined <code>AwsSecurityFinding</code> format.
         * </p>
         * 
         * @param productFields
         *        A data type where security-findings providers can include additional solution-specific details that
         *        aren't part of the defined <code>AwsSecurityFinding</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFields(MapFilter... productFields);

        /**
         * <p>
         * A data type where security-findings providers can include additional solution-specific details that aren't
         * part of the defined <code>AwsSecurityFinding</code> format.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MapFilter>.Builder} avoiding the need to
         * create one manually via {@link List<MapFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MapFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #productFields(List<MapFilter>)}.
         * 
         * @param productFields
         *        a consumer that will call methods on {@link List<MapFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productFields(List<MapFilter>)
         */
        Builder productFields(Consumer<MapFilter.Builder>... productFields);

        /**
         * <p>
         * The name of the solution (product) that generates findings.
         * </p>
         * 
         * @param productName
         *        The name of the solution (product) that generates findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(Collection<StringFilter> productName);

        /**
         * <p>
         * The name of the solution (product) that generates findings.
         * </p>
         * 
         * @param productName
         *        The name of the solution (product) that generates findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(StringFilter... productName);

        /**
         * <p>
         * The name of the solution (product) that generates findings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #productName(List<StringFilter>)}.
         * 
         * @param productName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productName(List<StringFilter>)
         */
        Builder productName(Consumer<StringFilter.Builder>... productName);

        /**
         * <p>
         * The name of the findings provider (company) that owns the solution (product) that generates findings.
         * </p>
         * 
         * @param companyName
         *        The name of the findings provider (company) that owns the solution (product) that generates findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(Collection<StringFilter> companyName);

        /**
         * <p>
         * The name of the findings provider (company) that owns the solution (product) that generates findings.
         * </p>
         * 
         * @param companyName
         *        The name of the findings provider (company) that owns the solution (product) that generates findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(StringFilter... companyName);

        /**
         * <p>
         * The name of the findings provider (company) that owns the solution (product) that generates findings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #companyName(List<StringFilter>)}.
         * 
         * @param companyName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #companyName(List<StringFilter>)
         */
        Builder companyName(Consumer<StringFilter.Builder>... companyName);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields
         *        added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Collection<MapFilter> userDefinedFields);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields
         *        added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(MapFilter... userDefinedFields);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MapFilter>.Builder} avoiding the need to
         * create one manually via {@link List<MapFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MapFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #userDefinedFields(List<MapFilter>)}.
         * 
         * @param userDefinedFields
         *        a consumer that will call methods on {@link List<MapFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefinedFields(List<MapFilter>)
         */
        Builder userDefinedFields(Consumer<MapFilter.Builder>... userDefinedFields);

        /**
         * <p>
         * The name of the malware that was observed.
         * </p>
         * 
         * @param malwareName
         *        The name of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareName(Collection<StringFilter> malwareName);

        /**
         * <p>
         * The name of the malware that was observed.
         * </p>
         * 
         * @param malwareName
         *        The name of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareName(StringFilter... malwareName);

        /**
         * <p>
         * The name of the malware that was observed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #malwareName(List<StringFilter>)}.
         * 
         * @param malwareName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareName(List<StringFilter>)
         */
        Builder malwareName(Consumer<StringFilter.Builder>... malwareName);

        /**
         * <p>
         * The type of the malware that was observed.
         * </p>
         * 
         * @param malwareType
         *        The type of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareType(Collection<StringFilter> malwareType);

        /**
         * <p>
         * The type of the malware that was observed.
         * </p>
         * 
         * @param malwareType
         *        The type of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareType(StringFilter... malwareType);

        /**
         * <p>
         * The type of the malware that was observed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #malwareType(List<StringFilter>)}.
         * 
         * @param malwareType
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareType(List<StringFilter>)
         */
        Builder malwareType(Consumer<StringFilter.Builder>... malwareType);

        /**
         * <p>
         * The filesystem path of the malware that was observed.
         * </p>
         * 
         * @param malwarePath
         *        The filesystem path of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwarePath(Collection<StringFilter> malwarePath);

        /**
         * <p>
         * The filesystem path of the malware that was observed.
         * </p>
         * 
         * @param malwarePath
         *        The filesystem path of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwarePath(StringFilter... malwarePath);

        /**
         * <p>
         * The filesystem path of the malware that was observed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #malwarePath(List<StringFilter>)}.
         * 
         * @param malwarePath
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwarePath(List<StringFilter>)
         */
        Builder malwarePath(Consumer<StringFilter.Builder>... malwarePath);

        /**
         * <p>
         * The state of the malware that was observed.
         * </p>
         * 
         * @param malwareState
         *        The state of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareState(Collection<StringFilter> malwareState);

        /**
         * <p>
         * The state of the malware that was observed.
         * </p>
         * 
         * @param malwareState
         *        The state of the malware that was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareState(StringFilter... malwareState);

        /**
         * <p>
         * The state of the malware that was observed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #malwareState(List<StringFilter>)}.
         * 
         * @param malwareState
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareState(List<StringFilter>)
         */
        Builder malwareState(Consumer<StringFilter.Builder>... malwareState);

        /**
         * <p>
         * Indicates the direction of network traffic associated with a finding.
         * </p>
         * 
         * @param networkDirection
         *        Indicates the direction of network traffic associated with a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDirection(Collection<StringFilter> networkDirection);

        /**
         * <p>
         * Indicates the direction of network traffic associated with a finding.
         * </p>
         * 
         * @param networkDirection
         *        Indicates the direction of network traffic associated with a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDirection(StringFilter... networkDirection);

        /**
         * <p>
         * Indicates the direction of network traffic associated with a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkDirection(List<StringFilter>)}.
         * 
         * @param networkDirection
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkDirection(List<StringFilter>)
         */
        Builder networkDirection(Consumer<StringFilter.Builder>... networkDirection);

        /**
         * <p>
         * The protocol of network-related information about a finding.
         * </p>
         * 
         * @param networkProtocol
         *        The protocol of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProtocol(Collection<StringFilter> networkProtocol);

        /**
         * <p>
         * The protocol of network-related information about a finding.
         * </p>
         * 
         * @param networkProtocol
         *        The protocol of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProtocol(StringFilter... networkProtocol);

        /**
         * <p>
         * The protocol of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkProtocol(List<StringFilter>)}.
         * 
         * @param networkProtocol
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProtocol(List<StringFilter>)
         */
        Builder networkProtocol(Consumer<StringFilter.Builder>... networkProtocol);

        /**
         * <p>
         * The source IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceIpV4
         *        The source IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceIpV4(Collection<IpFilter> networkSourceIpV4);

        /**
         * <p>
         * The source IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceIpV4
         *        The source IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceIpV4(IpFilter... networkSourceIpV4);

        /**
         * <p>
         * The source IPv4 address of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSourceIpV4(List<IpFilter>)}.
         * 
         * @param networkSourceIpV4
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSourceIpV4(List<IpFilter>)
         */
        Builder networkSourceIpV4(Consumer<IpFilter.Builder>... networkSourceIpV4);

        /**
         * <p>
         * The source IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceIpV6
         *        The source IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceIpV6(Collection<IpFilter> networkSourceIpV6);

        /**
         * <p>
         * The source IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceIpV6
         *        The source IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceIpV6(IpFilter... networkSourceIpV6);

        /**
         * <p>
         * The source IPv6 address of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSourceIpV6(List<IpFilter>)}.
         * 
         * @param networkSourceIpV6
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSourceIpV6(List<IpFilter>)
         */
        Builder networkSourceIpV6(Consumer<IpFilter.Builder>... networkSourceIpV6);

        /**
         * <p>
         * The source port of network-related information about a finding.
         * </p>
         * 
         * @param networkSourcePort
         *        The source port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourcePort(Collection<NumberFilter> networkSourcePort);

        /**
         * <p>
         * The source port of network-related information about a finding.
         * </p>
         * 
         * @param networkSourcePort
         *        The source port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourcePort(NumberFilter... networkSourcePort);

        /**
         * <p>
         * The source port of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSourcePort(List<NumberFilter>)}.
         * 
         * @param networkSourcePort
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSourcePort(List<NumberFilter>)
         */
        Builder networkSourcePort(Consumer<NumberFilter.Builder>... networkSourcePort);

        /**
         * <p>
         * The source domain of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceDomain
         *        The source domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceDomain(Collection<StringFilter> networkSourceDomain);

        /**
         * <p>
         * The source domain of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceDomain
         *        The source domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceDomain(StringFilter... networkSourceDomain);

        /**
         * <p>
         * The source domain of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSourceDomain(List<StringFilter>)}.
         * 
         * @param networkSourceDomain
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSourceDomain(List<StringFilter>)
         */
        Builder networkSourceDomain(Consumer<StringFilter.Builder>... networkSourceDomain);

        /**
         * <p>
         * The source media access control (MAC) address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceMac
         *        The source media access control (MAC) address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceMac(Collection<StringFilter> networkSourceMac);

        /**
         * <p>
         * The source media access control (MAC) address of network-related information about a finding.
         * </p>
         * 
         * @param networkSourceMac
         *        The source media access control (MAC) address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSourceMac(StringFilter... networkSourceMac);

        /**
         * <p>
         * The source media access control (MAC) address of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSourceMac(List<StringFilter>)}.
         * 
         * @param networkSourceMac
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSourceMac(List<StringFilter>)
         */
        Builder networkSourceMac(Consumer<StringFilter.Builder>... networkSourceMac);

        /**
         * <p>
         * The destination IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationIpV4
         *        The destination IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationIpV4(Collection<IpFilter> networkDestinationIpV4);

        /**
         * <p>
         * The destination IPv4 address of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationIpV4
         *        The destination IPv4 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationIpV4(IpFilter... networkDestinationIpV4);

        /**
         * <p>
         * The destination IPv4 address of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkDestinationIpV4(List<IpFilter>)}.
         * 
         * @param networkDestinationIpV4
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkDestinationIpV4(List<IpFilter>)
         */
        Builder networkDestinationIpV4(Consumer<IpFilter.Builder>... networkDestinationIpV4);

        /**
         * <p>
         * The destination IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationIpV6
         *        The destination IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationIpV6(Collection<IpFilter> networkDestinationIpV6);

        /**
         * <p>
         * The destination IPv6 address of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationIpV6
         *        The destination IPv6 address of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationIpV6(IpFilter... networkDestinationIpV6);

        /**
         * <p>
         * The destination IPv6 address of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkDestinationIpV6(List<IpFilter>)}.
         * 
         * @param networkDestinationIpV6
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkDestinationIpV6(List<IpFilter>)
         */
        Builder networkDestinationIpV6(Consumer<IpFilter.Builder>... networkDestinationIpV6);

        /**
         * <p>
         * The destination port of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationPort
         *        The destination port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationPort(Collection<NumberFilter> networkDestinationPort);

        /**
         * <p>
         * The destination port of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationPort
         *        The destination port of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationPort(NumberFilter... networkDestinationPort);

        /**
         * <p>
         * The destination port of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkDestinationPort(List<NumberFilter>)}.
         * 
         * @param networkDestinationPort
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkDestinationPort(List<NumberFilter>)
         */
        Builder networkDestinationPort(Consumer<NumberFilter.Builder>... networkDestinationPort);

        /**
         * <p>
         * The destination domain of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationDomain
         *        The destination domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationDomain(Collection<StringFilter> networkDestinationDomain);

        /**
         * <p>
         * The destination domain of network-related information about a finding.
         * </p>
         * 
         * @param networkDestinationDomain
         *        The destination domain of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkDestinationDomain(StringFilter... networkDestinationDomain);

        /**
         * <p>
         * The destination domain of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #networkDestinationDomain(List<StringFilter>)}.
         * 
         * @param networkDestinationDomain
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkDestinationDomain(List<StringFilter>)
         */
        Builder networkDestinationDomain(Consumer<StringFilter.Builder>... networkDestinationDomain);

        /**
         * <p>
         * The name of the process.
         * </p>
         * 
         * @param processName
         *        The name of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processName(Collection<StringFilter> processName);

        /**
         * <p>
         * The name of the process.
         * </p>
         * 
         * @param processName
         *        The name of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processName(StringFilter... processName);

        /**
         * <p>
         * The name of the process.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processName(List<StringFilter>)}.
         * 
         * @param processName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processName(List<StringFilter>)
         */
        Builder processName(Consumer<StringFilter.Builder>... processName);

        /**
         * <p>
         * The path to the process executable.
         * </p>
         * 
         * @param processPath
         *        The path to the process executable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processPath(Collection<StringFilter> processPath);

        /**
         * <p>
         * The path to the process executable.
         * </p>
         * 
         * @param processPath
         *        The path to the process executable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processPath(StringFilter... processPath);

        /**
         * <p>
         * The path to the process executable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processPath(List<StringFilter>)}.
         * 
         * @param processPath
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processPath(List<StringFilter>)
         */
        Builder processPath(Consumer<StringFilter.Builder>... processPath);

        /**
         * <p>
         * The process ID.
         * </p>
         * 
         * @param processPid
         *        The process ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processPid(Collection<NumberFilter> processPid);

        /**
         * <p>
         * The process ID.
         * </p>
         * 
         * @param processPid
         *        The process ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processPid(NumberFilter... processPid);

        /**
         * <p>
         * The process ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processPid(List<NumberFilter>)}.
         * 
         * @param processPid
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processPid(List<NumberFilter>)
         */
        Builder processPid(Consumer<NumberFilter.Builder>... processPid);

        /**
         * <p>
         * The parent process ID.
         * </p>
         * 
         * @param processParentPid
         *        The parent process ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processParentPid(Collection<NumberFilter> processParentPid);

        /**
         * <p>
         * The parent process ID.
         * </p>
         * 
         * @param processParentPid
         *        The parent process ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processParentPid(NumberFilter... processParentPid);

        /**
         * <p>
         * The parent process ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NumberFilter>.Builder} avoiding the need to
         * create one manually via {@link List<NumberFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NumberFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processParentPid(List<NumberFilter>)}.
         * 
         * @param processParentPid
         *        a consumer that will call methods on {@link List<NumberFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processParentPid(List<NumberFilter>)
         */
        Builder processParentPid(Consumer<NumberFilter.Builder>... processParentPid);

        /**
         * <p>
         * The date/time that the process was launched.
         * </p>
         * 
         * @param processLaunchedAt
         *        The date/time that the process was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processLaunchedAt(Collection<DateFilter> processLaunchedAt);

        /**
         * <p>
         * The date/time that the process was launched.
         * </p>
         * 
         * @param processLaunchedAt
         *        The date/time that the process was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processLaunchedAt(DateFilter... processLaunchedAt);

        /**
         * <p>
         * The date/time that the process was launched.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processLaunchedAt(List<DateFilter>)}.
         * 
         * @param processLaunchedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processLaunchedAt(List<DateFilter>)
         */
        Builder processLaunchedAt(Consumer<DateFilter.Builder>... processLaunchedAt);

        /**
         * <p>
         * The date/time that the process was terminated.
         * </p>
         * 
         * @param processTerminatedAt
         *        The date/time that the process was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processTerminatedAt(Collection<DateFilter> processTerminatedAt);

        /**
         * <p>
         * The date/time that the process was terminated.
         * </p>
         * 
         * @param processTerminatedAt
         *        The date/time that the process was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processTerminatedAt(DateFilter... processTerminatedAt);

        /**
         * <p>
         * The date/time that the process was terminated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #processTerminatedAt(List<DateFilter>)}.
         * 
         * @param processTerminatedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processTerminatedAt(List<DateFilter>)
         */
        Builder processTerminatedAt(Consumer<DateFilter.Builder>... processTerminatedAt);

        /**
         * <p>
         * The type of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorType
         *        The type of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorType(Collection<StringFilter> threatIntelIndicatorType);

        /**
         * <p>
         * The type of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorType
         *        The type of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorType(StringFilter... threatIntelIndicatorType);

        /**
         * <p>
         * The type of a threat intel indicator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorType(List<StringFilter>)}.
         * 
         * @param threatIntelIndicatorType
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorType(List<StringFilter>)
         */
        Builder threatIntelIndicatorType(Consumer<StringFilter.Builder>... threatIntelIndicatorType);

        /**
         * <p>
         * The value of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorValue
         *        The value of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorValue(Collection<StringFilter> threatIntelIndicatorValue);

        /**
         * <p>
         * The value of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorValue
         *        The value of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorValue(StringFilter... threatIntelIndicatorValue);

        /**
         * <p>
         * The value of a threat intel indicator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorValue(List<StringFilter>)}.
         * 
         * @param threatIntelIndicatorValue
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorValue(List<StringFilter>)
         */
        Builder threatIntelIndicatorValue(Consumer<StringFilter.Builder>... threatIntelIndicatorValue);

        /**
         * <p>
         * The category of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorCategory
         *        The category of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorCategory(Collection<StringFilter> threatIntelIndicatorCategory);

        /**
         * <p>
         * The category of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorCategory
         *        The category of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorCategory(StringFilter... threatIntelIndicatorCategory);

        /**
         * <p>
         * The category of a threat intel indicator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorCategory(List<StringFilter>)}.
         * 
         * @param threatIntelIndicatorCategory
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorCategory(List<StringFilter>)
         */
        Builder threatIntelIndicatorCategory(Consumer<StringFilter.Builder>... threatIntelIndicatorCategory);

        /**
         * <p>
         * The date/time of the last observation of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorLastObservedAt
         *        The date/time of the last observation of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorLastObservedAt(Collection<DateFilter> threatIntelIndicatorLastObservedAt);

        /**
         * <p>
         * The date/time of the last observation of a threat intel indicator.
         * </p>
         * 
         * @param threatIntelIndicatorLastObservedAt
         *        The date/time of the last observation of a threat intel indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorLastObservedAt(DateFilter... threatIntelIndicatorLastObservedAt);

        /**
         * <p>
         * The date/time of the last observation of a threat intel indicator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorLastObservedAt(List<DateFilter>)}.
         * 
         * @param threatIntelIndicatorLastObservedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorLastObservedAt(List<DateFilter>)
         */
        Builder threatIntelIndicatorLastObservedAt(Consumer<DateFilter.Builder>... threatIntelIndicatorLastObservedAt);

        /**
         * <p>
         * The source of the threat intel.
         * </p>
         * 
         * @param threatIntelIndicatorSource
         *        The source of the threat intel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorSource(Collection<StringFilter> threatIntelIndicatorSource);

        /**
         * <p>
         * The source of the threat intel.
         * </p>
         * 
         * @param threatIntelIndicatorSource
         *        The source of the threat intel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorSource(StringFilter... threatIntelIndicatorSource);

        /**
         * <p>
         * The source of the threat intel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorSource(List<StringFilter>)}.
         * 
         * @param threatIntelIndicatorSource
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorSource(List<StringFilter>)
         */
        Builder threatIntelIndicatorSource(Consumer<StringFilter.Builder>... threatIntelIndicatorSource);

        /**
         * <p>
         * The URL for more details from the source of the threat intel.
         * </p>
         * 
         * @param threatIntelIndicatorSourceUrl
         *        The URL for more details from the source of the threat intel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorSourceUrl(Collection<StringFilter> threatIntelIndicatorSourceUrl);

        /**
         * <p>
         * The URL for more details from the source of the threat intel.
         * </p>
         * 
         * @param threatIntelIndicatorSourceUrl
         *        The URL for more details from the source of the threat intel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicatorSourceUrl(StringFilter... threatIntelIndicatorSourceUrl);

        /**
         * <p>
         * The URL for more details from the source of the threat intel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #threatIntelIndicatorSourceUrl(List<StringFilter>)}.
         * 
         * @param threatIntelIndicatorSourceUrl
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicatorSourceUrl(List<StringFilter>)
         */
        Builder threatIntelIndicatorSourceUrl(Consumer<StringFilter.Builder>... threatIntelIndicatorSourceUrl);

        /**
         * <p>
         * Specifies the type of the resource that details are provided for.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of the resource that details are provided for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(Collection<StringFilter> resourceType);

        /**
         * <p>
         * Specifies the type of the resource that details are provided for.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of the resource that details are provided for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(StringFilter... resourceType);

        /**
         * <p>
         * Specifies the type of the resource that details are provided for.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceType(List<StringFilter>)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(List<StringFilter>)
         */
        Builder resourceType(Consumer<StringFilter.Builder>... resourceType);

        /**
         * <p>
         * The canonical identifier for the given resource type.
         * </p>
         * 
         * @param resourceId
         *        The canonical identifier for the given resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(Collection<StringFilter> resourceId);

        /**
         * <p>
         * The canonical identifier for the given resource type.
         * </p>
         * 
         * @param resourceId
         *        The canonical identifier for the given resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(StringFilter... resourceId);

        /**
         * <p>
         * The canonical identifier for the given resource type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceId(List<StringFilter>)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(List<StringFilter>)
         */
        Builder resourceId(Consumer<StringFilter.Builder>... resourceId);

        /**
         * <p>
         * The canonical AWS partition name that the Region is assigned to.
         * </p>
         * 
         * @param resourcePartition
         *        The canonical AWS partition name that the Region is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePartition(Collection<StringFilter> resourcePartition);

        /**
         * <p>
         * The canonical AWS partition name that the Region is assigned to.
         * </p>
         * 
         * @param resourcePartition
         *        The canonical AWS partition name that the Region is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePartition(StringFilter... resourcePartition);

        /**
         * <p>
         * The canonical AWS partition name that the Region is assigned to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcePartition(List<StringFilter>)}.
         * 
         * @param resourcePartition
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePartition(List<StringFilter>)
         */
        Builder resourcePartition(Consumer<StringFilter.Builder>... resourcePartition);

        /**
         * <p>
         * The canonical AWS external Region name where this resource is located.
         * </p>
         * 
         * @param resourceRegion
         *        The canonical AWS external Region name where this resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(Collection<StringFilter> resourceRegion);

        /**
         * <p>
         * The canonical AWS external Region name where this resource is located.
         * </p>
         * 
         * @param resourceRegion
         *        The canonical AWS external Region name where this resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(StringFilter... resourceRegion);

        /**
         * <p>
         * The canonical AWS external Region name where this resource is located.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceRegion(List<StringFilter>)}.
         * 
         * @param resourceRegion
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRegion(List<StringFilter>)
         */
        Builder resourceRegion(Consumer<StringFilter.Builder>... resourceRegion);

        /**
         * <p>
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * </p>
         * 
         * @param resourceTags
         *        A list of AWS tags associated with a resource at the time the finding was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<MapFilter> resourceTags);

        /**
         * <p>
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * </p>
         * 
         * @param resourceTags
         *        A list of AWS tags associated with a resource at the time the finding was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(MapFilter... resourceTags);

        /**
         * <p>
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MapFilter>.Builder} avoiding the need to
         * create one manually via {@link List<MapFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MapFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(List<MapFilter>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on {@link List<MapFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(List<MapFilter>)
         */
        Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags);

        /**
         * <p>
         * The instance type of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceType
         *        The instance type of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceType(Collection<StringFilter> resourceAwsEc2InstanceType);

        /**
         * <p>
         * The instance type of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceType
         *        The instance type of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceType(StringFilter... resourceAwsEc2InstanceType);

        /**
         * <p>
         * The instance type of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceType(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceType
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceType(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceType(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceType);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceImageId
         *        The Amazon Machine Image (AMI) ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceImageId(Collection<StringFilter> resourceAwsEc2InstanceImageId);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceImageId
         *        The Amazon Machine Image (AMI) ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceImageId(StringFilter... resourceAwsEc2InstanceImageId);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceImageId(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceImageId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceImageId(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceImageId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceImageId);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIpV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIpV4Addresses(Collection<IpFilter> resourceAwsEc2InstanceIpV4Addresses);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIpV4Addresses
         *        The IPv4 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIpV4Addresses(IpFilter... resourceAwsEc2InstanceIpV4Addresses);

        /**
         * <p>
         * The IPv4 addresses associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceIpV4Addresses(List<IpFilter>)}.
         * 
         * @param resourceAwsEc2InstanceIpV4Addresses
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceIpV4Addresses(List<IpFilter>)
         */
        Builder resourceAwsEc2InstanceIpV4Addresses(Consumer<IpFilter.Builder>... resourceAwsEc2InstanceIpV4Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIpV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIpV6Addresses(Collection<IpFilter> resourceAwsEc2InstanceIpV6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIpV6Addresses
         *        The IPv6 addresses associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIpV6Addresses(IpFilter... resourceAwsEc2InstanceIpV6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IpFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceIpV6Addresses(List<IpFilter>)}.
         * 
         * @param resourceAwsEc2InstanceIpV6Addresses
         *        a consumer that will call methods on {@link List<IpFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceIpV6Addresses(List<IpFilter>)
         */
        Builder resourceAwsEc2InstanceIpV6Addresses(Consumer<IpFilter.Builder>... resourceAwsEc2InstanceIpV6Addresses);

        /**
         * <p>
         * The key name associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceKeyName
         *        The key name associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceKeyName(Collection<StringFilter> resourceAwsEc2InstanceKeyName);

        /**
         * <p>
         * The key name associated with the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceKeyName
         *        The key name associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceKeyName(StringFilter... resourceAwsEc2InstanceKeyName);

        /**
         * <p>
         * The key name associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceKeyName(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceKeyName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceKeyName(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceKeyName(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceKeyName);

        /**
         * <p>
         * The IAM profile ARN of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIamInstanceProfileArn
         *        The IAM profile ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIamInstanceProfileArn(Collection<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn);

        /**
         * <p>
         * The IAM profile ARN of the instance.
         * </p>
         * 
         * @param resourceAwsEc2InstanceIamInstanceProfileArn
         *        The IAM profile ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceIamInstanceProfileArn(StringFilter... resourceAwsEc2InstanceIamInstanceProfileArn);

        /**
         * <p>
         * The IAM profile ARN of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceIamInstanceProfileArn(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceIamInstanceProfileArn
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceIamInstanceProfileArn(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceIamInstanceProfileArn(
                Consumer<StringFilter.Builder>... resourceAwsEc2InstanceIamInstanceProfileArn);

        /**
         * <p>
         * The identifier of the VPC that the instance was launched in.
         * </p>
         * 
         * @param resourceAwsEc2InstanceVpcId
         *        The identifier of the VPC that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceVpcId(Collection<StringFilter> resourceAwsEc2InstanceVpcId);

        /**
         * <p>
         * The identifier of the VPC that the instance was launched in.
         * </p>
         * 
         * @param resourceAwsEc2InstanceVpcId
         *        The identifier of the VPC that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceVpcId(StringFilter... resourceAwsEc2InstanceVpcId);

        /**
         * <p>
         * The identifier of the VPC that the instance was launched in.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceVpcId(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceVpcId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceVpcId(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceVpcId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceVpcId);

        /**
         * <p>
         * The identifier of the subnet that the instance was launched in.
         * </p>
         * 
         * @param resourceAwsEc2InstanceSubnetId
         *        The identifier of the subnet that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceSubnetId(Collection<StringFilter> resourceAwsEc2InstanceSubnetId);

        /**
         * <p>
         * The identifier of the subnet that the instance was launched in.
         * </p>
         * 
         * @param resourceAwsEc2InstanceSubnetId
         *        The identifier of the subnet that the instance was launched in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceSubnetId(StringFilter... resourceAwsEc2InstanceSubnetId);

        /**
         * <p>
         * The identifier of the subnet that the instance was launched in.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceSubnetId(List<StringFilter>)}.
         * 
         * @param resourceAwsEc2InstanceSubnetId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceSubnetId(List<StringFilter>)
         */
        Builder resourceAwsEc2InstanceSubnetId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceSubnetId);

        /**
         * <p>
         * The date/time the instance was launched.
         * </p>
         * 
         * @param resourceAwsEc2InstanceLaunchedAt
         *        The date/time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceLaunchedAt(Collection<DateFilter> resourceAwsEc2InstanceLaunchedAt);

        /**
         * <p>
         * The date/time the instance was launched.
         * </p>
         * 
         * @param resourceAwsEc2InstanceLaunchedAt
         *        The date/time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsEc2InstanceLaunchedAt(DateFilter... resourceAwsEc2InstanceLaunchedAt);

        /**
         * <p>
         * The date/time the instance was launched.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsEc2InstanceLaunchedAt(List<DateFilter>)}.
         * 
         * @param resourceAwsEc2InstanceLaunchedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsEc2InstanceLaunchedAt(List<DateFilter>)
         */
        Builder resourceAwsEc2InstanceLaunchedAt(Consumer<DateFilter.Builder>... resourceAwsEc2InstanceLaunchedAt);

        /**
         * <p>
         * The canonical user ID of the owner of the S3 bucket.
         * </p>
         * 
         * @param resourceAwsS3BucketOwnerId
         *        The canonical user ID of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsS3BucketOwnerId(Collection<StringFilter> resourceAwsS3BucketOwnerId);

        /**
         * <p>
         * The canonical user ID of the owner of the S3 bucket.
         * </p>
         * 
         * @param resourceAwsS3BucketOwnerId
         *        The canonical user ID of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsS3BucketOwnerId(StringFilter... resourceAwsS3BucketOwnerId);

        /**
         * <p>
         * The canonical user ID of the owner of the S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsS3BucketOwnerId(List<StringFilter>)}.
         * 
         * @param resourceAwsS3BucketOwnerId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsS3BucketOwnerId(List<StringFilter>)
         */
        Builder resourceAwsS3BucketOwnerId(Consumer<StringFilter.Builder>... resourceAwsS3BucketOwnerId);

        /**
         * <p>
         * The display name of the owner of the S3 bucket.
         * </p>
         * 
         * @param resourceAwsS3BucketOwnerName
         *        The display name of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsS3BucketOwnerName(Collection<StringFilter> resourceAwsS3BucketOwnerName);

        /**
         * <p>
         * The display name of the owner of the S3 bucket.
         * </p>
         * 
         * @param resourceAwsS3BucketOwnerName
         *        The display name of the owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsS3BucketOwnerName(StringFilter... resourceAwsS3BucketOwnerName);

        /**
         * <p>
         * The display name of the owner of the S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsS3BucketOwnerName(List<StringFilter>)}.
         * 
         * @param resourceAwsS3BucketOwnerName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsS3BucketOwnerName(List<StringFilter>)
         */
        Builder resourceAwsS3BucketOwnerName(Consumer<StringFilter.Builder>... resourceAwsS3BucketOwnerName);

        /**
         * <p>
         * The user associated with the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyUserName
         *        The user associated with the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyUserName(Collection<StringFilter> resourceAwsIamAccessKeyUserName);

        /**
         * <p>
         * The user associated with the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyUserName
         *        The user associated with the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyUserName(StringFilter... resourceAwsIamAccessKeyUserName);

        /**
         * <p>
         * The user associated with the IAM access key related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsIamAccessKeyUserName(List<StringFilter>)}.
         * 
         * @param resourceAwsIamAccessKeyUserName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsIamAccessKeyUserName(List<StringFilter>)
         */
        Builder resourceAwsIamAccessKeyUserName(Consumer<StringFilter.Builder>... resourceAwsIamAccessKeyUserName);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyStatus
         *        The status of the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyStatus(Collection<StringFilter> resourceAwsIamAccessKeyStatus);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyStatus
         *        The status of the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyStatus(StringFilter... resourceAwsIamAccessKeyStatus);

        /**
         * <p>
         * The status of the IAM access key related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsIamAccessKeyStatus(List<StringFilter>)}.
         * 
         * @param resourceAwsIamAccessKeyStatus
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsIamAccessKeyStatus(List<StringFilter>)
         */
        Builder resourceAwsIamAccessKeyStatus(Consumer<StringFilter.Builder>... resourceAwsIamAccessKeyStatus);

        /**
         * <p>
         * The creation date/time of the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyCreatedAt
         *        The creation date/time of the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyCreatedAt(Collection<DateFilter> resourceAwsIamAccessKeyCreatedAt);

        /**
         * <p>
         * The creation date/time of the IAM access key related to a finding.
         * </p>
         * 
         * @param resourceAwsIamAccessKeyCreatedAt
         *        The creation date/time of the IAM access key related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAwsIamAccessKeyCreatedAt(DateFilter... resourceAwsIamAccessKeyCreatedAt);

        /**
         * <p>
         * The creation date/time of the IAM access key related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAwsIamAccessKeyCreatedAt(List<DateFilter>)}.
         * 
         * @param resourceAwsIamAccessKeyCreatedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAwsIamAccessKeyCreatedAt(List<DateFilter>)
         */
        Builder resourceAwsIamAccessKeyCreatedAt(Consumer<DateFilter.Builder>... resourceAwsIamAccessKeyCreatedAt);

        /**
         * <p>
         * The name of the container related to a finding.
         * </p>
         * 
         * @param resourceContainerName
         *        The name of the container related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerName(Collection<StringFilter> resourceContainerName);

        /**
         * <p>
         * The name of the container related to a finding.
         * </p>
         * 
         * @param resourceContainerName
         *        The name of the container related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerName(StringFilter... resourceContainerName);

        /**
         * <p>
         * The name of the container related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceContainerName(List<StringFilter>)}.
         * 
         * @param resourceContainerName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceContainerName(List<StringFilter>)
         */
        Builder resourceContainerName(Consumer<StringFilter.Builder>... resourceContainerName);

        /**
         * <p>
         * The identifier of the image related to a finding.
         * </p>
         * 
         * @param resourceContainerImageId
         *        The identifier of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerImageId(Collection<StringFilter> resourceContainerImageId);

        /**
         * <p>
         * The identifier of the image related to a finding.
         * </p>
         * 
         * @param resourceContainerImageId
         *        The identifier of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerImageId(StringFilter... resourceContainerImageId);

        /**
         * <p>
         * The identifier of the image related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceContainerImageId(List<StringFilter>)}.
         * 
         * @param resourceContainerImageId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceContainerImageId(List<StringFilter>)
         */
        Builder resourceContainerImageId(Consumer<StringFilter.Builder>... resourceContainerImageId);

        /**
         * <p>
         * The name of the image related to a finding.
         * </p>
         * 
         * @param resourceContainerImageName
         *        The name of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerImageName(Collection<StringFilter> resourceContainerImageName);

        /**
         * <p>
         * The name of the image related to a finding.
         * </p>
         * 
         * @param resourceContainerImageName
         *        The name of the image related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerImageName(StringFilter... resourceContainerImageName);

        /**
         * <p>
         * The name of the image related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceContainerImageName(List<StringFilter>)}.
         * 
         * @param resourceContainerImageName
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceContainerImageName(List<StringFilter>)
         */
        Builder resourceContainerImageName(Consumer<StringFilter.Builder>... resourceContainerImageName);

        /**
         * <p>
         * The date/time that the container was started.
         * </p>
         * 
         * @param resourceContainerLaunchedAt
         *        The date/time that the container was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerLaunchedAt(Collection<DateFilter> resourceContainerLaunchedAt);

        /**
         * <p>
         * The date/time that the container was started.
         * </p>
         * 
         * @param resourceContainerLaunchedAt
         *        The date/time that the container was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceContainerLaunchedAt(DateFilter... resourceContainerLaunchedAt);

        /**
         * <p>
         * The date/time that the container was started.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceContainerLaunchedAt(List<DateFilter>)}.
         * 
         * @param resourceContainerLaunchedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceContainerLaunchedAt(List<DateFilter>)
         */
        Builder resourceContainerLaunchedAt(Consumer<DateFilter.Builder>... resourceContainerLaunchedAt);

        /**
         * <p>
         * The details of a resource that doesn't have a specific subfield for the resource type defined.
         * </p>
         * 
         * @param resourceDetailsOther
         *        The details of a resource that doesn't have a specific subfield for the resource type defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetailsOther(Collection<MapFilter> resourceDetailsOther);

        /**
         * <p>
         * The details of a resource that doesn't have a specific subfield for the resource type defined.
         * </p>
         * 
         * @param resourceDetailsOther
         *        The details of a resource that doesn't have a specific subfield for the resource type defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetailsOther(MapFilter... resourceDetailsOther);

        /**
         * <p>
         * The details of a resource that doesn't have a specific subfield for the resource type defined.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MapFilter>.Builder} avoiding the need to
         * create one manually via {@link List<MapFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MapFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetailsOther(List<MapFilter>)}.
         * 
         * @param resourceDetailsOther
         *        a consumer that will call methods on {@link List<MapFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetailsOther(List<MapFilter>)
         */
        Builder resourceDetailsOther(Consumer<MapFilter.Builder>... resourceDetailsOther);

        /**
         * <p>
         * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
         * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * </p>
         * 
         * @param complianceStatus
         *        Exclusive to findings that are generated as the result of a check run against a specific rule in a
         *        supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceStatus(Collection<StringFilter> complianceStatus);

        /**
         * <p>
         * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
         * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * </p>
         * 
         * @param complianceStatus
         *        Exclusive to findings that are generated as the result of a check run against a specific rule in a
         *        supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceStatus(StringFilter... complianceStatus);

        /**
         * <p>
         * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
         * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceStatus(List<StringFilter>)}.
         * 
         * @param complianceStatus
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceStatus(List<StringFilter>)
         */
        Builder complianceStatus(Consumer<StringFilter.Builder>... complianceStatus);

        /**
         * <p>
         * The veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        The veracity of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationState(Collection<StringFilter> verificationState);

        /**
         * <p>
         * The veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        The veracity of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationState(StringFilter... verificationState);

        /**
         * <p>
         * The veracity of a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #verificationState(List<StringFilter>)}.
         * 
         * @param verificationState
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationState(List<StringFilter>)
         */
        Builder verificationState(Consumer<StringFilter.Builder>... verificationState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowState(Collection<StringFilter> workflowState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowState(StringFilter... workflowState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #workflowState(List<StringFilter>)}.
         * 
         * @param workflowState
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowState(List<StringFilter>)
         */
        Builder workflowState(Consumer<StringFilter.Builder>... workflowState);

        /**
         * <p>
         * The updated record state for the finding.
         * </p>
         * 
         * @param recordState
         *        The updated record state for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordState(Collection<StringFilter> recordState);

        /**
         * <p>
         * The updated record state for the finding.
         * </p>
         * 
         * @param recordState
         *        The updated record state for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordState(StringFilter... recordState);

        /**
         * <p>
         * The updated record state for the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #recordState(List<StringFilter>)}.
         * 
         * @param recordState
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordState(List<StringFilter>)
         */
        Builder recordState(Consumer<StringFilter.Builder>... recordState);

        /**
         * <p>
         * The ARN of the solution that generated a related finding.
         * </p>
         * 
         * @param relatedFindingsProductArn
         *        The ARN of the solution that generated a related finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsProductArn(Collection<StringFilter> relatedFindingsProductArn);

        /**
         * <p>
         * The ARN of the solution that generated a related finding.
         * </p>
         * 
         * @param relatedFindingsProductArn
         *        The ARN of the solution that generated a related finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsProductArn(StringFilter... relatedFindingsProductArn);

        /**
         * <p>
         * The ARN of the solution that generated a related finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #relatedFindingsProductArn(List<StringFilter>)}.
         * 
         * @param relatedFindingsProductArn
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingsProductArn(List<StringFilter>)
         */
        Builder relatedFindingsProductArn(Consumer<StringFilter.Builder>... relatedFindingsProductArn);

        /**
         * <p>
         * The solution-generated identifier for a related finding.
         * </p>
         * 
         * @param relatedFindingsId
         *        The solution-generated identifier for a related finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsId(Collection<StringFilter> relatedFindingsId);

        /**
         * <p>
         * The solution-generated identifier for a related finding.
         * </p>
         * 
         * @param relatedFindingsId
         *        The solution-generated identifier for a related finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingsId(StringFilter... relatedFindingsId);

        /**
         * <p>
         * The solution-generated identifier for a related finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #relatedFindingsId(List<StringFilter>)}.
         * 
         * @param relatedFindingsId
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingsId(List<StringFilter>)
         */
        Builder relatedFindingsId(Consumer<StringFilter.Builder>... relatedFindingsId);

        /**
         * <p>
         * The text of a note.
         * </p>
         * 
         * @param noteText
         *        The text of a note.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteText(Collection<StringFilter> noteText);

        /**
         * <p>
         * The text of a note.
         * </p>
         * 
         * @param noteText
         *        The text of a note.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteText(StringFilter... noteText);

        /**
         * <p>
         * The text of a note.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #noteText(List<StringFilter>)}.
         * 
         * @param noteText
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteText(List<StringFilter>)
         */
        Builder noteText(Consumer<StringFilter.Builder>... noteText);

        /**
         * <p>
         * The timestamp of when the note was updated.
         * </p>
         * 
         * @param noteUpdatedAt
         *        The timestamp of when the note was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedAt(Collection<DateFilter> noteUpdatedAt);

        /**
         * <p>
         * The timestamp of when the note was updated.
         * </p>
         * 
         * @param noteUpdatedAt
         *        The timestamp of when the note was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedAt(DateFilter... noteUpdatedAt);

        /**
         * <p>
         * The timestamp of when the note was updated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #noteUpdatedAt(List<DateFilter>)}.
         * 
         * @param noteUpdatedAt
         *        a consumer that will call methods on {@link List<DateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteUpdatedAt(List<DateFilter>)
         */
        Builder noteUpdatedAt(Consumer<DateFilter.Builder>... noteUpdatedAt);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * 
         * @param noteUpdatedBy
         *        The principal that created a note.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedBy(Collection<StringFilter> noteUpdatedBy);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * 
         * @param noteUpdatedBy
         *        The principal that created a note.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noteUpdatedBy(StringFilter... noteUpdatedBy);

        /**
         * <p>
         * The principal that created a note.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StringFilter>.Builder} avoiding the need to
         * create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #noteUpdatedBy(List<StringFilter>)}.
         * 
         * @param noteUpdatedBy
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noteUpdatedBy(List<StringFilter>)
         */
        Builder noteUpdatedBy(Consumer<StringFilter.Builder>... noteUpdatedBy);

        /**
         * <p>
         * A keyword for a finding.
         * </p>
         * 
         * @param keyword
         *        A keyword for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(Collection<KeywordFilter> keyword);

        /**
         * <p>
         * A keyword for a finding.
         * </p>
         * 
         * @param keyword
         *        A keyword for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(KeywordFilter... keyword);

        /**
         * <p>
         * A keyword for a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeywordFilter>.Builder} avoiding the need
         * to create one manually via {@link List<KeywordFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeywordFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #keyword(List<KeywordFilter>)}.
         * 
         * @param keyword
         *        a consumer that will call methods on {@link List<KeywordFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyword(List<KeywordFilter>)
         */
        Builder keyword(Consumer<KeywordFilter.Builder>... keyword);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> productArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> awsAccountId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> id = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> generatorId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> type = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> firstObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> lastObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> createdAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> updatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> severityProduct = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> severityNormalized = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> severityLabel = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> confidence = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> criticality = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> title = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> description = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> recommendationText = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> sourceUrl = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> productFields = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> productName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> companyName = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> userDefinedFields = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> malwareName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> malwareType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> malwarePath = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> malwareState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkDirection = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkProtocol = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> networkSourceIpV4 = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> networkSourceIpV6 = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> networkSourcePort = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkSourceDomain = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkSourceMac = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> networkDestinationIpV4 = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> networkDestinationIpV6 = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> networkDestinationPort = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkDestinationDomain = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> processName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> processPath = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> processPid = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> processParentPid = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> processLaunchedAt = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> processTerminatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> threatIntelIndicatorType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> threatIntelIndicatorValue = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> threatIntelIndicatorCategory = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> threatIntelIndicatorLastObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> threatIntelIndicatorSource = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> threatIntelIndicatorSourceUrl = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourcePartition = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceRegion = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceImageId = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> resourceAwsEc2InstanceIpV4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<IpFilter> resourceAwsEc2InstanceIpV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceKeyName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceVpcId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsEc2InstanceSubnetId = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> resourceAwsEc2InstanceLaunchedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsS3BucketOwnerId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsS3BucketOwnerName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsIamAccessKeyUserName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceAwsIamAccessKeyStatus = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> resourceAwsIamAccessKeyCreatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceContainerName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceContainerImageId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceContainerImageName = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> resourceContainerLaunchedAt = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> resourceDetailsOther = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> complianceStatus = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> verificationState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> workflowState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> recordState = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> relatedFindingsProductArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> relatedFindingsId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> noteText = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> noteUpdatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> noteUpdatedBy = DefaultSdkAutoConstructList.getInstance();

        private List<KeywordFilter> keyword = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecurityFindingFilters model) {
            productArn(model.productArn);
            awsAccountId(model.awsAccountId);
            id(model.id);
            generatorId(model.generatorId);
            type(model.type);
            firstObservedAt(model.firstObservedAt);
            lastObservedAt(model.lastObservedAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            severityProduct(model.severityProduct);
            severityNormalized(model.severityNormalized);
            severityLabel(model.severityLabel);
            confidence(model.confidence);
            criticality(model.criticality);
            title(model.title);
            description(model.description);
            recommendationText(model.recommendationText);
            sourceUrl(model.sourceUrl);
            productFields(model.productFields);
            productName(model.productName);
            companyName(model.companyName);
            userDefinedFields(model.userDefinedFields);
            malwareName(model.malwareName);
            malwareType(model.malwareType);
            malwarePath(model.malwarePath);
            malwareState(model.malwareState);
            networkDirection(model.networkDirection);
            networkProtocol(model.networkProtocol);
            networkSourceIpV4(model.networkSourceIpV4);
            networkSourceIpV6(model.networkSourceIpV6);
            networkSourcePort(model.networkSourcePort);
            networkSourceDomain(model.networkSourceDomain);
            networkSourceMac(model.networkSourceMac);
            networkDestinationIpV4(model.networkDestinationIpV4);
            networkDestinationIpV6(model.networkDestinationIpV6);
            networkDestinationPort(model.networkDestinationPort);
            networkDestinationDomain(model.networkDestinationDomain);
            processName(model.processName);
            processPath(model.processPath);
            processPid(model.processPid);
            processParentPid(model.processParentPid);
            processLaunchedAt(model.processLaunchedAt);
            processTerminatedAt(model.processTerminatedAt);
            threatIntelIndicatorType(model.threatIntelIndicatorType);
            threatIntelIndicatorValue(model.threatIntelIndicatorValue);
            threatIntelIndicatorCategory(model.threatIntelIndicatorCategory);
            threatIntelIndicatorLastObservedAt(model.threatIntelIndicatorLastObservedAt);
            threatIntelIndicatorSource(model.threatIntelIndicatorSource);
            threatIntelIndicatorSourceUrl(model.threatIntelIndicatorSourceUrl);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourcePartition(model.resourcePartition);
            resourceRegion(model.resourceRegion);
            resourceTags(model.resourceTags);
            resourceAwsEc2InstanceType(model.resourceAwsEc2InstanceType);
            resourceAwsEc2InstanceImageId(model.resourceAwsEc2InstanceImageId);
            resourceAwsEc2InstanceIpV4Addresses(model.resourceAwsEc2InstanceIpV4Addresses);
            resourceAwsEc2InstanceIpV6Addresses(model.resourceAwsEc2InstanceIpV6Addresses);
            resourceAwsEc2InstanceKeyName(model.resourceAwsEc2InstanceKeyName);
            resourceAwsEc2InstanceIamInstanceProfileArn(model.resourceAwsEc2InstanceIamInstanceProfileArn);
            resourceAwsEc2InstanceVpcId(model.resourceAwsEc2InstanceVpcId);
            resourceAwsEc2InstanceSubnetId(model.resourceAwsEc2InstanceSubnetId);
            resourceAwsEc2InstanceLaunchedAt(model.resourceAwsEc2InstanceLaunchedAt);
            resourceAwsS3BucketOwnerId(model.resourceAwsS3BucketOwnerId);
            resourceAwsS3BucketOwnerName(model.resourceAwsS3BucketOwnerName);
            resourceAwsIamAccessKeyUserName(model.resourceAwsIamAccessKeyUserName);
            resourceAwsIamAccessKeyStatus(model.resourceAwsIamAccessKeyStatus);
            resourceAwsIamAccessKeyCreatedAt(model.resourceAwsIamAccessKeyCreatedAt);
            resourceContainerName(model.resourceContainerName);
            resourceContainerImageId(model.resourceContainerImageId);
            resourceContainerImageName(model.resourceContainerImageName);
            resourceContainerLaunchedAt(model.resourceContainerLaunchedAt);
            resourceDetailsOther(model.resourceDetailsOther);
            complianceStatus(model.complianceStatus);
            verificationState(model.verificationState);
            workflowState(model.workflowState);
            recordState(model.recordState);
            relatedFindingsProductArn(model.relatedFindingsProductArn);
            relatedFindingsId(model.relatedFindingsId);
            noteText(model.noteText);
            noteUpdatedAt(model.noteUpdatedAt);
            noteUpdatedBy(model.noteUpdatedBy);
            keyword(model.keyword);
        }

        public final Collection<StringFilter.Builder> getProductArn() {
            return productArn != null ? productArn.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productArn(Collection<StringFilter> productArn) {
            this.productArn = StringFilterListCopier.copy(productArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productArn(StringFilter... productArn) {
            productArn(Arrays.asList(productArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productArn(Consumer<StringFilter.Builder>... productArn) {
            productArn(Stream.of(productArn).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductArn(Collection<StringFilter.BuilderImpl> productArn) {
            this.productArn = StringFilterListCopier.copyFromBuilder(productArn);
        }

        public final Collection<StringFilter.Builder> getAwsAccountId() {
            return awsAccountId != null ? awsAccountId.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsAccountId(Collection<StringFilter> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copy(awsAccountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(StringFilter... awsAccountId) {
            awsAccountId(Arrays.asList(awsAccountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId) {
            awsAccountId(Stream.of(awsAccountId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAwsAccountId(Collection<StringFilter.BuilderImpl> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copyFromBuilder(awsAccountId);
        }

        public final Collection<StringFilter.Builder> getId() {
            return id != null ? id.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder id(Collection<StringFilter> id) {
            this.id = StringFilterListCopier.copy(id);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id(StringFilter... id) {
            id(Arrays.asList(id));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id(Consumer<StringFilter.Builder>... id) {
            id(Stream.of(id).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setId(Collection<StringFilter.BuilderImpl> id) {
            this.id = StringFilterListCopier.copyFromBuilder(id);
        }

        public final Collection<StringFilter.Builder> getGeneratorId() {
            return generatorId != null ? generatorId.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder generatorId(Collection<StringFilter> generatorId) {
            this.generatorId = StringFilterListCopier.copy(generatorId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatorId(StringFilter... generatorId) {
            generatorId(Arrays.asList(generatorId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatorId(Consumer<StringFilter.Builder>... generatorId) {
            generatorId(Stream.of(generatorId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGeneratorId(Collection<StringFilter.BuilderImpl> generatorId) {
            this.generatorId = StringFilterListCopier.copyFromBuilder(generatorId);
        }

        public final Collection<StringFilter.Builder> getType() {
            return type != null ? type.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder type(Collection<StringFilter> type) {
            this.type = StringFilterListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(StringFilter... type) {
            type(Arrays.asList(type));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(Consumer<StringFilter.Builder>... type) {
            type(Stream.of(type).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setType(Collection<StringFilter.BuilderImpl> type) {
            this.type = StringFilterListCopier.copyFromBuilder(type);
        }

        public final Collection<DateFilter.Builder> getFirstObservedAt() {
            return firstObservedAt != null ? firstObservedAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder firstObservedAt(Collection<DateFilter> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copy(firstObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(DateFilter... firstObservedAt) {
            firstObservedAt(Arrays.asList(firstObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt) {
            firstObservedAt(Stream.of(firstObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFirstObservedAt(Collection<DateFilter.BuilderImpl> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copyFromBuilder(firstObservedAt);
        }

        public final Collection<DateFilter.Builder> getLastObservedAt() {
            return lastObservedAt != null ? lastObservedAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder lastObservedAt(Collection<DateFilter> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copy(lastObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(DateFilter... lastObservedAt) {
            lastObservedAt(Arrays.asList(lastObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt) {
            lastObservedAt(Stream.of(lastObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLastObservedAt(Collection<DateFilter.BuilderImpl> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copyFromBuilder(lastObservedAt);
        }

        public final Collection<DateFilter.Builder> getCreatedAt() {
            return createdAt != null ? createdAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createdAt(Collection<DateFilter> createdAt) {
            this.createdAt = DateFilterListCopier.copy(createdAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdAt(DateFilter... createdAt) {
            createdAt(Arrays.asList(createdAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdAt(Consumer<DateFilter.Builder>... createdAt) {
            createdAt(Stream.of(createdAt).map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreatedAt(Collection<DateFilter.BuilderImpl> createdAt) {
            this.createdAt = DateFilterListCopier.copyFromBuilder(createdAt);
        }

        public final Collection<DateFilter.Builder> getUpdatedAt() {
            return updatedAt != null ? updatedAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updatedAt(Collection<DateFilter> updatedAt) {
            this.updatedAt = DateFilterListCopier.copy(updatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(DateFilter... updatedAt) {
            updatedAt(Arrays.asList(updatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt) {
            updatedAt(Stream.of(updatedAt).map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdatedAt(Collection<DateFilter.BuilderImpl> updatedAt) {
            this.updatedAt = DateFilterListCopier.copyFromBuilder(updatedAt);
        }

        public final Collection<NumberFilter.Builder> getSeverityProduct() {
            return severityProduct != null ? severityProduct.stream().map(NumberFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder severityProduct(Collection<NumberFilter> severityProduct) {
            this.severityProduct = NumberFilterListCopier.copy(severityProduct);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityProduct(NumberFilter... severityProduct) {
            severityProduct(Arrays.asList(severityProduct));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityProduct(Consumer<NumberFilter.Builder>... severityProduct) {
            severityProduct(Stream.of(severityProduct).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityProduct(Collection<NumberFilter.BuilderImpl> severityProduct) {
            this.severityProduct = NumberFilterListCopier.copyFromBuilder(severityProduct);
        }

        public final Collection<NumberFilter.Builder> getSeverityNormalized() {
            return severityNormalized != null ? severityNormalized.stream().map(NumberFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder severityNormalized(Collection<NumberFilter> severityNormalized) {
            this.severityNormalized = NumberFilterListCopier.copy(severityNormalized);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityNormalized(NumberFilter... severityNormalized) {
            severityNormalized(Arrays.asList(severityNormalized));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityNormalized(Consumer<NumberFilter.Builder>... severityNormalized) {
            severityNormalized(Stream.of(severityNormalized).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityNormalized(Collection<NumberFilter.BuilderImpl> severityNormalized) {
            this.severityNormalized = NumberFilterListCopier.copyFromBuilder(severityNormalized);
        }

        public final Collection<StringFilter.Builder> getSeverityLabel() {
            return severityLabel != null ? severityLabel.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder severityLabel(Collection<StringFilter> severityLabel) {
            this.severityLabel = StringFilterListCopier.copy(severityLabel);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLabel(StringFilter... severityLabel) {
            severityLabel(Arrays.asList(severityLabel));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLabel(Consumer<StringFilter.Builder>... severityLabel) {
            severityLabel(Stream.of(severityLabel).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityLabel(Collection<StringFilter.BuilderImpl> severityLabel) {
            this.severityLabel = StringFilterListCopier.copyFromBuilder(severityLabel);
        }

        public final Collection<NumberFilter.Builder> getConfidence() {
            return confidence != null ? confidence.stream().map(NumberFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder confidence(Collection<NumberFilter> confidence) {
            this.confidence = NumberFilterListCopier.copy(confidence);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder confidence(NumberFilter... confidence) {
            confidence(Arrays.asList(confidence));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder confidence(Consumer<NumberFilter.Builder>... confidence) {
            confidence(Stream.of(confidence).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfidence(Collection<NumberFilter.BuilderImpl> confidence) {
            this.confidence = NumberFilterListCopier.copyFromBuilder(confidence);
        }

        public final Collection<NumberFilter.Builder> getCriticality() {
            return criticality != null ? criticality.stream().map(NumberFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder criticality(Collection<NumberFilter> criticality) {
            this.criticality = NumberFilterListCopier.copy(criticality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criticality(NumberFilter... criticality) {
            criticality(Arrays.asList(criticality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criticality(Consumer<NumberFilter.Builder>... criticality) {
            criticality(Stream.of(criticality).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCriticality(Collection<NumberFilter.BuilderImpl> criticality) {
            this.criticality = NumberFilterListCopier.copyFromBuilder(criticality);
        }

        public final Collection<StringFilter.Builder> getTitle() {
            return title != null ? title.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder title(Collection<StringFilter> title) {
            this.title = StringFilterListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(StringFilter... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<StringFilter.Builder>... title) {
            title(Stream.of(title).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTitle(Collection<StringFilter.BuilderImpl> title) {
            this.title = StringFilterListCopier.copyFromBuilder(title);
        }

        public final Collection<StringFilter.Builder> getDescription() {
            return description != null ? description.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder description(Collection<StringFilter> description) {
            this.description = StringFilterListCopier.copy(description);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder description(StringFilter... description) {
            description(Arrays.asList(description));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder description(Consumer<StringFilter.Builder>... description) {
            description(Stream.of(description).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDescription(Collection<StringFilter.BuilderImpl> description) {
            this.description = StringFilterListCopier.copyFromBuilder(description);
        }

        public final Collection<StringFilter.Builder> getRecommendationText() {
            return recommendationText != null ? recommendationText.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationText(Collection<StringFilter> recommendationText) {
            this.recommendationText = StringFilterListCopier.copy(recommendationText);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationText(StringFilter... recommendationText) {
            recommendationText(Arrays.asList(recommendationText));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationText(Consumer<StringFilter.Builder>... recommendationText) {
            recommendationText(Stream.of(recommendationText).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationText(Collection<StringFilter.BuilderImpl> recommendationText) {
            this.recommendationText = StringFilterListCopier.copyFromBuilder(recommendationText);
        }

        public final Collection<StringFilter.Builder> getSourceUrl() {
            return sourceUrl != null ? sourceUrl.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceUrl(Collection<StringFilter> sourceUrl) {
            this.sourceUrl = StringFilterListCopier.copy(sourceUrl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceUrl(StringFilter... sourceUrl) {
            sourceUrl(Arrays.asList(sourceUrl));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceUrl(Consumer<StringFilter.Builder>... sourceUrl) {
            sourceUrl(Stream.of(sourceUrl).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceUrl(Collection<StringFilter.BuilderImpl> sourceUrl) {
            this.sourceUrl = StringFilterListCopier.copyFromBuilder(sourceUrl);
        }

        public final Collection<MapFilter.Builder> getProductFields() {
            return productFields != null ? productFields.stream().map(MapFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productFields(Collection<MapFilter> productFields) {
            this.productFields = MapFilterListCopier.copy(productFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productFields(MapFilter... productFields) {
            productFields(Arrays.asList(productFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productFields(Consumer<MapFilter.Builder>... productFields) {
            productFields(Stream.of(productFields).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductFields(Collection<MapFilter.BuilderImpl> productFields) {
            this.productFields = MapFilterListCopier.copyFromBuilder(productFields);
        }

        public final Collection<StringFilter.Builder> getProductName() {
            return productName != null ? productName.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productName(Collection<StringFilter> productName) {
            this.productName = StringFilterListCopier.copy(productName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productName(StringFilter... productName) {
            productName(Arrays.asList(productName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productName(Consumer<StringFilter.Builder>... productName) {
            productName(Stream.of(productName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductName(Collection<StringFilter.BuilderImpl> productName) {
            this.productName = StringFilterListCopier.copyFromBuilder(productName);
        }

        public final Collection<StringFilter.Builder> getCompanyName() {
            return companyName != null ? companyName.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder companyName(Collection<StringFilter> companyName) {
            this.companyName = StringFilterListCopier.copy(companyName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder companyName(StringFilter... companyName) {
            companyName(Arrays.asList(companyName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder companyName(Consumer<StringFilter.Builder>... companyName) {
            companyName(Stream.of(companyName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCompanyName(Collection<StringFilter.BuilderImpl> companyName) {
            this.companyName = StringFilterListCopier.copyFromBuilder(companyName);
        }

        public final Collection<MapFilter.Builder> getUserDefinedFields() {
            return userDefinedFields != null ? userDefinedFields.stream().map(MapFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder userDefinedFields(Collection<MapFilter> userDefinedFields) {
            this.userDefinedFields = MapFilterListCopier.copy(userDefinedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFields(MapFilter... userDefinedFields) {
            userDefinedFields(Arrays.asList(userDefinedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFields(Consumer<MapFilter.Builder>... userDefinedFields) {
            userDefinedFields(Stream.of(userDefinedFields).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserDefinedFields(Collection<MapFilter.BuilderImpl> userDefinedFields) {
            this.userDefinedFields = MapFilterListCopier.copyFromBuilder(userDefinedFields);
        }

        public final Collection<StringFilter.Builder> getMalwareName() {
            return malwareName != null ? malwareName.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder malwareName(Collection<StringFilter> malwareName) {
            this.malwareName = StringFilterListCopier.copy(malwareName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareName(StringFilter... malwareName) {
            malwareName(Arrays.asList(malwareName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareName(Consumer<StringFilter.Builder>... malwareName) {
            malwareName(Stream.of(malwareName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMalwareName(Collection<StringFilter.BuilderImpl> malwareName) {
            this.malwareName = StringFilterListCopier.copyFromBuilder(malwareName);
        }

        public final Collection<StringFilter.Builder> getMalwareType() {
            return malwareType != null ? malwareType.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder malwareType(Collection<StringFilter> malwareType) {
            this.malwareType = StringFilterListCopier.copy(malwareType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareType(StringFilter... malwareType) {
            malwareType(Arrays.asList(malwareType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareType(Consumer<StringFilter.Builder>... malwareType) {
            malwareType(Stream.of(malwareType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMalwareType(Collection<StringFilter.BuilderImpl> malwareType) {
            this.malwareType = StringFilterListCopier.copyFromBuilder(malwareType);
        }

        public final Collection<StringFilter.Builder> getMalwarePath() {
            return malwarePath != null ? malwarePath.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder malwarePath(Collection<StringFilter> malwarePath) {
            this.malwarePath = StringFilterListCopier.copy(malwarePath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwarePath(StringFilter... malwarePath) {
            malwarePath(Arrays.asList(malwarePath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwarePath(Consumer<StringFilter.Builder>... malwarePath) {
            malwarePath(Stream.of(malwarePath).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMalwarePath(Collection<StringFilter.BuilderImpl> malwarePath) {
            this.malwarePath = StringFilterListCopier.copyFromBuilder(malwarePath);
        }

        public final Collection<StringFilter.Builder> getMalwareState() {
            return malwareState != null ? malwareState.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder malwareState(Collection<StringFilter> malwareState) {
            this.malwareState = StringFilterListCopier.copy(malwareState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareState(StringFilter... malwareState) {
            malwareState(Arrays.asList(malwareState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareState(Consumer<StringFilter.Builder>... malwareState) {
            malwareState(Stream.of(malwareState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMalwareState(Collection<StringFilter.BuilderImpl> malwareState) {
            this.malwareState = StringFilterListCopier.copyFromBuilder(malwareState);
        }

        public final Collection<StringFilter.Builder> getNetworkDirection() {
            return networkDirection != null ? networkDirection.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkDirection(Collection<StringFilter> networkDirection) {
            this.networkDirection = StringFilterListCopier.copy(networkDirection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDirection(StringFilter... networkDirection) {
            networkDirection(Arrays.asList(networkDirection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDirection(Consumer<StringFilter.Builder>... networkDirection) {
            networkDirection(Stream.of(networkDirection).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkDirection(Collection<StringFilter.BuilderImpl> networkDirection) {
            this.networkDirection = StringFilterListCopier.copyFromBuilder(networkDirection);
        }

        public final Collection<StringFilter.Builder> getNetworkProtocol() {
            return networkProtocol != null ? networkProtocol.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkProtocol(Collection<StringFilter> networkProtocol) {
            this.networkProtocol = StringFilterListCopier.copy(networkProtocol);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProtocol(StringFilter... networkProtocol) {
            networkProtocol(Arrays.asList(networkProtocol));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProtocol(Consumer<StringFilter.Builder>... networkProtocol) {
            networkProtocol(Stream.of(networkProtocol).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkProtocol(Collection<StringFilter.BuilderImpl> networkProtocol) {
            this.networkProtocol = StringFilterListCopier.copyFromBuilder(networkProtocol);
        }

        public final Collection<IpFilter.Builder> getNetworkSourceIpV4() {
            return networkSourceIpV4 != null ? networkSourceIpV4.stream().map(IpFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkSourceIpV4(Collection<IpFilter> networkSourceIpV4) {
            this.networkSourceIpV4 = IpFilterListCopier.copy(networkSourceIpV4);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceIpV4(IpFilter... networkSourceIpV4) {
            networkSourceIpV4(Arrays.asList(networkSourceIpV4));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceIpV4(Consumer<IpFilter.Builder>... networkSourceIpV4) {
            networkSourceIpV4(Stream.of(networkSourceIpV4).map(c -> IpFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkSourceIpV4(Collection<IpFilter.BuilderImpl> networkSourceIpV4) {
            this.networkSourceIpV4 = IpFilterListCopier.copyFromBuilder(networkSourceIpV4);
        }

        public final Collection<IpFilter.Builder> getNetworkSourceIpV6() {
            return networkSourceIpV6 != null ? networkSourceIpV6.stream().map(IpFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkSourceIpV6(Collection<IpFilter> networkSourceIpV6) {
            this.networkSourceIpV6 = IpFilterListCopier.copy(networkSourceIpV6);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceIpV6(IpFilter... networkSourceIpV6) {
            networkSourceIpV6(Arrays.asList(networkSourceIpV6));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceIpV6(Consumer<IpFilter.Builder>... networkSourceIpV6) {
            networkSourceIpV6(Stream.of(networkSourceIpV6).map(c -> IpFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkSourceIpV6(Collection<IpFilter.BuilderImpl> networkSourceIpV6) {
            this.networkSourceIpV6 = IpFilterListCopier.copyFromBuilder(networkSourceIpV6);
        }

        public final Collection<NumberFilter.Builder> getNetworkSourcePort() {
            return networkSourcePort != null ? networkSourcePort.stream().map(NumberFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkSourcePort(Collection<NumberFilter> networkSourcePort) {
            this.networkSourcePort = NumberFilterListCopier.copy(networkSourcePort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourcePort(NumberFilter... networkSourcePort) {
            networkSourcePort(Arrays.asList(networkSourcePort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourcePort(Consumer<NumberFilter.Builder>... networkSourcePort) {
            networkSourcePort(Stream.of(networkSourcePort).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkSourcePort(Collection<NumberFilter.BuilderImpl> networkSourcePort) {
            this.networkSourcePort = NumberFilterListCopier.copyFromBuilder(networkSourcePort);
        }

        public final Collection<StringFilter.Builder> getNetworkSourceDomain() {
            return networkSourceDomain != null ? networkSourceDomain.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkSourceDomain(Collection<StringFilter> networkSourceDomain) {
            this.networkSourceDomain = StringFilterListCopier.copy(networkSourceDomain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceDomain(StringFilter... networkSourceDomain) {
            networkSourceDomain(Arrays.asList(networkSourceDomain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceDomain(Consumer<StringFilter.Builder>... networkSourceDomain) {
            networkSourceDomain(Stream.of(networkSourceDomain).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkSourceDomain(Collection<StringFilter.BuilderImpl> networkSourceDomain) {
            this.networkSourceDomain = StringFilterListCopier.copyFromBuilder(networkSourceDomain);
        }

        public final Collection<StringFilter.Builder> getNetworkSourceMac() {
            return networkSourceMac != null ? networkSourceMac.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkSourceMac(Collection<StringFilter> networkSourceMac) {
            this.networkSourceMac = StringFilterListCopier.copy(networkSourceMac);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceMac(StringFilter... networkSourceMac) {
            networkSourceMac(Arrays.asList(networkSourceMac));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSourceMac(Consumer<StringFilter.Builder>... networkSourceMac) {
            networkSourceMac(Stream.of(networkSourceMac).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkSourceMac(Collection<StringFilter.BuilderImpl> networkSourceMac) {
            this.networkSourceMac = StringFilterListCopier.copyFromBuilder(networkSourceMac);
        }

        public final Collection<IpFilter.Builder> getNetworkDestinationIpV4() {
            return networkDestinationIpV4 != null ? networkDestinationIpV4.stream().map(IpFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkDestinationIpV4(Collection<IpFilter> networkDestinationIpV4) {
            this.networkDestinationIpV4 = IpFilterListCopier.copy(networkDestinationIpV4);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationIpV4(IpFilter... networkDestinationIpV4) {
            networkDestinationIpV4(Arrays.asList(networkDestinationIpV4));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationIpV4(Consumer<IpFilter.Builder>... networkDestinationIpV4) {
            networkDestinationIpV4(Stream.of(networkDestinationIpV4).map(c -> IpFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkDestinationIpV4(Collection<IpFilter.BuilderImpl> networkDestinationIpV4) {
            this.networkDestinationIpV4 = IpFilterListCopier.copyFromBuilder(networkDestinationIpV4);
        }

        public final Collection<IpFilter.Builder> getNetworkDestinationIpV6() {
            return networkDestinationIpV6 != null ? networkDestinationIpV6.stream().map(IpFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkDestinationIpV6(Collection<IpFilter> networkDestinationIpV6) {
            this.networkDestinationIpV6 = IpFilterListCopier.copy(networkDestinationIpV6);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationIpV6(IpFilter... networkDestinationIpV6) {
            networkDestinationIpV6(Arrays.asList(networkDestinationIpV6));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationIpV6(Consumer<IpFilter.Builder>... networkDestinationIpV6) {
            networkDestinationIpV6(Stream.of(networkDestinationIpV6).map(c -> IpFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkDestinationIpV6(Collection<IpFilter.BuilderImpl> networkDestinationIpV6) {
            this.networkDestinationIpV6 = IpFilterListCopier.copyFromBuilder(networkDestinationIpV6);
        }

        public final Collection<NumberFilter.Builder> getNetworkDestinationPort() {
            return networkDestinationPort != null ? networkDestinationPort.stream().map(NumberFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkDestinationPort(Collection<NumberFilter> networkDestinationPort) {
            this.networkDestinationPort = NumberFilterListCopier.copy(networkDestinationPort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationPort(NumberFilter... networkDestinationPort) {
            networkDestinationPort(Arrays.asList(networkDestinationPort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationPort(Consumer<NumberFilter.Builder>... networkDestinationPort) {
            networkDestinationPort(Stream.of(networkDestinationPort).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkDestinationPort(Collection<NumberFilter.BuilderImpl> networkDestinationPort) {
            this.networkDestinationPort = NumberFilterListCopier.copyFromBuilder(networkDestinationPort);
        }

        public final Collection<StringFilter.Builder> getNetworkDestinationDomain() {
            return networkDestinationDomain != null ? networkDestinationDomain.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkDestinationDomain(Collection<StringFilter> networkDestinationDomain) {
            this.networkDestinationDomain = StringFilterListCopier.copy(networkDestinationDomain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationDomain(StringFilter... networkDestinationDomain) {
            networkDestinationDomain(Arrays.asList(networkDestinationDomain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkDestinationDomain(Consumer<StringFilter.Builder>... networkDestinationDomain) {
            networkDestinationDomain(Stream.of(networkDestinationDomain)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkDestinationDomain(Collection<StringFilter.BuilderImpl> networkDestinationDomain) {
            this.networkDestinationDomain = StringFilterListCopier.copyFromBuilder(networkDestinationDomain);
        }

        public final Collection<StringFilter.Builder> getProcessName() {
            return processName != null ? processName.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processName(Collection<StringFilter> processName) {
            this.processName = StringFilterListCopier.copy(processName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processName(StringFilter... processName) {
            processName(Arrays.asList(processName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processName(Consumer<StringFilter.Builder>... processName) {
            processName(Stream.of(processName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessName(Collection<StringFilter.BuilderImpl> processName) {
            this.processName = StringFilterListCopier.copyFromBuilder(processName);
        }

        public final Collection<StringFilter.Builder> getProcessPath() {
            return processPath != null ? processPath.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processPath(Collection<StringFilter> processPath) {
            this.processPath = StringFilterListCopier.copy(processPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processPath(StringFilter... processPath) {
            processPath(Arrays.asList(processPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processPath(Consumer<StringFilter.Builder>... processPath) {
            processPath(Stream.of(processPath).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessPath(Collection<StringFilter.BuilderImpl> processPath) {
            this.processPath = StringFilterListCopier.copyFromBuilder(processPath);
        }

        public final Collection<NumberFilter.Builder> getProcessPid() {
            return processPid != null ? processPid.stream().map(NumberFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processPid(Collection<NumberFilter> processPid) {
            this.processPid = NumberFilterListCopier.copy(processPid);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processPid(NumberFilter... processPid) {
            processPid(Arrays.asList(processPid));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processPid(Consumer<NumberFilter.Builder>... processPid) {
            processPid(Stream.of(processPid).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessPid(Collection<NumberFilter.BuilderImpl> processPid) {
            this.processPid = NumberFilterListCopier.copyFromBuilder(processPid);
        }

        public final Collection<NumberFilter.Builder> getProcessParentPid() {
            return processParentPid != null ? processParentPid.stream().map(NumberFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder processParentPid(Collection<NumberFilter> processParentPid) {
            this.processParentPid = NumberFilterListCopier.copy(processParentPid);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processParentPid(NumberFilter... processParentPid) {
            processParentPid(Arrays.asList(processParentPid));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processParentPid(Consumer<NumberFilter.Builder>... processParentPid) {
            processParentPid(Stream.of(processParentPid).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessParentPid(Collection<NumberFilter.BuilderImpl> processParentPid) {
            this.processParentPid = NumberFilterListCopier.copyFromBuilder(processParentPid);
        }

        public final Collection<DateFilter.Builder> getProcessLaunchedAt() {
            return processLaunchedAt != null ? processLaunchedAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder processLaunchedAt(Collection<DateFilter> processLaunchedAt) {
            this.processLaunchedAt = DateFilterListCopier.copy(processLaunchedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processLaunchedAt(DateFilter... processLaunchedAt) {
            processLaunchedAt(Arrays.asList(processLaunchedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processLaunchedAt(Consumer<DateFilter.Builder>... processLaunchedAt) {
            processLaunchedAt(Stream.of(processLaunchedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessLaunchedAt(Collection<DateFilter.BuilderImpl> processLaunchedAt) {
            this.processLaunchedAt = DateFilterListCopier.copyFromBuilder(processLaunchedAt);
        }

        public final Collection<DateFilter.Builder> getProcessTerminatedAt() {
            return processTerminatedAt != null ? processTerminatedAt.stream().map(DateFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processTerminatedAt(Collection<DateFilter> processTerminatedAt) {
            this.processTerminatedAt = DateFilterListCopier.copy(processTerminatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processTerminatedAt(DateFilter... processTerminatedAt) {
            processTerminatedAt(Arrays.asList(processTerminatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processTerminatedAt(Consumer<DateFilter.Builder>... processTerminatedAt) {
            processTerminatedAt(Stream.of(processTerminatedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessTerminatedAt(Collection<DateFilter.BuilderImpl> processTerminatedAt) {
            this.processTerminatedAt = DateFilterListCopier.copyFromBuilder(processTerminatedAt);
        }

        public final Collection<StringFilter.Builder> getThreatIntelIndicatorType() {
            return threatIntelIndicatorType != null ? threatIntelIndicatorType.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorType(Collection<StringFilter> threatIntelIndicatorType) {
            this.threatIntelIndicatorType = StringFilterListCopier.copy(threatIntelIndicatorType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorType(StringFilter... threatIntelIndicatorType) {
            threatIntelIndicatorType(Arrays.asList(threatIntelIndicatorType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorType(Consumer<StringFilter.Builder>... threatIntelIndicatorType) {
            threatIntelIndicatorType(Stream.of(threatIntelIndicatorType)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorType(Collection<StringFilter.BuilderImpl> threatIntelIndicatorType) {
            this.threatIntelIndicatorType = StringFilterListCopier.copyFromBuilder(threatIntelIndicatorType);
        }

        public final Collection<StringFilter.Builder> getThreatIntelIndicatorValue() {
            return threatIntelIndicatorValue != null ? threatIntelIndicatorValue.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorValue(Collection<StringFilter> threatIntelIndicatorValue) {
            this.threatIntelIndicatorValue = StringFilterListCopier.copy(threatIntelIndicatorValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorValue(StringFilter... threatIntelIndicatorValue) {
            threatIntelIndicatorValue(Arrays.asList(threatIntelIndicatorValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorValue(Consumer<StringFilter.Builder>... threatIntelIndicatorValue) {
            threatIntelIndicatorValue(Stream.of(threatIntelIndicatorValue)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorValue(Collection<StringFilter.BuilderImpl> threatIntelIndicatorValue) {
            this.threatIntelIndicatorValue = StringFilterListCopier.copyFromBuilder(threatIntelIndicatorValue);
        }

        public final Collection<StringFilter.Builder> getThreatIntelIndicatorCategory() {
            return threatIntelIndicatorCategory != null ? threatIntelIndicatorCategory.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorCategory(Collection<StringFilter> threatIntelIndicatorCategory) {
            this.threatIntelIndicatorCategory = StringFilterListCopier.copy(threatIntelIndicatorCategory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorCategory(StringFilter... threatIntelIndicatorCategory) {
            threatIntelIndicatorCategory(Arrays.asList(threatIntelIndicatorCategory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorCategory(Consumer<StringFilter.Builder>... threatIntelIndicatorCategory) {
            threatIntelIndicatorCategory(Stream.of(threatIntelIndicatorCategory)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorCategory(Collection<StringFilter.BuilderImpl> threatIntelIndicatorCategory) {
            this.threatIntelIndicatorCategory = StringFilterListCopier.copyFromBuilder(threatIntelIndicatorCategory);
        }

        public final Collection<DateFilter.Builder> getThreatIntelIndicatorLastObservedAt() {
            return threatIntelIndicatorLastObservedAt != null ? threatIntelIndicatorLastObservedAt.stream()
                    .map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorLastObservedAt(Collection<DateFilter> threatIntelIndicatorLastObservedAt) {
            this.threatIntelIndicatorLastObservedAt = DateFilterListCopier.copy(threatIntelIndicatorLastObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorLastObservedAt(DateFilter... threatIntelIndicatorLastObservedAt) {
            threatIntelIndicatorLastObservedAt(Arrays.asList(threatIntelIndicatorLastObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorLastObservedAt(
                Consumer<DateFilter.Builder>... threatIntelIndicatorLastObservedAt) {
            threatIntelIndicatorLastObservedAt(Stream.of(threatIntelIndicatorLastObservedAt)
                    .map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorLastObservedAt(
                Collection<DateFilter.BuilderImpl> threatIntelIndicatorLastObservedAt) {
            this.threatIntelIndicatorLastObservedAt = DateFilterListCopier.copyFromBuilder(threatIntelIndicatorLastObservedAt);
        }

        public final Collection<StringFilter.Builder> getThreatIntelIndicatorSource() {
            return threatIntelIndicatorSource != null ? threatIntelIndicatorSource.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorSource(Collection<StringFilter> threatIntelIndicatorSource) {
            this.threatIntelIndicatorSource = StringFilterListCopier.copy(threatIntelIndicatorSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorSource(StringFilter... threatIntelIndicatorSource) {
            threatIntelIndicatorSource(Arrays.asList(threatIntelIndicatorSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorSource(Consumer<StringFilter.Builder>... threatIntelIndicatorSource) {
            threatIntelIndicatorSource(Stream.of(threatIntelIndicatorSource)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorSource(Collection<StringFilter.BuilderImpl> threatIntelIndicatorSource) {
            this.threatIntelIndicatorSource = StringFilterListCopier.copyFromBuilder(threatIntelIndicatorSource);
        }

        public final Collection<StringFilter.Builder> getThreatIntelIndicatorSourceUrl() {
            return threatIntelIndicatorSourceUrl != null ? threatIntelIndicatorSourceUrl.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicatorSourceUrl(Collection<StringFilter> threatIntelIndicatorSourceUrl) {
            this.threatIntelIndicatorSourceUrl = StringFilterListCopier.copy(threatIntelIndicatorSourceUrl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorSourceUrl(StringFilter... threatIntelIndicatorSourceUrl) {
            threatIntelIndicatorSourceUrl(Arrays.asList(threatIntelIndicatorSourceUrl));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicatorSourceUrl(Consumer<StringFilter.Builder>... threatIntelIndicatorSourceUrl) {
            threatIntelIndicatorSourceUrl(Stream.of(threatIntelIndicatorSourceUrl)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicatorSourceUrl(Collection<StringFilter.BuilderImpl> threatIntelIndicatorSourceUrl) {
            this.threatIntelIndicatorSourceUrl = StringFilterListCopier.copyFromBuilder(threatIntelIndicatorSourceUrl);
        }

        public final Collection<StringFilter.Builder> getResourceType() {
            return resourceType != null ? resourceType.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceType(Collection<StringFilter> resourceType) {
            this.resourceType = StringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(StringFilter... resourceType) {
            resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<StringFilter.Builder>... resourceType) {
            resourceType(Stream.of(resourceType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceType(Collection<StringFilter.BuilderImpl> resourceType) {
            this.resourceType = StringFilterListCopier.copyFromBuilder(resourceType);
        }

        public final Collection<StringFilter.Builder> getResourceId() {
            return resourceId != null ? resourceId.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceId(Collection<StringFilter> resourceId) {
            this.resourceId = StringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(StringFilter... resourceId) {
            resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<StringFilter.Builder>... resourceId) {
            resourceId(Stream.of(resourceId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceId(Collection<StringFilter.BuilderImpl> resourceId) {
            this.resourceId = StringFilterListCopier.copyFromBuilder(resourceId);
        }

        public final Collection<StringFilter.Builder> getResourcePartition() {
            return resourcePartition != null ? resourcePartition.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourcePartition(Collection<StringFilter> resourcePartition) {
            this.resourcePartition = StringFilterListCopier.copy(resourcePartition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePartition(StringFilter... resourcePartition) {
            resourcePartition(Arrays.asList(resourcePartition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePartition(Consumer<StringFilter.Builder>... resourcePartition) {
            resourcePartition(Stream.of(resourcePartition).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourcePartition(Collection<StringFilter.BuilderImpl> resourcePartition) {
            this.resourcePartition = StringFilterListCopier.copyFromBuilder(resourcePartition);
        }

        public final Collection<StringFilter.Builder> getResourceRegion() {
            return resourceRegion != null ? resourceRegion.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourceRegion(Collection<StringFilter> resourceRegion) {
            this.resourceRegion = StringFilterListCopier.copy(resourceRegion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRegion(StringFilter... resourceRegion) {
            resourceRegion(Arrays.asList(resourceRegion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRegion(Consumer<StringFilter.Builder>... resourceRegion) {
            resourceRegion(Stream.of(resourceRegion).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRegion(Collection<StringFilter.BuilderImpl> resourceRegion) {
            this.resourceRegion = StringFilterListCopier.copyFromBuilder(resourceRegion);
        }

        public final Collection<MapFilter.Builder> getResourceTags() {
            return resourceTags != null ? resourceTags.stream().map(MapFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTags(Collection<MapFilter> resourceTags) {
            this.resourceTags = MapFilterListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(MapFilter... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTags(Collection<MapFilter.BuilderImpl> resourceTags) {
            this.resourceTags = MapFilterListCopier.copyFromBuilder(resourceTags);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceType() {
            return resourceAwsEc2InstanceType != null ? resourceAwsEc2InstanceType.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceType(Collection<StringFilter> resourceAwsEc2InstanceType) {
            this.resourceAwsEc2InstanceType = StringFilterListCopier.copy(resourceAwsEc2InstanceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceType(StringFilter... resourceAwsEc2InstanceType) {
            resourceAwsEc2InstanceType(Arrays.asList(resourceAwsEc2InstanceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceType(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceType) {
            resourceAwsEc2InstanceType(Stream.of(resourceAwsEc2InstanceType)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceType(Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceType) {
            this.resourceAwsEc2InstanceType = StringFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceType);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceImageId() {
            return resourceAwsEc2InstanceImageId != null ? resourceAwsEc2InstanceImageId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceImageId(Collection<StringFilter> resourceAwsEc2InstanceImageId) {
            this.resourceAwsEc2InstanceImageId = StringFilterListCopier.copy(resourceAwsEc2InstanceImageId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceImageId(StringFilter... resourceAwsEc2InstanceImageId) {
            resourceAwsEc2InstanceImageId(Arrays.asList(resourceAwsEc2InstanceImageId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceImageId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceImageId) {
            resourceAwsEc2InstanceImageId(Stream.of(resourceAwsEc2InstanceImageId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceImageId(Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceImageId) {
            this.resourceAwsEc2InstanceImageId = StringFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceImageId);
        }

        public final Collection<IpFilter.Builder> getResourceAwsEc2InstanceIpV4Addresses() {
            return resourceAwsEc2InstanceIpV4Addresses != null ? resourceAwsEc2InstanceIpV4Addresses.stream()
                    .map(IpFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceIpV4Addresses(Collection<IpFilter> resourceAwsEc2InstanceIpV4Addresses) {
            this.resourceAwsEc2InstanceIpV4Addresses = IpFilterListCopier.copy(resourceAwsEc2InstanceIpV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIpV4Addresses(IpFilter... resourceAwsEc2InstanceIpV4Addresses) {
            resourceAwsEc2InstanceIpV4Addresses(Arrays.asList(resourceAwsEc2InstanceIpV4Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIpV4Addresses(
                Consumer<IpFilter.Builder>... resourceAwsEc2InstanceIpV4Addresses) {
            resourceAwsEc2InstanceIpV4Addresses(Stream.of(resourceAwsEc2InstanceIpV4Addresses)
                    .map(c -> IpFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceIpV4Addresses(
                Collection<IpFilter.BuilderImpl> resourceAwsEc2InstanceIpV4Addresses) {
            this.resourceAwsEc2InstanceIpV4Addresses = IpFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceIpV4Addresses);
        }

        public final Collection<IpFilter.Builder> getResourceAwsEc2InstanceIpV6Addresses() {
            return resourceAwsEc2InstanceIpV6Addresses != null ? resourceAwsEc2InstanceIpV6Addresses.stream()
                    .map(IpFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceIpV6Addresses(Collection<IpFilter> resourceAwsEc2InstanceIpV6Addresses) {
            this.resourceAwsEc2InstanceIpV6Addresses = IpFilterListCopier.copy(resourceAwsEc2InstanceIpV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIpV6Addresses(IpFilter... resourceAwsEc2InstanceIpV6Addresses) {
            resourceAwsEc2InstanceIpV6Addresses(Arrays.asList(resourceAwsEc2InstanceIpV6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIpV6Addresses(
                Consumer<IpFilter.Builder>... resourceAwsEc2InstanceIpV6Addresses) {
            resourceAwsEc2InstanceIpV6Addresses(Stream.of(resourceAwsEc2InstanceIpV6Addresses)
                    .map(c -> IpFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceIpV6Addresses(
                Collection<IpFilter.BuilderImpl> resourceAwsEc2InstanceIpV6Addresses) {
            this.resourceAwsEc2InstanceIpV6Addresses = IpFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceIpV6Addresses);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceKeyName() {
            return resourceAwsEc2InstanceKeyName != null ? resourceAwsEc2InstanceKeyName.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceKeyName(Collection<StringFilter> resourceAwsEc2InstanceKeyName) {
            this.resourceAwsEc2InstanceKeyName = StringFilterListCopier.copy(resourceAwsEc2InstanceKeyName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceKeyName(StringFilter... resourceAwsEc2InstanceKeyName) {
            resourceAwsEc2InstanceKeyName(Arrays.asList(resourceAwsEc2InstanceKeyName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceKeyName(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceKeyName) {
            resourceAwsEc2InstanceKeyName(Stream.of(resourceAwsEc2InstanceKeyName)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceKeyName(Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceKeyName) {
            this.resourceAwsEc2InstanceKeyName = StringFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceKeyName);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceIamInstanceProfileArn() {
            return resourceAwsEc2InstanceIamInstanceProfileArn != null ? resourceAwsEc2InstanceIamInstanceProfileArn.stream()
                    .map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceIamInstanceProfileArn(
                Collection<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn) {
            this.resourceAwsEc2InstanceIamInstanceProfileArn = StringFilterListCopier
                    .copy(resourceAwsEc2InstanceIamInstanceProfileArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIamInstanceProfileArn(
                StringFilter... resourceAwsEc2InstanceIamInstanceProfileArn) {
            resourceAwsEc2InstanceIamInstanceProfileArn(Arrays.asList(resourceAwsEc2InstanceIamInstanceProfileArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceIamInstanceProfileArn(
                Consumer<StringFilter.Builder>... resourceAwsEc2InstanceIamInstanceProfileArn) {
            resourceAwsEc2InstanceIamInstanceProfileArn(Stream.of(resourceAwsEc2InstanceIamInstanceProfileArn)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceIamInstanceProfileArn(
                Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceIamInstanceProfileArn) {
            this.resourceAwsEc2InstanceIamInstanceProfileArn = StringFilterListCopier
                    .copyFromBuilder(resourceAwsEc2InstanceIamInstanceProfileArn);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceVpcId() {
            return resourceAwsEc2InstanceVpcId != null ? resourceAwsEc2InstanceVpcId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceVpcId(Collection<StringFilter> resourceAwsEc2InstanceVpcId) {
            this.resourceAwsEc2InstanceVpcId = StringFilterListCopier.copy(resourceAwsEc2InstanceVpcId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceVpcId(StringFilter... resourceAwsEc2InstanceVpcId) {
            resourceAwsEc2InstanceVpcId(Arrays.asList(resourceAwsEc2InstanceVpcId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceVpcId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceVpcId) {
            resourceAwsEc2InstanceVpcId(Stream.of(resourceAwsEc2InstanceVpcId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceVpcId(Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceVpcId) {
            this.resourceAwsEc2InstanceVpcId = StringFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceVpcId);
        }

        public final Collection<StringFilter.Builder> getResourceAwsEc2InstanceSubnetId() {
            return resourceAwsEc2InstanceSubnetId != null ? resourceAwsEc2InstanceSubnetId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceSubnetId(Collection<StringFilter> resourceAwsEc2InstanceSubnetId) {
            this.resourceAwsEc2InstanceSubnetId = StringFilterListCopier.copy(resourceAwsEc2InstanceSubnetId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceSubnetId(StringFilter... resourceAwsEc2InstanceSubnetId) {
            resourceAwsEc2InstanceSubnetId(Arrays.asList(resourceAwsEc2InstanceSubnetId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceSubnetId(Consumer<StringFilter.Builder>... resourceAwsEc2InstanceSubnetId) {
            resourceAwsEc2InstanceSubnetId(Stream.of(resourceAwsEc2InstanceSubnetId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceSubnetId(Collection<StringFilter.BuilderImpl> resourceAwsEc2InstanceSubnetId) {
            this.resourceAwsEc2InstanceSubnetId = StringFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceSubnetId);
        }

        public final Collection<DateFilter.Builder> getResourceAwsEc2InstanceLaunchedAt() {
            return resourceAwsEc2InstanceLaunchedAt != null ? resourceAwsEc2InstanceLaunchedAt.stream()
                    .map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsEc2InstanceLaunchedAt(Collection<DateFilter> resourceAwsEc2InstanceLaunchedAt) {
            this.resourceAwsEc2InstanceLaunchedAt = DateFilterListCopier.copy(resourceAwsEc2InstanceLaunchedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceLaunchedAt(DateFilter... resourceAwsEc2InstanceLaunchedAt) {
            resourceAwsEc2InstanceLaunchedAt(Arrays.asList(resourceAwsEc2InstanceLaunchedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsEc2InstanceLaunchedAt(Consumer<DateFilter.Builder>... resourceAwsEc2InstanceLaunchedAt) {
            resourceAwsEc2InstanceLaunchedAt(Stream.of(resourceAwsEc2InstanceLaunchedAt)
                    .map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsEc2InstanceLaunchedAt(Collection<DateFilter.BuilderImpl> resourceAwsEc2InstanceLaunchedAt) {
            this.resourceAwsEc2InstanceLaunchedAt = DateFilterListCopier.copyFromBuilder(resourceAwsEc2InstanceLaunchedAt);
        }

        public final Collection<StringFilter.Builder> getResourceAwsS3BucketOwnerId() {
            return resourceAwsS3BucketOwnerId != null ? resourceAwsS3BucketOwnerId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsS3BucketOwnerId(Collection<StringFilter> resourceAwsS3BucketOwnerId) {
            this.resourceAwsS3BucketOwnerId = StringFilterListCopier.copy(resourceAwsS3BucketOwnerId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsS3BucketOwnerId(StringFilter... resourceAwsS3BucketOwnerId) {
            resourceAwsS3BucketOwnerId(Arrays.asList(resourceAwsS3BucketOwnerId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsS3BucketOwnerId(Consumer<StringFilter.Builder>... resourceAwsS3BucketOwnerId) {
            resourceAwsS3BucketOwnerId(Stream.of(resourceAwsS3BucketOwnerId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsS3BucketOwnerId(Collection<StringFilter.BuilderImpl> resourceAwsS3BucketOwnerId) {
            this.resourceAwsS3BucketOwnerId = StringFilterListCopier.copyFromBuilder(resourceAwsS3BucketOwnerId);
        }

        public final Collection<StringFilter.Builder> getResourceAwsS3BucketOwnerName() {
            return resourceAwsS3BucketOwnerName != null ? resourceAwsS3BucketOwnerName.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsS3BucketOwnerName(Collection<StringFilter> resourceAwsS3BucketOwnerName) {
            this.resourceAwsS3BucketOwnerName = StringFilterListCopier.copy(resourceAwsS3BucketOwnerName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsS3BucketOwnerName(StringFilter... resourceAwsS3BucketOwnerName) {
            resourceAwsS3BucketOwnerName(Arrays.asList(resourceAwsS3BucketOwnerName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsS3BucketOwnerName(Consumer<StringFilter.Builder>... resourceAwsS3BucketOwnerName) {
            resourceAwsS3BucketOwnerName(Stream.of(resourceAwsS3BucketOwnerName)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsS3BucketOwnerName(Collection<StringFilter.BuilderImpl> resourceAwsS3BucketOwnerName) {
            this.resourceAwsS3BucketOwnerName = StringFilterListCopier.copyFromBuilder(resourceAwsS3BucketOwnerName);
        }

        public final Collection<StringFilter.Builder> getResourceAwsIamAccessKeyUserName() {
            return resourceAwsIamAccessKeyUserName != null ? resourceAwsIamAccessKeyUserName.stream()
                    .map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsIamAccessKeyUserName(Collection<StringFilter> resourceAwsIamAccessKeyUserName) {
            this.resourceAwsIamAccessKeyUserName = StringFilterListCopier.copy(resourceAwsIamAccessKeyUserName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyUserName(StringFilter... resourceAwsIamAccessKeyUserName) {
            resourceAwsIamAccessKeyUserName(Arrays.asList(resourceAwsIamAccessKeyUserName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyUserName(Consumer<StringFilter.Builder>... resourceAwsIamAccessKeyUserName) {
            resourceAwsIamAccessKeyUserName(Stream.of(resourceAwsIamAccessKeyUserName)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsIamAccessKeyUserName(Collection<StringFilter.BuilderImpl> resourceAwsIamAccessKeyUserName) {
            this.resourceAwsIamAccessKeyUserName = StringFilterListCopier.copyFromBuilder(resourceAwsIamAccessKeyUserName);
        }

        public final Collection<StringFilter.Builder> getResourceAwsIamAccessKeyStatus() {
            return resourceAwsIamAccessKeyStatus != null ? resourceAwsIamAccessKeyStatus.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsIamAccessKeyStatus(Collection<StringFilter> resourceAwsIamAccessKeyStatus) {
            this.resourceAwsIamAccessKeyStatus = StringFilterListCopier.copy(resourceAwsIamAccessKeyStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyStatus(StringFilter... resourceAwsIamAccessKeyStatus) {
            resourceAwsIamAccessKeyStatus(Arrays.asList(resourceAwsIamAccessKeyStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyStatus(Consumer<StringFilter.Builder>... resourceAwsIamAccessKeyStatus) {
            resourceAwsIamAccessKeyStatus(Stream.of(resourceAwsIamAccessKeyStatus)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsIamAccessKeyStatus(Collection<StringFilter.BuilderImpl> resourceAwsIamAccessKeyStatus) {
            this.resourceAwsIamAccessKeyStatus = StringFilterListCopier.copyFromBuilder(resourceAwsIamAccessKeyStatus);
        }

        public final Collection<DateFilter.Builder> getResourceAwsIamAccessKeyCreatedAt() {
            return resourceAwsIamAccessKeyCreatedAt != null ? resourceAwsIamAccessKeyCreatedAt.stream()
                    .map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAwsIamAccessKeyCreatedAt(Collection<DateFilter> resourceAwsIamAccessKeyCreatedAt) {
            this.resourceAwsIamAccessKeyCreatedAt = DateFilterListCopier.copy(resourceAwsIamAccessKeyCreatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyCreatedAt(DateFilter... resourceAwsIamAccessKeyCreatedAt) {
            resourceAwsIamAccessKeyCreatedAt(Arrays.asList(resourceAwsIamAccessKeyCreatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAwsIamAccessKeyCreatedAt(Consumer<DateFilter.Builder>... resourceAwsIamAccessKeyCreatedAt) {
            resourceAwsIamAccessKeyCreatedAt(Stream.of(resourceAwsIamAccessKeyCreatedAt)
                    .map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAwsIamAccessKeyCreatedAt(Collection<DateFilter.BuilderImpl> resourceAwsIamAccessKeyCreatedAt) {
            this.resourceAwsIamAccessKeyCreatedAt = DateFilterListCopier.copyFromBuilder(resourceAwsIamAccessKeyCreatedAt);
        }

        public final Collection<StringFilter.Builder> getResourceContainerName() {
            return resourceContainerName != null ? resourceContainerName.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceContainerName(Collection<StringFilter> resourceContainerName) {
            this.resourceContainerName = StringFilterListCopier.copy(resourceContainerName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerName(StringFilter... resourceContainerName) {
            resourceContainerName(Arrays.asList(resourceContainerName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerName(Consumer<StringFilter.Builder>... resourceContainerName) {
            resourceContainerName(Stream.of(resourceContainerName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceContainerName(Collection<StringFilter.BuilderImpl> resourceContainerName) {
            this.resourceContainerName = StringFilterListCopier.copyFromBuilder(resourceContainerName);
        }

        public final Collection<StringFilter.Builder> getResourceContainerImageId() {
            return resourceContainerImageId != null ? resourceContainerImageId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceContainerImageId(Collection<StringFilter> resourceContainerImageId) {
            this.resourceContainerImageId = StringFilterListCopier.copy(resourceContainerImageId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerImageId(StringFilter... resourceContainerImageId) {
            resourceContainerImageId(Arrays.asList(resourceContainerImageId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerImageId(Consumer<StringFilter.Builder>... resourceContainerImageId) {
            resourceContainerImageId(Stream.of(resourceContainerImageId)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceContainerImageId(Collection<StringFilter.BuilderImpl> resourceContainerImageId) {
            this.resourceContainerImageId = StringFilterListCopier.copyFromBuilder(resourceContainerImageId);
        }

        public final Collection<StringFilter.Builder> getResourceContainerImageName() {
            return resourceContainerImageName != null ? resourceContainerImageName.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceContainerImageName(Collection<StringFilter> resourceContainerImageName) {
            this.resourceContainerImageName = StringFilterListCopier.copy(resourceContainerImageName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerImageName(StringFilter... resourceContainerImageName) {
            resourceContainerImageName(Arrays.asList(resourceContainerImageName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerImageName(Consumer<StringFilter.Builder>... resourceContainerImageName) {
            resourceContainerImageName(Stream.of(resourceContainerImageName)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceContainerImageName(Collection<StringFilter.BuilderImpl> resourceContainerImageName) {
            this.resourceContainerImageName = StringFilterListCopier.copyFromBuilder(resourceContainerImageName);
        }

        public final Collection<DateFilter.Builder> getResourceContainerLaunchedAt() {
            return resourceContainerLaunchedAt != null ? resourceContainerLaunchedAt.stream().map(DateFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceContainerLaunchedAt(Collection<DateFilter> resourceContainerLaunchedAt) {
            this.resourceContainerLaunchedAt = DateFilterListCopier.copy(resourceContainerLaunchedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerLaunchedAt(DateFilter... resourceContainerLaunchedAt) {
            resourceContainerLaunchedAt(Arrays.asList(resourceContainerLaunchedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceContainerLaunchedAt(Consumer<DateFilter.Builder>... resourceContainerLaunchedAt) {
            resourceContainerLaunchedAt(Stream.of(resourceContainerLaunchedAt)
                    .map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceContainerLaunchedAt(Collection<DateFilter.BuilderImpl> resourceContainerLaunchedAt) {
            this.resourceContainerLaunchedAt = DateFilterListCopier.copyFromBuilder(resourceContainerLaunchedAt);
        }

        public final Collection<MapFilter.Builder> getResourceDetailsOther() {
            return resourceDetailsOther != null ? resourceDetailsOther.stream().map(MapFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceDetailsOther(Collection<MapFilter> resourceDetailsOther) {
            this.resourceDetailsOther = MapFilterListCopier.copy(resourceDetailsOther);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetailsOther(MapFilter... resourceDetailsOther) {
            resourceDetailsOther(Arrays.asList(resourceDetailsOther));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetailsOther(Consumer<MapFilter.Builder>... resourceDetailsOther) {
            resourceDetailsOther(Stream.of(resourceDetailsOther).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceDetailsOther(Collection<MapFilter.BuilderImpl> resourceDetailsOther) {
            this.resourceDetailsOther = MapFilterListCopier.copyFromBuilder(resourceDetailsOther);
        }

        public final Collection<StringFilter.Builder> getComplianceStatus() {
            return complianceStatus != null ? complianceStatus.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder complianceStatus(Collection<StringFilter> complianceStatus) {
            this.complianceStatus = StringFilterListCopier.copy(complianceStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceStatus(StringFilter... complianceStatus) {
            complianceStatus(Arrays.asList(complianceStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceStatus(Consumer<StringFilter.Builder>... complianceStatus) {
            complianceStatus(Stream.of(complianceStatus).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceStatus(Collection<StringFilter.BuilderImpl> complianceStatus) {
            this.complianceStatus = StringFilterListCopier.copyFromBuilder(complianceStatus);
        }

        public final Collection<StringFilter.Builder> getVerificationState() {
            return verificationState != null ? verificationState.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder verificationState(Collection<StringFilter> verificationState) {
            this.verificationState = StringFilterListCopier.copy(verificationState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verificationState(StringFilter... verificationState) {
            verificationState(Arrays.asList(verificationState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verificationState(Consumer<StringFilter.Builder>... verificationState) {
            verificationState(Stream.of(verificationState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVerificationState(Collection<StringFilter.BuilderImpl> verificationState) {
            this.verificationState = StringFilterListCopier.copyFromBuilder(verificationState);
        }

        public final Collection<StringFilter.Builder> getWorkflowState() {
            return workflowState != null ? workflowState.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder workflowState(Collection<StringFilter> workflowState) {
            this.workflowState = StringFilterListCopier.copy(workflowState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowState(StringFilter... workflowState) {
            workflowState(Arrays.asList(workflowState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowState(Consumer<StringFilter.Builder>... workflowState) {
            workflowState(Stream.of(workflowState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWorkflowState(Collection<StringFilter.BuilderImpl> workflowState) {
            this.workflowState = StringFilterListCopier.copyFromBuilder(workflowState);
        }

        public final Collection<StringFilter.Builder> getRecordState() {
            return recordState != null ? recordState.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordState(Collection<StringFilter> recordState) {
            this.recordState = StringFilterListCopier.copy(recordState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordState(StringFilter... recordState) {
            recordState(Arrays.asList(recordState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordState(Consumer<StringFilter.Builder>... recordState) {
            recordState(Stream.of(recordState).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecordState(Collection<StringFilter.BuilderImpl> recordState) {
            this.recordState = StringFilterListCopier.copyFromBuilder(recordState);
        }

        public final Collection<StringFilter.Builder> getRelatedFindingsProductArn() {
            return relatedFindingsProductArn != null ? relatedFindingsProductArn.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedFindingsProductArn(Collection<StringFilter> relatedFindingsProductArn) {
            this.relatedFindingsProductArn = StringFilterListCopier.copy(relatedFindingsProductArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsProductArn(StringFilter... relatedFindingsProductArn) {
            relatedFindingsProductArn(Arrays.asList(relatedFindingsProductArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsProductArn(Consumer<StringFilter.Builder>... relatedFindingsProductArn) {
            relatedFindingsProductArn(Stream.of(relatedFindingsProductArn)
                    .map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedFindingsProductArn(Collection<StringFilter.BuilderImpl> relatedFindingsProductArn) {
            this.relatedFindingsProductArn = StringFilterListCopier.copyFromBuilder(relatedFindingsProductArn);
        }

        public final Collection<StringFilter.Builder> getRelatedFindingsId() {
            return relatedFindingsId != null ? relatedFindingsId.stream().map(StringFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedFindingsId(Collection<StringFilter> relatedFindingsId) {
            this.relatedFindingsId = StringFilterListCopier.copy(relatedFindingsId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsId(StringFilter... relatedFindingsId) {
            relatedFindingsId(Arrays.asList(relatedFindingsId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindingsId(Consumer<StringFilter.Builder>... relatedFindingsId) {
            relatedFindingsId(Stream.of(relatedFindingsId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedFindingsId(Collection<StringFilter.BuilderImpl> relatedFindingsId) {
            this.relatedFindingsId = StringFilterListCopier.copyFromBuilder(relatedFindingsId);
        }

        public final Collection<StringFilter.Builder> getNoteText() {
            return noteText != null ? noteText.stream().map(StringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder noteText(Collection<StringFilter> noteText) {
            this.noteText = StringFilterListCopier.copy(noteText);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteText(StringFilter... noteText) {
            noteText(Arrays.asList(noteText));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteText(Consumer<StringFilter.Builder>... noteText) {
            noteText(Stream.of(noteText).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNoteText(Collection<StringFilter.BuilderImpl> noteText) {
            this.noteText = StringFilterListCopier.copyFromBuilder(noteText);
        }

        public final Collection<DateFilter.Builder> getNoteUpdatedAt() {
            return noteUpdatedAt != null ? noteUpdatedAt.stream().map(DateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder noteUpdatedAt(Collection<DateFilter> noteUpdatedAt) {
            this.noteUpdatedAt = DateFilterListCopier.copy(noteUpdatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedAt(DateFilter... noteUpdatedAt) {
            noteUpdatedAt(Arrays.asList(noteUpdatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedAt(Consumer<DateFilter.Builder>... noteUpdatedAt) {
            noteUpdatedAt(Stream.of(noteUpdatedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNoteUpdatedAt(Collection<DateFilter.BuilderImpl> noteUpdatedAt) {
            this.noteUpdatedAt = DateFilterListCopier.copyFromBuilder(noteUpdatedAt);
        }

        public final Collection<StringFilter.Builder> getNoteUpdatedBy() {
            return noteUpdatedBy != null ? noteUpdatedBy.stream().map(StringFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder noteUpdatedBy(Collection<StringFilter> noteUpdatedBy) {
            this.noteUpdatedBy = StringFilterListCopier.copy(noteUpdatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedBy(StringFilter... noteUpdatedBy) {
            noteUpdatedBy(Arrays.asList(noteUpdatedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noteUpdatedBy(Consumer<StringFilter.Builder>... noteUpdatedBy) {
            noteUpdatedBy(Stream.of(noteUpdatedBy).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNoteUpdatedBy(Collection<StringFilter.BuilderImpl> noteUpdatedBy) {
            this.noteUpdatedBy = StringFilterListCopier.copyFromBuilder(noteUpdatedBy);
        }

        public final Collection<KeywordFilter.Builder> getKeyword() {
            return keyword != null ? keyword.stream().map(KeywordFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyword(Collection<KeywordFilter> keyword) {
            this.keyword = KeywordFilterListCopier.copy(keyword);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyword(KeywordFilter... keyword) {
            keyword(Arrays.asList(keyword));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyword(Consumer<KeywordFilter.Builder>... keyword) {
            keyword(Stream.of(keyword).map(c -> KeywordFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyword(Collection<KeywordFilter.BuilderImpl> keyword) {
            this.keyword = KeywordFilterListCopier.copyFromBuilder(keyword);
        }

        @Override
        public AwsSecurityFindingFilters build() {
            return new AwsSecurityFindingFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
