/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides consistent format for the contents of the Security Hub-aggregated findings. <code>AwsSecurityFinding</code>
 * format enables you to share findings between AWS security services and third-party solutions, and compliance checks.
 * </p>
 * <note>
 * <p>
 * A finding is a potential security issue generated either by AWS services (Amazon GuardDuty, Amazon Inspector, and
 * Amazon Macie) or by the integrated third-party solutions and compliance checks.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSecurityFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSecurityFinding.Builder, AwsSecurityFinding> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::productArn)).setter(setter(Builder::productArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()).build();

    private static final SdkField<String> GENERATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::generatorId)).setter(setter(Builder::generatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratorId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFinding::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIRST_OBSERVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::firstObservedAt)).setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstObservedAt").build()).build();

    private static final SdkField<String> LAST_OBSERVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::lastObservedAt)).setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<Severity> SEVERITY_FIELD = SdkField.<Severity> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::severity)).setter(setter(Builder::severity)).constructor(Severity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsSecurityFinding::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsSecurityFinding::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.<Remediation> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::remediation)).setter(setter(Builder::remediation))
            .constructor(Remediation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remediation").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()).build();

    private static final SdkField<Map<String, String>> PRODUCT_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AwsSecurityFinding::productFields))
            .setter(setter(Builder::productFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AwsSecurityFinding::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Malware>> MALWARE_FIELD = SdkField
            .<List<Malware>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFinding::malware))
            .setter(setter(Builder::malware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Malware").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Malware> builder(MarshallingType.SDK_POJO)
                                            .constructor(Malware::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Network> NETWORK_FIELD = SdkField.<Network> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::network)).setter(setter(Builder::network)).constructor(Network::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Network").build()).build();

    private static final SdkField<ProcessDetails> PROCESS_FIELD = SdkField.<ProcessDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::process)).setter(setter(Builder::process)).constructor(ProcessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Process").build()).build();

    private static final SdkField<List<ThreatIntelIndicator>> THREAT_INTEL_INDICATORS_FIELD = SdkField
            .<List<ThreatIntelIndicator>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFinding::threatIntelIndicators))
            .setter(setter(Builder::threatIntelIndicators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreatIntelIndicators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatIntelIndicator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatIntelIndicator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFinding::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.<Compliance> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::compliance)).setter(setter(Builder::compliance)).constructor(Compliance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::verificationStateAsString)).setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()).build();

    private static final SdkField<String> WORKFLOW_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::workflowStateAsString)).setter(setter(Builder::workflowState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowState").build()).build();

    private static final SdkField<String> RECORD_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsSecurityFinding::recordStateAsString)).setter(setter(Builder::recordState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordState").build()).build();

    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField
            .<List<RelatedFinding>> builder(MarshallingType.LIST)
            .getter(getter(AwsSecurityFinding::relatedFindings))
            .setter(setter(Builder::relatedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Note> NOTE_FIELD = SdkField.<Note> builder(MarshallingType.SDK_POJO)
            .getter(getter(AwsSecurityFinding::note)).setter(setter(Builder::note)).constructor(Note::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            ID_FIELD, PRODUCT_ARN_FIELD, GENERATOR_ID_FIELD, AWS_ACCOUNT_ID_FIELD, TYPES_FIELD, FIRST_OBSERVED_AT_FIELD,
            LAST_OBSERVED_AT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, SEVERITY_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_FIELD, SOURCE_URL_FIELD, PRODUCT_FIELDS_FIELD, USER_DEFINED_FIELDS_FIELD,
            MALWARE_FIELD, NETWORK_FIELD, PROCESS_FIELD, THREAT_INTEL_INDICATORS_FIELD, RESOURCES_FIELD, COMPLIANCE_FIELD,
            VERIFICATION_STATE_FIELD, WORKFLOW_STATE_FIELD, RECORD_STATE_FIELD, RELATED_FINDINGS_FIELD, NOTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaVersion;

    private final String id;

    private final String productArn;

    private final String generatorId;

    private final String awsAccountId;

    private final List<String> types;

    private final String firstObservedAt;

    private final String lastObservedAt;

    private final String createdAt;

    private final String updatedAt;

    private final Severity severity;

    private final Integer confidence;

    private final Integer criticality;

    private final String title;

    private final String description;

    private final Remediation remediation;

    private final String sourceUrl;

    private final Map<String, String> productFields;

    private final Map<String, String> userDefinedFields;

    private final List<Malware> malware;

    private final Network network;

    private final ProcessDetails process;

    private final List<ThreatIntelIndicator> threatIntelIndicators;

    private final List<Resource> resources;

    private final Compliance compliance;

    private final String verificationState;

    private final String workflowState;

    private final String recordState;

    private final List<RelatedFinding> relatedFindings;

    private final Note note;

    private AwsSecurityFinding(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.id = builder.id;
        this.productArn = builder.productArn;
        this.generatorId = builder.generatorId;
        this.awsAccountId = builder.awsAccountId;
        this.types = builder.types;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.severity = builder.severity;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.title = builder.title;
        this.description = builder.description;
        this.remediation = builder.remediation;
        this.sourceUrl = builder.sourceUrl;
        this.productFields = builder.productFields;
        this.userDefinedFields = builder.userDefinedFields;
        this.malware = builder.malware;
        this.network = builder.network;
        this.process = builder.process;
        this.threatIntelIndicators = builder.threatIntelIndicators;
        this.resources = builder.resources;
        this.compliance = builder.compliance;
        this.verificationState = builder.verificationState;
        this.workflowState = builder.workflowState;
        this.recordState = builder.recordState;
        this.relatedFindings = builder.relatedFindings;
        this.note = builder.note;
    }

    /**
     * <p>
     * The schema version that a finding is formatted for.
     * </p>
     * 
     * @return The schema version that a finding is formatted for.
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @return The security findings provider-specific identifier for a finding.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security-findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a third-party company (security-findings
     *         provider) after this provider's product (solution that generates findings) is registered with Security
     *         Hub.
     */
    public String productArn() {
        return productArn;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * 
     * @return The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
     *         In various security-findings providers' solutions, this generator can be called a rule, a check, a
     *         detector, a plug-in, etc.
     */
    public String generatorId() {
        return generatorId;
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * 
     * @return The AWS account ID that a finding is generated in.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.
     * </p>
     * <p>
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive
     * Data Identifications
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
     *         finding.</p>
     *         <p>
     *         Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
     *         Sensitive Data Identifications
     */
    public List<String> types() {
        return types;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *         potential security issue that a finding captured.
     */
    public String firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *         the potential security issue that a finding captured.
     */
    public String lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider created the potential security
     * issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider created the potential
     *         security issue that a finding captured.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
     *         finding record.
     */
    public String updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * A finding's severity.
     * </p>
     * 
     * @return A finding's severity.
     */
    public Severity severity() {
        return severity;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * 
     * @return A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *         behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *         scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    public Integer confidence() {
        return confidence;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * 
     * @return The level of importance assigned to the resources associated with the finding. A score of 0 means that
     *         the underlying resources have no criticality, and a score of 100 is reserved for the most critical
     *         resources.
     */
    public Integer criticality() {
        return criticality;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Title</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's title.</p> <note>
     *         <p>
     *         In this release, <code>Title</code> is a required property.
     *         </p>
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <note>
     * <p>
     * In this release, <code>Description</code> is a required property.
     * </p>
     * </note>
     * 
     * @return A finding's description.</p> <note>
     *         <p>
     *         In this release, <code>Description</code> is a required property.
     *         </p>
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A data type that describes the remediation options for a finding.
     * </p>
     * 
     * @return A data type that describes the remediation options for a finding.
     */
    public Remediation remediation() {
        return remediation;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * 
     * @return A URL that links to a page about the current finding in the security-findings provider's solution.
     */
    public String sourceUrl() {
        return sourceUrl;
    }

    /**
     * Returns true if the ProductFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductFields() {
        return productFields != null && !(productFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A data type where security-findings providers can include additional solution-specific details that
     *         aren't part of the defined <code>AwsSecurityFinding</code> format.
     */
    public Map<String, String> productFields() {
        return productFields;
    }

    /**
     * Returns true if the UserDefinedFields property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserDefinedFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */
    public Map<String, String> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * Returns true if the Malware property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMalware() {
        return malware != null && !(malware instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of malware related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMalware()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of malware related to a finding.
     */
    public List<Malware> malware() {
        return malware;
    }

    /**
     * <p>
     * The details of network-related information about a finding.
     * </p>
     * 
     * @return The details of network-related information about a finding.
     */
    public Network network() {
        return network;
    }

    /**
     * <p>
     * The details of process-related information about a finding.
     * </p>
     * 
     * @return The details of process-related information about a finding.
     */
    public ProcessDetails process() {
        return process;
    }

    /**
     * Returns true if the ThreatIntelIndicators property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasThreatIntelIndicators() {
        return threatIntelIndicators != null && !(threatIntelIndicators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Threat intel details related to a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThreatIntelIndicators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Threat intel details related to a finding.
     */
    public List<ThreatIntelIndicator> threatIntelIndicators() {
        return threatIntelIndicators;
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of resource data types that describe the resources that the finding refers to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of resource data types that describe the resources that the finding refers to.
     */
    public List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule
     * in a supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * 
     * @return This data type is exclusive to findings that are generated as the result of a check run against a
     *         specific rule in a supported standard (for example, CIS AWS Foundations). Contains compliance-related
     *         finding details.
     */
    public Compliance compliance() {
        return compliance;
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.
     * @see VerificationState
     */
    public VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * Indicates the veracity of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return Indicates the veracity of a finding.
     * @see VerificationState
     */
    public String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowState}
     * will return {@link WorkflowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowStateAsString}.
     * </p>
     * 
     * @return The workflow state of a finding.
     * @see WorkflowState
     */
    public WorkflowState workflowState() {
        return WorkflowState.fromValue(workflowState);
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowState}
     * will return {@link WorkflowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowStateAsString}.
     * </p>
     * 
     * @return The workflow state of a finding.
     * @see WorkflowState
     */
    public String workflowStateAsString() {
        return workflowState;
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The record state of a finding.
     * @see RecordState
     */
    public RecordState recordState() {
        return RecordState.fromValue(recordState);
    }

    /**
     * <p>
     * The record state of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordState} will
     * return {@link RecordState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordStateAsString}.
     * </p>
     * 
     * @return The record state of a finding.
     * @see RecordState
     */
    public String recordStateAsString() {
        return recordState;
    }

    /**
     * Returns true if the RelatedFindings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelatedFindings() {
        return relatedFindings != null && !(relatedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of related findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of related findings.
     */
    public List<RelatedFinding> relatedFindings() {
        return relatedFindings;
    }

    /**
     * <p>
     * A user-defined note added to a finding.
     * </p>
     * 
     * @return A user-defined note added to a finding.
     */
    public Note note() {
        return note;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(productArn());
        hashCode = 31 * hashCode + Objects.hashCode(generatorId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(types());
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(productFields());
        hashCode = 31 * hashCode + Objects.hashCode(userDefinedFields());
        hashCode = 31 * hashCode + Objects.hashCode(malware());
        hashCode = 31 * hashCode + Objects.hashCode(network());
        hashCode = 31 * hashCode + Objects.hashCode(process());
        hashCode = 31 * hashCode + Objects.hashCode(threatIntelIndicators());
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSecurityFinding)) {
            return false;
        }
        AwsSecurityFinding other = (AwsSecurityFinding) obj;
        return Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(id(), other.id())
                && Objects.equals(productArn(), other.productArn()) && Objects.equals(generatorId(), other.generatorId())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(types(), other.types())
                && Objects.equals(firstObservedAt(), other.firstObservedAt())
                && Objects.equals(lastObservedAt(), other.lastObservedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(severity(), other.severity())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(remediation(), other.remediation()) && Objects.equals(sourceUrl(), other.sourceUrl())
                && Objects.equals(productFields(), other.productFields())
                && Objects.equals(userDefinedFields(), other.userDefinedFields()) && Objects.equals(malware(), other.malware())
                && Objects.equals(network(), other.network()) && Objects.equals(process(), other.process())
                && Objects.equals(threatIntelIndicators(), other.threatIntelIndicators())
                && Objects.equals(resources(), other.resources()) && Objects.equals(compliance(), other.compliance())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(workflowStateAsString(), other.workflowStateAsString())
                && Objects.equals(recordStateAsString(), other.recordStateAsString())
                && Objects.equals(relatedFindings(), other.relatedFindings()) && Objects.equals(note(), other.note());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsSecurityFinding").add("SchemaVersion", schemaVersion()).add("Id", id())
                .add("ProductArn", productArn()).add("GeneratorId", generatorId()).add("AwsAccountId", awsAccountId())
                .add("Types", types()).add("FirstObservedAt", firstObservedAt()).add("LastObservedAt", lastObservedAt())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Severity", severity())
                .add("Confidence", confidence()).add("Criticality", criticality()).add("Title", title())
                .add("Description", description()).add("Remediation", remediation()).add("SourceUrl", sourceUrl())
                .add("ProductFields", productFields()).add("UserDefinedFields", userDefinedFields()).add("Malware", malware())
                .add("Network", network()).add("Process", process()).add("ThreatIntelIndicators", threatIntelIndicators())
                .add("Resources", resources()).add("Compliance", compliance())
                .add("VerificationState", verificationStateAsString()).add("WorkflowState", workflowStateAsString())
                .add("RecordState", recordStateAsString()).add("RelatedFindings", relatedFindings()).add("Note", note()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ProductArn":
            return Optional.ofNullable(clazz.cast(productArn()));
        case "GeneratorId":
            return Optional.ofNullable(clazz.cast(generatorId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "FirstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "LastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "ProductFields":
            return Optional.ofNullable(clazz.cast(productFields()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "Malware":
            return Optional.ofNullable(clazz.cast(malware()));
        case "Network":
            return Optional.ofNullable(clazz.cast(network()));
        case "Process":
            return Optional.ofNullable(clazz.cast(process()));
        case "ThreatIntelIndicators":
            return Optional.ofNullable(clazz.cast(threatIntelIndicators()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "WorkflowState":
            return Optional.ofNullable(clazz.cast(workflowStateAsString()));
        case "RecordState":
            return Optional.ofNullable(clazz.cast(recordStateAsString()));
        case "RelatedFindings":
            return Optional.ofNullable(clazz.cast(relatedFindings()));
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSecurityFinding, T> g) {
        return obj -> g.apply((AwsSecurityFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSecurityFinding> {
        /**
         * <p>
         * The schema version that a finding is formatted for.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version that a finding is formatted for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The security findings provider-specific identifier for a finding.
         * </p>
         * 
         * @param id
         *        The security findings provider-specific identifier for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security-findings provider)
         * after this provider's product (solution that generates findings) is registered with Security Hub.
         * </p>
         * 
         * @param productArn
         *        The ARN generated by Security Hub that uniquely identifies a third-party company (security-findings
         *        provider) after this provider's product (solution that generates findings) is registered with Security
         *        Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productArn(String productArn);

        /**
         * <p>
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
         * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
         * plug-in, etc.
         * </p>
         * 
         * @param generatorId
         *        The identifier for the solution-specific component (a discrete unit of logic) that generated a
         *        finding. In various security-findings providers' solutions, this generator can be called a rule, a
         *        check, a detector, a plug-in, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatorId(String generatorId);

        /**
         * <p>
         * The AWS account ID that a finding is generated in.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID that a finding is generated in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         * finding.
         * </p>
         * <p>
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         * Sensitive Data Identifications
         * </p>
         * 
         * @param types
         *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         *        finding.</p>
         *        <p>
         *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         *        Sensitive Data Identifications
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         * finding.
         * </p>
         * <p>
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         * Sensitive Data Identifications
         * </p>
         * 
         * @param types
         *        One or more finding types in the format of <code>namespace/category/classifier</code> that classify a
         *        finding.</p>
         *        <p>
         *        Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors |
         *        Sensitive Data Identifications
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param firstObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(String firstObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
         * potential security issue that a finding captured.
         * </p>
         * 
         * @param lastObservedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently
         *        observed the potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(String lastObservedAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider created the potential
         * security issue that a finding captured.
         * </p>
         * 
         * @param createdAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider created the
         *        potential security issue that a finding captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
         * record.
         * </p>
         * 
         * @param updatedAt
         *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
         *        finding record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);

        /**
         * <p>
         * A finding's severity.
         * </p>
         * 
         * @param severity
         *        A finding's severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * A finding's severity.
         * </p>
         * This is a convenience that creates an instance of the {@link Severity.Builder} avoiding the need to create
         * one manually via {@link Severity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Severity.Builder#build()} is called immediately and its result is
         * passed to {@link #severity(Severity)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link Severity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(Severity)
         */
        default Builder severity(Consumer<Severity.Builder> severity) {
            return severity(Severity.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
         * behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
         * scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * </p>
         * 
         * @param confidence
         *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies
         *        the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a
         *        ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Integer confidence);

        /**
         * <p>
         * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
         * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * </p>
         * 
         * @param criticality
         *        The level of importance assigned to the resources associated with the finding. A score of 0 means that
         *        the underlying resources have no criticality, and a score of 100 is reserved for the most critical
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * A finding's title.
         * </p>
         * <note>
         * <p>
         * In this release, <code>Title</code> is a required property.
         * </p>
         * </note>
         * 
         * @param title
         *        A finding's title.</p> <note>
         *        <p>
         *        In this release, <code>Title</code> is a required property.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A finding's description.
         * </p>
         * <note>
         * <p>
         * In this release, <code>Description</code> is a required property.
         * </p>
         * </note>
         * 
         * @param description
         *        A finding's description.</p> <note>
         *        <p>
         *        In this release, <code>Description</code> is a required property.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A data type that describes the remediation options for a finding.
         * </p>
         * 
         * @param remediation
         *        A data type that describes the remediation options for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(Remediation remediation);

        /**
         * <p>
         * A data type that describes the remediation options for a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link Remediation.Builder} avoiding the need to create
         * one manually via {@link Remediation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Remediation.Builder#build()} is called immediately and its result
         * is passed to {@link #remediation(Remediation)}.
         * 
         * @param remediation
         *        a consumer that will call methods on {@link Remediation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediation(Remediation)
         */
        default Builder remediation(Consumer<Remediation.Builder> remediation) {
            return remediation(Remediation.builder().applyMutation(remediation).build());
        }

        /**
         * <p>
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         * </p>
         * 
         * @param sourceUrl
         *        A URL that links to a page about the current finding in the security-findings provider's solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * A data type where security-findings providers can include additional solution-specific details that aren't
         * part of the defined <code>AwsSecurityFinding</code> format.
         * </p>
         * 
         * @param productFields
         *        A data type where security-findings providers can include additional solution-specific details that
         *        aren't part of the defined <code>AwsSecurityFinding</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFields(Map<String, String> productFields);

        /**
         * <p>
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to
         * a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields
         *        added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Map<String, String> userDefinedFields);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * 
         * @param malware
         *        A list of malware related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malware(Collection<Malware> malware);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * 
         * @param malware
         *        A list of malware related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malware(Malware... malware);

        /**
         * <p>
         * A list of malware related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Malware>.Builder} avoiding the need to
         * create one manually via {@link List<Malware>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Malware>.Builder#build()} is called immediately and its
         * result is passed to {@link #malware(List<Malware>)}.
         * 
         * @param malware
         *        a consumer that will call methods on {@link List<Malware>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malware(List<Malware>)
         */
        Builder malware(Consumer<Malware.Builder>... malware);

        /**
         * <p>
         * The details of network-related information about a finding.
         * </p>
         * 
         * @param network
         *        The details of network-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder network(Network network);

        /**
         * <p>
         * The details of network-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link Network.Builder} avoiding the need to create one
         * manually via {@link Network#builder()}.
         *
         * When the {@link Consumer} completes, {@link Network.Builder#build()} is called immediately and its result is
         * passed to {@link #network(Network)}.
         * 
         * @param network
         *        a consumer that will call methods on {@link Network.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #network(Network)
         */
        default Builder network(Consumer<Network.Builder> network) {
            return network(Network.builder().applyMutation(network).build());
        }

        /**
         * <p>
         * The details of process-related information about a finding.
         * </p>
         * 
         * @param process
         *        The details of process-related information about a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder process(ProcessDetails process);

        /**
         * <p>
         * The details of process-related information about a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessDetails.Builder} avoiding the need to
         * create one manually via {@link ProcessDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #process(ProcessDetails)}.
         * 
         * @param process
         *        a consumer that will call methods on {@link ProcessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #process(ProcessDetails)
         */
        default Builder process(Consumer<ProcessDetails.Builder> process) {
            return process(ProcessDetails.builder().applyMutation(process).build());
        }

        /**
         * <p>
         * Threat intel details related to a finding.
         * </p>
         * 
         * @param threatIntelIndicators
         *        Threat intel details related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicators(Collection<ThreatIntelIndicator> threatIntelIndicators);

        /**
         * <p>
         * Threat intel details related to a finding.
         * </p>
         * 
         * @param threatIntelIndicators
         *        Threat intel details related to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatIntelIndicators(ThreatIntelIndicator... threatIntelIndicators);

        /**
         * <p>
         * Threat intel details related to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThreatIntelIndicator>.Builder} avoiding the
         * need to create one manually via {@link List<ThreatIntelIndicator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThreatIntelIndicator>.Builder#build()} is called immediately
         * and its result is passed to {@link #threatIntelIndicators(List<ThreatIntelIndicator>)}.
         * 
         * @param threatIntelIndicators
         *        a consumer that will call methods on {@link List<ThreatIntelIndicator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatIntelIndicators(List<ThreatIntelIndicator>)
         */
        Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder>... threatIntelIndicators);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * 
         * @param resources
         *        A set of resource data types that describe the resources that the finding refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * 
         * @param resources
         *        A set of resource data types that describe the resources that the finding refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * A set of resource data types that describe the resources that the finding refers to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Resource>.Builder} avoiding the need to
         * create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * This data type is exclusive to findings that are generated as the result of a check run against a specific
         * rule in a supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * </p>
         * 
         * @param compliance
         *        This data type is exclusive to findings that are generated as the result of a check run against a
         *        specific rule in a supported standard (for example, CIS AWS Foundations). Contains compliance-related
         *        finding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);

        /**
         * <p>
         * This data type is exclusive to findings that are generated as the result of a check run against a specific
         * rule in a supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
         * </p>
         * This is a convenience that creates an instance of the {@link Compliance.Builder} avoiding the need to create
         * one manually via {@link Compliance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Compliance.Builder#build()} is called immediately and its result
         * is passed to {@link #compliance(Compliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link Compliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(Compliance)
         */
        default Builder compliance(Consumer<Compliance.Builder> compliance) {
            return compliance(Compliance.builder().applyMutation(compliance).build());
        }

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * Indicates the veracity of a finding.
         * </p>
         * 
         * @param verificationState
         *        Indicates the veracity of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @see WorkflowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowState
         */
        Builder workflowState(String workflowState);

        /**
         * <p>
         * The workflow state of a finding.
         * </p>
         * 
         * @param workflowState
         *        The workflow state of a finding.
         * @see WorkflowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowState
         */
        Builder workflowState(WorkflowState workflowState);

        /**
         * <p>
         * The record state of a finding.
         * </p>
         * 
         * @param recordState
         *        The record state of a finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(String recordState);

        /**
         * <p>
         * The record state of a finding.
         * </p>
         * 
         * @param recordState
         *        The record state of a finding.
         * @see RecordState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordState
         */
        Builder recordState(RecordState recordState);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of related findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(Collection<RelatedFinding> relatedFindings);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * 
         * @param relatedFindings
         *        A list of related findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(RelatedFinding... relatedFindings);

        /**
         * <p>
         * A list of related findings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelatedFinding>.Builder} avoiding the need
         * to create one manually via {@link List<RelatedFinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelatedFinding>.Builder#build()} is called immediately and
         * its result is passed to {@link #relatedFindings(List<RelatedFinding>)}.
         * 
         * @param relatedFindings
         *        a consumer that will call methods on {@link List<RelatedFinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindings(List<RelatedFinding>)
         */
        Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings);

        /**
         * <p>
         * A user-defined note added to a finding.
         * </p>
         * 
         * @param note
         *        A user-defined note added to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(Note note);

        /**
         * <p>
         * A user-defined note added to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link Note.Builder} avoiding the need to create one
         * manually via {@link Note#builder()}.
         *
         * When the {@link Consumer} completes, {@link Note.Builder#build()} is called immediately and its result is
         * passed to {@link #note(Note)}.
         * 
         * @param note
         *        a consumer that will call methods on {@link Note.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #note(Note)
         */
        default Builder note(Consumer<Note.Builder> note) {
            return note(Note.builder().applyMutation(note).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String schemaVersion;

        private String id;

        private String productArn;

        private String generatorId;

        private String awsAccountId;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private String firstObservedAt;

        private String lastObservedAt;

        private String createdAt;

        private String updatedAt;

        private Severity severity;

        private Integer confidence;

        private Integer criticality;

        private String title;

        private String description;

        private Remediation remediation;

        private String sourceUrl;

        private Map<String, String> productFields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();

        private List<Malware> malware = DefaultSdkAutoConstructList.getInstance();

        private Network network;

        private ProcessDetails process;

        private List<ThreatIntelIndicator> threatIntelIndicators = DefaultSdkAutoConstructList.getInstance();

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private Compliance compliance;

        private String verificationState;

        private String workflowState;

        private String recordState;

        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private Note note;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSecurityFinding model) {
            schemaVersion(model.schemaVersion);
            id(model.id);
            productArn(model.productArn);
            generatorId(model.generatorId);
            awsAccountId(model.awsAccountId);
            types(model.types);
            firstObservedAt(model.firstObservedAt);
            lastObservedAt(model.lastObservedAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            severity(model.severity);
            confidence(model.confidence);
            criticality(model.criticality);
            title(model.title);
            description(model.description);
            remediation(model.remediation);
            sourceUrl(model.sourceUrl);
            productFields(model.productFields);
            userDefinedFields(model.userDefinedFields);
            malware(model.malware);
            network(model.network);
            process(model.process);
            threatIntelIndicators(model.threatIntelIndicators);
            resources(model.resources);
            compliance(model.compliance);
            verificationState(model.verificationState);
            workflowState(model.workflowState);
            recordState(model.recordState);
            relatedFindings(model.relatedFindings);
            note(model.note);
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getProductArn() {
            return productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        public final String getGeneratorId() {
            return generatorId;
        }

        @Override
        public final Builder generatorId(String generatorId) {
            this.generatorId = generatorId;
            return this;
        }

        public final void setGeneratorId(String generatorId) {
            this.generatorId = generatorId;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final Collection<String> getTypes() {
            return types;
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        public final String getFirstObservedAt() {
            return firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final void setFirstObservedAt(String firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        public final String getLastObservedAt() {
            return lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final void setLastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final Severity.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(Severity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        public final Integer getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Remediation.Builder getRemediation() {
            return remediation != null ? remediation.toBuilder() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        public final Map<String, String> getProductFields() {
            return productFields;
        }

        @Override
        public final Builder productFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
            return this;
        }

        public final void setProductFields(Map<String, String> productFields) {
            this.productFields = FieldMapCopier.copy(productFields);
        }

        public final Map<String, String> getUserDefinedFields() {
            return userDefinedFields;
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        public final Collection<Malware.Builder> getMalware() {
            return malware != null ? malware.stream().map(Malware::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder malware(Collection<Malware> malware) {
            this.malware = MalwareListCopier.copy(malware);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Malware... malware) {
            malware(Arrays.asList(malware));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malware(Consumer<Malware.Builder>... malware) {
            malware(Stream.of(malware).map(c -> Malware.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMalware(Collection<Malware.BuilderImpl> malware) {
            this.malware = MalwareListCopier.copyFromBuilder(malware);
        }

        public final Network.Builder getNetwork() {
            return network != null ? network.toBuilder() : null;
        }

        @Override
        public final Builder network(Network network) {
            this.network = network;
            return this;
        }

        public final void setNetwork(Network.BuilderImpl network) {
            this.network = network != null ? network.build() : null;
        }

        public final ProcessDetails.Builder getProcess() {
            return process != null ? process.toBuilder() : null;
        }

        @Override
        public final Builder process(ProcessDetails process) {
            this.process = process;
            return this;
        }

        public final void setProcess(ProcessDetails.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        public final Collection<ThreatIntelIndicator.Builder> getThreatIntelIndicators() {
            return threatIntelIndicators != null ? threatIntelIndicators.stream().map(ThreatIntelIndicator::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelIndicators(Collection<ThreatIntelIndicator> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copy(threatIntelIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(ThreatIntelIndicator... threatIntelIndicators) {
            threatIntelIndicators(Arrays.asList(threatIntelIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelIndicators(Consumer<ThreatIntelIndicator.Builder>... threatIntelIndicators) {
            threatIntelIndicators(Stream.of(threatIntelIndicators)
                    .map(c -> ThreatIntelIndicator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelIndicators(Collection<ThreatIntelIndicator.BuilderImpl> threatIntelIndicators) {
            this.threatIntelIndicators = ThreatIntelIndicatorListCopier.copyFromBuilder(threatIntelIndicators);
        }

        public final Collection<Resource.Builder> getResources() {
            return resources != null ? resources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        public final String getVerificationStateAsString() {
            return verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        public final String getWorkflowStateAsString() {
            return workflowState;
        }

        @Override
        public final Builder workflowState(String workflowState) {
            this.workflowState = workflowState;
            return this;
        }

        @Override
        public final Builder workflowState(WorkflowState workflowState) {
            this.workflowState(workflowState == null ? null : workflowState.toString());
            return this;
        }

        public final void setWorkflowState(String workflowState) {
            this.workflowState = workflowState;
        }

        public final String getRecordStateAsString() {
            return recordState;
        }

        @Override
        public final Builder recordState(String recordState) {
            this.recordState = recordState;
            return this;
        }

        @Override
        public final Builder recordState(RecordState recordState) {
            this.recordState(recordState == null ? null : recordState.toString());
            return this;
        }

        public final void setRecordState(String recordState) {
            this.recordState = recordState;
        }

        public final Collection<RelatedFinding.Builder> getRelatedFindings() {
            return relatedFindings != null ? relatedFindings.stream().map(RelatedFinding::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding... relatedFindings) {
            relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings) {
            relatedFindings(Stream.of(relatedFindings).map(c -> RelatedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        public final Note.Builder getNote() {
            return note != null ? note.toBuilder() : null;
        }

        @Override
        public final Builder note(Note note) {
            this.note = note;
            return this;
        }

        public final void setNote(Note.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        public AwsSecurityFinding build() {
            return new AwsSecurityFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
