/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes the Amazon S3 bucket, HTTP server (for example, a web server), Amazon MediaStore, or
 * other server from which CloudFront gets your files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginItem.Builder, AwsCloudFrontDistributionOriginItem> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionOriginItem::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionOriginItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ORIGIN_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudFrontDistributionOriginItem::originPath)).setter(setter(Builder::originPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ID_FIELD,
            ORIGIN_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String id;

    private final String originPath;

    private AwsCloudFrontDistributionOriginItem(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.originPath = builder.originPath;
    }

    /**
     * <p>
     * Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want CloudFront to get objects for this
     * origin.
     * </p>
     * 
     * @return Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want CloudFront to get objects for
     *         this origin.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A unique identifier for the origin or origin group.
     * </p>
     * 
     * @return A unique identifier for the origin or origin group.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or
     * your custom origin.
     * </p>
     * 
     * @return An optional element that causes CloudFront to request your content from a directory in your Amazon S3
     *         bucket or your custom origin.
     */
    public String originPath() {
        return originPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(originPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginItem)) {
            return false;
        }
        AwsCloudFrontDistributionOriginItem other = (AwsCloudFrontDistributionOriginItem) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(id(), other.id())
                && Objects.equals(originPath(), other.originPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginItem").add("DomainName", domainName()).add("Id", id())
                .add("OriginPath", originPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OriginPath":
            return Optional.ofNullable(clazz.cast(originPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginItem, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
        /**
         * <p>
         * Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want CloudFront to get objects for
         * this origin.
         * </p>
         * 
         * @param domainName
         *        Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want CloudFront to get objects
         *        for this origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A unique identifier for the origin or origin group.
         * </p>
         * 
         * @param id
         *        A unique identifier for the origin or origin group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket
         * or your custom origin.
         * </p>
         * 
         * @param originPath
         *        An optional element that causes CloudFront to request your content from a directory in your Amazon S3
         *        bucket or your custom origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originPath(String originPath);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String id;

        private String originPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginItem model) {
            domainName(model.domainName);
            id(model.id);
            originPath(model.originPath);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getOriginPath() {
            return originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        @Override
        public AwsCloudFrontDistributionOriginItem build() {
            return new AwsCloudFrontDistributionOriginItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
