/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotateSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<RotateSecretRequest.Builder, RotateSecretRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(RotateSecretRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(RotateSecretRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROTATION_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationLambdaARN").getter(getter(RotateSecretRequest::rotationLambdaARN))
            .setter(setter(Builder::rotationLambdaARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationLambdaARN").build()).build();

    private static final SdkField<RotationRulesType> ROTATION_RULES_FIELD = SdkField
            .<RotationRulesType> builder(MarshallingType.SDK_POJO).memberName("RotationRules")
            .getter(getter(RotateSecretRequest::rotationRules)).setter(setter(Builder::rotationRules))
            .constructor(RotationRulesType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationRules").build()).build();

    private static final SdkField<List<ExternalSecretRotationMetadataItem>> EXTERNAL_SECRET_ROTATION_METADATA_FIELD = SdkField
            .<List<ExternalSecretRotationMetadataItem>> builder(MarshallingType.LIST)
            .memberName("ExternalSecretRotationMetadata")
            .getter(getter(RotateSecretRequest::externalSecretRotationMetadata))
            .setter(setter(Builder::externalSecretRotationMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalSecretRotationMetadata")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExternalSecretRotationMetadataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExternalSecretRotationMetadataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXTERNAL_SECRET_ROTATION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExternalSecretRotationRoleArn")
            .getter(getter(RotateSecretRequest::externalSecretRotationRoleArn))
            .setter(setter(Builder::externalSecretRotationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalSecretRotationRoleArn")
                    .build()).build();

    private static final SdkField<Boolean> ROTATE_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RotateImmediately").getter(getter(RotateSecretRequest::rotateImmediately))
            .setter(setter(Builder::rotateImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotateImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, ROTATION_LAMBDA_ARN_FIELD, ROTATION_RULES_FIELD, EXTERNAL_SECRET_ROTATION_METADATA_FIELD,
            EXTERNAL_SECRET_ROTATION_ROLE_ARN_FIELD, ROTATE_IMMEDIATELY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String secretId;

    private final String clientRequestToken;

    private final String rotationLambdaARN;

    private final RotationRulesType rotationRules;

    private final List<ExternalSecretRotationMetadataItem> externalSecretRotationMetadata;

    private final String externalSecretRotationRoleArn;

    private final Boolean rotateImmediately;

    private RotateSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.clientRequestToken = builder.clientRequestToken;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
        this.externalSecretRotationMetadata = builder.externalSecretRotationMetadata;
        this.externalSecretRotationRoleArn = builder.externalSecretRotationRoleArn;
        this.rotateImmediately = builder.rotateImmediately;
    }

    /**
     * <p>
     * The ARN or name of the secret to rotate.
     * </p>
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">Finding
     * a secret from a partial ARN</a>.
     * </p>
     * 
     * @return The ARN or name of the secret to rotate.</p>
     *         <p>
     *         For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
     *         >Finding a secret from a partial ARN</a>.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * A unique identifier for the new version of the secret. You only need to specify this value if you implement your
     * own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice.
     * </p>
     * <note>
     * <p>
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you
     * can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for
     * this parameter in the request.
     * </p>
     * </note>
     * <p>
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
     * <code>ClientRequestToken</code> and include it in the request.
     * </p>
     * <p>
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of
     * duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a
     * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your
     * versions within the specified secret.
     * </p>
     * 
     * @return A unique identifier for the new version of the secret. You only need to specify this value if you
     *         implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a
     *         secret version twice.</p> <note>
     *         <p>
     *         If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation,
     *         then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it
     *         as the value for this parameter in the request.
     *         </p>
     *         </note>
     *         <p>
     *         If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
     *         <code>ClientRequestToken</code> and include it in the request.
     *         </p>
     *         <p>
     *         This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation
     *         of duplicate versions if there are failures and retries during a rotation. We recommend that you generate
     *         a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure
     *         uniqueness of your versions within the specified secret.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function.
     * </p>
     * <p>
     * For secrets that use <i>managed rotation</i>, omit this field. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html">Managed
     * rotation</a> in the <i>Secrets Manager User Guide</i>.
     * </p>
     * 
     * @return For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function. </p>
     *         <p>
     *         For secrets that use <i>managed rotation</i>, omit this field. For more information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html">Managed
     *         rotation</a> in the <i>Secrets Manager User Guide</i>.
     */
    public final String rotationLambdaARN() {
        return rotationLambdaARN;
    }

    /**
     * <p>
     * A structure that defines the rotation configuration for this secret.
     * </p>
     * <important>
     * <p>
     * When changing an existing rotation schedule and setting <code>RotateImmediately</code> to <code>false</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with <code>rate()</code>, the
     * previously scheduled rotation might still occur.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for granular
     * control over rotation windows.
     * </p>
     * </li>
     * </ul>
     * </important>
     * 
     * @return A structure that defines the rotation configuration for this secret.</p> <important>
     *         <p>
     *         When changing an existing rotation schedule and setting <code>RotateImmediately</code> to
     *         <code>false</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with
     *         <code>rate()</code>, the previously scheduled rotation might still occur.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for
     *         granular control over rotation windows.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final RotationRulesType rotationRules() {
        return rotationRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalSecretRotationMetadata property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExternalSecretRotationMetadata() {
        return externalSecretRotationMetadata != null && !(externalSecretRotationMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata needed to successfully rotate a managed external secret. A list of key value pairs in JSON format
     * specified by the partner. For more information about the required information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using Secrets
     * Manager managed external secrets</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalSecretRotationMetadata} method.
     * </p>
     * 
     * @return The metadata needed to successfully rotate a managed external secret. A list of key value pairs in JSON
     *         format specified by the partner. For more information about the required information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
     *         Secrets Manager managed external secrets</a>
     */
    public final List<ExternalSecretRotationMetadataItem> externalSecretRotationMetadata() {
        return externalSecretRotationMetadata;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that allows Secrets Manager to rotate a secret held by a third-party
     * partner. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-security.html">Security and
     * permissions</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that allows Secrets Manager to rotate a secret held by a
     *         third-party partner. For more information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-security.html">Security and
     *         permissions</a>.
     */
    public final String externalSecretRotationRoleArn() {
        return externalSecretRotationRoleArn;
    }

    /**
     * <p>
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation
     * schedule is defined in <a>RotateSecretRequest$RotationRules</a>.
     * </p>
     * <p>
     * The default for <code>RotateImmediately</code> is <code>true</code>. If you don't specify this value, Secrets
     * Manager rotates the secret immediately.
     * </p>
     * <p>
     * If you set <code>RotateImmediately</code> to <code>false</code>, Secrets Manager tests the rotation configuration
     * by running the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">
     * <code>testSecret</code> step</a> of the Lambda rotation function. This test creates an <code>AWSPENDING</code>
     * version of the secret and then removes it.
     * </p>
     * <p>
     * When changing an existing rotation schedule and setting <code>RotateImmediately</code> to <code>false</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with <code>rate()</code>, the
     * previously scheduled rotation might still occur.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for granular
     * control over rotation windows.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Rotation is an asynchronous process. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     * works</a>.
     * </p>
     * 
     * @return Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The
     *         rotation schedule is defined in <a>RotateSecretRequest$RotationRules</a>.</p>
     *         <p>
     *         The default for <code>RotateImmediately</code> is <code>true</code>. If you don't specify this value,
     *         Secrets Manager rotates the secret immediately.
     *         </p>
     *         <p>
     *         If you set <code>RotateImmediately</code> to <code>false</code>, Secrets Manager tests the rotation
     *         configuration by running the <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">
     *         <code>testSecret</code> step</a> of the Lambda rotation function. This test creates an
     *         <code>AWSPENDING</code> version of the secret and then removes it.
     *         </p>
     *         <p>
     *         When changing an existing rotation schedule and setting <code>RotateImmediately</code> to
     *         <code>false</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with
     *         <code>rate()</code>, the previously scheduled rotation might still occur.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for
     *         granular control over rotation windows.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Rotation is an asynchronous process. For more information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     *         works</a>.
     */
    public final Boolean rotateImmediately() {
        return rotateImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasExternalSecretRotationMetadata() ? externalSecretRotationMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(externalSecretRotationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(rotateImmediately());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateSecretRequest)) {
            return false;
        }
        RotateSecretRequest other = (RotateSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(rotationLambdaARN(), other.rotationLambdaARN())
                && Objects.equals(rotationRules(), other.rotationRules())
                && hasExternalSecretRotationMetadata() == other.hasExternalSecretRotationMetadata()
                && Objects.equals(externalSecretRotationMetadata(), other.externalSecretRotationMetadata())
                && Objects.equals(externalSecretRotationRoleArn(), other.externalSecretRotationRoleArn())
                && Objects.equals(rotateImmediately(), other.rotateImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("RotateSecretRequest")
                .add("SecretId", secretId())
                .add("ClientRequestToken", clientRequestToken())
                .add("RotationLambdaARN", rotationLambdaARN())
                .add("RotationRules", rotationRules())
                .add("ExternalSecretRotationMetadata",
                        hasExternalSecretRotationMetadata() ? externalSecretRotationMetadata() : null)
                .add("ExternalSecretRotationRoleArn", externalSecretRotationRoleArn())
                .add("RotateImmediately", rotateImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "RotationLambdaARN":
            return Optional.ofNullable(clazz.cast(rotationLambdaARN()));
        case "RotationRules":
            return Optional.ofNullable(clazz.cast(rotationRules()));
        case "ExternalSecretRotationMetadata":
            return Optional.ofNullable(clazz.cast(externalSecretRotationMetadata()));
        case "ExternalSecretRotationRoleArn":
            return Optional.ofNullable(clazz.cast(externalSecretRotationRoleArn()));
        case "RotateImmediately":
            return Optional.ofNullable(clazz.cast(rotateImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretId", SECRET_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("RotationLambdaARN", ROTATION_LAMBDA_ARN_FIELD);
        map.put("RotationRules", ROTATION_RULES_FIELD);
        map.put("ExternalSecretRotationMetadata", EXTERNAL_SECRET_ROTATION_METADATA_FIELD);
        map.put("ExternalSecretRotationRoleArn", EXTERNAL_SECRET_ROTATION_ROLE_ARN_FIELD);
        map.put("RotateImmediately", ROTATE_IMMEDIATELY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotateSecretRequest, T> g) {
        return obj -> g.apply((RotateSecretRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RotateSecretRequest> {
        /**
         * <p>
         * The ARN or name of the secret to rotate.
         * </p>
         * <p>
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         * >Finding a secret from a partial ARN</a>.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret to rotate.</p>
         *        <p>
         *        For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         *        >Finding a secret from a partial ARN</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * A unique identifier for the new version of the secret. You only need to specify this value if you implement
         * your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version
         * twice.
         * </p>
         * <note>
         * <p>
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then
         * you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the
         * value for this parameter in the request.
         * </p>
         * </note>
         * <p>
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
         * <code>ClientRequestToken</code> and include it in the request.
         * </p>
         * <p>
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of
         * duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of
         * your versions within the specified secret.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the new version of the secret. You only need to specify this value if you
         *        implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a
         *        secret version twice.</p> <note>
         *        <p>
         *        If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation,
         *        then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes
         *        it as the value for this parameter in the request.
         *        </p>
         *        </note>
         *        <p>
         *        If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
         *        <code>ClientRequestToken</code> and include it in the request.
         *        </p>
         *        <p>
         *        This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental
         *        creation of duplicate versions if there are failures and retries during a rotation. We recommend that
         *        you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value
         *        to ensure uniqueness of your versions within the specified secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function.
         * </p>
         * <p>
         * For secrets that use <i>managed rotation</i>, omit this field. For more information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html">Managed
         * rotation</a> in the <i>Secrets Manager User Guide</i>.
         * </p>
         * 
         * @param rotationLambdaARN
         *        For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function.
         *        </p>
         *        <p>
         *        For secrets that use <i>managed rotation</i>, omit this field. For more information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html">Managed
         *        rotation</a> in the <i>Secrets Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaARN(String rotationLambdaARN);

        /**
         * <p>
         * A structure that defines the rotation configuration for this secret.
         * </p>
         * <important>
         * <p>
         * When changing an existing rotation schedule and setting <code>RotateImmediately</code> to <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with <code>rate()</code>,
         * the previously scheduled rotation might still occur.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for granular
         * control over rotation windows.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param rotationRules
         *        A structure that defines the rotation configuration for this secret.</p> <important>
         *        <p>
         *        When changing an existing rotation schedule and setting <code>RotateImmediately</code> to
         *        <code>false</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with
         *        <code>rate()</code>, the previously scheduled rotation might still occur.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for
         *        granular control over rotation windows.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(RotationRulesType rotationRules);

        /**
         * <p>
         * A structure that defines the rotation configuration for this secret.
         * </p>
         * <important>
         * <p>
         * When changing an existing rotation schedule and setting <code>RotateImmediately</code> to <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with <code>rate()</code>,
         * the previously scheduled rotation might still occur.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for granular
         * control over rotation windows.
         * </p>
         * </li>
         * </ul>
         * </important> This is a convenience method that creates an instance of the {@link RotationRulesType.Builder}
         * avoiding the need to create one manually via {@link RotationRulesType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RotationRulesType.Builder#build()} is called immediately and its
         * result is passed to {@link #rotationRules(RotationRulesType)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link RotationRulesType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(RotationRulesType)
         */
        default Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return rotationRules(RotationRulesType.builder().applyMutation(rotationRules).build());
        }

        /**
         * <p>
         * The metadata needed to successfully rotate a managed external secret. A list of key value pairs in JSON
         * format specified by the partner. For more information about the required information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
         * Secrets Manager managed external secrets</a>
         * </p>
         * 
         * @param externalSecretRotationMetadata
         *        The metadata needed to successfully rotate a managed external secret. A list of key value pairs in
         *        JSON format specified by the partner. For more information about the required information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
         *        Secrets Manager managed external secrets</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSecretRotationMetadata(Collection<ExternalSecretRotationMetadataItem> externalSecretRotationMetadata);

        /**
         * <p>
         * The metadata needed to successfully rotate a managed external secret. A list of key value pairs in JSON
         * format specified by the partner. For more information about the required information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
         * Secrets Manager managed external secrets</a>
         * </p>
         * 
         * @param externalSecretRotationMetadata
         *        The metadata needed to successfully rotate a managed external secret. A list of key value pairs in
         *        JSON format specified by the partner. For more information about the required information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
         *        Secrets Manager managed external secrets</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSecretRotationMetadata(ExternalSecretRotationMetadataItem... externalSecretRotationMetadata);

        /**
         * <p>
         * The metadata needed to successfully rotate a managed external secret. A list of key value pairs in JSON
         * format specified by the partner. For more information about the required information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/managed-external-secrets.html">Using
         * Secrets Manager managed external secrets</a>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.ExternalSecretRotationMetadataItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.secretsmanager.model.ExternalSecretRotationMetadataItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.ExternalSecretRotationMetadataItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #externalSecretRotationMetadata(List<ExternalSecretRotationMetadataItem>)}.
         * 
         * @param externalSecretRotationMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.ExternalSecretRotationMetadataItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalSecretRotationMetadata(java.util.Collection<ExternalSecretRotationMetadataItem>)
         */
        Builder externalSecretRotationMetadata(
                Consumer<ExternalSecretRotationMetadataItem.Builder>... externalSecretRotationMetadata);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that allows Secrets Manager to rotate a secret held by a
         * third-party partner. For more information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-security.html">Security and
         * permissions</a>.
         * </p>
         * 
         * @param externalSecretRotationRoleArn
         *        The Amazon Resource Name (ARN) of the role that allows Secrets Manager to rotate a secret held by a
         *        third-party partner. For more information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-security.html">Security and
         *        permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalSecretRotationRoleArn(String externalSecretRotationRoleArn);

        /**
         * <p>
         * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The
         * rotation schedule is defined in <a>RotateSecretRequest$RotationRules</a>.
         * </p>
         * <p>
         * The default for <code>RotateImmediately</code> is <code>true</code>. If you don't specify this value, Secrets
         * Manager rotates the secret immediately.
         * </p>
         * <p>
         * If you set <code>RotateImmediately</code> to <code>false</code>, Secrets Manager tests the rotation
         * configuration by running the <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">
         * <code>testSecret</code> step</a> of the Lambda rotation function. This test creates an
         * <code>AWSPENDING</code> version of the secret and then removes it.
         * </p>
         * <p>
         * When changing an existing rotation schedule and setting <code>RotateImmediately</code> to <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with <code>rate()</code>,
         * the previously scheduled rotation might still occur.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for granular
         * control over rotation windows.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Rotation is an asynchronous process. For more information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
         * works</a>.
         * </p>
         * 
         * @param rotateImmediately
         *        Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window.
         *        The rotation schedule is defined in <a>RotateSecretRequest$RotationRules</a>.</p>
         *        <p>
         *        The default for <code>RotateImmediately</code> is <code>true</code>. If you don't specify this value,
         *        Secrets Manager rotates the secret immediately.
         *        </p>
         *        <p>
         *        If you set <code>RotateImmediately</code> to <code>false</code>, Secrets Manager tests the rotation
         *        configuration by running the <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">
         *        <code>testSecret</code> step</a> of the Lambda rotation function. This test creates an
         *        <code>AWSPENDING</code> version of the secret and then removes it.
         *        </p>
         *        <p>
         *        When changing an existing rotation schedule and setting <code>RotateImmediately</code> to
         *        <code>false</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using <code>AutomaticallyAfterDays</code> or a <code>ScheduleExpression</code> with
         *        <code>rate()</code>, the previously scheduled rotation might still occur.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent unintended rotations, use a <code>ScheduleExpression</code> with <code>cron()</code> for
         *        granular control over rotation windows.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Rotation is an asynchronous process. For more information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How
         *        rotation works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotateImmediately(Boolean rotateImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String clientRequestToken;

        private String rotationLambdaARN;

        private RotationRulesType rotationRules;

        private List<ExternalSecretRotationMetadataItem> externalSecretRotationMetadata = DefaultSdkAutoConstructList
                .getInstance();

        private String externalSecretRotationRoleArn;

        private Boolean rotateImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateSecretRequest model) {
            super(model);
            secretId(model.secretId);
            clientRequestToken(model.clientRequestToken);
            rotationLambdaARN(model.rotationLambdaARN);
            rotationRules(model.rotationRules);
            externalSecretRotationMetadata(model.externalSecretRotationMetadata);
            externalSecretRotationRoleArn(model.externalSecretRotationRoleArn);
            rotateImmediately(model.rotateImmediately);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRotationLambdaARN() {
            return rotationLambdaARN;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final List<ExternalSecretRotationMetadataItem.Builder> getExternalSecretRotationMetadata() {
            List<ExternalSecretRotationMetadataItem.Builder> result = ExternalSecretRotationMetadataTypeCopier
                    .copyToBuilder(this.externalSecretRotationMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalSecretRotationMetadata(
                Collection<ExternalSecretRotationMetadataItem.BuilderImpl> externalSecretRotationMetadata) {
            this.externalSecretRotationMetadata = ExternalSecretRotationMetadataTypeCopier
                    .copyFromBuilder(externalSecretRotationMetadata);
        }

        @Override
        public final Builder externalSecretRotationMetadata(
                Collection<ExternalSecretRotationMetadataItem> externalSecretRotationMetadata) {
            this.externalSecretRotationMetadata = ExternalSecretRotationMetadataTypeCopier.copy(externalSecretRotationMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalSecretRotationMetadata(ExternalSecretRotationMetadataItem... externalSecretRotationMetadata) {
            externalSecretRotationMetadata(Arrays.asList(externalSecretRotationMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalSecretRotationMetadata(
                Consumer<ExternalSecretRotationMetadataItem.Builder>... externalSecretRotationMetadata) {
            externalSecretRotationMetadata(Stream.of(externalSecretRotationMetadata)
                    .map(c -> ExternalSecretRotationMetadataItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExternalSecretRotationRoleArn() {
            return externalSecretRotationRoleArn;
        }

        public final void setExternalSecretRotationRoleArn(String externalSecretRotationRoleArn) {
            this.externalSecretRotationRoleArn = externalSecretRotationRoleArn;
        }

        @Override
        public final Builder externalSecretRotationRoleArn(String externalSecretRotationRoleArn) {
            this.externalSecretRotationRoleArn = externalSecretRotationRoleArn;
            return this;
        }

        public final Boolean getRotateImmediately() {
            return rotateImmediately;
        }

        public final void setRotateImmediately(Boolean rotateImmediately) {
            this.rotateImmediately = rotateImmediately;
        }

        @Override
        public final Builder rotateImmediately(Boolean rotateImmediately) {
            this.rotateImmediately = rotateImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RotateSecretRequest build() {
            return new RotateSecretRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
