/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicateSecretToRegionsRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<ReplicateSecretToRegionsRequest.Builder, ReplicateSecretToRegionsRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(ReplicateSecretToRegionsRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<List<ReplicaRegionType>> ADD_REPLICA_REGIONS_FIELD = SdkField
            .<List<ReplicaRegionType>> builder(MarshallingType.LIST)
            .memberName("AddReplicaRegions")
            .getter(getter(ReplicateSecretToRegionsRequest::addReplicaRegions))
            .setter(setter(Builder::addReplicaRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddReplicaRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaRegionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaRegionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> FORCE_OVERWRITE_REPLICA_SECRET_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceOverwriteReplicaSecret")
            .getter(getter(ReplicateSecretToRegionsRequest::forceOverwriteReplicaSecret))
            .setter(setter(Builder::forceOverwriteReplicaSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceOverwriteReplicaSecret")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            ADD_REPLICA_REGIONS_FIELD, FORCE_OVERWRITE_REPLICA_SECRET_FIELD));

    private final String secretId;

    private final List<ReplicaRegionType> addReplicaRegions;

    private final Boolean forceOverwriteReplicaSecret;

    private ReplicateSecretToRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.addReplicaRegions = builder.addReplicaRegions;
        this.forceOverwriteReplicaSecret = builder.forceOverwriteReplicaSecret;
    }

    /**
     * <p>
     * The ARN or name of the secret to replicate.
     * </p>
     * 
     * @return The ARN or name of the secret to replicate.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddReplicaRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddReplicaRegions() {
        return addReplicaRegions != null && !(addReplicaRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Regions in which to replicate the secret.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddReplicaRegions} method.
     * </p>
     * 
     * @return A list of Regions in which to replicate the secret.
     */
    public final List<ReplicaRegionType> addReplicaRegions() {
        return addReplicaRegions;
    }

    /**
     * <p>
     * Specifies whether to overwrite a secret with the same name in the destination Region.
     * </p>
     * 
     * @return Specifies whether to overwrite a secret with the same name in the destination Region.
     */
    public final Boolean forceOverwriteReplicaSecret() {
        return forceOverwriteReplicaSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddReplicaRegions() ? addReplicaRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forceOverwriteReplicaSecret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicateSecretToRegionsRequest)) {
            return false;
        }
        ReplicateSecretToRegionsRequest other = (ReplicateSecretToRegionsRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && hasAddReplicaRegions() == other.hasAddReplicaRegions()
                && Objects.equals(addReplicaRegions(), other.addReplicaRegions())
                && Objects.equals(forceOverwriteReplicaSecret(), other.forceOverwriteReplicaSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicateSecretToRegionsRequest").add("SecretId", secretId())
                .add("AddReplicaRegions", hasAddReplicaRegions() ? addReplicaRegions() : null)
                .add("ForceOverwriteReplicaSecret", forceOverwriteReplicaSecret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "AddReplicaRegions":
            return Optional.ofNullable(clazz.cast(addReplicaRegions()));
        case "ForceOverwriteReplicaSecret":
            return Optional.ofNullable(clazz.cast(forceOverwriteReplicaSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicateSecretToRegionsRequest, T> g) {
        return obj -> g.apply((ReplicateSecretToRegionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ReplicateSecretToRegionsRequest> {
        /**
         * <p>
         * The ARN or name of the secret to replicate.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret to replicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * A list of Regions in which to replicate the secret.
         * </p>
         * 
         * @param addReplicaRegions
         *        A list of Regions in which to replicate the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addReplicaRegions(Collection<ReplicaRegionType> addReplicaRegions);

        /**
         * <p>
         * A list of Regions in which to replicate the secret.
         * </p>
         * 
         * @param addReplicaRegions
         *        A list of Regions in which to replicate the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addReplicaRegions(ReplicaRegionType... addReplicaRegions);

        /**
         * <p>
         * A list of Regions in which to replicate the secret.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType.Builder#build()} is called
         * immediately and its result is passed to {@link #addReplicaRegions(List<ReplicaRegionType>)}.
         * 
         * @param addReplicaRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addReplicaRegions(java.util.Collection<ReplicaRegionType>)
         */
        Builder addReplicaRegions(Consumer<ReplicaRegionType.Builder>... addReplicaRegions);

        /**
         * <p>
         * Specifies whether to overwrite a secret with the same name in the destination Region.
         * </p>
         * 
         * @param forceOverwriteReplicaSecret
         *        Specifies whether to overwrite a secret with the same name in the destination Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceOverwriteReplicaSecret(Boolean forceOverwriteReplicaSecret);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private List<ReplicaRegionType> addReplicaRegions = DefaultSdkAutoConstructList.getInstance();

        private Boolean forceOverwriteReplicaSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicateSecretToRegionsRequest model) {
            super(model);
            secretId(model.secretId);
            addReplicaRegions(model.addReplicaRegions);
            forceOverwriteReplicaSecret(model.forceOverwriteReplicaSecret);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final List<ReplicaRegionType.Builder> getAddReplicaRegions() {
            List<ReplicaRegionType.Builder> result = AddReplicaRegionListTypeCopier.copyToBuilder(this.addReplicaRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddReplicaRegions(Collection<ReplicaRegionType.BuilderImpl> addReplicaRegions) {
            this.addReplicaRegions = AddReplicaRegionListTypeCopier.copyFromBuilder(addReplicaRegions);
        }

        @Override
        public final Builder addReplicaRegions(Collection<ReplicaRegionType> addReplicaRegions) {
            this.addReplicaRegions = AddReplicaRegionListTypeCopier.copy(addReplicaRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addReplicaRegions(ReplicaRegionType... addReplicaRegions) {
            addReplicaRegions(Arrays.asList(addReplicaRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addReplicaRegions(Consumer<ReplicaRegionType.Builder>... addReplicaRegions) {
            addReplicaRegions(Stream.of(addReplicaRegions).map(c -> ReplicaRegionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getForceOverwriteReplicaSecret() {
            return forceOverwriteReplicaSecret;
        }

        public final void setForceOverwriteReplicaSecret(Boolean forceOverwriteReplicaSecret) {
            this.forceOverwriteReplicaSecret = forceOverwriteReplicaSecret;
        }

        @Override
        public final Builder forceOverwriteReplicaSecret(Boolean forceOverwriteReplicaSecret) {
            this.forceOverwriteReplicaSecret = forceOverwriteReplicaSecret;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplicateSecretToRegionsRequest build() {
            return new ReplicateSecretToRegionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
