/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.transform.RotationRulesTypeUnmarshaller;
import software.amazon.awssdk.services.secretsmanager.transform.TagUnmarshaller;

public class SecretListEntryUnmarshaller
implements Unmarshaller<SecretListEntry, JsonUnmarshallerContext> {
    private static final SecretListEntryUnmarshaller INSTANCE = new SecretListEntryUnmarshaller();

    public SecretListEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        SecretListEntry.Builder secretListEntryBuilder = SecretListEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ARN", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RotationEnabled", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationEnabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("RotationLambdaARN", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationLambdaARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RotationRules", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationRules(RotationRulesTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastRotatedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastRotatedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastChangedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastChangedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAccessedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastAccessedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeletedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.deletedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.tags(new ListUnmarshaller((Unmarshaller)TagUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SecretVersionsToStages", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.secretVersionsToStages(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SecretListEntry)secretListEntryBuilder.build();
    }

    public static SecretListEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

