/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretListTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecretsResponse
extends SecretsManagerResponse
implements ToCopyableBuilder<Builder, ListSecretsResponse> {
    private final List<SecretListEntry> secretList;
    private final String nextToken;

    private ListSecretsResponse(BuilderImpl builder) {
        super(builder);
        this.secretList = builder.secretList;
        this.nextToken = builder.nextToken;
    }

    public List<SecretListEntry> secretList() {
        return this.secretList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretsResponse)) {
            return false;
        }
        ListSecretsResponse other = (ListSecretsResponse)((Object)obj);
        return Objects.equals(this.secretList(), other.secretList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSecretsResponse").add("SecretList", this.secretList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretList": {
                return Optional.ofNullable(clazz.cast(this.secretList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerResponse.BuilderImpl
    implements Builder {
        private List<SecretListEntry> secretList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretsResponse model) {
            super(model);
            this.secretList(model.secretList);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecretListEntry.Builder> getSecretList() {
            return this.secretList != null ? (Collection)this.secretList.stream().map(SecretListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secretList(Collection<SecretListEntry> secretList) {
            this.secretList = SecretListTypeCopier.copy(secretList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(SecretListEntry ... secretList) {
            this.secretList(Arrays.asList(secretList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretList(Consumer<SecretListEntry.Builder> ... secretList) {
            this.secretList(Stream.of(secretList).map(c -> (SecretListEntry)((SecretListEntry.Builder)SecretListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecretList(Collection<SecretListEntry.BuilderImpl> secretList) {
            this.secretList = SecretListTypeCopier.copyFromBuilder(secretList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSecretsResponse build() {
            return new ListSecretsResponse(this);
        }
    }

    public static interface Builder
    extends SecretsManagerResponse.Builder,
    CopyableBuilder<Builder, ListSecretsResponse> {
        public Builder secretList(Collection<SecretListEntry> var1);

        public Builder secretList(SecretListEntry ... var1);

        public Builder secretList(Consumer<SecretListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

