/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.secretsmanager.model.RotationRulesType;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RotateSecretRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, RotateSecretRequest> {
    private final String secretId;
    private final String clientRequestToken;
    private final String rotationLambdaARN;
    private final RotationRulesType rotationRules;

    private RotateSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.clientRequestToken = builder.clientRequestToken;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
    }

    public String secretId() {
        return this.secretId;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String rotationLambdaARN() {
        return this.rotationLambdaARN;
    }

    public RotationRulesType rotationRules() {
        return this.rotationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateSecretRequest)) {
            return false;
        }
        RotateSecretRequest other = (RotateSecretRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.rotationLambdaARN(), other.rotationLambdaARN()) && Objects.equals(this.rotationRules(), other.rotationRules());
    }

    public String toString() {
        return ToString.builder((String)"RotateSecretRequest").add("SecretId", (Object)this.secretId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RotationLambdaARN", (Object)this.rotationLambdaARN()).add("RotationRules", (Object)this.rotationRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.of(clazz.cast(this.secretId()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "RotationLambdaARN": {
                return Optional.of(clazz.cast(this.rotationLambdaARN()));
            }
            case "RotationRules": {
                return Optional.of(clazz.cast(this.rotationRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private String clientRequestToken;
        private String rotationLambdaARN;
        private RotationRulesType rotationRules;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateSecretRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.clientRequestToken(model.clientRequestToken);
            this.rotationLambdaARN(model.rotationLambdaARN);
            this.rotationRules(model.rotationRules);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getRotationLambdaARN() {
            return this.rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return this.rotationRules != null ? this.rotationRules.toBuilder() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RotateSecretRequest build() {
            return new RotateSecretRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, RotateSecretRequest> {
        public Builder secretId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder rotationLambdaARN(String var1);

        public Builder rotationRules(RotationRulesType var1);

        default public Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return this.rotationRules((RotationRulesType)((RotationRulesType.Builder)RotationRulesType.builder().apply(rotationRules)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

