/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSecretVersionIdsResponse
extends SecretsManagerResponse
implements ToCopyableBuilder<Builder, ListSecretVersionIdsResponse> {
    private final List<SecretVersionsListEntry> versions;
    private final String nextToken;
    private final String arn;
    private final String name;

    private ListSecretVersionIdsResponse(BuilderImpl builder) {
        super(builder);
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
        this.arn = builder.arn;
        this.name = builder.name;
    }

    public List<SecretVersionsListEntry> versions() {
        return this.versions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretVersionIdsResponse)) {
            return false;
        }
        ListSecretVersionIdsResponse other = (ListSecretVersionIdsResponse)((Object)obj);
        return Objects.equals(this.versions(), other.versions()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"ListSecretVersionIdsResponse").add("Versions", this.versions()).add("NextToken", (Object)this.nextToken()).add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerResponse.BuilderImpl
    implements Builder {
        private List<SecretVersionsListEntry> versions;
        private String nextToken;
        private String arn;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecretVersionIdsResponse model) {
            super(model);
            this.versions(model.versions);
            this.nextToken(model.nextToken);
            this.arn(model.arn);
            this.name(model.name);
        }

        public final Collection<SecretVersionsListEntry.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(SecretVersionsListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<SecretVersionsListEntry> versions) {
            this.versions = SecretVersionsListTypeCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(SecretVersionsListEntry ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<SecretVersionsListEntry.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (SecretVersionsListEntry)((SecretVersionsListEntry.Builder)SecretVersionsListEntry.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<SecretVersionsListEntry.BuilderImpl> versions) {
            this.versions = SecretVersionsListTypeCopier.copyFromBuilder(versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public ListSecretVersionIdsResponse build() {
            return new ListSecretVersionIdsResponse(this);
        }
    }

    public static interface Builder
    extends SecretsManagerResponse.Builder,
    CopyableBuilder<Builder, ListSecretVersionIdsResponse> {
        public Builder versions(Collection<SecretVersionsListEntry> var1);

        public Builder versions(SecretVersionsListEntry ... var1);

        public Builder versions(Consumer<SecretVersionsListEntry.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);
    }
}

