/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionStagesTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSecretValueResponse
extends SecretsManagerResponse
implements ToCopyableBuilder<Builder, GetSecretValueResponse> {
    private final String arn;
    private final String name;
    private final String versionId;
    private final ByteBuffer secretBinary;
    private final String secretString;
    private final List<String> versionStages;
    private final Instant createdDate;

    private GetSecretValueResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.versionId = builder.versionId;
        this.secretBinary = builder.secretBinary;
        this.secretString = builder.secretString;
        this.versionStages = builder.versionStages;
        this.createdDate = builder.createdDate;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String versionId() {
        return this.versionId;
    }

    public ByteBuffer secretBinary() {
        return this.secretBinary == null ? null : this.secretBinary.asReadOnlyBuffer();
    }

    public String secretString() {
        return this.secretString;
    }

    public List<String> versionStages() {
        return this.versionStages;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretBinary());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStages());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecretValueResponse)) {
            return false;
        }
        GetSecretValueResponse other = (GetSecretValueResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.secretBinary(), other.secretBinary()) && Objects.equals(this.secretString(), other.secretString()) && Objects.equals(this.versionStages(), other.versionStages()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public String toString() {
        return ToString.builder((String)"GetSecretValueResponse").add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).add("VersionId", (Object)this.versionId()).add("SecretBinary", (Object)this.secretBinary()).add("SecretString", (Object)this.secretString()).add("VersionStages", this.versionStages()).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "SecretBinary": {
                return Optional.of(clazz.cast(this.secretBinary()));
            }
            case "SecretString": {
                return Optional.of(clazz.cast(this.secretString()));
            }
            case "VersionStages": {
                return Optional.of(clazz.cast(this.versionStages()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String versionId;
        private ByteBuffer secretBinary;
        private String secretString;
        private List<String> versionStages;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecretValueResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.versionId(model.versionId);
            this.secretBinary(model.secretBinary);
            this.secretString(model.secretString);
            this.versionStages(model.versionStages);
            this.createdDate(model.createdDate);
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final ByteBuffer getSecretBinary() {
            return this.secretBinary;
        }

        @Override
        public final Builder secretBinary(ByteBuffer secretBinary) {
            this.secretBinary = StandardMemberCopier.copy((ByteBuffer)secretBinary);
            return this;
        }

        public final void setSecretBinary(ByteBuffer secretBinary) {
            this.secretBinary = StandardMemberCopier.copy((ByteBuffer)secretBinary);
        }

        public final String getSecretString() {
            return this.secretString;
        }

        @Override
        public final Builder secretString(String secretString) {
            this.secretString = secretString;
            return this;
        }

        public final void setSecretString(String secretString) {
            this.secretString = secretString;
        }

        public final Collection<String> getVersionStages() {
            return this.versionStages;
        }

        @Override
        public final Builder versionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionStages(String ... versionStages) {
            this.versionStages(Arrays.asList(versionStages));
            return this;
        }

        public final void setVersionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public GetSecretValueResponse build() {
            return new GetSecretValueResponse(this);
        }
    }

    public static interface Builder
    extends SecretsManagerResponse.Builder,
    CopyableBuilder<Builder, GetSecretValueResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder versionId(String var1);

        public Builder secretBinary(ByteBuffer var1);

        public Builder secretString(String var1);

        public Builder versionStages(Collection<String> var1);

        public Builder versionStages(String ... var1);

        public Builder createdDate(Instant var1);
    }
}

