/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteSecretRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, DeleteSecretRequest> {
    private final String secretId;
    private final Long recoveryWindowInDays;

    private DeleteSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.recoveryWindowInDays = builder.recoveryWindowInDays;
    }

    public String secretId() {
        return this.secretId;
    }

    public Long recoveryWindowInDays() {
        return this.recoveryWindowInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryWindowInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecretRequest)) {
            return false;
        }
        DeleteSecretRequest other = (DeleteSecretRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.recoveryWindowInDays(), other.recoveryWindowInDays());
    }

    public String toString() {
        return ToString.builder((String)"DeleteSecretRequest").add("SecretId", (Object)this.secretId()).add("RecoveryWindowInDays", (Object)this.recoveryWindowInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.of(clazz.cast(this.secretId()));
            }
            case "RecoveryWindowInDays": {
                return Optional.of(clazz.cast(this.recoveryWindowInDays()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private Long recoveryWindowInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecretRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.recoveryWindowInDays(model.recoveryWindowInDays);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Long getRecoveryWindowInDays() {
            return this.recoveryWindowInDays;
        }

        @Override
        public final Builder recoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        public final void setRecoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteSecretRequest build() {
            return new DeleteSecretRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, DeleteSecretRequest> {
        public Builder secretId(String var1);

        public Builder recoveryWindowInDays(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

