/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisParameters> {
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionKey").getter(KinesisParameters.getter(KinesisParameters::partitionKey)).setter(KinesisParameters.setter(Builder::partitionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String partitionKey;

    private KinesisParameters(BuilderImpl builder) {
        this.partitionKey = builder.partitionKey;
    }

    public final String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisParameters)) {
            return false;
        }
        KinesisParameters other = (KinesisParameters)obj;
        return Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisParameters").add("PartitionKey", (Object)this.partitionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PartitionKey", PARTITION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisParameters, T> g) {
        return obj -> g.apply((KinesisParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisParameters model) {
            this.partitionKey(model.partitionKey);
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public KinesisParameters build() {
            return new KinesisParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisParameters> {
        public Builder partitionKey(String var1);
    }
}

