/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindowMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlexibleTimeWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlexibleTimeWindow> {
    private static final SdkField<Integer> MAXIMUM_WINDOW_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumWindowInMinutes").getter(FlexibleTimeWindow.getter(FlexibleTimeWindow::maximumWindowInMinutes)).setter(FlexibleTimeWindow.setter(Builder::maximumWindowInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumWindowInMinutes").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(FlexibleTimeWindow.getter(FlexibleTimeWindow::modeAsString)).setter(FlexibleTimeWindow.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_WINDOW_IN_MINUTES_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumWindowInMinutes;
    private final String mode;

    private FlexibleTimeWindow(BuilderImpl builder) {
        this.maximumWindowInMinutes = builder.maximumWindowInMinutes;
        this.mode = builder.mode;
    }

    public final Integer maximumWindowInMinutes() {
        return this.maximumWindowInMinutes;
    }

    public final FlexibleTimeWindowMode mode() {
        return FlexibleTimeWindowMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumWindowInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlexibleTimeWindow)) {
            return false;
        }
        FlexibleTimeWindow other = (FlexibleTimeWindow)obj;
        return Objects.equals(this.maximumWindowInMinutes(), other.maximumWindowInMinutes()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlexibleTimeWindow").add("MaximumWindowInMinutes", (Object)this.maximumWindowInMinutes()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumWindowInMinutes": {
                return Optional.ofNullable(clazz.cast(this.maximumWindowInMinutes()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlexibleTimeWindow, T> g) {
        return obj -> g.apply((FlexibleTimeWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumWindowInMinutes;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(FlexibleTimeWindow model) {
            this.maximumWindowInMinutes(model.maximumWindowInMinutes);
            this.mode(model.mode);
        }

        public final Integer getMaximumWindowInMinutes() {
            return this.maximumWindowInMinutes;
        }

        public final void setMaximumWindowInMinutes(Integer maximumWindowInMinutes) {
            this.maximumWindowInMinutes = maximumWindowInMinutes;
        }

        @Override
        public final Builder maximumWindowInMinutes(Integer maximumWindowInMinutes) {
            this.maximumWindowInMinutes = maximumWindowInMinutes;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(FlexibleTimeWindowMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public FlexibleTimeWindow build() {
            return new FlexibleTimeWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlexibleTimeWindow> {
        public Builder maximumWindowInMinutes(Integer var1);

        public Builder mode(String var1);

        public Builder mode(FlexibleTimeWindowMode var1);
    }
}

