/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.scheduler.DefaultSchedulerBaseClientBuilder;
import software.amazon.awssdk.services.scheduler.DefaultSchedulerClient;
import software.amazon.awssdk.services.scheduler.SchedulerClient;
import software.amazon.awssdk.services.scheduler.SchedulerClientBuilder;
import software.amazon.awssdk.services.scheduler.SchedulerServiceClientConfiguration;
import software.amazon.awssdk.services.scheduler.endpoints.SchedulerEndpointProvider;

@SdkInternalApi
final class DefaultSchedulerClientBuilder
extends DefaultSchedulerBaseClientBuilder<SchedulerClientBuilder, SchedulerClient>
implements SchedulerClientBuilder {
    DefaultSchedulerClientBuilder() {
    }

    @Override
    public DefaultSchedulerClientBuilder endpointProvider(SchedulerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SchedulerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSchedulerClientBuilder.validateClientOptions(clientConfiguration);
        SchedulerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSchedulerClient client = new DefaultSchedulerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SchedulerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SchedulerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

