/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.scheduler.model.FlexibleTimeWindow;
import software.amazon.awssdk.services.scheduler.model.ScheduleState;
import software.amazon.awssdk.services.scheduler.model.SchedulerRequest;
import software.amazon.awssdk.services.scheduler.model.Target;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScheduleRequest
extends SchedulerRequest
implements ToCopyableBuilder<Builder, UpdateScheduleRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::clientToken)).setter(UpdateScheduleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::description)).setter(UpdateScheduleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::endDate)).setter(UpdateScheduleRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<FlexibleTimeWindow> FLEXIBLE_TIME_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlexibleTimeWindow").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::flexibleTimeWindow)).setter(UpdateScheduleRequest.setter(Builder::flexibleTimeWindow)).constructor(FlexibleTimeWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexibleTimeWindow").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::groupName)).setter(UpdateScheduleRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::kmsKeyArn)).setter(UpdateScheduleRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::name)).setter(UpdateScheduleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::scheduleExpression)).setter(UpdateScheduleRequest.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpressionTimezone").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::scheduleExpressionTimezone)).setter(UpdateScheduleRequest.setter(Builder::scheduleExpressionTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::startDate)).setter(UpdateScheduleRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::stateAsString)).setter(UpdateScheduleRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Target> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(UpdateScheduleRequest.getter(UpdateScheduleRequest::target)).setter(UpdateScheduleRequest.setter(Builder::target)).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, END_DATE_FIELD, FLEXIBLE_TIME_WINDOW_FIELD, GROUP_NAME_FIELD, KMS_KEY_ARN_FIELD, NAME_FIELD, SCHEDULE_EXPRESSION_FIELD, SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_DATE_FIELD, STATE_FIELD, TARGET_FIELD));
    private final String clientToken;
    private final String description;
    private final Instant endDate;
    private final FlexibleTimeWindow flexibleTimeWindow;
    private final String groupName;
    private final String kmsKeyArn;
    private final String name;
    private final String scheduleExpression;
    private final String scheduleExpressionTimezone;
    private final Instant startDate;
    private final String state;
    private final Target target;

    private UpdateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.endDate = builder.endDate;
        this.flexibleTimeWindow = builder.flexibleTimeWindow;
        this.groupName = builder.groupName;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.name = builder.name;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startDate = builder.startDate;
        this.state = builder.state;
        this.target = builder.target;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final FlexibleTimeWindow flexibleTimeWindow() {
        return this.flexibleTimeWindow;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final String scheduleExpressionTimezone() {
        return this.scheduleExpressionTimezone;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final ScheduleState state() {
        return ScheduleState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Target target() {
        return this.target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.flexibleTimeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduleRequest)) {
            return false;
        }
        UpdateScheduleRequest other = (UpdateScheduleRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.flexibleTimeWindow(), other.flexibleTimeWindow()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.scheduleExpressionTimezone(), other.scheduleExpressionTimezone()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScheduleRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("EndDate", (Object)this.endDate()).add("FlexibleTimeWindow", (Object)this.flexibleTimeWindow()).add("GroupName", (Object)this.groupName()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Name", (Object)this.name()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("ScheduleExpressionTimezone", (Object)this.scheduleExpressionTimezone()).add("StartDate", (Object)this.startDate()).add("State", (Object)this.stateAsString()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "FlexibleTimeWindow": {
                return Optional.ofNullable(clazz.cast(this.flexibleTimeWindow()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "ScheduleExpressionTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpressionTimezone()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduleRequest, T> g) {
        return obj -> g.apply((UpdateScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchedulerRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private Instant endDate;
        private FlexibleTimeWindow flexibleTimeWindow;
        private String groupName;
        private String kmsKeyArn;
        private String name;
        private String scheduleExpression;
        private String scheduleExpressionTimezone;
        private Instant startDate;
        private String state;
        private Target target;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduleRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.endDate(model.endDate);
            this.flexibleTimeWindow(model.flexibleTimeWindow);
            this.groupName(model.groupName);
            this.kmsKeyArn(model.kmsKeyArn);
            this.name(model.name);
            this.scheduleExpression(model.scheduleExpression);
            this.scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            this.startDate(model.startDate);
            this.state(model.state);
            this.target(model.target);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final FlexibleTimeWindow.Builder getFlexibleTimeWindow() {
            return this.flexibleTimeWindow != null ? this.flexibleTimeWindow.toBuilder() : null;
        }

        public final void setFlexibleTimeWindow(FlexibleTimeWindow.BuilderImpl flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow != null ? flexibleTimeWindow.build() : null;
        }

        @Override
        public final Builder flexibleTimeWindow(FlexibleTimeWindow flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return this.scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Target.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduleRequest build() {
            return new UpdateScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchedulerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScheduleRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder endDate(Instant var1);

        public Builder flexibleTimeWindow(FlexibleTimeWindow var1);

        default public Builder flexibleTimeWindow(Consumer<FlexibleTimeWindow.Builder> flexibleTimeWindow) {
            return this.flexibleTimeWindow((FlexibleTimeWindow)((FlexibleTimeWindow.Builder)FlexibleTimeWindow.builder().applyMutation(flexibleTimeWindow)).build());
        }

        public Builder groupName(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder name(String var1);

        public Builder scheduleExpression(String var1);

        public Builder scheduleExpressionTimezone(String var1);

        public Builder startDate(Instant var1);

        public Builder state(String var1);

        public Builder state(ScheduleState var1);

        public Builder target(Target var1);

        default public Builder target(Consumer<Target.Builder> target) {
            return this.target((Target)((Target.Builder)Target.builder().applyMutation(target)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

