/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.scheduler.model.ScheduleState;
import software.amazon.awssdk.services.scheduler.model.SchedulerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchedulesRequest
extends SchedulerRequest
implements ToCopyableBuilder<Builder, ListSchedulesRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(ListSchedulesRequest.getter(ListSchedulesRequest::groupName)).setter(ListSchedulesRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ScheduleGroup").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSchedulesRequest.getter(ListSchedulesRequest::maxResults)).setter(ListSchedulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(ListSchedulesRequest.getter(ListSchedulesRequest::namePrefix)).setter(ListSchedulesRequest.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NamePrefix").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSchedulesRequest.getter(ListSchedulesRequest::nextToken)).setter(ListSchedulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListSchedulesRequest.getter(ListSchedulesRequest::stateAsString)).setter(ListSchedulesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, MAX_RESULTS_FIELD, NAME_PREFIX_FIELD, NEXT_TOKEN_FIELD, STATE_FIELD));
    private final String groupName;
    private final Integer maxResults;
    private final String namePrefix;
    private final String nextToken;
    private final String state;

    private ListSchedulesRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.maxResults = builder.maxResults;
        this.namePrefix = builder.namePrefix;
        this.nextToken = builder.nextToken;
        this.state = builder.state;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ScheduleState state() {
        return ScheduleState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchedulesRequest)) {
            return false;
        }
        ListSchedulesRequest other = (ListSchedulesRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.namePrefix(), other.namePrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchedulesRequest").add("GroupName", (Object)this.groupName()).add("MaxResults", (Object)this.maxResults()).add("NamePrefix", (Object)this.namePrefix()).add("NextToken", (Object)this.nextToken()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchedulesRequest, T> g) {
        return obj -> g.apply((ListSchedulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchedulerRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private Integer maxResults;
        private String namePrefix;
        private String nextToken;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchedulesRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.maxResults(model.maxResults);
            this.namePrefix(model.namePrefix);
            this.nextToken(model.nextToken);
            this.state(model.state);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchedulesRequest build() {
            return new ListSchedulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchedulerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchedulesRequest> {
        public Builder groupName(String var1);

        public Builder maxResults(Integer var1);

        public Builder namePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder state(String var1);

        public Builder state(ScheduleState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

