/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakermetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakermetrics.model.MetricQuery;
import software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryListCopier;
import software.amazon.awssdk.services.sagemakermetrics.model.SageMakerMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMetricsRequest
extends SageMakerMetricsRequest
implements ToCopyableBuilder<Builder, BatchGetMetricsRequest> {
    private static final SdkField<List<MetricQuery>> METRIC_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricQueries").getter(BatchGetMetricsRequest.getter(BatchGetMetricsRequest::metricQueries)).setter(BatchGetMetricsRequest.setter(Builder::metricQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetMetricsRequest.memberNameToFieldInitializer();
    private final List<MetricQuery> metricQueries;

    private BatchGetMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.metricQueries = builder.metricQueries;
    }

    public final boolean hasMetricQueries() {
        return this.metricQueries != null && !(this.metricQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricQuery> metricQueries() {
        return this.metricQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricQueries() ? this.metricQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMetricsRequest)) {
            return false;
        }
        BatchGetMetricsRequest other = (BatchGetMetricsRequest)((Object)obj);
        return this.hasMetricQueries() == other.hasMetricQueries() && Objects.equals(this.metricQueries(), other.metricQueries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMetricsRequest").add("MetricQueries", this.hasMetricQueries() ? this.metricQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricQueries": {
                return Optional.ofNullable(clazz.cast(this.metricQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<MetricQuery>>> map = new HashMap<String, SdkField<List<MetricQuery>>>();
        map.put("MetricQueries", METRIC_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMetricsRequest, T> g) {
        return obj -> g.apply((BatchGetMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerMetricsRequest.BuilderImpl
    implements Builder {
        private List<MetricQuery> metricQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMetricsRequest model) {
            super(model);
            this.metricQueries(model.metricQueries);
        }

        public final List<MetricQuery.Builder> getMetricQueries() {
            List<MetricQuery.Builder> result = MetricQueryListCopier.copyToBuilder(this.metricQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricQueries(Collection<MetricQuery.BuilderImpl> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copyFromBuilder(metricQueries);
        }

        @Override
        public final Builder metricQueries(Collection<MetricQuery> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copy(metricQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(MetricQuery ... metricQueries) {
            this.metricQueries(Arrays.asList(metricQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(Consumer<MetricQuery.Builder> ... metricQueries) {
            this.metricQueries(Stream.of(metricQueries).map(c -> (MetricQuery)((MetricQuery.Builder)MetricQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetMetricsRequest build() {
            return new BatchGetMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMetricsRequest> {
        public Builder metricQueries(Collection<MetricQuery> var1);

        public Builder metricQueries(MetricQuery ... var1);

        public Builder metricQueries(Consumer<MetricQuery.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

