/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.LinearRingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolygonGeometryInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolygonGeometryInput> {
    private static final SdkField<List<List<List<Double>>>> COORDINATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Coordinates").getter(PolygonGeometryInput.getter(PolygonGeometryInput::coordinates)).setter(PolygonGeometryInput.setter(Builder::coordinates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolygonGeometryInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<List<Double>>> coordinates;

    private PolygonGeometryInput(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
    }

    public final boolean hasCoordinates() {
        return this.coordinates != null && !(this.coordinates instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> coordinates() {
        return this.coordinates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoordinates() ? this.coordinates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolygonGeometryInput)) {
            return false;
        }
        PolygonGeometryInput other = (PolygonGeometryInput)obj;
        return this.hasCoordinates() == other.hasCoordinates() && Objects.equals(this.coordinates(), other.coordinates());
    }

    public final String toString() {
        return ToString.builder((String)"PolygonGeometryInput").add("Coordinates", (Object)(this.coordinates() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Coordinates": {
                return Optional.ofNullable(clazz.cast(this.coordinates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<List<List<Double>>>>> map = new HashMap<String, SdkField<List<List<List<Double>>>>>();
        map.put("Coordinates", COORDINATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolygonGeometryInput, T> g) {
        return obj -> g.apply((PolygonGeometryInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<List<Double>>> coordinates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolygonGeometryInput model) {
            this.coordinates(model.coordinates);
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getCoordinates() {
            if (this.coordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.coordinates;
        }

        public final void setCoordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
        }

        @Override
        public final Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> coordinates) {
            this.coordinates = LinearRingsCopier.copy(coordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coordinates(Collection<? extends Collection<Double>> ... coordinates) {
            this.coordinates((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(coordinates));
            return this;
        }

        public PolygonGeometryInput build() {
            return new PolygonGeometryInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolygonGeometryInput> {
        public Builder coordinates(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder coordinates(Collection<? extends Collection<Double>> ... var1);
    }
}

